/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.translations;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateFiller;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;

public enum TranslateType {
    DISGUISES("disguises"),
    MESSAGES("messages"),
    DISGUISE_OPTIONS("disguise_options"),
    DISGUISE_OPTIONS_PARAMETERS("disguise_option_parameters");

    private File file;
    private LinkedHashMap<String, String> translated = new LinkedHashMap();
    private HashMap<String, Boolean> toDeDupe = new HashMap();
    private OutputStreamWriter writer;
    private int written;

    private TranslateType(String fileName) {
        if (LibsDisguises.getInstance() == null) {
            return;
        }
        this.file = new File(LibsDisguises.getInstance().getDataFolder(), "Translations/" + fileName + ".yml");
    }

    public static void refreshTranslations() {
        for (TranslateType type : TranslateType.values()) {
            type.loadTranslations();
        }
        TranslateFiller.fillConfigs();
        if (!LibsPremium.isPremium().booleanValue() && DisguiseConfig.isUseTranslations()) {
            DisguiseUtilities.getLogger().severe("You must purchase the plugin to use translations!");
        }
    }

    protected void saveTranslations() {
        Iterator<Map.Entry<String, String>> itel = this.translated.entrySet().iterator();
        while (itel.hasNext()) {
            Map.Entry<String, String> entry = itel.next();
            if (!entry.getKey().equals(entry.getValue())) continue;
            itel.remove();
        }
        try {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
                DisguiseUtilities.getLogger().info("Saved " + this.written + " translations that were not in " + this.getFile().getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.deDupeMessages();
    }

    private void loadTranslations() {
        this.translated.clear();
        if (!this.getFile().exists()) {
            DisguiseUtilities.getLogger().info("Translations for " + this.name() + " missing! Saving..");
            return;
        }
        YamlConfiguration config = new YamlConfiguration();
        config.options().pathSeparator(Character.toChars(0)[0]);
        int diff = 0;
        try {
            config.load(this.getFile());
            for (String key : config.getKeys(false)) {
                String value = config.getString(key);
                if (value == null) {
                    DisguiseUtilities.getLogger().severe("Translation for " + this.name() + " has a null value for the key '" + key + "'");
                    continue;
                }
                this.toDeDupe.put(key, true);
                String newKey = DisguiseUtilities.translateAlternateColorCodes(key);
                this.translated.put(newKey, DisguiseUtilities.translateAlternateColorCodes(value));
                if (newKey.equals(this.translated.get(newKey))) continue;
                ++diff;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (LibsPremium.isPremium().booleanValue() && DisguiseConfig.isUseTranslations()) {
            DisguiseUtilities.getLogger().info("Loaded " + this.translated.size() + " translations for " + this.name() + " with " + diff + " changed");
        } else if (diff > 0 && !DisguiseConfig.isUseTranslations()) {
            DisguiseUtilities.getLogger().info("Translations are disabled in libsdisguises.yml, but you modified " + diff + " messages in the translations for " + this.name() + ". Is this intended?");
        }
    }

    private File getFile() {
        return this.file;
    }

    public void save(String msg) {
        if (this != MESSAGES) {
            throw new IllegalArgumentException("Can't set no comment for '" + msg + "'");
        }
        this.save(msg, null);
    }

    public void save(String message, String comment) {
        this.save(null, message, comment);
    }

    public void save(LibsMsg orig, String rawMessage, String comment) {
        String vanilla;
        this.toDeDupe.put(StringEscapeUtils.escapeJava((String)rawMessage.replace("\u00a7", "&")), false);
        if (this.translated.containsKey(rawMessage)) {
            return;
        }
        String value = rawMessage;
        if (orig != null && this.translated.containsKey(vanilla = orig.getVanillaFormat()) && !vanilla.equals(rawMessage) && !this.translated.get(vanilla).equals(vanilla)) {
            value = this.translated.get(vanilla);
            for (ChatColor color : ChatColor.values()) {
                value = value.replace("\u00a7" + color.getChar(), "<" + color.name().toLowerCase(Locale.ROOT) + ">");
            }
        }
        this.translated.put(rawMessage, value);
        try {
            boolean exists = this.getFile().exists();
            if (!exists) {
                this.getFile().getParentFile().mkdirs();
                this.getFile().createNewFile();
            }
            if (this.writer == null) {
                this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.getFile(), true), StandardCharsets.UTF_8);
                if (!exists) {
                    this.writer.write("# To use translations in Lib's Disguises, you must have the purchased plugin\n");
                    if (this == MESSAGES) {
                        this.writer.write("# %s is where text is inserted, look up printf format codes if you're interested\n");
                    }
                    this.writer.write("# To translate, follow this example 'Original Message': 'My New Message'\n# The Original Message is used as a yaml config key to get your new message!");
                    this.writer.write("\n# To use hex color codes, use <#hexcolor> where hexcolor is the 6 char code");
                }
            }
            String sanitizedKey = StringEscapeUtils.escapeJava((String)rawMessage.replace("\u00a7", "&"));
            String sanitizedValue = StringEscapeUtils.escapeJava((String)value.replace("\u00a7", "&"));
            this.writer.write("\n" + (comment != null ? "# " + comment + "\n" : "") + "\"" + sanitizedKey + "\": \"" + sanitizedValue + "\"\n");
            ++this.written;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deDupeMessages() {
        try {
            if (!this.getFile().exists()) {
                return;
            }
            ArrayList<String> disguiseText = new ArrayList<String>(Arrays.asList(new String(Files.readAllBytes(this.getFile().toPath())).split("\r?\n")));
            int dupes = 0;
            int outdated = 0;
            for (Map.Entry<String, Boolean> entry : this.toDeDupe.entrySet()) {
                boolean isOutdated;
                String s = entry.getKey();
                boolean removedFirst = isOutdated = entry.getValue().booleanValue();
                String str = "\"" + s + "\": \"" + s + "\"";
                for (int i = 0; i < disguiseText.size(); ++i) {
                    if (!disguiseText.get(i).equals(str)) continue;
                    if (!removedFirst) {
                        removedFirst = true;
                        continue;
                    }
                    disguiseText.remove(i);
                    if (isOutdated) {
                        ++outdated;
                    } else {
                        ++dupes;
                    }
                    if (disguiseText.get(--i).startsWith("# Reference: ")) {
                        disguiseText.remove(i);
                    }
                    if (disguiseText.size() <= i || !disguiseText.get(i).isEmpty()) continue;
                    disguiseText.remove(i);
                }
            }
            if (dupes + outdated > 0) {
                DisguiseUtilities.getLogger().info("Removed " + dupes + " duplicate and " + outdated + " outdated translations from " + this.getFile().getName() + ", this was likely caused by a previous issue in the plugin");
                Files.write(this.getFile().toPath(), StringUtils.join(disguiseText, (String)"\n").getBytes(), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.toDeDupe.clear();
        }
    }

    public String reverseGet(String translated) {
        if (translated == null || !LibsPremium.isPremium().booleanValue() || !DisguiseConfig.isUseTranslations()) {
            return translated;
        }
        String lowerCase = translated.toLowerCase(Locale.ENGLISH);
        for (Map.Entry<String, String> entry : this.translated.entrySet()) {
            if (!Objects.equals(entry.getValue().toLowerCase(Locale.ENGLISH), lowerCase)) continue;
            return entry.getKey();
        }
        return translated;
    }

    public String get(LibsMsg msg) {
        return this.get(msg.getRaw());
    }

    public String get(String msg) {
        if (msg == null || !LibsPremium.isPremium().booleanValue() || !DisguiseConfig.isUseTranslations()) {
            return msg;
        }
        String toReturn = this.translated.get(msg);
        return toReturn == null ? msg : toReturn;
    }
}

