/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.modded.ModdedManager;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListenerModdedClient
extends PacketAdapter {
    private final Cache<String, String> loginAttempts = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build();
    private final int packetId1 = 5555554;
    private final int packetId2 = 5555555;

    public PacketListenerModdedClient() {
        super((Plugin)LibsDisguises.getInstance(), new PacketType[]{PacketType.Login.Client.START, PacketType.Login.Client.CUSTOM_PAYLOAD});
    }

    private int getInt(ByteBuf buf) {
        byte b0;
        int i = 0;
        int j = 0;
        do {
            b0 = buf.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    private void handleModlist(Player player, String name, byte[] data) {
        ByteBuf buf = Unpooled.copiedBuffer((byte[])data);
        int packetId = this.getInt(buf);
        if (packetId != 2) {
            return;
        }
        int count = this.getInt(buf);
        ArrayList<String> mods = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            mods.add(this.getString(buf));
        }
        ModdedManager.getForgeMods().put((Object)name, mods);
    }

    public String getString(ByteBuf buf) {
        int size;
        int j = this.getInt(buf);
        if (j > (size = 256) * 4) {
            throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + j + " > " + size * 4 + ")");
        }
        if (j < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        String s = buf.toString(buf.readerIndex(), j, StandardCharsets.UTF_8);
        buf.readerIndex(buf.readerIndex() + j);
        if (s.length() > size) {
            throw new DecoderException("The received string length is longer than maximum allowed (" + j + " > " + size + ")");
        }
        return s;
    }

    private void handleDataReceived(Player player, String name) {
        PacketContainer packet = new PacketContainer(PacketType.Login.Client.START);
        packet.getModifier().write(0, (Object)new GameProfile(null, name));
        try {
            ProtocolLibrary.getProtocolManager().recieveClientPacket(player, packet, false);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void onPacketReceiving(PacketEvent event) {
        event.setCancelled(true);
        if (event.getPacketType() != PacketType.Login.Client.START) {
            ByteBuf buf;
            String address = event.getPlayer().getAddress().toString();
            String name = (String)this.loginAttempts.getIfPresent((Object)address);
            if (name == null) {
                return;
            }
            if ((Integer)event.getPacket().getIntegers().read(0) == 5555555) {
                this.loginAttempts.invalidate((Object)address);
                this.handleDataReceived(event.getPlayer(), name);
                return;
            }
            if ((Integer)event.getPacket().getIntegers().read(0) == 5555554 && (buf = (ByteBuf)event.getPacket().getModifier().read(1)) != null) {
                byte[] bytes = new byte[buf.readableBytes()];
                buf.readBytes(bytes);
                this.handleModlist(event.getPlayer(), name, bytes);
            }
            return;
        }
        this.loginAttempts.put((Object)event.getPlayer().getAddress().toString(), (Object)((WrappedGameProfile)event.getPacket().getGameProfiles().read(0)).getName());
        PacketContainer packet1 = new PacketContainer(PacketType.Login.Server.CUSTOM_PAYLOAD);
        packet1.getIntegers().write(0, (Object)5555554);
        packet1.getMinecraftKeys().write(0, (Object)new MinecraftKey("fml", "handshake"));
        try {
            Object obj1 = ReflectionManager.getNmsConstructor("PacketDataSerializer", ByteBuf.class).newInstance(Unpooled.wrappedBuffer((byte[])ModdedManager.getFmlHandshake()));
            packet1.getModifier().write(2, obj1);
            PacketContainer packet2 = new PacketContainer(PacketType.Login.Server.CUSTOM_PAYLOAD);
            packet2.getIntegers().write(0, (Object)5555555);
            packet2.getMinecraftKeys().write(0, (Object)new MinecraftKey("fml", "handshake"));
            Object obj2 = ReflectionManager.getNmsConstructor("PacketDataSerializer", ByteBuf.class).newInstance(Unpooled.wrappedBuffer((byte[])ModdedManager.getFmlRegistries()));
            packet2.getModifier().write(2, obj2);
            ProtocolLibrary.getProtocolManager().sendServerPacket(event.getPlayer(), packet1);
            ProtocolLibrary.getProtocolManager().sendServerPacket(event.getPlayer(), packet2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

