/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.wrappers.Vector3F;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import org.bukkit.util.EulerAngle;

public class ArmorStandWatcher
extends LivingWatcher {
    public ArmorStandWatcher(Disguise disguise) {
        super(disguise);
    }

    private boolean getArmorStandFlag(int value) {
        return (this.getData(MetaIndex.ARMORSTAND_META) & value) != 0;
    }

    public EulerAngle getBody() {
        return this.getPose(MetaIndex.ARMORSTAND_BODY);
    }

    public EulerAngle getHead() {
        return this.getPose(MetaIndex.ARMORSTAND_HEAD);
    }

    public EulerAngle getLeftArm() {
        return this.getPose(MetaIndex.ARMORSTAND_LEFT_ARM);
    }

    public EulerAngle getLeftLeg() {
        return this.getPose(MetaIndex.ARMORSTAND_LEFT_LEG);
    }

    private EulerAngle getPose(MetaIndex<Vector3F> type) {
        if (!this.hasValue(type)) {
            return new EulerAngle(0.0, 0.0, 0.0);
        }
        Vector3F vec = this.getData(type);
        return new EulerAngle((double)vec.getX(), (double)vec.getY(), (double)vec.getZ());
    }

    public EulerAngle getRightArm() {
        return this.getPose(MetaIndex.ARMORSTAND_RIGHT_ARM);
    }

    public EulerAngle getRightLeg() {
        return this.getPose(MetaIndex.ARMORSTAND_RIGHT_LEG);
    }

    public boolean isMarker() {
        return this.getArmorStandFlag(16);
    }

    public boolean isNoBasePlate() {
        return this.getArmorStandFlag(8);
    }

    @Override
    public boolean isNoGravity() {
        return this.getArmorStandFlag(2);
    }

    public boolean isShowArms() {
        return this.getArmorStandFlag(4);
    }

    public boolean isSmall() {
        return this.getArmorStandFlag(1);
    }

    private void setArmorStandFlag(int value, boolean isTrue) {
        byte b1 = this.getData(MetaIndex.ARMORSTAND_META);
        b1 = isTrue ? (byte)(b1 | value) : (byte)(b1 & ~value);
        this.setData(MetaIndex.ARMORSTAND_META, b1);
        this.sendData(MetaIndex.ARMORSTAND_META);
    }

    public void setBody(EulerAngle vector) {
        this.setPose(MetaIndex.ARMORSTAND_BODY, vector);
    }

    public void setHead(EulerAngle vector) {
        this.setPose(MetaIndex.ARMORSTAND_HEAD, vector);
    }

    public void setLeftArm(EulerAngle vector) {
        this.setPose(MetaIndex.ARMORSTAND_LEFT_ARM, vector);
    }

    public void setLeftLeg(EulerAngle vector) {
        this.setPose(MetaIndex.ARMORSTAND_LEFT_LEG, vector);
    }

    public void setMarker(boolean isMarker) {
        this.setArmorStandFlag(16, isMarker);
    }

    public void setNoBasePlate(boolean noBasePlate) {
        this.setArmorStandFlag(8, noBasePlate);
    }

    @Override
    public void setNoGravity(boolean noGravity) {
        this.setArmorStandFlag(2, noGravity);
    }

    private void setPose(MetaIndex<Vector3F> type, EulerAngle vector) {
        this.setData(type, new Vector3F((float)vector.getX(), (float)vector.getY(), (float)vector.getZ()));
        this.sendData(type);
    }

    public void setRightArm(EulerAngle vector) {
        this.setPose(MetaIndex.ARMORSTAND_RIGHT_ARM, vector);
    }

    public void setRightLeg(EulerAngle vector) {
        this.setPose(MetaIndex.ARMORSTAND_RIGHT_LEG, vector);
    }

    public void setShowArms(boolean showArms) {
        this.setArmorStandFlag(4, showArms);
    }

    public void setSmall(boolean isSmall) {
        this.setArmorStandFlag(1, isSmall);
    }
}

