/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.LibsDisguisesCommand;
import me.libraryaddict.disguise.commands.disguise.DisguiseCommand;
import me.libraryaddict.disguise.commands.disguise.DisguiseEntityCommand;
import me.libraryaddict.disguise.commands.disguise.DisguisePlayerCommand;
import me.libraryaddict.disguise.commands.disguise.DisguiseRadiusCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyEntityCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyPlayerCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyRadiusCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguiseCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguiseEntityCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguisePlayerCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguiseRadiusCommand;
import me.libraryaddict.disguise.commands.utils.CopyDisguiseCommand;
import me.libraryaddict.disguise.commands.utils.DisguiseCloneCommand;
import me.libraryaddict.disguise.commands.utils.DisguiseHelpCommand;
import me.libraryaddict.disguise.commands.utils.DisguiseViewBarCommand;
import me.libraryaddict.disguise.commands.utils.DisguiseViewSelfCommand;
import me.libraryaddict.disguise.commands.utils.GrabHeadCommand;
import me.libraryaddict.disguise.commands.utils.GrabSkinCommand;
import me.libraryaddict.disguise.commands.utils.SaveDisguiseCommand;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.config.DisguiseCommandConfig;
import me.libraryaddict.disguise.utilities.listeners.DisguiseListener;
import me.libraryaddict.disguise.utilities.listeners.PaperDisguiseListener;
import me.libraryaddict.disguise.utilities.listeners.PlayerSkinHandler;
import me.libraryaddict.disguise.utilities.metrics.MetricsInitalizer;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.sounds.SoundManager;
import me.libraryaddict.disguise.utilities.updates.UpdateChecker;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LibsDisguises
extends JavaPlugin {
    private static LibsDisguises instance;
    private DisguiseListener listener;
    private String buildNumber;
    private boolean reloaded;
    private final UpdateChecker updateChecker = new UpdateChecker();
    private PlayerSkinHandler skinHandler;
    private DisguiseCommandConfig commandConfig;

    public void onLoad() {
        try {
            if (instance != null || !Bukkit.getServer().getWorlds().isEmpty() || !Bukkit.getOnlinePlayers().isEmpty()) {
                this.reloaded = true;
                this.getLogger().severe("Server was reloaded! Please do not report any bugs! This plugin can't handle reloads gracefully!");
            }
            instance = this;
            Plugin plugin = Bukkit.getPluginManager().getPlugin("ProtocolLib");
            if (plugin == null || DisguiseUtilities.isProtocolLibOutdated()) {
                this.getLogger().warning("Noticed you're using an older version of ProtocolLib (or not using it)! We're forcibly updating you!");
                try {
                    File dest = DisguiseUtilities.updateProtocolLib();
                    if (plugin == null) {
                        this.getLogger().info("ProtocolLib downloaded and stuck in plugins folder! Now trying to load it!");
                        plugin = Bukkit.getPluginManager().loadPlugin(dest);
                        plugin.onLoad();
                        Bukkit.getPluginManager().enablePlugin(plugin);
                    } else {
                        this.getLogger().severe("Please restart the server to complete the ProtocolLib update!");
                    }
                }
                catch (Exception e) {
                    this.getLogger().severe("Looks like ProtocolLib's site may be down! MythicCraft/MythicMobs has a discord server https://discord.gg/EErRhJ4qgx you can join. Check the pins in #libs-support for a ProtocolLib.jar you can download!");
                    e.printStackTrace();
                }
            }
            try {
                Class<?> e = Class.forName("org.bukkit.Server$Spigot");
            }
            catch (ClassNotFoundException e) {
                this.getLogger().severe("Oh dear, you seem to be using CraftBukkit. Please use Spigot or Paper instead! This plugin will continue to load, but it will look like a mugging victim");
            }
            this.commandConfig = new DisguiseCommandConfig();
            if (!this.reloaded) {
                this.commandConfig.load();
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.isNumberedBuild() && DisguiseConfig.isAutoUpdate()) {
                    this.getUpdateChecker().doUpdate();
                }
            }
            catch (Throwable t) {
                this.getLogger().severe("Failed to even do a forced update");
            }
            throw throwable;
        }
    }

    public void onEnable() {
        try {
            if (this.reloaded) {
                this.getLogger().severe("Server was reloaded! Please do not report any bugs! This plugin can't handle reloads gracefully!");
            }
            if (Bukkit.getVersion().contains("(MC: 1.17)")) {
                this.getLogger().severe("Please update from MC 1.17! You should be using 1.17.1!");
            }
            if (Bukkit.getVersion().contains("(MC: 1.18)") || Bukkit.getVersion().contains("(MC: 1.18.1)")) {
                this.getLogger().severe("Please update from MC 1.18 and MC 1.18.1! You should be using 1.18.2! Support will eventually be dropped for your specific version!");
            }
            try {
                Class<?> clazz = Class.forName("org.bukkit.Server$Spigot");
            }
            catch (ClassNotFoundException e) {
                this.getLogger().severe("Oh dear, you seem to be using CraftBukkit. Please use Spigot or Paper instead! This plugin will continue to load, but it will look like a mugging victim");
            }
            File disguiseFile = new File(this.getDataFolder(), "configs/disguises.yml");
            if (!disguiseFile.exists()) {
                disguiseFile.getParentFile().mkdirs();
                File oldFile = new File(this.getDataFolder(), "disguises.yml");
                if (oldFile.exists()) {
                    oldFile.renameTo(disguiseFile);
                } else {
                    this.saveResource("configs/disguises.yml", false);
                }
            }
            YamlConfiguration pluginYml = ReflectionManager.getPluginYAML(this.getFile());
            this.buildNumber = StringUtils.stripToNull((String)pluginYml.getString("build-number"));
            this.getLogger().info("File Name: " + this.getFile().getName());
            this.getLogger().info("Discovered nms version: " + ReflectionManager.getBukkitVersion());
            this.getLogger().info("Jenkins Build: " + (this.isNumberedBuild() ? "#" : "") + this.getBuildNo());
            this.getLogger().info("Build Date: " + pluginYml.getString("build-date"));
            DisguiseConfig.loadInternalConfig();
            LibsPremium.check(this.getDescription().getVersion(), this.getFile());
            if (!LibsPremium.isPremium().booleanValue()) {
                this.getLogger().info("You are running the free version, commands limited to non-players and operators. (Console, Command Blocks, Admins)");
            }
            if (ReflectionManager.getVersion() == null) {
                this.getLogger().severe("You're using the wrong version of Lib's Disguises for your server! This is intended for " + StringUtils.join((Collection)Arrays.stream(NmsVersion.values()).map(v -> v.name().replace("_", ".")).collect(Collectors.toList()), (String)" & ") + "!");
                this.getPluginLoader().disablePlugin((Plugin)this);
                return;
            }
            if (DisguiseUtilities.isProtocolLibOutdated()) {
                final String requiredProtocolLib = StringUtils.join((Object[])DisguiseUtilities.getProtocolLibRequiredVersion(), (String)" or build #");
                final String version = Bukkit.getPluginManager().getPlugin("ProtocolLib").getDescription().getVersion();
                BukkitRunnable runnable = new BukkitRunnable(){
                    private int timesRun;

                    public void run() {
                        LibsDisguises.this.getLogger().severe("!! May I have your attention please !!");
                        LibsDisguises.this.getLogger().severe("Update your ProtocolLib! You are running " + version + " but the minimum version you should be on is " + requiredProtocolLib + "!");
                        LibsDisguises.this.getLogger().severe("https://ci.dmulloy2.net/job/ProtocolLib/lastSuccessfulBuild/artifact/target/ProtocolLib.jar");
                        LibsDisguises.this.getLogger().severe("Or! Use /ld protocollib - To update to the latest development build");
                        if (this.timesRun++ > 0) {
                            LibsDisguises.this.getLogger().severe("This message is on repeat due to the sheer number of people who don't see this.");
                        }
                        LibsDisguises.this.getLogger().severe("!! May I have your attention please !!");
                    }
                };
                runnable.run();
                runnable.runTaskTimer((Plugin)this, 20L, 12000L);
            }
            if (this.isReleaseBuild()) {
                if (LibsPremium.getUserID().matches("[0-9]+")) {
                    DisguiseConfig.setUsingReleaseBuilds(true);
                }
            } else {
                DisguiseConfig.setUsingReleaseBuilds(false);
            }
            ReflectionManager.init();
            PacketsManager.init();
            DisguiseUtilities.init();
            new SoundManager().load();
            ReflectionManager.registerValues();
            ParamInfoManager.getParamInfoSoundGroup().recalculate();
            DisguiseConfig.loadConfig();
            DisguiseParser.createDefaultMethods();
            PacketsManager.addPacketListeners();
            this.listener = new DisguiseListener(this);
            this.skinHandler = new PlayerSkinHandler();
            Bukkit.getPluginManager().registerEvents((Listener)this.getSkinHandler(), (Plugin)LibsDisguises.getInstance());
            if (DisguiseUtilities.isRunningPaper()) {
                Bukkit.getPluginManager().registerEvents((Listener)new PaperDisguiseListener(), (Plugin)this);
            }
            this.registerCommand("libsdisguises", new LibsDisguisesCommand());
            this.registerCommand("disguise", new DisguiseCommand());
            this.registerCommand("undisguise", new UndisguiseCommand());
            this.registerCommand("disguiseplayer", new DisguisePlayerCommand());
            this.registerCommand("undisguiseplayer", new UndisguisePlayerCommand());
            this.registerCommand("undisguiseentity", new UndisguiseEntityCommand());
            this.registerCommand("disguiseentity", new DisguiseEntityCommand());
            this.registerCommand("disguiseradius", new DisguiseRadiusCommand());
            this.registerCommand("undisguiseradius", new UndisguiseRadiusCommand());
            this.registerCommand("disguisehelp", new DisguiseHelpCommand());
            this.registerCommand("disguiseclone", new DisguiseCloneCommand());
            this.registerCommand("disguiseviewself", new DisguiseViewSelfCommand());
            this.registerCommand("disguiseviewbar", new DisguiseViewBarCommand());
            this.registerCommand("disguisemodify", new DisguiseModifyCommand());
            this.registerCommand("disguisemodifyentity", new DisguiseModifyEntityCommand());
            this.registerCommand("disguisemodifyplayer", new DisguiseModifyPlayerCommand());
            this.registerCommand("disguisemodifyradius", new DisguiseModifyRadiusCommand());
            this.registerCommand("copydisguise", new CopyDisguiseCommand());
            this.registerCommand("grabskin", new GrabSkinCommand());
            this.registerCommand("savedisguise", new SaveDisguiseCommand());
            this.registerCommand("grabhead", new GrabHeadCommand());
            this.unregisterCommands(false);
            new MetricsInitalizer();
        }
        catch (Throwable throwable) {
            try {
                if (this.isNumberedBuild() && DisguiseConfig.isAutoUpdate()) {
                    this.getUpdateChecker().doUpdate();
                }
            }
            catch (Throwable t) {
                this.getLogger().severe("Failed to even do a forced update");
            }
            throw throwable;
        }
    }

    public void unregisterCommands(boolean force) {
        SimpleCommandMap map = ReflectionManager.getCommandMap();
        Map<String, Command> commands = ReflectionManager.getCommands((CommandMap)map);
        for (String command : this.getDescription().getCommands().keySet()) {
            PluginCommand cmd = this.getCommand("libsdisguises:" + command);
            if (cmd == null || cmd.getExecutor() != this && !force) continue;
            if (cmd.getPermission() != null && cmd.getPermission().startsWith("libsdisguises.seecmd")) {
                Bukkit.getPluginManager().removePermission(cmd.getPermission());
            }
            Iterator<Map.Entry<String, Command>> itel = commands.entrySet().iterator();
            while (itel.hasNext()) {
                Map.Entry<String, Command> entry = itel.next();
                if (entry.getValue() != cmd) continue;
                itel.remove();
            }
        }
    }

    public File getFile() {
        return super.getFile();
    }

    public void onDisable() {
        DisguiseUtilities.saveDisguises();
        this.reloaded = true;
    }

    public boolean isReleaseBuild() {
        return !this.getDescription().getVersion().contains("-SNAPSHOT");
    }

    public String getBuildNo() {
        return this.buildNumber;
    }

    public int getBuildNumber() {
        return this.isNumberedBuild() ? Integer.parseInt(this.getBuildNo()) : 0;
    }

    public boolean isNumberedBuild() {
        return this.getBuildNo() != null && this.getBuildNo().matches("[0-9]+");
    }

    private void registerCommand(String commandName, CommandExecutor executioner) {
        String name = this.commandConfig.getCommand(commandName);
        if (name == null) {
            return;
        }
        PluginCommand command = this.getCommand("libsdisguises:" + name);
        if (command == null) {
            return;
        }
        command.setExecutor(executioner);
        if (executioner instanceof TabCompleter) {
            command.setTabCompleter((TabCompleter)executioner);
        }
    }

    @Deprecated
    public void reload() {
        DisguiseConfig.loadConfig();
    }

    public DisguiseListener getListener() {
        return this.listener;
    }

    public static LibsDisguises getInstance() {
        return instance;
    }

    public boolean isReloaded() {
        return this.reloaded;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public PlayerSkinHandler getSkinHandler() {
        return this.skinHandler;
    }
}

