/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListenerSounds
extends PacketAdapter {
    private static boolean cancelSound;

    public PacketListenerSounds(LibsDisguises plugin) {
        super((Plugin)plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.NAMED_SOUND_EFFECT, PacketType.Play.Server.ENTITY_STATUS});
    }

    public void onPacketSending(PacketEvent event) {
        if (event.isCancelled() || event.isAsync() || event.isPlayerTemporary()) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Server.ENTITY_STATUS) {
            this.handleEntityStatus(event);
        } else if (event.getPacketType() == PacketType.Play.Server.NAMED_SOUND_EFFECT) {
            this.handleNamedSoundEffect(event);
        }
    }

    private void handleNamedSoundEffect(PacketEvent event) {
        StructureModifier mods = event.getPacket().getModifier();
        Player observer = event.getPlayer();
        SoundGroup.SoundType soundType = null;
        Entity disguisedEntity = null;
        SoundGroup soundGroup = null;
        Object soundEffectObj = mods.read(0);
        Disguise disguise = null;
        int[] soundCords = new int[]{(Integer)mods.read(2), (Integer)mods.read(3), (Integer)mods.read(4)};
        for (Set<TargetedDisguise> disguises : DisguiseUtilities.getDisguises().values()) {
            for (TargetedDisguise entityDisguise : disguises) {
                Entity entity = entityDisguise.getEntity();
                if (entity == null || entity.getWorld() != observer.getWorld() || !entityDisguise.canSee(observer)) continue;
                Location loc = entity.getLocation();
                int[] entCords = new int[]{(int)(loc.getX() * 8.0), (int)(loc.getY() * 8.0), (int)(loc.getZ() * 8.0)};
                if (soundCords[0] != entCords[0] || soundCords[1] != entCords[1] || soundCords[2] != entCords[2]) continue;
                disguise = entityDisguise;
                disguisedEntity = entity;
                soundGroup = SoundGroup.getGroup(entity.getType().name());
                if (soundGroup.getSound(soundEffectObj) == null) {
                    return;
                }
                if (!(entity instanceof LivingEntity) || ((LivingEntity)entity).getHealth() > 0.0) {
                    boolean hasInvun = ReflectionManager.hasInvul(entity);
                    soundType = soundGroup.getType(soundEffectObj, !hasInvun);
                    continue;
                }
                soundType = SoundGroup.SoundType.DEATH;
            }
            if (disguise == null) continue;
            break;
        }
        if (disguise == null || !disguise.isSoundsReplaced()) {
            return;
        }
        if (soundType != SoundGroup.SoundType.STEP && soundType != SoundGroup.SoundType.IDLE) {
            event.setCancelled(true);
            return;
        }
        if (disguisedEntity == observer && !disguise.isSelfDisguiseSoundsReplaced()) {
            return;
        }
        Object sound = null;
        SoundGroup disguiseSound = SoundGroup.getGroup(disguise);
        if (disguiseSound != null) {
            sound = disguiseSound.getSound(soundType);
        }
        if (sound == null) {
            event.setCancelled(true);
            return;
        }
        Enum soundCat = ReflectionManager.getSoundCategory(disguise.getType());
        float volume = ((Float)mods.read(5)).floatValue();
        float pitch = ((Float)mods.read(6)).floatValue();
        if (volume == soundGroup.getDamageAndIdleSoundVolume()) {
            volume = disguiseSound.getDamageAndIdleSoundVolume();
        }
        if (disguise instanceof MobDisguise && disguisedEntity instanceof LivingEntity && ((MobDisguise)disguise).doesDisguiseAge()) {
            pitch = ((MobDisguise)disguise).isAdult() ? (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.0f : (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.4f;
        }
        if (sound.getClass().getSimpleName().equals("MinecraftKey")) {
            PacketContainer newPacket = new PacketContainer(PacketType.Play.Server.CUSTOM_SOUND_EFFECT);
            StructureModifier newModifs = newPacket.getModifier();
            newModifs.write(0, sound);
            newModifs.write(1, (Object)soundCat);
            newModifs.write(2, mods.read(2));
            newModifs.write(3, mods.read(3));
            newModifs.write(4, mods.read(4));
            newModifs.write(5, (Object)Float.valueOf(volume));
            newModifs.write(6, (Object)Float.valueOf(pitch));
            event.setPacket(newPacket);
        } else {
            event.setPacket(event.getPacket().shallowClone());
            mods = event.getPacket().getModifier();
            mods.write(0, sound);
            mods.write(1, (Object)soundCat);
            mods.write(5, (Object)Float.valueOf(volume));
            mods.write(6, (Object)Float.valueOf(pitch));
        }
    }

    private void handleEntityStatus(PacketEvent event) {
        SoundGroup entitySoundGroup;
        StructureModifier mods = event.getPacket().getModifier();
        Player observer = event.getPlayer();
        if ((Byte)mods.read(1) != 2) {
            return;
        }
        Disguise disguise = DisguiseUtilities.getDisguise(observer, (Integer)event.getPacket().getIntegers().read(0));
        if (disguise == null) {
            return;
        }
        Entity entity = disguise.getEntity();
        if (disguise instanceof TargetedDisguise) {
            Set<TargetedDisguise> discs = DisguiseUtilities.getDisguises().get(entity.getEntityId());
            for (TargetedDisguise targetedDisguise : discs) {
                if (targetedDisguise != disguise || targetedDisguise.canSee(observer)) continue;
                return;
            }
        }
        SoundGroup.SoundType soundType = SoundGroup.SoundType.HURT;
        if (entity instanceof LivingEntity && ((LivingEntity)entity).getHealth() == 0.0) {
            soundType = SoundGroup.SoundType.DEATH;
        }
        if (entity == event.getPlayer() && !disguise.getType().isPlayer() && !disguise.isSelfDisguiseSoundsReplaced()) {
            boolean bl = cancelSound = !cancelSound;
            if (cancelSound) {
                return;
            }
        }
        if ((entitySoundGroup = SoundGroup.getGroup(entity.getType().name())) == null) {
            return;
        }
        Object sound = entitySoundGroup.getSound(soundType);
        if (sound == null) {
            return;
        }
        SoundGroup disSound = SoundGroup.getGroup(disguise);
        if (disSound == null || disSound == entitySoundGroup) {
            return;
        }
        Location loc = entity.getLocation();
        PacketContainer packet = new PacketContainer(sound.getClass().getSimpleName().equals("MinecraftKey") ? PacketType.Play.Server.CUSTOM_SOUND_EFFECT : PacketType.Play.Server.NAMED_SOUND_EFFECT);
        mods = packet.getModifier();
        mods.write(0, sound);
        mods.write(1, (Object)ReflectionManager.getSoundCategory(disguise.getType()));
        mods.write(2, (Object)((int)(loc.getX() * 8.0)));
        mods.write(3, (Object)((int)(loc.getY() * 8.0)));
        mods.write(4, (Object)((int)(loc.getZ() * 8.0)));
        mods.write(5, (Object)Float.valueOf(disSound.getDamageAndIdleSoundVolume()));
        float pitch = disguise instanceof MobDisguise && !((MobDisguise)disguise).isAdult() ? (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.4f : (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.0f;
        if (disguise.getType() == DisguiseType.BAT) {
            pitch *= 0.95f;
        }
        mods.write(6, (Object)Float.valueOf(pitch));
        event.setCancelled(true);
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(observer, packet, false);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

