/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.config.ConfigLoader;
import me.libraryaddict.disguise.utilities.modded.ModdedEntity;
import me.libraryaddict.disguise.utilities.modded.ModdedManager;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class DisguiseConfig {
    private static HashMap<DisguisePerm, String> customDisguises = new HashMap();
    private static UpdatesBranch updatesBranch = UpdatesBranch.SAME_BUILDS;
    private static boolean addEntityAnimations;
    private static boolean animationPacketsEnabled;
    private static boolean catDyeable;
    private static boolean collectPacketsEnabled;
    private static boolean disableFriendlyInvisibles;
    private static boolean disabledInvisibility;
    private static boolean disguiseBlownWhenAttacked;
    private static boolean disguiseBlownWhenAttacking;
    private static boolean dynamicExpiry;
    private static boolean entityStatusPacketsEnabled;
    private static boolean equipmentPacketsEnabled;
    private static boolean explicitDisguisePermissions;
    private static boolean hideDisguisedPlayers;
    private static boolean hidingArmorFromSelf;
    private static boolean hidingCreativeEquipmentFromSelf;
    private static boolean hidingHeldItemFromSelf;
    private static boolean horseSaddleable;
    private static boolean keepDisguiseOnPlayerDeath;
    private static boolean llamaCarpetable;
    private static boolean maxHealthDeterminedByDisguisedEntity;
    private static boolean metaPacketsEnabled;
    private static boolean miscDisguisesForLivingEnabled;
    private static boolean modifyBoundingBox;
    private static boolean modifyCollisions;
    private static boolean monstersIgnoreDisguises;
    private static boolean movementPacketsEnabled;
    private static boolean nameAboveHeadAlwaysVisible;
    private static boolean nameOfPlayerShownAboveDisguise;
    private static boolean playerHideArmor;
    private static boolean saveEntityDisguises;
    private static boolean saveGameProfiles;
    private static boolean savePlayerDisguises;
    private static boolean selfDisguisesSoundsReplaced;
    private static boolean sheepDyeable;
    private static boolean showDisguisedPlayersInTab;
    private static boolean stopShulkerDisguisesFromMoving;
    private static boolean undisguiseOnWorldChange;
    private static boolean updateGameProfiles;
    private static boolean useTranslations;
    private static boolean velocitySent;
    private static boolean viewDisguises;
    private static boolean warnScoreboardConflict;
    private static boolean witherSkullPacketsEnabled;
    private static boolean wolfDyeable;
    private static int disguiseCloneExpire;
    private static int disguiseEntityExpire;
    private static int maxClonedDisguises;
    private static int uuidGeneratedVersion;
    private static boolean disablePvP;
    private static boolean disablePvE;
    private static double pvPTimer;
    private static boolean retaliationCombat;
    private static NotifyBar notifyBar;
    private static BarStyle bossBarStyle;
    private static BarColor bossBarColor;
    private static PermissionDefault commandVisibility;
    private static int tablistRemoveDelay;
    private static boolean usingReleaseBuild;
    private static boolean bisectHosted;
    private static String savedServerIp;
    private static Boolean autoUpdate;
    private static boolean notifyUpdate;
    private static BukkitTask updaterTask;
    private static boolean tallSelfDisguises;
    private static PlayerNameType playerNameType;
    private static boolean overrideCustomNames;
    private static boolean randomDisguises;
    private static boolean loginPayloadPackets;
    private static boolean saveUserPreferences;
    private static long lastUpdateRequest;
    private static boolean hittingRateLimit;
    private static boolean copyPlayerTeamInfo;
    private static String nameAboveDisguise;
    private static int playerDisguisesSkinExpiresMove;
    private static boolean viewSelfDisguisesDefault;
    private static String lastGithubUpdateETag;
    private static String lastPluginUpdateVersion;
    private static boolean contactMojangServers;
    private static int disguiseRadiusMax;
    private static String data;

    public static boolean isArmorstandsName() {
        return DisguiseConfig.getPlayerNameType() == PlayerNameType.ARMORSTANDS;
    }

    public static boolean isExtendedNames() {
        return DisguiseConfig.getPlayerNameType() == PlayerNameType.EXTENDED;
    }

    public static boolean isAutoUpdate() {
        if (DisguiseConfig.getAutoUpdate() == null) {
            autoUpdate = LibsDisguises.getInstance().getConfig().getBoolean("AutoUpdate");
        }
        return DisguiseConfig.getAutoUpdate();
    }

    public static void setAutoUpdate(boolean update) {
        if (DisguiseConfig.isAutoUpdate() == update) {
            return;
        }
        autoUpdate = update;
        DisguiseConfig.doUpdaterTask();
    }

    public static void setNotifyUpdate(boolean update) {
        if (DisguiseConfig.isNotifyUpdate() == update) {
            return;
        }
        notifyUpdate = update;
        DisguiseConfig.doUpdaterTask();
    }

    public static void setLastUpdateRequest(long lastRequest) {
        if (lastRequest <= DisguiseConfig.getLastUpdateRequest()) {
            return;
        }
        lastUpdateRequest = lastRequest;
        DisguiseConfig.saveInternalConfig();
    }

    private static void doUpdaterTask() {
        boolean startTask;
        boolean bl = DisguiseConfig.isAutoUpdate() || DisguiseConfig.isNotifyUpdate() || "1592".equals((LibsPremium.getPaidInformation() == null ? LibsPremium.getPluginInformation() : LibsPremium.getPaidInformation()).getUserID()) ? true : (startTask = false);
        if (!LibsDisguises.getInstance().isNumberedBuild()) {
            return;
        }
        if (updaterTask == null != startTask) {
            return;
        }
        if (!startTask) {
            updaterTask.cancel();
            updaterTask = null;
            return;
        }
        int timer = (int)(TimeUnit.HOURS.toSeconds(DisguiseConfig.isHittingRateLimit() ? 36L : 12L) * 20L);
        long timeSinceLast = (System.currentTimeMillis() - DisguiseConfig.getLastUpdateRequest()) / 50L;
        timeSinceLast = Math.max(36000L, (long)timer - timeSinceLast);
        updaterTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)LibsDisguises.getInstance(), new Runnable(){

            @Override
            public void run() {
                LibsDisguises.getInstance().getUpdateChecker().doAutoUpdateCheck();
            }
        }, timeSinceLast, (long)timer);
    }

    public static void setUsingReleaseBuilds(boolean useReleaseBuilds) {
        if (useReleaseBuilds == DisguiseConfig.isUsingReleaseBuild()) {
            return;
        }
        usingReleaseBuild = useReleaseBuilds;
        DisguiseConfig.saveInternalConfig();
    }

    public static void setHittingRateLimit(boolean hitRateLimit) {
        if (hitRateLimit == DisguiseConfig.isHittingRateLimit()) {
            return;
        }
        hittingRateLimit = hitRateLimit;
        DisguiseConfig.saveInternalConfig();
        DisguiseConfig.doUpdaterTask();
    }

    public static void setBisectHosted(boolean isBisectHosted, String serverIP) {
        if (DisguiseConfig.isBisectHosted() == isBisectHosted && DisguiseConfig.getSavedServerIp().equals(serverIP)) {
            return;
        }
        bisectHosted = isBisectHosted;
        savedServerIp = serverIP;
        DisguiseConfig.saveInternalConfig();
    }

    public static void loadInternalConfig() {
        File internalFile = new File(LibsDisguises.getInstance().getDataFolder(), "internal.yml");
        if (!internalFile.exists()) {
            DisguiseConfig.saveInternalConfig();
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)internalFile);
        bisectHosted = configuration.getBoolean("Bisect-Hosted", DisguiseConfig.isBisectHosted());
        savedServerIp = configuration.getString("Server-IP", DisguiseConfig.getSavedServerIp());
        usingReleaseBuild = configuration.getBoolean("ReleaseBuild", DisguiseConfig.isUsingReleaseBuild());
        lastUpdateRequest = configuration.getLong("LastUpdateRequest", 0L);
        hittingRateLimit = configuration.getBoolean("HittingRateLimit", false);
        lastGithubUpdateETag = configuration.getString("LastGithubETag", null);
        lastPluginUpdateVersion = configuration.getString("LastPluginVersion", null);
        data = configuration.getString("Data", null);
        if (!(configuration.contains("Bisect-Hosted") && configuration.contains("Server-IP") && configuration.contains("ReleaseBuild"))) {
            DisguiseConfig.saveInternalConfig();
        }
    }

    public static void saveInternalConfig() {
        File internalFile = new File(LibsDisguises.getInstance().getDataFolder(), "internal.yml");
        String internalConfig = ReflectionManager.getResourceAsString(LibsDisguises.getInstance().getFile(), "internal.yml");
        for (Object s : new Object[]{DisguiseConfig.isBisectHosted(), DisguiseConfig.getSavedServerIp(), DisguiseConfig.isUsingReleaseBuild(), DisguiseConfig.getLastUpdateRequest(), DisguiseConfig.isHittingRateLimit(), DisguiseConfig.getLastGithubUpdateETag(), DisguiseConfig.getLastPluginUpdateVersion(), DisguiseConfig.getData()}) {
            internalConfig = internalConfig.replaceFirst("%data%", "" + s);
        }
        internalFile.delete();
        try {
            internalFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (PrintWriter writer = new PrintWriter(internalFile, "UTF-8");){
            writer.write(internalConfig);
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static PermissionDefault getCommandVisibility() {
        return commandVisibility;
    }

    public static void setCommandVisibility(PermissionDefault permissionDefault) {
        if (permissionDefault == null || DisguiseConfig.getCommandVisibility() == permissionDefault) {
            return;
        }
        commandVisibility = permissionDefault;
        for (Permission perm : LibsDisguises.getInstance().getDescription().getPermissions()) {
            if (!perm.getName().startsWith("libsdisguises.seecmd")) continue;
            perm.setDefault(DisguiseConfig.getCommandVisibility());
        }
    }

    private DisguiseConfig() {
    }

    public static int getUUIDGeneratedVersion() {
        return uuidGeneratedVersion;
    }

    public static void setUUIDGeneratedVersion(int uuidVersion) {
        uuidGeneratedVersion = uuidVersion;
    }

    public static Map.Entry<DisguisePerm, Disguise> getCustomDisguise(String disguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Custom Disguises should not be called async!");
        }
        Map.Entry<DisguisePerm, String> entry = DisguiseConfig.getRawCustomDisguise(disguise);
        if (entry == null) {
            return null;
        }
        try {
            return new AbstractMap.SimpleEntry<DisguisePerm, Disguise>(entry.getKey(), DisguiseParser.parseDisguise(entry.getValue()));
        }
        catch (Throwable e) {
            DisguiseUtilities.getLogger().warning("Error when attempting to grab the custom disguise " + disguise);
            e.printStackTrace();
            return null;
        }
    }

    public static Map.Entry<DisguisePerm, Disguise> getCustomDisguise(Entity target, String disguise) throws Throwable {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Custom Disguises should not be called async!");
        }
        Map.Entry<DisguisePerm, String> entry = DisguiseConfig.getRawCustomDisguise(disguise);
        if (entry == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<DisguisePerm, Disguise>(entry.getKey(), DisguiseParser.parseDisguise((CommandSender)Bukkit.getConsoleSender(), target, entry.getValue()));
    }

    public static Map.Entry<DisguisePerm, Disguise> getCustomDisguise(CommandSender invoker, Entity target, String disguise) throws Throwable {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Custom Disguises should not be called async!");
        }
        Map.Entry<DisguisePerm, String> entry = DisguiseConfig.getRawCustomDisguise(disguise);
        if (entry == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<DisguisePerm, Disguise>(entry.getKey(), DisguiseParser.parseDisguise(invoker, target, entry.getValue()));
    }

    public static boolean isScoreboardNames() {
        return DisguiseConfig.getPlayerNameType() != PlayerNameType.VANILLA;
    }

    public static void removeCustomDisguise(String disguise) {
        for (DisguisePerm entry : customDisguises.keySet()) {
            String name = entry.toReadable();
            if (!name.equalsIgnoreCase(disguise) && !name.replaceAll("_", "").equalsIgnoreCase(disguise)) continue;
            customDisguises.remove(entry);
            break;
        }
    }

    public static Map.Entry<DisguisePerm, String> getRawCustomDisguise(String disguise) {
        for (Map.Entry<DisguisePerm, String> entry : customDisguises.entrySet()) {
            String name = entry.getKey().toReadable();
            if (!name.equalsIgnoreCase(disguise) && !name.replaceAll("_", "").equalsIgnoreCase(disguise)) continue;
            return entry;
        }
        return null;
    }

    public static void setUseTranslations(boolean setUseTranslations) {
        useTranslations = setUseTranslations;
        TranslateType.refreshTranslations();
    }

    public static void loadConfig() {
        int missingConfigs;
        ArrayList<String> returns;
        boolean verbose;
        PermissionDefault commandVisibility;
        ConfigLoader configLoader = new ConfigLoader();
        configLoader.saveMissingConfigs();
        DisguiseConfig.loadModdedDisguiseTypes();
        File skinsFolder = new File(LibsDisguises.getInstance().getDataFolder(), "Skins");
        if (!skinsFolder.exists()) {
            skinsFolder.mkdir();
            File explain = new File(skinsFolder, "README");
            try {
                explain.createNewFile();
                try (PrintWriter out = new PrintWriter(explain);){
                    out.println("This folder is used to store .png files for uploading with the /savedisguise or /grabskin commands");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        YamlConfiguration config = configLoader.load();
        PacketsManager.setViewDisguisesListener(true);
        DisguiseConfig.setAddEntityAnimations(config.getBoolean("AddEntityAnimations"));
        DisguiseConfig.setAnimationPacketsEnabled(config.getBoolean("PacketsEnabled.Animation"));
        DisguiseConfig.setCatDyeable(config.getBoolean("DyeableCat"));
        DisguiseConfig.setCollectPacketsEnabled(config.getBoolean("PacketsEnabled.Collect"));
        DisguiseConfig.setDisableFriendlyInvisibles(config.getBoolean("Scoreboard.DisableFriendlyInvisibles"));
        DisguiseConfig.setDisabledInvisibility(config.getBoolean("DisableInvisibility"));
        DisguiseConfig.setDisablePvP(config.getBoolean("DisablePvP"));
        DisguiseConfig.setDisablePvE(config.getBoolean("DisablePvE"));
        DisguiseConfig.setPvPTimer(config.getDouble("PvPTimer"));
        DisguiseConfig.setDisguiseBlownWhenAttacked(config.getBoolean("BlowDisguisesWhenAttacked"));
        DisguiseConfig.setDisguiseBlownWhenAttacking(config.getBoolean("BlowDisguisesWhenAttacking"));
        DisguiseConfig.setDisguiseCloneExpire(config.getInt("DisguiseCloneExpire"));
        DisguiseConfig.setDisguiseEntityExpire(config.getInt("DisguiseEntityExpire"));
        DisguiseConfig.setDynamicExpiry(config.getBoolean("DynamicExpiry"));
        DisguiseConfig.setEntityStatusPacketsEnabled(config.getBoolean("PacketsEnabled.EntityStatus"));
        DisguiseConfig.setEquipmentPacketsEnabled(config.getBoolean("PacketsEnabled.Equipment"));
        DisguiseConfig.setExplicitDisguisePermissions(config.getBoolean("Permissions.ExplicitDisguises"));
        DisguiseConfig.setHideArmorFromSelf(config.getBoolean("RemoveArmor"));
        DisguiseConfig.setHidingCreativeEquipmentFromSelf(config.getBoolean("RemoveCreativeEquipment"));
        DisguiseConfig.setHideDisguisedPlayers(config.getBoolean("HideDisguisedPlayersFromTab"));
        DisguiseConfig.setHideHeldItemFromSelf(config.getBoolean("RemoveHeldItem"));
        DisguiseConfig.setHorseSaddleable(config.getBoolean("SaddleableHorse"));
        DisguiseConfig.setKeepDisguiseOnPlayerDeath(config.getBoolean("KeepDisguises.PlayerDeath"));
        DisguiseConfig.setLlamaCarpetable(config.getBoolean("CarpetableLlama"));
        DisguiseConfig.setMaxClonedDisguises(config.getInt("DisguiseCloneSize"));
        DisguiseConfig.setMaxHealthDeterminedByDisguisedEntity(config.getBoolean("MaxHealthDeterminedByEntity"));
        DisguiseConfig.setMetaPacketsEnabled(config.getBoolean("PacketsEnabled.Metadata"));
        DisguiseConfig.setLoginPayloadPackets(config.getBoolean("PacketsEnabled.LoginPayload"));
        DisguiseConfig.setMiscDisguisesForLivingEnabled(config.getBoolean("MiscDisguisesForLiving"));
        DisguiseConfig.setModifyBoundingBox(config.getBoolean("ModifyBoundingBox"));
        DisguiseConfig.setModifyCollisions(config.getBoolean("Scoreboard.Collisions"));
        DisguiseConfig.setMonstersIgnoreDisguises(config.getBoolean("MonstersIgnoreDisguises"));
        DisguiseConfig.setMovementPacketsEnabled(config.getBoolean("PacketsEnabled.Movement"));
        DisguiseConfig.setNameAboveHeadAlwaysVisible(config.getBoolean("NameAboveHeadAlwaysVisible"));
        DisguiseConfig.setNameOfPlayerShownAboveDisguise(config.getBoolean("ShowNamesAboveDisguises"));
        DisguiseConfig.setNameAboveDisguise(config.getString("NameAboveDisguise"));
        DisguiseConfig.setPlayerHideArmor(config.getBoolean("PlayerHideArmor"));
        DisguiseConfig.setRetaliationCombat(config.getBoolean("RetaliationCombat"));
        DisguiseConfig.setSaveGameProfiles(config.getBoolean("SaveGameProfiles"));
        DisguiseConfig.setSavePlayerDisguises(config.getBoolean("SaveDisguises.Players"));
        DisguiseConfig.setSaveEntityDisguises(config.getBoolean("SaveDisguises.Entities"));
        DisguiseConfig.setSelfDisguisesSoundsReplaced(config.getBoolean("HearSelfDisguise"));
        DisguiseConfig.setSheepDyeable(config.getBoolean("DyeableSheep"));
        DisguiseConfig.setShowDisguisedPlayersInTab(config.getBoolean("ShowPlayerDisguisesInTab"));
        DisguiseConfig.setSoundsEnabled(config.getBoolean("DisguiseSounds"));
        DisguiseConfig.setStopShulkerDisguisesFromMoving(config.getBoolean("StopShulkerDisguisesFromMoving", true));
        DisguiseConfig.setUUIDGeneratedVersion(config.getInt("UUIDVersion"));
        DisguiseConfig.setUndisguiseOnWorldChange(config.getBoolean("UndisguiseOnWorldChange"));
        DisguiseConfig.setUpdateGameProfiles(config.getBoolean("UpdateGameProfiles"));
        DisguiseConfig.setUseTranslations(config.getBoolean("Translations"));
        DisguiseConfig.setVelocitySent(config.getBoolean("SendVelocity"));
        DisguiseConfig.setViewDisguises(config.getBoolean("ViewSelfDisguises"));
        DisguiseConfig.setWarnScoreboardConflict(config.getBoolean("Scoreboard.WarnConflict"));
        DisguiseConfig.setCopyPlayerTeamInfo(config.getBoolean("Scoreboard.CopyPlayerTeamInfo"));
        DisguiseConfig.setWitherSkullPacketsEnabled(config.getBoolean("PacketsEnabled.WitherSkull"));
        DisguiseConfig.setWolfDyeable(config.getBoolean("DyeableWolf"));
        DisguiseConfig.setTablistRemoveDelay(config.getInt("TablistRemoveDelay"));
        DisguiseConfig.setAutoUpdate(config.getBoolean("AutoUpdate"));
        DisguiseConfig.setTallSelfDisguises(config.getBoolean("TallSelfDisguises"));
        DisguiseConfig.setOverrideCustomNames(config.getBoolean("OverrideCustomNames"));
        DisguiseConfig.setRandomDisguises(config.getBoolean("RandomDisguiseOptions"));
        DisguiseConfig.setSaveUserPreferences(config.getBoolean("SaveUserPreferences"));
        DisguiseConfig.setPlayerDisguisesSkinExpiresMove(config.getInt("PlayerDisguisesTablistExpiresMove"));
        DisguiseConfig.setViewSelfDisguisesDefault(config.getBoolean("ViewSelfDisguisesDefault"));
        DisguiseConfig.setContactMojangServers(config.getBoolean("ContactMojangServers"));
        DisguiseConfig.setDisguiseRadiusMax(config.getInt("DisguiseRadiusMax"));
        String apiKey = config.getString("MineSkinAPIKey");
        if (apiKey != null && apiKey.matches("[a-zA-Z0-9]{8,}")) {
            DisguiseUtilities.getMineSkinAPI().setApiKey(apiKey);
        } else if (apiKey != null && apiKey.length() > 8) {
            DisguiseUtilities.getLogger().warning("API Key provided for MineSkin does not appear to be in a valid format!");
        }
        if (!LibsPremium.isPremium().booleanValue() && (DisguiseConfig.isSavePlayerDisguises() || DisguiseConfig.isSaveEntityDisguises())) {
            DisguiseUtilities.getLogger().warning("You must purchase the plugin to use saved disguises!");
        }
        try {
            DisguiseConfig.setPlayerNameType(PlayerNameType.valueOf(config.getString("PlayerNames").toUpperCase(Locale.ENGLISH)));
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + config.getString("PlayerNames") + "' to a valid option for PlayerNames");
        }
        try {
            DisguiseConfig.setNotifyBar(NotifyBar.valueOf(config.getString("NotifyBar").toUpperCase(Locale.ENGLISH)));
            if (DisguiseConfig.getNotifyBar() == NotifyBar.BOSS_BAR && !NmsVersion.v1_13.isSupported()) {
                DisguiseUtilities.getLogger().warning("BossBars hasn't been implemented properly in 1.12 due to api restrictions, falling back to ACTION_BAR");
                DisguiseConfig.setNotifyBar(NotifyBar.ACTION_BAR);
            }
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + config.getString("NotifyBar") + "' to a valid option for NotifyBar");
        }
        try {
            DisguiseConfig.setBossBarColor(BarColor.valueOf((String)config.getString("BossBarColor").toUpperCase(Locale.ENGLISH)));
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + config.getString("BossBarColor") + "' to a valid option for BossBarColor");
        }
        try {
            DisguiseConfig.setBossBarStyle(BarStyle.valueOf((String)config.getString("BossBarStyle").toUpperCase(Locale.ENGLISH)));
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + config.getString("BossBarStyle") + "' to a valid option for BossBarStyle");
        }
        try {
            DisguiseConfig.setUpdatesBranch(UpdatesBranch.valueOf(config.getString("UpdatesBranch").toUpperCase(Locale.ENGLISH)));
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + config.getString("UpdatesBranch") + "' to a valid option for UpdatesBranch");
        }
        String seeCommands = config.getString("Permissions.SeeCommands");
        PermissionDefault permissionDefault = commandVisibility = seeCommands == null ? null : PermissionDefault.getByName((String)seeCommands);
        if (commandVisibility == null) {
            DisguiseUtilities.getLogger().warning("Invalid option '" + config.getString("Permissions.SeeCommands") + "' for Permissions.SeeCommands when loading config!");
        } else {
            DisguiseConfig.setCommandVisibility(commandVisibility);
        }
        DisguiseConfig.loadCustomDisguises();
        if ("%%__USER__%%".equals("12345") && DisguiseConfig.getCustomDisguises().size() > 10) {
            DisguiseConfig.setSoundsEnabled(false);
            Iterator<Map.Entry<DisguisePerm, String>> itel = DisguiseConfig.getCustomDisguises().entrySet().iterator();
            boolean i = false;
            while (itel.hasNext()) {
                itel.next();
                if (!new Random().nextBoolean()) continue;
                itel.remove();
            }
        }
        if (config.contains("VerboseConfig")) {
            verbose = config.getBoolean("VerboseConfig");
        } else {
            DisguiseUtilities.getLogger().info("As 'VerboseConfig' hasn't been set, it is assumed true. Set it in your config to remove these messages!");
            verbose = true;
        }
        boolean changed = config.getBoolean("ChangedConfig");
        if ((verbose || changed) && !(returns = DisguiseConfig.doOutput((ConfigurationSection)config, changed, verbose)).isEmpty()) {
            DisguiseUtilities.getLogger().info("This is not an error! Now outputting " + (verbose ? "missing " : "") + (changed ? (verbose ? "and " : "") + "changed/invalid " : "") + "config values");
            for (String v : returns) {
                DisguiseUtilities.getLogger().info(v);
            }
        }
        if ((missingConfigs = DisguiseConfig.doOutput((ConfigurationSection)config, false, true).size()) > 0) {
            if (config.getBoolean("UpdateConfig", true)) {
                configLoader.saveDefaultConfigs();
                DisguiseUtilities.getLogger().info("Config has been auto-updated!");
            } else if (!verbose) {
                DisguiseUtilities.getLogger().warning("Your config is missing " + missingConfigs + " options! Please consider regenerating your config!");
                DisguiseUtilities.getLogger().info("You can also add the missing entries yourself! Try '/libsdisguises config'");
            }
        } else {
            DisguiseUtilities.getLogger().info("Config is up to date!");
        }
    }

    public static void loadModdedDisguiseTypes() {
        File disguisesFile = new File(LibsDisguises.getInstance().getDataFolder(), "configs/disguises.yml");
        if (!disguisesFile.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)disguisesFile);
        if (!config.contains("Custom-Entities")) {
            return;
        }
        ArrayList<String> channels = new ArrayList<String>();
        for (String name : config.getConfigurationSection("Custom-Entities").getKeys(false)) {
            try {
                String requireMessage;
                if (!name.matches("[a-zA-Z0-9_]+")) {
                    DisguiseUtilities.getLogger().severe("Invalid modded disguise name '" + name + "'");
                    continue;
                }
                ConfigurationSection section = config.getConfigurationSection("Custom-Entities." + name);
                if (!section.contains("Name")) {
                    DisguiseUtilities.getLogger().severe("No mod:entity 'Name' provided for '" + name + "'");
                    continue;
                }
                String key = section.getString("Name");
                if (!key.contains(":") || key.contains(".")) {
                    DisguiseUtilities.getLogger().severe("Invalid modded name '" + key + "' in disguises.yml!");
                    continue;
                }
                boolean register = section.getBoolean("Register", true);
                boolean living = section.getString("Type", "LIVING").equalsIgnoreCase("LIVING");
                String type = section.getString("Type");
                String mod = section.getString("Mod");
                String[] version = mod == null || !section.contains("Version") ? null : section.getString("Version").split(",");
                String string = requireMessage = mod == null ? null : section.getString("Required");
                if (section.contains("Channels")) {
                    for (String s : section.getString("Channels").split(",")) {
                        if (!s.contains("|")) {
                            s = s + "|";
                            DisguiseUtilities.getLogger().severe("No channel version declared for " + s);
                        }
                        channels.add(s);
                    }
                }
                if (requireMessage != null) {
                    requireMessage = DisguiseUtilities.translateAlternateColorCodes(requireMessage);
                }
                ModdedEntity entity = new ModdedEntity(null, name, living, mod, version, requireMessage, 0);
                if (ModdedManager.getModdedEntity(name) != null) {
                    DisguiseUtilities.getLogger().info("Modded entity " + name + " has already been " + (register ? "registered" : "added"));
                    continue;
                }
                ModdedManager.registerModdedEntity(new NamespacedKey(key.substring(0, key.indexOf(":")), key.substring(key.indexOf(":") + 1)), entity, register);
                DisguiseUtilities.getLogger().info("Modded entity " + name + " has been " + (register ? "registered" : "added"));
            }
            catch (Exception ex) {
                DisguiseUtilities.getLogger().severe("Error while trying to register modded entity " + name);
                ex.printStackTrace();
            }
        }
        new ModdedManager(channels);
    }

    public static ArrayList<String> doOutput(boolean informChangedUnknown, boolean informMissing) {
        return DisguiseConfig.doOutput((ConfigurationSection)new ConfigLoader().load(), informChangedUnknown, informMissing);
    }

    public static ArrayList<String> doOutput(ConfigurationSection config, boolean informChangedUnknown, boolean informMissing) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        ConfigurationSection defaultSection = config.getDefaultSection();
        if (defaultSection == null) {
            defaultSection = new ConfigLoader().loadDefaults();
        }
        ArrayList<String> returns = new ArrayList<String>();
        for (String string : defaultSection.getKeys(true)) {
            if (defaultSection.isConfigurationSection(string)) continue;
            configs.put(string, defaultSection.get(string));
        }
        for (String string : config.getKeys(true)) {
            if (config.isConfigurationSection(string)) continue;
            if (!configs.containsKey(string)) {
                if (!informChangedUnknown) continue;
                returns.add("Unknown config option '" + string + ": " + config.get(string) + "'");
                continue;
            }
            if (!configs.get(string).equals(config.get(string)) && informChangedUnknown) {
                returns.add("Modified config: '" + string + ": " + config.get(string) + "'");
            }
            configs.remove(string);
        }
        if (informMissing) {
            for (Map.Entry entry : configs.entrySet()) {
                returns.add("Missing '" + (String)entry.getKey() + ": " + entry.getValue() + "'");
            }
        }
        return returns;
    }

    static void loadCustomDisguises() {
        customDisguises.clear();
        File disguisesFile = new File(LibsDisguises.getInstance().getDataFolder(), "configs/disguises.yml");
        if (!disguisesFile.exists()) {
            return;
        }
        YamlConfiguration disguisesConfig = YamlConfiguration.loadConfiguration((File)disguisesFile);
        ConfigurationSection section = disguisesConfig.getConfigurationSection("Disguises");
        if (section == null) {
            return;
        }
        int failedCustomDisguises = 0;
        for (String key : section.getKeys(false)) {
            String toParse = section.getString(key);
            if (!NmsVersion.v1_13.isSupported() && key.equals("libraryaddict")) {
                toParse = toParse.replace("GOLDEN_BOOTS,GOLDEN_LEGGINGS,GOLDEN_CHESTPLATE,GOLDEN_HELMET", "GOLD_BOOTS,GOLD_LEGGINGS,GOLD_CHESTPLATE,GOLD_HELMET");
            }
            try {
                DisguiseConfig.addCustomDisguise(key, toParse);
            }
            catch (Exception e) {
                ++failedCustomDisguises;
                if (e instanceof DisguiseParseException) {
                    if (e.getMessage() != null) {
                        DisguiseUtilities.getLogger().severe(e.getMessage());
                    }
                    if (e.getCause() == null) continue;
                    e.printStackTrace();
                    continue;
                }
                e.printStackTrace();
            }
        }
        if (failedCustomDisguises > 0) {
            DisguiseUtilities.getLogger().warning("Failed to load " + failedCustomDisguises + " custom disguises");
        }
        DisguiseUtilities.getLogger().info("Loaded " + customDisguises.size() + " custom disguise" + (customDisguises.size() == 1 ? "" : "s"));
    }

    public static void addCustomDisguise(String disguiseName, String toParse) throws DisguiseParseException {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Custom Disguises should not be called async!");
        }
        if (DisguiseConfig.getRawCustomDisguise(toParse) != null) {
            throw new DisguiseParseException(LibsMsg.CUSTOM_DISGUISE_NAME_CONFLICT, disguiseName);
        }
        try {
            String[] disguiseArgs = DisguiseUtilities.split(toParse);
            Disguise disguise = DisguiseParser.parseTestDisguise((CommandSender)Bukkit.getConsoleSender(), "disguise", disguiseArgs, DisguiseParser.getPermissions((CommandSender)Bukkit.getConsoleSender(), "disguise"));
            DisguisePerm perm = new DisguisePerm(disguise.getType(), disguiseName);
            customDisguises.put(perm, toParse);
            DisguiseUtilities.getLogger().info("Loaded custom disguise " + disguiseName);
        }
        catch (DisguiseParseException e) {
            throw new DisguiseParseException(LibsMsg.ERROR_LOADING_CUSTOM_DISGUISE, disguiseName, e.getMessage() == null ? "" : ": " + e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new DisguiseParseException(LibsMsg.ERROR_LOADING_CUSTOM_DISGUISE, disguiseName, "");
        }
    }

    public static boolean isSoundEnabled() {
        return PacketsManager.isHearDisguisesEnabled();
    }

    public static void setAnimationPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isAnimationPacketsEnabled()) {
            animationPacketsEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setCollectPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isCollectPacketsEnabled()) {
            collectPacketsEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setEntityStatusPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isEntityStatusPacketsEnabled()) {
            entityStatusPacketsEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setEquipmentPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isEquipmentPacketsEnabled()) {
            equipmentPacketsEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setHideArmorFromSelf(boolean hideArmor) {
        if (hidingArmorFromSelf != hideArmor) {
            hidingArmorFromSelf = hideArmor;
            PacketsManager.setInventoryListenerEnabled(DisguiseConfig.isHidingHeldItemFromSelf() || DisguiseConfig.isHidingArmorFromSelf());
        }
    }

    public static void setHideHeldItemFromSelf(boolean hideHelditem) {
        if (hidingHeldItemFromSelf != hideHelditem) {
            hidingHeldItemFromSelf = hideHelditem;
            PacketsManager.setInventoryListenerEnabled(DisguiseConfig.isHidingHeldItemFromSelf() || DisguiseConfig.isHidingArmorFromSelf());
        }
    }

    public static void setMiscDisguisesForLivingEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
            miscDisguisesForLivingEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setMovementPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isMovementPacketsEnabled()) {
            movementPacketsEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setSoundsEnabled(boolean isSoundsEnabled) {
        PacketsManager.setHearDisguisesListener(isSoundsEnabled);
    }

    public static HashMap<DisguisePerm, String> getCustomDisguises() {
        return customDisguises;
    }

    public static void setCustomDisguises(HashMap<DisguisePerm, String> customDisguises) {
        DisguiseConfig.customDisguises = customDisguises;
    }

    public static UpdatesBranch getUpdatesBranch() {
        return updatesBranch;
    }

    public static void setUpdatesBranch(UpdatesBranch updatesBranch) {
        DisguiseConfig.updatesBranch = updatesBranch;
    }

    public static boolean isAddEntityAnimations() {
        return addEntityAnimations;
    }

    public static void setAddEntityAnimations(boolean addEntityAnimations) {
        DisguiseConfig.addEntityAnimations = addEntityAnimations;
    }

    public static boolean isAnimationPacketsEnabled() {
        return animationPacketsEnabled;
    }

    public static boolean isCatDyeable() {
        return catDyeable;
    }

    public static void setCatDyeable(boolean catDyeable) {
        DisguiseConfig.catDyeable = catDyeable;
    }

    public static boolean isCollectPacketsEnabled() {
        return collectPacketsEnabled;
    }

    public static boolean isDisableFriendlyInvisibles() {
        return disableFriendlyInvisibles;
    }

    public static void setDisableFriendlyInvisibles(boolean disableFriendlyInvisibles) {
        DisguiseConfig.disableFriendlyInvisibles = disableFriendlyInvisibles;
    }

    public static boolean isDisabledInvisibility() {
        return disabledInvisibility;
    }

    public static void setDisabledInvisibility(boolean disabledInvisibility) {
        DisguiseConfig.disabledInvisibility = disabledInvisibility;
    }

    public static boolean isDisguiseBlownWhenAttacked() {
        return disguiseBlownWhenAttacked;
    }

    public static void setDisguiseBlownWhenAttacked(boolean disguiseBlownWhenAttacked) {
        DisguiseConfig.disguiseBlownWhenAttacked = disguiseBlownWhenAttacked;
    }

    public static boolean isDisguiseBlownWhenAttacking() {
        return disguiseBlownWhenAttacking;
    }

    public static void setDisguiseBlownWhenAttacking(boolean disguiseBlownWhenAttacking) {
        DisguiseConfig.disguiseBlownWhenAttacking = disguiseBlownWhenAttacking;
    }

    public static boolean isDynamicExpiry() {
        return dynamicExpiry;
    }

    public static void setDynamicExpiry(boolean dynamicExpiry) {
        DisguiseConfig.dynamicExpiry = dynamicExpiry;
    }

    public static boolean isEntityStatusPacketsEnabled() {
        return entityStatusPacketsEnabled;
    }

    public static boolean isEquipmentPacketsEnabled() {
        return equipmentPacketsEnabled;
    }

    public static boolean isExplicitDisguisePermissions() {
        return explicitDisguisePermissions;
    }

    public static void setExplicitDisguisePermissions(boolean explicitDisguisePermissions) {
        DisguiseConfig.explicitDisguisePermissions = explicitDisguisePermissions;
    }

    public static boolean isHideDisguisedPlayers() {
        return hideDisguisedPlayers;
    }

    public static void setHideDisguisedPlayers(boolean hideDisguisedPlayers) {
        DisguiseConfig.hideDisguisedPlayers = hideDisguisedPlayers;
    }

    public static boolean isHidingArmorFromSelf() {
        return hidingArmorFromSelf;
    }

    public static void setHidingArmorFromSelf(boolean hidingArmorFromSelf) {
        DisguiseConfig.hidingArmorFromSelf = hidingArmorFromSelf;
    }

    public static boolean isHidingCreativeEquipmentFromSelf() {
        return hidingCreativeEquipmentFromSelf;
    }

    public static void setHidingCreativeEquipmentFromSelf(boolean hidingCreativeEquipmentFromSelf) {
        DisguiseConfig.hidingCreativeEquipmentFromSelf = hidingCreativeEquipmentFromSelf;
    }

    public static boolean isHidingHeldItemFromSelf() {
        return hidingHeldItemFromSelf;
    }

    public static void setHidingHeldItemFromSelf(boolean hidingHeldItemFromSelf) {
        DisguiseConfig.hidingHeldItemFromSelf = hidingHeldItemFromSelf;
    }

    public static boolean isHorseSaddleable() {
        return horseSaddleable;
    }

    public static void setHorseSaddleable(boolean horseSaddleable) {
        DisguiseConfig.horseSaddleable = horseSaddleable;
    }

    public static boolean isKeepDisguiseOnPlayerDeath() {
        return keepDisguiseOnPlayerDeath;
    }

    public static void setKeepDisguiseOnPlayerDeath(boolean keepDisguiseOnPlayerDeath) {
        DisguiseConfig.keepDisguiseOnPlayerDeath = keepDisguiseOnPlayerDeath;
    }

    public static boolean isLlamaCarpetable() {
        return llamaCarpetable;
    }

    public static void setLlamaCarpetable(boolean llamaCarpetable) {
        DisguiseConfig.llamaCarpetable = llamaCarpetable;
    }

    public static boolean isMaxHealthDeterminedByDisguisedEntity() {
        return maxHealthDeterminedByDisguisedEntity;
    }

    public static void setMaxHealthDeterminedByDisguisedEntity(boolean maxHealthDeterminedByDisguisedEntity) {
        DisguiseConfig.maxHealthDeterminedByDisguisedEntity = maxHealthDeterminedByDisguisedEntity;
    }

    public static boolean isMetaPacketsEnabled() {
        return metaPacketsEnabled;
    }

    public static void setMetaPacketsEnabled(boolean metaPacketsEnabled) {
        DisguiseConfig.metaPacketsEnabled = metaPacketsEnabled;
    }

    public static boolean isMiscDisguisesForLivingEnabled() {
        return miscDisguisesForLivingEnabled;
    }

    public static boolean isModifyBoundingBox() {
        return modifyBoundingBox;
    }

    public static void setModifyBoundingBox(boolean modifyBoundingBox) {
        DisguiseConfig.modifyBoundingBox = modifyBoundingBox;
    }

    public static boolean isModifyCollisions() {
        return modifyCollisions;
    }

    public static void setModifyCollisions(boolean modifyCollisions) {
        DisguiseConfig.modifyCollisions = modifyCollisions;
    }

    public static boolean isMonstersIgnoreDisguises() {
        return monstersIgnoreDisguises;
    }

    public static void setMonstersIgnoreDisguises(boolean monstersIgnoreDisguises) {
        DisguiseConfig.monstersIgnoreDisguises = monstersIgnoreDisguises;
    }

    public static boolean isMovementPacketsEnabled() {
        return movementPacketsEnabled;
    }

    public static boolean isNameAboveHeadAlwaysVisible() {
        return nameAboveHeadAlwaysVisible;
    }

    public static void setNameAboveHeadAlwaysVisible(boolean nameAboveHeadAlwaysVisible) {
        DisguiseConfig.nameAboveHeadAlwaysVisible = nameAboveHeadAlwaysVisible;
    }

    public static boolean isNameOfPlayerShownAboveDisguise() {
        return nameOfPlayerShownAboveDisguise;
    }

    public static void setNameOfPlayerShownAboveDisguise(boolean nameOfPlayerShownAboveDisguise) {
        DisguiseConfig.nameOfPlayerShownAboveDisguise = nameOfPlayerShownAboveDisguise;
    }

    public static boolean isPlayerHideArmor() {
        return playerHideArmor;
    }

    public static void setPlayerHideArmor(boolean playerHideArmor) {
        DisguiseConfig.playerHideArmor = playerHideArmor;
    }

    public static boolean isSaveEntityDisguises() {
        return saveEntityDisguises;
    }

    public static void setSaveEntityDisguises(boolean saveEntityDisguises) {
        DisguiseConfig.saveEntityDisguises = saveEntityDisguises;
    }

    public static boolean isSaveGameProfiles() {
        return saveGameProfiles;
    }

    public static void setSaveGameProfiles(boolean saveGameProfiles) {
        DisguiseConfig.saveGameProfiles = saveGameProfiles;
    }

    public static boolean isSavePlayerDisguises() {
        return savePlayerDisguises;
    }

    public static void setSavePlayerDisguises(boolean savePlayerDisguises) {
        DisguiseConfig.savePlayerDisguises = savePlayerDisguises;
    }

    public static boolean isSelfDisguisesSoundsReplaced() {
        return selfDisguisesSoundsReplaced;
    }

    public static void setSelfDisguisesSoundsReplaced(boolean selfDisguisesSoundsReplaced) {
        DisguiseConfig.selfDisguisesSoundsReplaced = selfDisguisesSoundsReplaced;
    }

    public static boolean isSheepDyeable() {
        return sheepDyeable;
    }

    public static void setSheepDyeable(boolean sheepDyeable) {
        DisguiseConfig.sheepDyeable = sheepDyeable;
    }

    public static boolean isShowDisguisedPlayersInTab() {
        return showDisguisedPlayersInTab;
    }

    public static void setShowDisguisedPlayersInTab(boolean showDisguisedPlayersInTab) {
        DisguiseConfig.showDisguisedPlayersInTab = showDisguisedPlayersInTab;
    }

    public static boolean isStopShulkerDisguisesFromMoving() {
        return stopShulkerDisguisesFromMoving;
    }

    public static void setStopShulkerDisguisesFromMoving(boolean stopShulkerDisguisesFromMoving) {
        DisguiseConfig.stopShulkerDisguisesFromMoving = stopShulkerDisguisesFromMoving;
    }

    public static boolean isUndisguiseOnWorldChange() {
        return undisguiseOnWorldChange;
    }

    public static void setUndisguiseOnWorldChange(boolean undisguiseOnWorldChange) {
        DisguiseConfig.undisguiseOnWorldChange = undisguiseOnWorldChange;
    }

    public static boolean isUpdateGameProfiles() {
        return updateGameProfiles;
    }

    public static void setUpdateGameProfiles(boolean updateGameProfiles) {
        DisguiseConfig.updateGameProfiles = updateGameProfiles;
    }

    public static boolean isUseTranslations() {
        return useTranslations;
    }

    public static boolean isVelocitySent() {
        return velocitySent;
    }

    public static void setVelocitySent(boolean velocitySent) {
        DisguiseConfig.velocitySent = velocitySent;
    }

    public static boolean isViewDisguises() {
        return viewDisguises;
    }

    public static void setViewDisguises(boolean viewDisguises) {
        DisguiseConfig.viewDisguises = viewDisguises;
    }

    public static boolean isWarnScoreboardConflict() {
        return warnScoreboardConflict;
    }

    public static void setWarnScoreboardConflict(boolean warnScoreboardConflict) {
        DisguiseConfig.warnScoreboardConflict = warnScoreboardConflict;
    }

    public static boolean isWitherSkullPacketsEnabled() {
        return witherSkullPacketsEnabled;
    }

    public static void setWitherSkullPacketsEnabled(boolean witherSkullPacketsEnabled) {
        DisguiseConfig.witherSkullPacketsEnabled = witherSkullPacketsEnabled;
    }

    public static boolean isWolfDyeable() {
        return wolfDyeable;
    }

    public static void setWolfDyeable(boolean wolfDyeable) {
        DisguiseConfig.wolfDyeable = wolfDyeable;
    }

    public static int getDisguiseCloneExpire() {
        return disguiseCloneExpire;
    }

    public static void setDisguiseCloneExpire(int disguiseCloneExpire) {
        DisguiseConfig.disguiseCloneExpire = disguiseCloneExpire;
    }

    public static int getDisguiseEntityExpire() {
        return disguiseEntityExpire;
    }

    public static void setDisguiseEntityExpire(int disguiseEntityExpire) {
        DisguiseConfig.disguiseEntityExpire = disguiseEntityExpire;
    }

    public static int getMaxClonedDisguises() {
        return maxClonedDisguises;
    }

    public static void setMaxClonedDisguises(int maxClonedDisguises) {
        DisguiseConfig.maxClonedDisguises = maxClonedDisguises;
    }

    public static boolean isDisablePvP() {
        return disablePvP;
    }

    public static void setDisablePvP(boolean disablePvP) {
        DisguiseConfig.disablePvP = disablePvP;
    }

    public static boolean isDisablePvE() {
        return disablePvE;
    }

    public static void setDisablePvE(boolean disablePvE) {
        DisguiseConfig.disablePvE = disablePvE;
    }

    public static double getPvPTimer() {
        return pvPTimer;
    }

    public static void setPvPTimer(double pvPTimer) {
        DisguiseConfig.pvPTimer = pvPTimer;
    }

    public static boolean isRetaliationCombat() {
        return retaliationCombat;
    }

    public static void setRetaliationCombat(boolean retaliationCombat) {
        DisguiseConfig.retaliationCombat = retaliationCombat;
    }

    public static NotifyBar getNotifyBar() {
        return notifyBar;
    }

    public static void setNotifyBar(NotifyBar notifyBar) {
        DisguiseConfig.notifyBar = notifyBar;
    }

    public static BarStyle getBossBarStyle() {
        return bossBarStyle;
    }

    public static void setBossBarStyle(BarStyle bossBarStyle) {
        DisguiseConfig.bossBarStyle = bossBarStyle;
    }

    public static BarColor getBossBarColor() {
        return bossBarColor;
    }

    public static void setBossBarColor(BarColor bossBarColor) {
        DisguiseConfig.bossBarColor = bossBarColor;
    }

    public static int getTablistRemoveDelay() {
        return tablistRemoveDelay;
    }

    public static void setTablistRemoveDelay(int tablistRemoveDelay) {
        DisguiseConfig.tablistRemoveDelay = tablistRemoveDelay;
    }

    public static boolean isUsingReleaseBuild() {
        return usingReleaseBuild;
    }

    public static boolean isBisectHosted() {
        return bisectHosted;
    }

    public static String getSavedServerIp() {
        return savedServerIp;
    }

    public static Boolean getAutoUpdate() {
        return autoUpdate;
    }

    public static boolean isNotifyUpdate() {
        return notifyUpdate;
    }

    public static boolean isTallSelfDisguises() {
        return tallSelfDisguises;
    }

    public static void setTallSelfDisguises(boolean tallSelfDisguises) {
        DisguiseConfig.tallSelfDisguises = tallSelfDisguises;
    }

    public static PlayerNameType getPlayerNameType() {
        return playerNameType;
    }

    public static void setPlayerNameType(PlayerNameType playerNameType) {
        DisguiseConfig.playerNameType = playerNameType;
    }

    public static boolean isOverrideCustomNames() {
        return overrideCustomNames;
    }

    public static void setOverrideCustomNames(boolean overrideCustomNames) {
        DisguiseConfig.overrideCustomNames = overrideCustomNames;
    }

    public static boolean isRandomDisguises() {
        return randomDisguises;
    }

    public static void setRandomDisguises(boolean randomDisguises) {
        DisguiseConfig.randomDisguises = randomDisguises;
    }

    public static boolean isLoginPayloadPackets() {
        return loginPayloadPackets;
    }

    public static void setLoginPayloadPackets(boolean loginPayloadPackets) {
        DisguiseConfig.loginPayloadPackets = loginPayloadPackets;
    }

    public static boolean isSaveUserPreferences() {
        return saveUserPreferences;
    }

    public static void setSaveUserPreferences(boolean saveUserPreferences) {
        DisguiseConfig.saveUserPreferences = saveUserPreferences;
    }

    public static long getLastUpdateRequest() {
        return lastUpdateRequest;
    }

    public static boolean isHittingRateLimit() {
        return hittingRateLimit;
    }

    public static boolean isCopyPlayerTeamInfo() {
        return copyPlayerTeamInfo;
    }

    public static void setCopyPlayerTeamInfo(boolean copyPlayerTeamInfo) {
        DisguiseConfig.copyPlayerTeamInfo = copyPlayerTeamInfo;
    }

    public static String getNameAboveDisguise() {
        return nameAboveDisguise;
    }

    public static void setNameAboveDisguise(String nameAboveDisguise) {
        DisguiseConfig.nameAboveDisguise = nameAboveDisguise;
    }

    public static int getPlayerDisguisesSkinExpiresMove() {
        return playerDisguisesSkinExpiresMove;
    }

    public static void setPlayerDisguisesSkinExpiresMove(int playerDisguisesSkinExpiresMove) {
        DisguiseConfig.playerDisguisesSkinExpiresMove = playerDisguisesSkinExpiresMove;
    }

    public static boolean isViewSelfDisguisesDefault() {
        return viewSelfDisguisesDefault;
    }

    public static void setViewSelfDisguisesDefault(boolean viewSelfDisguisesDefault) {
        DisguiseConfig.viewSelfDisguisesDefault = viewSelfDisguisesDefault;
    }

    public static String getLastGithubUpdateETag() {
        return lastGithubUpdateETag;
    }

    public static void setLastGithubUpdateETag(String lastGithubUpdateETag) {
        DisguiseConfig.lastGithubUpdateETag = lastGithubUpdateETag;
    }

    public static String getLastPluginUpdateVersion() {
        return lastPluginUpdateVersion;
    }

    public static void setLastPluginUpdateVersion(String lastPluginUpdateVersion) {
        DisguiseConfig.lastPluginUpdateVersion = lastPluginUpdateVersion;
    }

    public static boolean isContactMojangServers() {
        return contactMojangServers;
    }

    public static void setContactMojangServers(boolean contactMojangServers) {
        DisguiseConfig.contactMojangServers = contactMojangServers;
    }

    public static int getDisguiseRadiusMax() {
        return disguiseRadiusMax;
    }

    protected static void setDisguiseRadiusMax(int disguiseRadiusMax) {
        DisguiseConfig.disguiseRadiusMax = disguiseRadiusMax;
    }

    public static String getData() {
        return data;
    }

    public static void setData(String data) {
        DisguiseConfig.data = data;
    }

    static {
        notifyBar = NotifyBar.ACTION_BAR;
        bossBarStyle = BarStyle.SOLID;
        bossBarColor = BarColor.GREEN;
        commandVisibility = PermissionDefault.TRUE;
        usingReleaseBuild = true;
        bisectHosted = true;
        savedServerIp = "";
        playerNameType = PlayerNameType.TEAMS;
    }

    public static enum NotifyBar {
        NONE,
        BOSS_BAR,
        ACTION_BAR;

    }

    public static enum UpdatesBranch {
        SAME_BUILDS,
        SNAPSHOTS,
        RELEASES;

    }

    public static enum PlayerNameType {
        VANILLA,
        TEAMS,
        EXTENDED,
        ARMORSTANDS;


        public boolean isTeams() {
            return this == TEAMS || this == EXTENDED;
        }
    }

    public static enum DisguisePushing {
        MODIFY_SCOREBOARD,
        IGNORE_SCOREBOARD,
        CREATE_SCOREBOARD;

    }
}

