/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage;

import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.examination.Examinable;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import ld-shaded.net.kyori.examination.string.StringExaminer;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface Template
extends Examinable {
    public static @NonNull Template of(@NonNull String key, @NonNull String value) {
        return new StringTemplate(key, value);
    }

    public static @NonNull Template of(@NonNull String key, @NonNull Component value) {
        return new ComponentTemplate(key, value);
    }

    public static class ComponentTemplate
    implements Template {
        private final String key;
        private final Component value;

        public ComponentTemplate(@NonNull String key, @NonNull Component value) {
            this.key = key;
            this.value = value;
        }

        public @NonNull String key() {
            return this.key;
        }

        public @NonNull Component value() {
            return this.value;
        }

        public final String toString() {
            return this.examine(StringExaminer.simpleEscaping());
        }

        @Override
        public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("key", this.key), ExaminableProperty.of("value", this.value));
        }
    }

    public static class StringTemplate
    implements Template {
        private final String key;
        private final String value;

        StringTemplate(@NonNull String key, @NonNull String value) {
            this.key = key;
            this.value = value;
        }

        public @NonNull String key() {
            return this.key;
        }

        public @NonNull String value() {
            return this.value;
        }

        public final String toString() {
            return this.examine(StringExaminer.simpleEscaping());
        }

        @Override
        public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("key", this.key), ExaminableProperty.of("value", this.value));
        }
    }
}

