/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.Deque;
import java.util.Objects;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.minimessage.Template;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Inserting;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.InstantApplyTransformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TemplateTransformation
extends InstantApplyTransformation
implements Inserting {
    private final Template.ComponentTemplate template;

    public TemplateTransformation(@NonNull Template.ComponentTemplate template) {
        this.template = template;
    }

    @Override
    public void applyInstant( @NonNull TextComponent.Builder parent, @NonNull Deque<Transformation> transformations) {
        Component comp = this.template.value();
        for (Transformation transformation : transformations) {
            comp = transformation.apply(comp, parent);
        }
        comp = this.merge(this.template.value(), comp);
        parent.append(comp);
    }

    @Override
    public boolean allowedInPre() {
        return true;
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("template", this.template));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TemplateTransformation that = (TemplateTransformation)other;
        return Objects.equals(this.template, that.template);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.template);
    }
}

