/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedEnumEntityUseAction;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractHorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.CatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LlamaWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SheepWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.WolfWatcher;
import me.libraryaddict.disguise.events.DisguiseInteractEvent;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PacketListenerClientInteract
extends PacketAdapter {
    public PacketListenerClientInteract(LibsDisguises plugin) {
        super((Plugin)plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Client.USE_ENTITY});
    }

    public void onPacketReceiving(PacketEvent event) {
        PacketContainer packet;
        if (event.isCancelled()) {
            return;
        }
        final Player observer = event.getPlayer();
        if (observer == null || event.isPlayerTemporary() || observer.getName().contains("UNKNOWN[")) {
            return;
        }
        if (!observer.isOp() && ("%%__USER__%%".equals("12345") || LibsDisguises.getInstance().getUpdateChecker().isGoSilent())) {
            event.setCancelled(true);
        }
        if ((Integer)(packet = event.getPacket()).getIntegers().read(0) == DisguiseAPI.getSelfDisguiseId()) {
            event.setCancelled(true);
        } else if (DisguiseUtilities.isNotInteractable((Integer)packet.getIntegers().read(0))) {
            event.setCancelled(true);
        } else if (DisguiseUtilities.isSpecialInteract((Integer)packet.getIntegers().read(0)) && this.getHand(packet) == EnumWrappers.Hand.OFF_HAND) {
            event.setCancelled(true);
        }
        if (event.isAsync()) {
            new BukkitRunnable(){

                public void run() {
                    PacketListenerClientInteract.this.handleSync(observer, packet);
                }
            }.runTask((Plugin)LibsDisguises.getInstance());
        } else {
            this.handleSync(observer, packet);
        }
    }

    private EnumWrappers.Hand getHand(PacketContainer packet) {
        if (!NmsVersion.v1_17.isSupported()) {
            return (EnumWrappers.Hand)packet.getHands().read(0);
        }
        WrappedEnumEntityUseAction action = (WrappedEnumEntityUseAction)packet.getEnumEntityUseActions().read(0);
        if (action.getAction() == EnumWrappers.EntityUseAction.ATTACK) {
            return EnumWrappers.Hand.MAIN_HAND;
        }
        return action.getHand();
    }

    private EnumWrappers.EntityUseAction getInteractType(PacketContainer packet) {
        if (!NmsVersion.v1_17.isSupported()) {
            return (EnumWrappers.EntityUseAction)packet.getEntityUseActions().read(0);
        }
        return ((WrappedEnumEntityUseAction)packet.getEnumEntityUseActions().read(0)).getAction();
    }

    private void handleSync(Player observer, PacketContainer packet) {
        final Disguise disguise = DisguiseUtilities.getDisguise(observer, (Integer)packet.getIntegers().read(0));
        if (disguise == null) {
            return;
        }
        if (disguise.getEntity() == observer) {
            final EnumWrappers.EntityUseAction interactType = this.getInteractType(packet);
            final EquipmentSlot handUsed = interactType != EnumWrappers.EntityUseAction.ATTACK && this.getHand(packet) == EnumWrappers.Hand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND;
            new BukkitRunnable(){

                public void run() {
                    DisguiseInteractEvent selfEvent = new DisguiseInteractEvent((TargetedDisguise)disguise, handUsed, interactType == EnumWrappers.EntityUseAction.ATTACK);
                    Bukkit.getPluginManager().callEvent((Event)selfEvent);
                }
            }.runTask((Plugin)LibsDisguises.getInstance());
        }
        switch (disguise.getType()) {
            case AXOLOTL: {
                if (disguise.getEntity() instanceof Axolotl) break;
                DisguiseUtilities.refreshTrackers((TargetedDisguise)disguise);
                observer.updateInventory();
                break;
            }
            case CAT: 
            case WOLF: 
            case SHEEP: {
                this.doDyeable(observer, disguise);
                break;
            }
            case MULE: 
            case DONKEY: 
            case HORSE: 
            case ZOMBIE_HORSE: 
            case SKELETON_HORSE: {
                if (!DisguiseConfig.isHorseSaddleable()) break;
                this.doSaddleable(observer, disguise);
                break;
            }
            case LLAMA: 
            case TRADER_LLAMA: {
                if (!DisguiseConfig.isLlamaCarpetable()) break;
                this.doCarpetable(observer, disguise);
                break;
            }
        }
    }

    private void doSaddleable(final Player observer, final Disguise disguise) {
        new BukkitRunnable(){

            public void run() {
                for (ItemStack item : new ItemStack[]{observer.getInventory().getItemInMainHand(), observer.getInventory().getItemInOffHand()}) {
                    if (item == null || item.getType() != Material.SADDLE) continue;
                    AbstractHorseWatcher watcher = (AbstractHorseWatcher)disguise.getWatcher();
                    watcher.setSaddled(true);
                    break;
                }
            }
        }.runTask((Plugin)LibsDisguises.getInstance());
    }

    private void doCarpetable(final Player observer, final Disguise disguise) {
        new BukkitRunnable(){

            public void run() {
                for (ItemStack item : new ItemStack[]{observer.getInventory().getItemInMainHand(), observer.getInventory().getItemInOffHand()}) {
                    AnimalColor color;
                    if (item == null || !item.getType().name().endsWith("_CARPET") || (color = AnimalColor.getColorByItem(item)) == null) continue;
                    LlamaWatcher llamaWatcher = (LlamaWatcher)disguise.getWatcher();
                    llamaWatcher.setSaddled(true);
                    llamaWatcher.setCarpet(color);
                    break;
                }
            }
        }.runTask((Plugin)LibsDisguises.getInstance());
    }

    private void doDyeable(final Player observer, final Disguise disguise) {
        new BukkitRunnable(){

            public void run() {
                for (ItemStack item : new ItemStack[]{observer.getInventory().getItemInMainHand(), observer.getInventory().getItemInOffHand()}) {
                    AnimalColor color;
                    if (item == null || (color = AnimalColor.getColorByItem(item)) == null) continue;
                    if (disguise.getType() == DisguiseType.SHEEP) {
                        SheepWatcher watcher = (SheepWatcher)disguise.getWatcher();
                        watcher.setColor(DisguiseConfig.isSheepDyeable() ? color.getDyeColor() : watcher.getColor());
                        break;
                    }
                    if (disguise.getType() == DisguiseType.WOLF) {
                        WolfWatcher watcher = (WolfWatcher)disguise.getWatcher();
                        watcher.setCollarColor(DisguiseConfig.isWolfDyeable() ? color.getDyeColor() : watcher.getCollarColor());
                        break;
                    }
                    if (disguise.getType() != DisguiseType.CAT) continue;
                    CatWatcher watcher = (CatWatcher)disguise.getWatcher();
                    watcher.setCollarColor(DisguiseConfig.isCatDyeable() ? color.getDyeColor() : watcher.getCollarColor());
                    break;
                }
            }
        }.runTask((Plugin)LibsDisguises.getInstance());
    }
}

