/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.format;

import ld-shaded.net.kyori.adventure.text.format.Style;
import ld-shaded.net.kyori.adventure.text.format.StyleBuilderApplicable;
import ld-shaded.net.kyori.adventure.text.format.TextFormat;
import ld-shaded.net.kyori.adventure.util.Index;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum TextDecoration implements StyleBuilderApplicable,
TextFormat
{
    OBFUSCATED("obfuscated"),
    BOLD("bold"),
    STRIKETHROUGH("strikethrough"),
    UNDERLINED("underlined"),
    ITALIC("italic");

    public static final Index<String, TextDecoration> NAMES;
    private final String name;

    private TextDecoration(String name) {
        this.name = name;
    }

    @Override
    public void styleApply(@NonNull Style.Builder style) {
        style.decorate(this);
    }

    public @NonNull String toString() {
        return this.name;
    }

    static {
        NAMES = Index.create(TextDecoration.class, constant -> constant.name);
    }

    public static enum State {
        NOT_SET("not_set"),
        FALSE("false"),
        TRUE("true");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static @NonNull State byBoolean(boolean flag) {
            return flag ? TRUE : FALSE;
        }

        public static @NonNull State byBoolean(@Nullable Boolean flag) {
            return flag == null ? NOT_SET : State.byBoolean((boolean)flag);
        }
    }
}

