/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import ld-shaded.net.kyori.adventure.key.Key;
import ld-shaded.net.kyori.adventure.text.BlockNBTComponent;
import ld-shaded.net.kyori.adventure.text.BlockNBTComponentImpl;
import ld-shaded.net.kyori.adventure.text.ComponentBuilder;
import ld-shaded.net.kyori.adventure.text.ComponentBuilderApplicable;
import ld-shaded.net.kyori.adventure.text.ComponentLike;
import ld-shaded.net.kyori.adventure.text.EntityNBTComponent;
import ld-shaded.net.kyori.adventure.text.EntityNBTComponentImpl;
import ld-shaded.net.kyori.adventure.text.KeybindComponent;
import ld-shaded.net.kyori.adventure.text.KeybindComponentImpl;
import ld-shaded.net.kyori.adventure.text.PatternReplacementResult;
import ld-shaded.net.kyori.adventure.text.ScoreComponent;
import ld-shaded.net.kyori.adventure.text.ScoreComponentImpl;
import ld-shaded.net.kyori.adventure.text.SelectorComponent;
import ld-shaded.net.kyori.adventure.text.SelectorComponentImpl;
import ld-shaded.net.kyori.adventure.text.StorageNBTComponent;
import ld-shaded.net.kyori.adventure.text.StorageNBTComponentImpl;
import ld-shaded.net.kyori.adventure.text.TextComponent;
import ld-shaded.net.kyori.adventure.text.TextComponentImpl;
import ld-shaded.net.kyori.adventure.text.TextReplacementConfig;
import ld-shaded.net.kyori.adventure.text.TranslatableComponent;
import ld-shaded.net.kyori.adventure.text.TranslatableComponentImpl;
import ld-shaded.net.kyori.adventure.text.event.ClickEvent;
import ld-shaded.net.kyori.adventure.text.event.HoverEvent;
import ld-shaded.net.kyori.adventure.text.event.HoverEventSource;
import ld-shaded.net.kyori.adventure.text.format.Style;
import ld-shaded.net.kyori.adventure.text.format.TextColor;
import ld-shaded.net.kyori.adventure.text.format.TextDecoration;
import ld-shaded.net.kyori.adventure.util.Buildable;
import ld-shaded.net.kyori.adventure.util.IntFunction2;
import ld-shaded.net.kyori.examination.Examinable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public interface Component
extends ComponentBuilderApplicable,
ComponentLike,
Examinable,
HoverEventSource<Component> {
    public static @NonNull TextComponent empty() {
        return TextComponentImpl.EMPTY;
    }

    public static @NonNull TextComponent newline() {
        return TextComponentImpl.NEWLINE;
    }

    public static @NonNull TextComponent space() {
        return TextComponentImpl.SPACE;
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent join(@NonNull ComponentLike separator, ComponentLike ... components) {
        return Component.join(separator, Arrays.asList(components));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent join(@NonNull ComponentLike separator, Iterable<? extends ComponentLike> components) {
        Iterator<? extends ComponentLike> it = components.iterator();
        if (!it.hasNext()) {
            return Component.empty();
        }
        TextComponent.Builder builder = Component.text();
        while (it.hasNext()) {
            builder.append(it.next());
            if (!it.hasNext()) continue;
            builder.append(separator);
        }
        return (TextComponent)builder.build();
    }

    public static @NonNull Collector<Component, ? extends ComponentBuilder<?, ?>, Component> toComponent() {
        return Component.toComponent(Component.empty());
    }

    public static @NonNull Collector<Component, ? extends ComponentBuilder<?, ?>, Component> toComponent(@NonNull Component separator) {
        return Collector.of(Component::text, (builder, add) -> {
            if (separator != Component.empty() && !builder.children().isEmpty()) {
                builder.append(separator);
            }
            builder.append((Component)add);
        }, (a, b) -> {
            List<Component> aChildren = a.children();
            TextComponent.Builder ret = (TextComponent.Builder)Component.text().append(aChildren);
            if (!aChildren.isEmpty()) {
                ret.append(separator);
            }
            ret.append(b.children());
            return ret;
        }, ComponentBuilder::build, new Collector.Characteristics[0]);
    }

    @Contract(pure=true)
    public static @NonNull BlockNBTComponent.Builder blockNBT() {
        return new BlockNBTComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static @NonNull BlockNBTComponent blockNBT(@NonNull Consumer<? super BlockNBTComponent.Builder> consumer) {
        return (BlockNBTComponent)Buildable.configureAndBuild(Component.blockNBT(), consumer);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull BlockNBTComponent blockNBT(@NonNull String nbtPath, @NonNull BlockNBTComponent.Pos pos) {
        return Component.blockNBT(nbtPath, false, pos);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull BlockNBTComponent blockNBT(@NonNull String nbtPath, boolean interpret, @NonNull BlockNBTComponent.Pos pos) {
        return new BlockNBTComponentImpl(Collections.emptyList(), Style.empty(), nbtPath, interpret, pos);
    }

    @Contract(pure=true)
    public static @NonNull EntityNBTComponent.Builder entityNBT() {
        return new EntityNBTComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static @NonNull EntityNBTComponent entityNBT(@NonNull Consumer<? super EntityNBTComponent.Builder> consumer) {
        return (EntityNBTComponent)Buildable.configureAndBuild(Component.entityNBT(), consumer);
    }

    @Contract(value="_, _ -> new")
    public static @NonNull EntityNBTComponent entityNBT(@NonNull String nbtPath, @NonNull String selector) {
        return (EntityNBTComponent)((EntityNBTComponent.Builder)Component.entityNBT().nbtPath(nbtPath)).selector(selector).build();
    }

    @Contract(pure=true)
    public static @NonNull KeybindComponent.Builder keybind() {
        return new KeybindComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static @NonNull KeybindComponent keybind(@NonNull Consumer<? super KeybindComponent.Builder> consumer) {
        return (KeybindComponent)Buildable.configureAndBuild(Component.keybind(), consumer);
    }

    @Contract(value="_ -> new", pure=true)
    public static @NonNull KeybindComponent keybind(@NonNull String keybind) {
        return Component.keybind(keybind, Style.empty());
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull KeybindComponent keybind(@NonNull String keybind, @NonNull Style style) {
        return new KeybindComponentImpl(Collections.emptyList(), style, keybind);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull KeybindComponent keybind(@NonNull String keybind, @Nullable TextColor color) {
        return Component.keybind(keybind, Style.style(color));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull KeybindComponent keybind(@NonNull String keybind, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.keybind(keybind, Style.style(color, decorations));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull KeybindComponent keybind(@NonNull String keybind, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.keybind(keybind, Style.style(color, decorations));
    }

    @Contract(pure=true)
    public static @NonNull ScoreComponent.Builder score() {
        return new ScoreComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static @NonNull ScoreComponent score(@NonNull Consumer<? super ScoreComponent.Builder> consumer) {
        return (ScoreComponent)Buildable.configureAndBuild(Component.score(), consumer);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull ScoreComponent score(@NonNull String name, @NonNull String objective) {
        return Component.score(name, objective, null);
    }

    @Deprecated
    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull ScoreComponent score(@NonNull String name, @NonNull String objective, @Nullable String value) {
        return new ScoreComponentImpl(Collections.emptyList(), Style.empty(), name, objective, value);
    }

    @Contract(pure=true)
    public static @NonNull SelectorComponent.Builder selector() {
        return new SelectorComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static @NonNull SelectorComponent selector(@NonNull Consumer<? super SelectorComponent.Builder> consumer) {
        return (SelectorComponent)Buildable.configureAndBuild(Component.selector(), consumer);
    }

    @Contract(value="_ -> new", pure=true)
    public static @NonNull SelectorComponent selector(@NonNull String pattern) {
        return new SelectorComponentImpl(Collections.emptyList(), Style.empty(), pattern);
    }

    @Contract(pure=true)
    public static @NonNull StorageNBTComponent.Builder storageNBT() {
        return new StorageNBTComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static @NonNull StorageNBTComponent storageNBT(@NonNull Consumer<? super StorageNBTComponent.Builder> consumer) {
        return (StorageNBTComponent)Buildable.configureAndBuild(Component.storageNBT(), consumer);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull StorageNBTComponent storageNBT(@NonNull String nbtPath, @NonNull Key storage) {
        return Component.storageNBT(nbtPath, false, storage);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull StorageNBTComponent storageNBT(@NonNull String nbtPath, boolean interpret, @NonNull Key storage) {
        return new StorageNBTComponentImpl(Collections.emptyList(), Style.empty(), nbtPath, interpret, storage);
    }

    @Contract(pure=true)
    public static @NonNull TextComponent.Builder text() {
        return new TextComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static @NonNull TextComponent text(@NonNull Consumer<? super TextComponent.Builder> consumer) {
        return (TextComponent)Buildable.configureAndBuild(Component.text(), consumer);
    }

    @Contract(value="_ -> new", pure=true)
    public static @NonNull TextComponent text(@NonNull String content) {
        if (content.isEmpty()) {
            return Component.empty();
        }
        return new TextComponentImpl(Collections.emptyList(), Style.empty(), content);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent text(@NonNull String content, @NonNull Style style) {
        return new TextComponentImpl(Collections.emptyList(), style, content);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent text(@NonNull String content, @Nullable TextColor color) {
        return new TextComponentImpl(Collections.emptyList(), Style.style(color), content);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TextComponent text(@NonNull String content, @Nullable TextColor color, TextDecoration ... decorations) {
        return new TextComponentImpl(Collections.emptyList(), Style.style(color, decorations), content);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TextComponent text(@NonNull String content, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return new TextComponentImpl(Collections.emptyList(), Style.style(color, decorations), content);
    }

    @Contract(value="_ -> new", pure=true)
    public static @NonNull TextComponent text(boolean value) {
        return Component.text(String.valueOf(value));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent text(boolean value, @NonNull Style style) {
        return Component.text(String.valueOf(value), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent text(boolean value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TextComponent text(boolean value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TextComponent text(boolean value, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(pure=true)
    public static @NonNull TextComponent text(char value) {
        if (value == '\n') {
            return Component.newline();
        }
        if (value == ' ') {
            return Component.space();
        }
        return Component.text(String.valueOf(value));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent text(char value, @NonNull Style style) {
        return Component.text(String.valueOf(value), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent text(char value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TextComponent text(char value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TextComponent text(char value, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_ -> new", pure=true)
    public static @NonNull TextComponent text(double value) {
        return Component.text(String.valueOf(value));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent text(double value, @NonNull Style style) {
        return Component.text(String.valueOf(value), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent text(double value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TextComponent text(double value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TextComponent text(double value, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_ -> new", pure=true)
    public static @NonNull TextComponent text(float value) {
        return Component.text(String.valueOf(value));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent text(float value, @NonNull Style style) {
        return Component.text(String.valueOf(value), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent text(float value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TextComponent text(float value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TextComponent text(float value, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_ -> new", pure=true)
    public static @NonNull TextComponent text(int value) {
        return Component.text(String.valueOf(value));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent text(int value, @NonNull Style style) {
        return Component.text(String.valueOf(value), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent text(int value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TextComponent text(int value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TextComponent text(int value, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_ -> new", pure=true)
    public static @NonNull TextComponent text(long value) {
        return Component.text(String.valueOf(value));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent text(long value, @NonNull Style style) {
        return Component.text(String.valueOf(value), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TextComponent text(long value, @Nullable TextColor color) {
        return Component.text(String.valueOf(value), color);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TextComponent text(long value, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TextComponent text(long value, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.text(String.valueOf(value), color, decorations);
    }

    @Contract(pure=true)
    public static @NonNull TranslatableComponent.Builder translatable() {
        return new TranslatableComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    public static @NonNull TranslatableComponent translatable(@NonNull Consumer<? super TranslatableComponent.Builder> consumer) {
        return (TranslatableComponent)Buildable.configureAndBuild(Component.translatable(), consumer);
    }

    @Contract(value="_ -> new", pure=true)
    public static @NonNull TranslatableComponent translatable(@NonNull String key) {
        return Component.translatable(key, Style.empty());
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TranslatableComponent translatable(@NonNull String key, @NonNull Style style) {
        return new TranslatableComponentImpl(Collections.emptyList(), style, key, Collections.emptyList());
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TranslatableComponent translatable(@NonNull String key, @Nullable TextColor color) {
        return Component.translatable(key, Style.style(color));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TranslatableComponent translatable(@NonNull String key, @Nullable TextColor color, TextDecoration ... decorations) {
        return Component.translatable(key, Style.style(color, decorations));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TranslatableComponent translatable(@NonNull String key, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return Component.translatable(key, Style.style(color, decorations));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TranslatableComponent translatable(@NonNull String key, ComponentLike ... args) {
        return Component.translatable(key, Style.empty(), args);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TranslatableComponent translatable(@NonNull String key, @NonNull Style style, ComponentLike ... args) {
        return new TranslatableComponentImpl(Collections.emptyList(), style, key, args);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TranslatableComponent translatable(@NonNull String key, @Nullable TextColor color, ComponentLike ... args) {
        return Component.translatable(key, Style.style(color), args);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static @NonNull TranslatableComponent translatable(@NonNull String key, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations, ComponentLike ... args) {
        return Component.translatable(key, Style.style(color, decorations), args);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static @NonNull TranslatableComponent translatable(@NonNull String key, @NonNull List<? extends ComponentLike> args) {
        return new TranslatableComponentImpl(Collections.emptyList(), Style.empty(), key, args);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static @NonNull TranslatableComponent translatable(@NonNull String key, @NonNull Style style, @NonNull List<? extends ComponentLike> args) {
        return new TranslatableComponentImpl(Collections.emptyList(), style, key, args);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(@NonNull String key, @Nullable TextColor color, @NonNull List<? extends ComponentLike> args) {
        return Component.translatable(key, Style.style(color), args);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static @NonNull TranslatableComponent translatable(@NonNull String key, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations, @NonNull List<? extends ComponentLike> args) {
        return Component.translatable(key, Style.style(color, decorations), args);
    }

    public @NonNull @Unmodifiable List<Component> children();

    @Contract(pure=true)
    public @NonNull Component children(@NonNull List<? extends ComponentLike> var1);

    default public boolean contains(@NonNull Component that) {
        if (this == that) {
            return true;
        }
        for (Component child : this.children()) {
            if (!child.contains(that)) continue;
            return true;
        }
        @Nullable HoverEvent<?> hoverEvent = this.hoverEvent();
        if (hoverEvent != null && hoverEvent.action().type().isAssignableFrom(Component.class)) {
            Component hover = (Component)hoverEvent.value();
            if (that == hover) {
                return true;
            }
            for (Component child : hover.children()) {
                if (!child.contains(that)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    default public void detectCycle(@NonNull Component that) {
        if (that.contains(this)) {
            throw new IllegalStateException("Component cycle detected between " + this + " and " + that);
        }
    }

    @Contract(pure=true)
    public @NonNull Component append(@NonNull Component var1);

    default public @NonNull Component append(@NonNull ComponentLike component) {
        return this.append(component.asComponent());
    }

    @Contract(pure=true)
    default public @NonNull Component append(@NonNull ComponentBuilder<?, ?> builder) {
        return this.append((Component)builder.build());
    }

    public @NonNull Style style();

    @Contract(pure=true)
    public @NonNull Component style(@NonNull Style var1);

    @Contract(pure=true)
    default public @NonNull Component style(@NonNull Consumer<Style.Builder> consumer) {
        return this.style(this.style().edit(consumer));
    }

    @Contract(pure=true)
    default public @NonNull Component style(@NonNull Consumer<Style.Builder> consumer, @NonNull Style.Merge.Strategy strategy) {
        return this.style(this.style().edit(consumer, strategy));
    }

    @Contract(pure=true)
    default public @NonNull Component style(@NonNull Style.Builder style) {
        return this.style(style.build());
    }

    @Contract(pure=true)
    default public @NonNull Component mergeStyle(@NonNull Component that) {
        return this.mergeStyle(that, Style.Merge.all());
    }

    @Contract(pure=true)
    default public @NonNull Component mergeStyle(@NonNull Component that, Style.Merge ... merges) {
        return this.mergeStyle(that, Style.Merge.of(merges));
    }

    @Contract(pure=true)
    default public @NonNull Component mergeStyle(@NonNull Component that, @NonNull Set<Style.Merge> merges) {
        return this.style(this.style().merge(that.style(), merges));
    }

    default public @Nullable TextColor color() {
        return this.style().color();
    }

    @Contract(pure=true)
    default public @NonNull Component color(@Nullable TextColor color) {
        return this.style(this.style().color(color));
    }

    @Contract(pure=true)
    default public @NonNull Component colorIfAbsent(@Nullable TextColor color) {
        if (this.color() == null) {
            return this.color(color);
        }
        return this;
    }

    default public boolean hasDecoration(@NonNull TextDecoration decoration) {
        return this.decoration(decoration) == TextDecoration.State.TRUE;
    }

    @Contract(pure=true)
    default public @NonNull Component decorate(@NonNull TextDecoration decoration) {
        return this.decoration(decoration, TextDecoration.State.TRUE);
    }

    default public @NonNull TextDecoration.State decoration(@NonNull TextDecoration decoration) {
        return this.style().decoration(decoration);
    }

    @Contract(pure=true)
    default public @NonNull Component decoration(@NonNull TextDecoration decoration, boolean flag) {
        return this.decoration(decoration, TextDecoration.State.byBoolean(flag));
    }

    @Contract(pure=true)
    default public @NonNull Component decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
        return this.style(this.style().decoration(decoration, state));
    }

    default public @NonNull Map<TextDecoration, TextDecoration.State> decorations() {
        return this.style().decorations();
    }

    @Contract(pure=true)
    default public @NonNull Component decorations(@NonNull Map<TextDecoration, TextDecoration.State> decorations) {
        return this.style(this.style().decorations(decorations));
    }

    default public @Nullable ClickEvent clickEvent() {
        return this.style().clickEvent();
    }

    @Contract(pure=true)
    default public @NonNull Component clickEvent(@Nullable ClickEvent event) {
        return this.style(this.style().clickEvent(event));
    }

    default public @Nullable HoverEvent<?> hoverEvent() {
        return this.style().hoverEvent();
    }

    @Contract(pure=true)
    default public @NonNull Component hoverEvent(@Nullable HoverEventSource<?> source) {
        return this.style(this.style().hoverEvent(source));
    }

    default public @Nullable String insertion() {
        return this.style().insertion();
    }

    @Contract(pure=true)
    default public @NonNull Component insertion(@Nullable String insertion) {
        return this.style(this.style().insertion(insertion));
    }

    default public boolean hasStyling() {
        return !this.style().isEmpty();
    }

    @Contract(pure=true)
    public @NonNull Component replaceText(@NonNull Consumer<TextReplacementConfig.Builder> var1);

    @Contract(pure=true)
    public @NonNull Component replaceText(@NonNull TextReplacementConfig var1);

    @Deprecated
    @Contract(pure=true)
    default public @NonNull Component replaceText(@NonNull String search, @Nullable ComponentLike replacement) {
        return this.replaceText((TextReplacementConfig.Builder b) -> b.matchLiteral(search).replacement(replacement));
    }

    @Deprecated
    @Contract(pure=true)
    default public @NonNull Component replaceText(@NonNull Pattern pattern, @NonNull Function<TextComponent.Builder, @Nullable ComponentLike> replacement) {
        return this.replaceText((TextReplacementConfig.Builder b) -> b.match(pattern).replacement(replacement));
    }

    @Deprecated
    @Contract(pure=true)
    default public @NonNull Component replaceFirstText(@NonNull String search, @Nullable ComponentLike replacement) {
        return this.replaceText((TextReplacementConfig.Builder b) -> b.matchLiteral(search).once().replacement(replacement));
    }

    @Deprecated
    @Contract(pure=true)
    default public @NonNull Component replaceFirstText(@NonNull Pattern pattern, @NonNull Function<TextComponent.Builder, @Nullable ComponentLike> replacement) {
        return this.replaceText((TextReplacementConfig.Builder b) -> b.match(pattern).once().replacement(replacement));
    }

    @Deprecated
    @Contract(pure=true)
    default public @NonNull Component replaceText(@NonNull String search, @Nullable ComponentLike replacement, int numberOfReplacements) {
        return this.replaceText((TextReplacementConfig.Builder b) -> b.matchLiteral(search).times(numberOfReplacements).replacement(replacement));
    }

    @Deprecated
    @Contract(pure=true)
    default public @NonNull Component replaceText(@NonNull Pattern pattern, @NonNull Function<TextComponent.Builder, @Nullable ComponentLike> replacement, int numberOfReplacements) {
        return this.replaceText((TextReplacementConfig.Builder b) -> b.match(pattern).times(numberOfReplacements).replacement(replacement));
    }

    @Deprecated
    @Contract(pure=true)
    default public @NonNull Component replaceText(@NonNull String search, @Nullable ComponentLike replacement, @NonNull IntFunction2<PatternReplacementResult> fn) {
        return this.replaceText((TextReplacementConfig.Builder b) -> b.matchLiteral(search).replacement(replacement).condition(fn));
    }

    @Deprecated
    @Contract(pure=true)
    default public @NonNull Component replaceText(@NonNull Pattern pattern, @NonNull Function<TextComponent.Builder, @Nullable ComponentLike> replacement, @NonNull IntFunction2<PatternReplacementResult> fn) {
        return this.replaceText((TextReplacementConfig.Builder b) -> b.match(pattern).replacement(replacement).condition(fn));
    }

    @Override
    default public void componentBuilderApply(@NonNull ComponentBuilder<?, ?> component) {
        component.append(this);
    }

    @Override
    default public @NonNull Component asComponent() {
        return this;
    }

    @Override
    default public @NonNull HoverEvent<Component> asHoverEvent(@NonNull UnaryOperator<Component> op) {
        return HoverEvent.showText((Component)op.apply(this));
    }
}

