/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import java.lang.reflect.InvocationTargetException;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FallingBlockWatcher
extends FlagWatcher {
    private int blockCombinedId = 1;
    private boolean gridLocked;

    public FallingBlockWatcher(Disguise disguise) {
        super(disguise);
    }

    @Override
    public FallingBlockWatcher clone(Disguise disguise) {
        FallingBlockWatcher watcher = (FallingBlockWatcher)super.clone(disguise);
        if (NmsVersion.v1_13.isSupported()) {
            watcher.setBlockData(this.getBlockData().clone());
        } else {
            watcher.setBlock(this.getBlock().clone());
        }
        return watcher;
    }

    public boolean isGridLocked() {
        return this.gridLocked;
    }

    public void setGridLocked(boolean gridLocked) {
        if (this.isGridLocked() == gridLocked) {
            return;
        }
        this.gridLocked = gridLocked;
        if (this.getDisguise().isDisguiseInUse() && this.getDisguise().getEntity() != null) {
            PacketContainer relMove = new PacketContainer(PacketType.Play.Server.REL_ENTITY_MOVE);
            StructureModifier shorts = relMove.getShorts();
            Location loc = this.getDisguise().getEntity().getLocation();
            relMove.getModifier().write(0, (Object)this.getDisguise().getEntity().getEntityId());
            shorts.write(0, (Object)this.conRel(loc.getX(), (double)loc.getBlockX() + 0.5));
            shorts.write(1, (Object)this.conRel(loc.getY(), (double)loc.getBlockY() + (loc.getY() % 1.0 >= 0.85 ? 1.0 : (loc.getY() % 1.0 >= 0.35 ? 0.5 : 0.0))));
            shorts.write(2, (Object)this.conRel(loc.getZ(), (double)loc.getBlockZ() + 0.5));
            try {
                for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                    if (player == this.getDisguise().getEntity()) {
                        PacketContainer temp = relMove.shallowClone();
                        temp.getModifier().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, temp, this.isGridLocked());
                        continue;
                    }
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, relMove, this.isGridLocked());
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private short conRel(double oldCord, double newCord) {
        return (short)((oldCord - newCord) * 4096.0 * (double)(this.isGridLocked() ? -1 : 1));
    }

    public ItemStack getBlock() {
        return ReflectionManager.getItemStackByCombinedId(this.getBlockCombinedId());
    }

    public void setBlock(ItemStack block) {
        if (block == null || block.getType() == null || block.getType() == Material.AIR || !block.getType().isBlock()) {
            block = new ItemStack(Material.STONE);
        }
        this.blockCombinedId = ReflectionManager.getCombinedIdByItemStack(block);
        if (!this.getDisguise().isCustomDisguiseName()) {
            this.getDisguise().setDisguiseName(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("Block") + " " + TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(ReflectionManager.toReadable(block.getType().name(), " ")));
        }
        if (DisguiseAPI.isDisguiseInUse(this.getDisguise()) && this.getDisguise().getWatcher() == this) {
            DisguiseUtilities.refreshTrackers(this.getDisguise());
        }
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public BlockData getBlockData() {
        return ReflectionManager.getBlockDataByCombinedId(this.getBlockCombinedId());
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public void setBlockData(BlockData data) {
        if (data == null || data.getMaterial() == Material.AIR && data.getMaterial().isBlock()) {
            this.setBlock(null);
            return;
        }
        this.blockCombinedId = ReflectionManager.getCombinedIdByBlockData(data);
        if (!this.getDisguise().isCustomDisguiseName()) {
            this.getDisguise().setDisguiseName(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("Block") + " " + TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(ReflectionManager.toReadable(data.getMaterial().name(), " ")));
        }
        if (DisguiseAPI.isDisguiseInUse(this.getDisguise()) && this.getDisguise().getWatcher() == this) {
            DisguiseUtilities.refreshTrackers(this.getDisguise());
        }
    }

    public int getBlockCombinedId() {
        if (this.blockCombinedId < 1) {
            this.blockCombinedId = 1;
        }
        return this.blockCombinedId;
    }
}

