/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.serializer.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import ld-shaded.net.kyori.adventure.key.Key;
import ld-shaded.net.kyori.adventure.text.BlockNBTComponent;
import ld-shaded.net.kyori.adventure.text.BuildableComponent;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.ComponentBuilder;
import ld-shaded.net.kyori.adventure.text.EntityNBTComponent;
import ld-shaded.net.kyori.adventure.text.KeybindComponent;
import ld-shaded.net.kyori.adventure.text.NBTComponent;
import ld-shaded.net.kyori.adventure.text.NBTComponentBuilder;
import ld-shaded.net.kyori.adventure.text.ScoreComponent;
import ld-shaded.net.kyori.adventure.text.SelectorComponent;
import ld-shaded.net.kyori.adventure.text.StorageNBTComponent;
import ld-shaded.net.kyori.adventure.text.TextComponent;
import ld-shaded.net.kyori.adventure.text.TranslatableComponent;
import ld-shaded.net.kyori.adventure.text.format.Style;
import ld-shaded.net.kyori.adventure.util.Buildable;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ComponentSerializerImpl
implements JsonDeserializer<Component>,
JsonSerializer<Component> {
    static final String TEXT = "text";
    static final String TRANSLATE = "translate";
    static final String TRANSLATE_WITH = "with";
    static final String SCORE = "score";
    static final String SCORE_NAME = "name";
    static final String SCORE_OBJECTIVE = "objective";
    static final String SCORE_VALUE = "value";
    static final String SELECTOR = "selector";
    static final String KEYBIND = "keybind";
    static final String EXTRA = "extra";
    static final String NBT = "nbt";
    static final String NBT_INTERPRET = "interpret";
    static final String NBT_BLOCK = "block";
    static final String NBT_ENTITY = "entity";
    static final String NBT_STORAGE = "storage";

    ComponentSerializerImpl() {
    }

    public Component deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return this.deserialize0(json, context);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BuildableComponent<?, ?> deserialize0(JsonElement element, JsonDeserializationContext context) throws JsonParseException {
        Style style;
        ComponentBuilder<TextComponent, TextComponent.Builder> component;
        if (element.isJsonPrimitive()) {
            return Component.text(element.getAsString());
        }
        if (element.isJsonArray()) {
            void var3_4;
            Object var3_3 = null;
            for (JsonElement childElement : element.getAsJsonArray()) {
                BuildableComponent<?, ?> child = this.deserialize0(childElement, context);
                if (var3_4 == null) {
                    Buildable.Builder builder = child.toBuilder();
                    continue;
                }
                var3_4.append((Component)child);
            }
            if (var3_4 != null) return var3_4.build();
            throw ComponentSerializerImpl.notSureHowToDeserialize(element);
        }
        if (!element.isJsonObject()) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(element);
        }
        JsonObject jsonObject = element.getAsJsonObject();
        if (jsonObject.has(TEXT)) {
            component = Component.text().content(jsonObject.get(TEXT).getAsString());
        } else if (jsonObject.has(TRANSLATE)) {
            String key = jsonObject.get(TRANSLATE).getAsString();
            if (!jsonObject.has(TRANSLATE_WITH)) {
                component = Component.translatable().key(key);
            } else {
                JsonArray with = jsonObject.getAsJsonArray(TRANSLATE_WITH);
                ArrayList args = new ArrayList(with.size());
                int size = with.size();
                for (int i = 0; i < size; ++i) {
                    JsonElement argElement = with.get(i);
                    args.add(this.deserialize0(argElement, context));
                }
                component = Component.translatable().key(key).args(args);
            }
        } else if (jsonObject.has(SCORE)) {
            JsonObject score = jsonObject.getAsJsonObject(SCORE);
            if (!score.has(SCORE_NAME) || !score.has(SCORE_OBJECTIVE)) {
                throw new JsonParseException("A score component requires a name and objective");
            }
            ScoreComponent.Builder builder = Component.score().name(score.get(SCORE_NAME).getAsString()).objective(score.get(SCORE_OBJECTIVE).getAsString());
            component = score.has(SCORE_VALUE) ? builder.value(score.get(SCORE_VALUE).getAsString()) : builder;
        } else if (jsonObject.has(SELECTOR)) {
            component = Component.selector().pattern(jsonObject.get(SELECTOR).getAsString());
        } else if (jsonObject.has(KEYBIND)) {
            component = Component.keybind().keybind(jsonObject.get(KEYBIND).getAsString());
        } else {
            boolean interpret;
            if (!jsonObject.has(NBT)) throw ComponentSerializerImpl.notSureHowToDeserialize(element);
            String nbt = jsonObject.get(NBT).getAsString();
            boolean bl = interpret = jsonObject.has(NBT_INTERPRET) && jsonObject.getAsJsonPrimitive(NBT_INTERPRET).getAsBoolean();
            if (jsonObject.has(NBT_BLOCK)) {
                BlockNBTComponent.Pos pos = (BlockNBTComponent.Pos)context.deserialize(jsonObject.get(NBT_BLOCK), BlockNBTComponent.Pos.class);
                component = ComponentSerializerImpl.nbt(Component.blockNBT(), nbt, interpret).pos(pos);
            } else if (jsonObject.has(NBT_ENTITY)) {
                component = ComponentSerializerImpl.nbt(Component.entityNBT(), nbt, interpret).selector(jsonObject.get(NBT_ENTITY).getAsString());
            } else {
                if (!jsonObject.has(NBT_STORAGE)) throw ComponentSerializerImpl.notSureHowToDeserialize(element);
                component = ComponentSerializerImpl.nbt(Component.storageNBT(), nbt, interpret).storage((Key)context.deserialize(jsonObject.get(NBT_STORAGE), Key.class));
            }
        }
        if (jsonObject.has(EXTRA)) {
            JsonArray extra = jsonObject.getAsJsonArray(EXTRA);
            int size = extra.size();
            for (int i = 0; i < size; ++i) {
                JsonElement extraElement = extra.get(i);
                component.append((Component)this.deserialize0(extraElement, context));
            }
        }
        if ((style = (Style)context.deserialize(element, Style.class)).isEmpty()) return component.build();
        component.style(style);
        return component.build();
    }

    private static <C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>> B nbt(B builder, String nbt, boolean interpret) {
        return builder.nbtPath(nbt).interpret(interpret);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonElement serialize(Component src, Type typeOfSrc, JsonSerializationContext context) {
        List<Component> children;
        JsonElement style;
        JsonObject object = new JsonObject();
        if (src.hasStyling() && (style = context.serialize((Object)src.style())).isJsonObject()) {
            for (Object entry : ((JsonObject)style).entrySet()) {
                object.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        if (!(children = src.children()).isEmpty()) {
            JsonArray extra = new JsonArray();
            for (Component component : children) {
                extra.add(context.serialize((Object)component));
            }
            object.add(EXTRA, (JsonElement)extra);
        }
        if (src instanceof TextComponent) {
            object.addProperty(TEXT, ((TextComponent)src).content());
            return object;
        } else if (src instanceof TranslatableComponent) {
            TranslatableComponent tc = (TranslatableComponent)src;
            object.addProperty(TRANSLATE, tc.key());
            if (tc.args().isEmpty()) return object;
            JsonArray with = new JsonArray();
            for (Component arg : tc.args()) {
                with.add(context.serialize((Object)arg));
            }
            object.add(TRANSLATE_WITH, (JsonElement)with);
            return object;
        } else if (src instanceof ScoreComponent) {
            ScoreComponent sc = (ScoreComponent)src;
            JsonObject score = new JsonObject();
            score.addProperty(SCORE_NAME, sc.name());
            score.addProperty(SCORE_OBJECTIVE, sc.objective());
            @Nullable String string = sc.value();
            if (string != null) {
                score.addProperty(SCORE_VALUE, string);
            }
            object.add(SCORE, (JsonElement)score);
            return object;
        } else if (src instanceof SelectorComponent) {
            object.addProperty(SELECTOR, ((SelectorComponent)src).pattern());
            return object;
        } else if (src instanceof KeybindComponent) {
            object.addProperty(KEYBIND, ((KeybindComponent)src).keybind());
            return object;
        } else {
            if (!(src instanceof NBTComponent)) throw ComponentSerializerImpl.notSureHowToSerialize(src);
            NBTComponent nc = (NBTComponent)src;
            object.addProperty(NBT, nc.nbtPath());
            object.addProperty(NBT_INTERPRET, Boolean.valueOf(nc.interpret()));
            if (src instanceof BlockNBTComponent) {
                JsonElement position = context.serialize((Object)((BlockNBTComponent)nc).pos());
                object.add(NBT_BLOCK, position);
                return object;
            } else if (src instanceof EntityNBTComponent) {
                object.addProperty(NBT_ENTITY, ((EntityNBTComponent)nc).selector());
                return object;
            } else {
                if (!(src instanceof StorageNBTComponent)) throw ComponentSerializerImpl.notSureHowToSerialize(src);
                object.add(NBT_STORAGE, context.serialize((Object)((StorageNBTComponent)nc).storage()));
            }
        }
        return object;
    }

    static JsonParseException notSureHowToDeserialize(Object element) {
        return new JsonParseException("Don't know how to turn " + element + " into a Component");
    }

    private static IllegalArgumentException notSureHowToSerialize(Component component) {
        return new IllegalArgumentException("Don't know how to serialize " + component + " as a Component");
    }
}

