/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.TextComponent;
import ld-shaded.net.kyori.adventure.text.format.TextDecoration;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.Token;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.TransformationParser;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DecorationTransformation
extends Transformation {
    private TextDecoration decoration;

    public static boolean canParse(String name) {
        return DecorationTransformation.parseDecoration(name) != null;
    }

    private DecorationTransformation() {
    }

    @Override
    public void load(String name, List<Token> args) {
        super.load(name, args);
        this.decoration = DecorationTransformation.parseDecoration(name);
        if (this.decoration == null) {
            throw new ParsingException("Don't know how to turn '" + name + "' into a decoration", -1);
        }
    }

    private static TextDecoration parseDecoration(String name) {
        switch (name = name.toLowerCase(Locale.ROOT)) {
            case "b": {
                name = "bold";
                break;
            }
            case "em": 
            case "i": {
                name = "italic";
                break;
            }
            case "u": {
                name = "underlined";
                break;
            }
            case "st": {
                name = "strikethrough";
                break;
            }
            case "obf": {
                name = "obfuscated";
                break;
            }
        }
        return TextDecoration.NAMES.value(name);
    }

    @Override
    public Component apply(Component component, TextComponent.Builder parent) {
        return component.decorate(this.decoration);
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("decoration", this.decoration));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DecorationTransformation that = (DecorationTransformation)other;
        return this.decoration == that.decoration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.decoration);
    }

    public static class Parser
    implements TransformationParser<DecorationTransformation> {
        @Override
        public DecorationTransformation parse() {
            return new DecorationTransformation();
        }
    }
}

