/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Vector3F;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedParticle;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.nbt.NbtWrapper;
import com.mojang.authlib.GameProfile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.EntityPose;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.VillagerData;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ArrowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FishWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.GuardianWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.IllagerWizardWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.InsentientWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ItemFrameWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.MinecartWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ModdedWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.OcelotWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PufferFishWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SlimeWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SpiderWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TNTWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TameableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TippedArrowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.reflection.ClassGetter;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookupCaller;
import me.libraryaddict.disguise.utilities.reflection.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsRemovedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fish;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ReflectionManager {
    private static final HashMap<String, Enum> soundCategories = new HashMap();
    private static String bukkitVersion;
    private static Method itemAsCraftCopyMethod;
    private static Method itemAsNmsCopyMethod;
    private static Method damageAndIdleSoundMethod;
    private static Constructor<?> boundingBoxConstructor;
    private static Method setBoundingBoxMethod;
    private static Field pingField;
    private static Field entityCountField;
    private static Field chunkMapField;
    private static Field chunkProviderField;
    private static Field entityTrackerField;
    private static Field trackedEntitiesField;
    @NmsRemovedIn(value=NmsVersion.v1_14)
    private static Method ihmGet;
    @NmsRemovedIn(value=NmsVersion.v1_14)
    private static Field trackerField;
    @NmsRemovedIn(value=NmsVersion.v1_14)
    private static Field entitiesField;
    private static NmsVersion version;
    private static Method itemAsBukkitMethod;
    private static Method soundEffectMethod;
    private static Method getServerMethod;
    private static Method getEnumArtMethod;
    private static Constructor blockPositionConstructor;
    private static Method enumDirectionMethod;
    private static Enum[] enumPlayerInfoAction;
    private static Constructor chatComponentConstructor;
    private static Constructor packetPlayOutConstructor;
    private static Enum[] enumGamemode;
    private static Method getNmsEntityMethod;
    private static Enum[] enumItemSlots;
    private static Method soundGetMethod;
    private static Method soundEffectGetMethod;
    private static Field soundEffectGetKey;
    private static Constructor vector3FConstructor;
    private static Method enumDirectionFrom;
    private static Constructor villagerDataConstructor;
    private static Method bukkitKeyToNms;
    private static Method registryBlocksGetMethod;
    private static Object villagerTypeRegistry;
    private static Object villagerProfessionRegistry;
    private static Constructor dataWatcherItemConstructor;
    private static Constructor vec3DConstructor;
    private static Method entityTypesAMethod;
    private static Class entityPoseClass;
    private static Method craftBlockDataGetState;
    private static Method getOldItemAsBlock;
    private static Method magicGetBlock;
    private static Method magicGetMaterial;
    private static Method getNmsItem;
    private static Method getBlockData;
    private static Method getBlockDataAsId;
    private static Method getNmsWorld;
    private static Method deserializedItemMeta;
    private static Method mobEffectList;
    private static Constructor mobEffectConstructor;
    private static Method boundingBoxMethod;
    private static Method bukkitEntityMethod;
    private static Method connectionEntityMethod;
    private static Field noDamageTicks;
    private static Method isInvul;
    private static Object genericDamage;
    private static Field boardField;
    public static Object scoreboardCrtieriaHealth;
    private static Method getObjectives;
    private static Method getPlayerScoreObjective;
    private static Method setScore;
    private static HashMap<String, String> classLocations;
    private static Field playerConnection;

    public static void init() {
        try {
            boundingBoxConstructor = ReflectionManager.getNmsConstructor("AxisAlignedBB", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            setBoundingBoxMethod = ReflectionManager.getNmsMethod("Entity", "a", ReflectionManager.getNmsClass("AxisAlignedBB"));
            if (NmsVersion.v1_17.isSupported()) {
                for (Field f : ReflectionManager.getNmsClass("Entity").getDeclaredFields()) {
                    if (f.getType() != AtomicInteger.class) continue;
                    f.setAccessible(true);
                    entityCountField = f;
                    break;
                }
            } else {
                entityCountField = ReflectionManager.getNmsField("Entity", "entityCount");
            }
            mobEffectConstructor = ReflectionManager.getNmsConstructor("MobEffect", ReflectionManager.getNmsClass("MobEffectList"), Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            mobEffectList = ReflectionManager.getNmsMethod("MobEffectList", "fromId", Integer.TYPE);
            boundingBoxMethod = ReflectionManager.getNmsMethod("Entity", "getBoundingBox", new Class[0]);
            bukkitEntityMethod = ReflectionManager.getNmsMethod("Entity", "getBukkitEntity", new Class[0]);
            Class<?> craftItemClass = ReflectionManager.getCraftClass("CraftItemStack");
            itemAsCraftCopyMethod = ReflectionManager.getCraftMethod(craftItemClass, "asCraftCopy", ItemStack.class);
            itemAsNmsCopyMethod = ReflectionManager.getCraftMethod(craftItemClass, "asNMSCopy", ItemStack.class);
            itemAsBukkitMethod = ReflectionManager.getCraftMethod(craftItemClass, "asBukkitCopy", ReflectionManager.getNmsClass("ItemStack"));
            getServerMethod = ReflectionManager.getCraftMethod("CraftServer", "getServer", new Class[0]);
            getEnumArtMethod = ReflectionManager.getCraftMethod("CraftArt", "BukkitToNotch", Art.class);
            blockPositionConstructor = ReflectionManager.getNmsConstructor("BlockPosition", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            enumDirectionMethod = ReflectionManager.getNmsMethod("EnumDirection", "fromType2", Integer.TYPE);
            enumPlayerInfoAction = (Enum[])ReflectionManager.getNmsClass("PacketPlayOutPlayerInfo$EnumPlayerInfoAction").getEnumConstants();
            chatComponentConstructor = ReflectionManager.getNmsConstructor("ChatComponentText", String.class);
            packetPlayOutConstructor = NmsVersion.v1_17.isSupported() ? ReflectionManager.getNmsConstructor("PacketPlayOutPlayerInfo$PlayerInfoData", GameProfile.class, Integer.TYPE, ReflectionManager.getNmsClass("EnumGamemode"), ReflectionManager.getNmsClass("IChatBaseComponent")) : ReflectionManager.getNmsConstructor("PacketPlayOutPlayerInfo$PlayerInfoData", ReflectionManager.getNmsClass("PacketPlayOutPlayerInfo"), GameProfile.class, Integer.TYPE, ReflectionManager.getNmsClass("EnumGamemode"), ReflectionManager.getNmsClass("IChatBaseComponent"));
            enumGamemode = (Enum[])ReflectionManager.getNmsClass("EnumGamemode").getEnumConstants();
            getNmsEntityMethod = ReflectionManager.getCraftMethod("CraftEntity", "getHandle", new Class[0]);
            enumItemSlots = (Enum[])ReflectionManager.getNmsClass("EnumItemSlot").getEnumConstants();
            Class<?> craftSound = ReflectionManager.getCraftClass("CraftSound");
            try {
                soundGetMethod = craftSound.getMethod("getSound", Sound.class);
            }
            catch (Exception ex) {
                soundEffectGetMethod = ReflectionManager.getCraftMethod("CraftSound", "getSoundEffect", Sound.class);
                soundEffectGetKey = ReflectionManager.getNmsField("SoundEffect", "b");
            }
            soundEffectMethod = ReflectionManager.getCraftMethod("CraftSound", "getSoundEffect", String.class);
            vector3FConstructor = ReflectionManager.getNmsConstructor("Vector3f", Float.TYPE, Float.TYPE, Float.TYPE);
            enumDirectionFrom = ReflectionManager.getNmsMethod("EnumDirection", "fromType1", Integer.TYPE);
            getBlockData = ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass("Block"), "getBlockData", new Class[0]);
            if (NmsVersion.v1_13.isSupported()) {
                craftBlockDataGetState = ReflectionManager.getCraftMethod("CraftBlockData", "getState", new Class[0]);
                magicGetBlock = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getBlock", Material.class);
                magicGetMaterial = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getMaterial", ReflectionManager.getNmsClass("Block"));
                entityTypesAMethod = ReflectionManager.getNmsMethod("EntityTypes", "a", String.class);
                if (NmsVersion.v1_14.isSupported()) {
                    entityPoseClass = ReflectionManager.getNmsClass("EntityPose");
                    registryBlocksGetMethod = ReflectionManager.getNmsMethod("RegistryBlocks", "get", ReflectionManager.getNmsClass("MinecraftKey"));
                    villagerDataConstructor = ReflectionManager.getNmsConstructor("VillagerData", ReflectionManager.getNmsClass("VillagerType"), ReflectionManager.getNmsClass("VillagerProfession"), Integer.TYPE);
                    if (NmsVersion.v1_17.isSupported()) {
                        villagerProfessionRegistry = ReflectionManager.getNmsField("IRegistry", "ap").get(null);
                        villagerTypeRegistry = ReflectionManager.getNmsField("IRegistry", "ao").get(null);
                        playerConnection = ReflectionManager.getNmsField("EntityPlayer", "b");
                        connectionEntityMethod = ReflectionManager.getNmsMethod("PlayerConnection", "d", new Class[0]);
                    } else {
                        villagerProfessionRegistry = ReflectionManager.getNmsField("IRegistry", "VILLAGER_PROFESSION").get(null);
                        villagerTypeRegistry = ReflectionManager.getNmsField("IRegistry", "VILLAGER_TYPE").get(null);
                    }
                } else {
                    registryBlocksGetMethod = ReflectionManager.getNmsMethod("RegistryBlocks", "getOrDefault", ReflectionManager.getNmsClass("MinecraftKey"));
                }
            }
            bukkitKeyToNms = ReflectionManager.getCraftMethod("CraftNamespacedKey", "toMinecraft", NamespacedKey.class);
            dataWatcherItemConstructor = ReflectionManager.getNmsConstructor("DataWatcher$Item", ReflectionManager.getNmsClass("DataWatcherObject"), Object.class);
            vec3DConstructor = ReflectionManager.getNmsConstructor("Vec3D", Double.TYPE, Double.TYPE, Double.TYPE);
            getOldItemAsBlock = ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass("Block"), "asBlock", ReflectionManager.getNmsClass("Item"));
            getNmsItem = ReflectionManager.getNmsMethod("ItemStack", "getItem", new Class[0]);
            getBlockDataAsId = ReflectionManager.getNmsMethod("Block", "getCombinedId", ReflectionManager.getNmsClass("IBlockData"));
            getNmsWorld = ReflectionManager.getCraftMethod("CraftWorld", "getHandle", new Class[0]);
            deserializedItemMeta = ReflectionManager.getCraftMethod(ReflectionManager.getCraftClass("CraftMetaItem$SerializableMeta"), "deserialize", Map.class);
            if (NmsVersion.v1_17.isSupported()) {
                boolean nextInt = false;
                Field[] fieldArray = ReflectionManager.getNmsClass("Entity").getDeclaredFields();
                int n = fieldArray.length;
                for (int i = 0; i < n; ++i) {
                    Field f = fieldArray[i];
                    if (f.getType().getSimpleName().equals("Tag")) {
                        nextInt = true;
                        continue;
                    }
                    if (f.getType() != Integer.TYPE || !nextInt) continue;
                    noDamageTicks = f;
                    break;
                }
            } else {
                noDamageTicks = ReflectionManager.getNmsField("Entity", "noDamageTicks");
            }
            isInvul = ReflectionManager.getNmsMethod("Entity", "isInvulnerable", ReflectionManager.getNmsClass("DamageSource"));
            for (Field f : ReflectionManager.getNmsClass("DamageSource").getFields()) {
                Object obj;
                if (!Modifier.isStatic(f.getModifiers()) || (obj = f.get(null)) == null || !obj.toString().contains("(generic)")) continue;
                genericDamage = obj;
                break;
            }
            boardField = ReflectionManager.getCraftClass("CraftScoreboard").getDeclaredField("board");
            boardField.setAccessible(true);
            scoreboardCrtieriaHealth = ReflectionManager.getNmsField("IScoreboardCriteria", NmsVersion.v1_17.isSupported() ? "f" : (NmsVersion.v1_13.isSupported() ? "HEALTH" : "g")).get(null);
            setScore = ReflectionManager.getNmsMethod("ScoreboardScore", "setScore", Integer.TYPE);
            if (!NmsVersion.v1_13.isSupported()) {
                getObjectives = ReflectionManager.getNmsMethod("Scoreboard", "getObjectivesForCriteria", ReflectionManager.getNmsClass("IScoreboardCriteria"));
                getPlayerScoreObjective = ReflectionManager.getNmsMethod("Scoreboard", "getPlayerScoreForObjective", String.class, ReflectionManager.getNmsClass("ScoreboardObjective"));
            } else {
                getObjectives = ReflectionManager.getNmsMethod("Scoreboard", "getObjectivesForCriteria", ReflectionManager.getNmsClass("IScoreboardCriteria"), String.class, Consumer.class);
            }
            Method method = ReflectionManager.getNmsMethod("SoundCategory", "a", new Class[0]);
            for (Enum anEnum : (Enum[])ReflectionManager.getNmsClass("SoundCategory").getEnumConstants()) {
                soundCategories.put((String)method.invoke((Object)anEnum, new Object[0]), anEnum);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Object entity = ReflectionManager.createEntityInstance(DisguiseType.COW, "Cow");
            for (Method method : ReflectionManager.getNmsClass("EntityCow").getDeclaredMethods()) {
                if (method.getReturnType() != Float.TYPE || !Modifier.isProtected(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
                method.setAccessible(true);
                float value = ((Float)method.invoke(entity, new Object[0])).floatValue();
                if (((Float)method.invoke(entity, new Object[0])).floatValue() != 0.4f) continue;
                damageAndIdleSoundMethod = ReflectionManager.getNmsClass("EntityLiving").getDeclaredMethod(method.getName(), new Class[0]);
                damageAndIdleSoundMethod.setAccessible(true);
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        pingField = ReflectionManager.getNmsField("EntityPlayer", NmsVersion.v1_17.isSupported() ? "e" : "ping");
        if (NmsVersion.v1_14.isSupported()) {
            chunkMapField = ReflectionManager.getNmsField("ChunkProviderServer", NmsVersion.v1_17.isSupported() ? "a" : "playerChunkMap");
            trackedEntitiesField = ReflectionManager.getNmsField("PlayerChunkMap", NmsVersion.v1_17.isSupported() ? "G" : "trackedEntities");
            entityTrackerField = ReflectionManager.getNmsField("PlayerChunkMap$EntityTracker", NmsVersion.v1_17.isSupported() ? "b" : "trackerEntry");
            chunkProviderField = NmsVersion.v1_16.isSupported() ? ReflectionManager.getNmsField("WorldServer", NmsVersion.v1_17.isSupported() ? "C" : "chunkProvider") : ReflectionManager.getNmsField("World", "chunkProvider");
        } else {
            trackerField = ReflectionManager.getNmsField("WorldServer", "tracker");
            entitiesField = ReflectionManager.getNmsField("EntityTracker", "trackedEntities");
            ihmGet = ReflectionManager.getNmsMethod("IntHashMap", "get", Integer.TYPE);
        }
    }

    public static boolean hasInvul(Entity entity) {
        Object nmsEntity = ReflectionManager.getNmsEntity(entity);
        try {
            if (entity instanceof LivingEntity) {
                return noDamageTicks.getInt(nmsEntity) > 0;
            }
            return (Boolean)isInvul.invoke(nmsEntity, genericDamage);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean isSupported(AccessibleObject obj) {
        NmsAddedIn added;
        if (obj.isAnnotationPresent(NmsAddedIn.class) && !(added = obj.getAnnotation(NmsAddedIn.class)).value().isSupported()) {
            return false;
        }
        if (obj.isAnnotationPresent(NmsRemovedIn.class)) {
            NmsRemovedIn removed = obj.getAnnotation(NmsRemovedIn.class);
            return !removed.value().isSupported();
        }
        return true;
    }

    public static boolean isSupported(Class cl, String name) {
        try {
            for (Field field : cl.getFields()) {
                if (!field.getName().equals(name)) continue;
                return ReflectionManager.isSupported(field);
            }
            for (AccessibleObject accessibleObject : cl.getMethods()) {
                if (!((Method)accessibleObject).getName().equals(name)) continue;
                return ReflectionManager.isSupported(accessibleObject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public static String getResourceAsString(File file, String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static YamlConfiguration getPluginYAML(File file) {
        try {
            String s = ReflectionManager.getResourceAsString(file, "plugin.yml");
            if (s == null) {
                return null;
            }
            YamlConfiguration config = new YamlConfiguration();
            config.loadFromString(ReflectionManager.getResourceAsString(file, "plugin.yml"));
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getNewEntityId() {
        return ReflectionManager.getNewEntityId(true);
    }

    public static int getNewEntityId(boolean increment) {
        try {
            Number entityCount = (Number)entityCountField.get(null);
            if (increment) {
                if (NmsVersion.v1_14.isSupported()) {
                    return ((AtomicInteger)entityCount).incrementAndGet();
                }
                int id = entityCount.intValue();
                entityCountField.set(null, id + 1);
                return id;
            }
            return entityCount.intValue();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static Object getPlayerConnectionOrPlayer(Player player) {
        try {
            if (NmsVersion.v1_17.isSupported()) {
                return playerConnection.get(ReflectionManager.getNmsEntity((Entity)player));
            }
            return ReflectionManager.getNmsEntity((Entity)player);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static Object createEntityInstance(DisguiseType disguiseType, String entityName) {
        try {
            Object entityObject;
            Class entityClass;
            if (NmsVersion.v1_17.isSupported()) {
                entityClass = ReflectionManager.getNmsClassIgnoreErrors("Entity" + entityName);
                if (entityClass == null) {
                    entityClass = ReflectionManager.getNmsClass(entityName);
                }
            } else {
                entityClass = ReflectionManager.getNmsClass("Entity" + entityName);
            }
            Object world = ReflectionManager.getWorldServer((World)Bukkit.getWorlds().get(0));
            if (entityName.equals("Player")) {
                Object minecraftServer = ReflectionManager.getNmsMethod("MinecraftServer", "getServer", new Class[0]).invoke(null, new Object[0]);
                WrappedGameProfile gameProfile = ReflectionManager.getGameProfile(new UUID(0L, 0L), "Steve");
                if (NmsVersion.v1_17.isSupported()) {
                    entityObject = entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("MinecraftServer"), ReflectionManager.getNmsClass("WorldServer"), gameProfile.getHandleType()).newInstance(minecraftServer, world, gameProfile.getHandle());
                } else {
                    Object playerinteractmanager = ReflectionManager.getNmsClass("PlayerInteractManager").getDeclaredConstructor(ReflectionManager.getNmsClass(NmsVersion.v1_14.isSupported() ? "WorldServer" : "World")).newInstance(world);
                    entityObject = entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("MinecraftServer"), ReflectionManager.getNmsClass("WorldServer"), gameProfile.getHandleType(), playerinteractmanager.getClass()).newInstance(minecraftServer, world, gameProfile.getHandle(), playerinteractmanager);
                }
            } else {
                entityObject = entityName.equals("EnderPearl") ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), ReflectionManager.getNmsClass("EntityLiving")).newInstance(world, ReflectionManager.createEntityInstance(DisguiseType.COW, "Cow")) : (entityName.equals("FishingHook") ? (NmsVersion.v1_14.isSupported() ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("EntityHuman"), ReflectionManager.getNmsClass("World"), Integer.TYPE, Integer.TYPE).newInstance(ReflectionManager.createEntityInstance(DisguiseType.PLAYER, "Player"), world, 0, 0) : entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), ReflectionManager.getNmsClass("EntityHuman")).newInstance(world, ReflectionManager.createEntityInstance(DisguiseType.PLAYER, "Player"))) : (!NmsVersion.v1_14.isSupported() && entityName.equals("Potion") ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), Double.TYPE, Double.TYPE, Double.TYPE, ReflectionManager.getNmsClass("ItemStack")).newInstance(world, 0.0, 0.0, 0.0, ReflectionManager.getNmsItem(new ItemStack(Material.SPLASH_POTION))) : (NmsVersion.v1_14.isSupported() ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("EntityTypes"), ReflectionManager.getNmsClass("World")).newInstance(ReflectionManager.getEntityType(disguiseType.getEntityType()), world) : entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World")).newInstance(world))));
            }
            ReflectionManager.getNmsMethod("Entity", "setPosition", Double.TYPE, Double.TYPE, Double.TYPE).invoke(entityObject, 1, 1, 1);
            ReflectionManager.getNmsMethod("Entity", "setPosition", Double.TYPE, Double.TYPE, Double.TYPE).invoke(entityObject, 0, 0, 0);
            return entityObject;
        }
        catch (Exception e) {
            DisguiseUtilities.getLogger().warning("Error while attempting to create entity instance for " + disguiseType.name());
            e.printStackTrace();
            return null;
        }
    }

    public static Object getMobEffectList(int id) {
        try {
            return mobEffectList.invoke(null, id);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object createMobEffect(PotionEffect effect) {
        return ReflectionManager.createMobEffect(effect.getType().getId(), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles());
    }

    public static Object createMobEffect(int id, int duration, int amplification, boolean ambient, boolean particles) {
        try {
            return mobEffectConstructor.newInstance(ReflectionManager.getMobEffectList(id), duration, amplification, ambient, particles);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static FakeBoundingBox getBoundingBox(Entity entity) {
        try {
            Object boundingBox = boundingBoxMethod.invoke(ReflectionManager.getNmsEntity(entity), new Object[0]);
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            int stage = 0;
            block10: for (Field field : boundingBox.getClass().getDeclaredFields()) {
                if (!field.getType().getSimpleName().equals("double") || Modifier.isStatic(field.getModifiers())) continue;
                switch (++stage) {
                    case 1: {
                        x -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 2: {
                        y -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 3: {
                        z -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 4: {
                        x += field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 5: {
                        y += field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 6: {
                        z += field.getDouble(boundingBox);
                        continue block10;
                    }
                    default: {
                        throw new Exception("Error while setting the bounding box, more doubles than I thought??");
                    }
                }
            }
            return new FakeBoundingBox(x, y, z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerFromPlayerConnection(Object nmsEntity) {
        try {
            if (NmsVersion.v1_17.isSupported()) {
                nmsEntity = connectionEntityMethod.invoke(nmsEntity, new Object[0]);
            }
            return nmsEntity;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Entity getBukkitEntity(Object nmsEntity) {
        try {
            return (Entity)bukkitEntityMethod.invoke(nmsEntity, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ItemStack getBukkitItem(Object nmsItem) {
        try {
            return (ItemStack)itemAsBukkitMethod.invoke(null, nmsItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ItemStack getCraftItem(ItemStack bukkitItem) {
        try {
            return (ItemStack)itemAsCraftCopyMethod.invoke(null, bukkitItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static NmsVersion getVersion() {
        if (version == null) {
            ReflectionManager.getBukkitVersion();
        }
        return version;
    }

    public static String getBukkitVersion() {
        if (bukkitVersion == null) {
            bukkitVersion = Bukkit.getServer().getClass().getName().split("\\.")[3];
            for (NmsVersion v : NmsVersion.values()) {
                if (!ReflectionManager.getBukkitVersion().startsWith(v.name())) continue;
                version = v;
                break;
            }
        }
        return bukkitVersion;
    }

    public static Class<?> getCraftClass(String className) {
        try {
            return Class.forName(ReflectionManager.getLocation("org.bukkit.craftbukkit", className));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getCraftConstructor(Class clazz, Class<?> ... parameters) {
        try {
            Constructor declaredConstructor = clazz.getDeclaredConstructor(parameters);
            declaredConstructor.setAccessible(true);
            return declaredConstructor;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getCraftConstructor(String className, Class<?> ... parameters) {
        return ReflectionManager.getCraftConstructor(ReflectionManager.getCraftClass(className), parameters);
    }

    public static Object getCraftSound(Sound sound) {
        try {
            return soundEffectMethod.invoke(null, ReflectionManager.getSoundString(sound));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getEntityTrackerEntry(Entity target) throws Exception {
        Object world = ReflectionManager.getWorldServer(target.getWorld());
        if (NmsVersion.v1_14.isSupported()) {
            Object chunkProvider = chunkProviderField.get(world);
            Object chunkMap = chunkMapField.get(chunkProvider);
            Map trackedEntities = (Map)trackedEntitiesField.get(chunkMap);
            Object entityTracker = trackedEntities.get(target.getEntityId());
            if (entityTracker == null) {
                return null;
            }
            return entityTrackerField.get(entityTracker);
        }
        Object tracker = trackerField.get(world);
        Object trackedEntities = entitiesField.get(tracker);
        return ihmGet.invoke(trackedEntities, target.getEntityId());
    }

    public static Object getMinecraftServer() {
        try {
            return getServerMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getEnumArt(Art art) {
        try {
            Object enumArt = getEnumArtMethod.invoke(null, art);
            for (Field field : enumArt.getClass().getDeclaredFields()) {
                if (field.getType() != String.class) continue;
                return (String)field.get(enumArt);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static Object getBlockPosition(int x, int y, int z) {
        try {
            return blockPositionConstructor.newInstance(x, y, z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Enum getEnumDirection(int direction) {
        try {
            return (Enum)enumDirectionMethod.invoke(null, direction);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Enum getEnumPlayerInfoAction(int action) {
        try {
            return enumPlayerInfoAction[action];
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerInfoData(Object playerInfoPacket, WrappedGameProfile gameProfile) {
        try {
            Object playerListName = chatComponentConstructor.newInstance(gameProfile.getName());
            if (NmsVersion.v1_17.isSupported()) {
                return packetPlayOutConstructor.newInstance(gameProfile.getHandle(), 0, enumGamemode[1], playerListName);
            }
            return packetPlayOutConstructor.newInstance(playerInfoPacket, gameProfile.getHandle(), 0, enumGamemode[1], playerListName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static WrappedGameProfile getGameProfile(Player player) {
        return WrappedGameProfile.fromPlayer((Player)player);
    }

    public static WrappedGameProfile getGameProfile(UUID uuid, String playerName) {
        try {
            return new WrappedGameProfile(uuid != null ? uuid : ReflectionManager.getRandomUUID(), playerName == null || playerName.length() < 17 ? playerName : playerName.substring(0, 16));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static WrappedGameProfile getClonedProfile(WrappedGameProfile gameProfile) {
        return ReflectionManager.getGameProfileWithThisSkin(null, gameProfile.getName(), gameProfile);
    }

    public static WrappedGameProfile getGameProfileWithThisSkin(UUID uuid, String playerName, WrappedGameProfile profileWithSkin) {
        try {
            WrappedGameProfile gameProfile = new WrappedGameProfile(uuid != null ? uuid : ReflectionManager.getRandomUUID(), playerName == null || playerName.length() < 17 ? playerName : playerName.substring(0, 16));
            if (profileWithSkin != null) {
                gameProfile.getProperties().putAll(profileWithSkin.getProperties());
            }
            return gameProfile;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static UUID getRandomUUID() {
        UUID uuid = UUID.randomUUID();
        if (DisguiseConfig.getUUIDGeneratedVersion() == 4) {
            return uuid;
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        bb.put(6, (byte)(bb.get(6) & 0xF));
        bb.put(6, (byte)(bb.get(6) | DisguiseConfig.getUUIDGeneratedVersion()));
        bb.position(0);
        long firstLong = bb.getLong();
        long secondLong = bb.getLong();
        return new UUID(firstLong, secondLong);
    }

    private static String getLocation(String pack, String className) {
        String toReturn = classLocations.get(className);
        if (toReturn != null) {
            return toReturn;
        }
        try {
            ArrayList<String> classes = ClassGetter.getEntriesForPackage(pack);
            String realLocation = classes.stream().filter(s -> s.endsWith("/" + className + ".class")).findAny().get().replace("/", ".").replace(".class", "");
            classLocations.put(className, realLocation);
            return realLocation;
        }
        catch (Throwable throwable) {
            classLocations.put(className, className);
            return className;
        }
    }

    public static Class getNmsClass(String className) {
        try {
            return Class.forName(ReflectionManager.getLocation("net.minecraft", className));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class getNmsClassIgnoreErrors(String className) {
        try {
            return Class.forName(ReflectionManager.getLocation("net.minecraft", className));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Constructor getNmsConstructor(Class clazz, Class<?> ... parameters) {
        try {
            Constructor declaredConstructor = clazz.getDeclaredConstructor(parameters);
            declaredConstructor.setAccessible(true);
            return declaredConstructor;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getNmsConstructor(String className, Class<?> ... parameters) {
        return ReflectionManager.getNmsConstructor(ReflectionManager.getNmsClass(className), parameters);
    }

    public static Object getNmsEntity(Entity entity) {
        try {
            return getNmsEntityMethod.invoke((Object)entity, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Field getNmsField(Class clazz, String fieldName) {
        try {
            Field declaredField = clazz.getDeclaredField(fieldName);
            declaredField.setAccessible(true);
            return declaredField;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Field getNmsField(String className, String fieldName) {
        return ReflectionManager.getNmsField(ReflectionManager.getNmsClass(className), fieldName);
    }

    public static Object getNmsItem(ItemStack itemstack) {
        try {
            return itemAsNmsCopyMethod.invoke(null, itemstack);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getCraftMethod(String className, String methodName, Class<?> ... parameters) {
        return ReflectionManager.getCraftMethod(ReflectionManager.getCraftClass(className), methodName, parameters);
    }

    public static Method getCraftMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            Method declaredMethod = clazz.getDeclaredMethod(methodName, parameters);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getNmsMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            Method declaredMethod = clazz.getDeclaredMethod(methodName, parameters);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getNmsMethod(String className, String methodName, Class<?> ... parameters) {
        return ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass(className), methodName, parameters);
    }

    public static double getPing(Player player) {
        try {
            return pingField.getInt(ReflectionManager.getNmsEntity((Entity)player));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    public static float[] getSize(Entity entity) {
        try {
            if (NmsVersion.v1_14.isSupported()) {
                Object size = ReflectionManager.getNmsField("Entity", "size").get(ReflectionManager.getNmsEntity(entity));
                float width = ReflectionManager.getNmsField("EntitySize", "width").getFloat(size);
                float height = ReflectionManager.getNmsField("Entity", "headHeight").getFloat(ReflectionManager.getNmsEntity(entity));
                return new float[]{width, height};
            }
            float width = ReflectionManager.getNmsField("Entity", "width").getFloat(ReflectionManager.getNmsEntity(entity));
            float height = ((Float)ReflectionManager.getNmsMethod("Entity", "getHeadHeight", new Class[0]).invoke(ReflectionManager.getNmsEntity(entity), new Object[0])).floatValue();
            return new float[]{width, height};
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static WrappedGameProfile getSkullBlob(WrappedGameProfile gameProfile) {
        try {
            Object minecraftServer = ReflectionManager.getMinecraftServer();
            for (Method method : ReflectionManager.getNmsClass("MinecraftServer").getMethods()) {
                if (!method.getReturnType().getSimpleName().equals("MinecraftSessionService")) continue;
                Object session = method.invoke(minecraftServer, new Object[0]);
                return WrappedGameProfile.fromHandle((Object)session.getClass().getDeclaredMethod("fillProfileProperties", gameProfile.getHandleType(), Boolean.TYPE).invoke(session, gameProfile.getHandle(), true));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static Float getSoundModifier(Object entity) {
        try {
            return (Float)damageAndIdleSoundMethod.invoke(entity, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static WrappedGameProfile grabProfileAddUUID(String playername) {
        try {
            Object minecraftServer = ReflectionManager.getMinecraftServer();
            for (Method method : ReflectionManager.getNmsClass("MinecraftServer").getMethods()) {
                if (!method.getReturnType().getSimpleName().equals("GameProfileRepository")) continue;
                Object agent = Class.forName("com.mojang.authlib.Agent").getDeclaredField("MINECRAFT").get(null);
                LibsProfileLookupCaller callback = new LibsProfileLookupCaller();
                Object profileRepo = method.invoke(minecraftServer, new Object[0]);
                method.getReturnType().getMethod("findProfilesByNames", String[].class, agent.getClass(), Class.forName("com.mojang.authlib.ProfileLookupCallback")).invoke(profileRepo, new String[]{playername}, agent, callback);
                if (callback.getGameProfile() != null) {
                    return callback.getGameProfile();
                }
                return ReflectionManager.getGameProfile(null, playername);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void setBoundingBox(Entity entity, FakeBoundingBox newBox) {
        try {
            Location loc = entity.getLocation();
            Object boundingBox = boundingBoxConstructor.newInstance(loc.getX() - newBox.getX() / 2.0, loc.getY(), loc.getZ() - newBox.getZ() / 2.0, loc.getX() + newBox.getX() / 2.0, loc.getY() + newBox.getY(), loc.getZ() + newBox.getZ() / 2.0);
            setBoundingBoxMethod.invoke(ReflectionManager.getNmsEntity(entity), boundingBox);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Enum getSoundCategory(String category) {
        return soundCategories.get(category);
    }

    public static Enum getSoundCategory(DisguiseType disguiseType) {
        if (disguiseType == DisguiseType.PLAYER) {
            return ReflectionManager.getSoundCategory("player");
        }
        Class entityClass = disguiseType.getEntityType().getEntityClass();
        if (Monster.class.isAssignableFrom(entityClass)) {
            return ReflectionManager.getSoundCategory("hostile");
        }
        if (Ambient.class.isAssignableFrom(entityClass)) {
            return ReflectionManager.getSoundCategory("ambient");
        }
        return ReflectionManager.getSoundCategory("neutral");
    }

    public static Enum createEnumItemSlot(EquipmentSlot slot) {
        switch (slot) {
            case HAND: {
                return enumItemSlots[0];
            }
            case OFF_HAND: {
                return enumItemSlots[1];
            }
            case FEET: {
                return enumItemSlots[2];
            }
            case LEGS: {
                return enumItemSlots[3];
            }
            case CHEST: {
                return enumItemSlots[4];
            }
            case HEAD: {
                return enumItemSlots[5];
            }
        }
        return null;
    }

    public static EquipmentSlot createEquipmentSlot(Object enumItemSlot) {
        try {
            Enum nmsSlot = (Enum)enumItemSlot;
            switch (nmsSlot.name()) {
                case "MAINHAND": {
                    return EquipmentSlot.HAND;
                }
                case "OFFHAND": {
                    return EquipmentSlot.OFF_HAND;
                }
                case "FEET": {
                    return EquipmentSlot.FEET;
                }
                case "LEGS": {
                    return EquipmentSlot.LEGS;
                }
                case "CHEST": {
                    return EquipmentSlot.CHEST;
                }
                case "HEAD": {
                    return EquipmentSlot.HEAD;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ItemStack getEquipment(EquipmentSlot slot, Entity disguisedEntity) {
        if (!(disguisedEntity instanceof LivingEntity)) {
            return null;
        }
        switch (slot) {
            case HAND: {
                return ((LivingEntity)disguisedEntity).getEquipment().getItemInMainHand();
            }
            case OFF_HAND: {
                return ((LivingEntity)disguisedEntity).getEquipment().getItemInOffHand();
            }
            case FEET: {
                return ((LivingEntity)disguisedEntity).getEquipment().getBoots();
            }
            case LEGS: {
                return ((LivingEntity)disguisedEntity).getEquipment().getLeggings();
            }
            case CHEST: {
                return ((LivingEntity)disguisedEntity).getEquipment().getChestplate();
            }
            case HEAD: {
                return ((LivingEntity)disguisedEntity).getEquipment().getHelmet();
            }
        }
        return null;
    }

    public static Object getSoundString(Sound sound) {
        try {
            if (soundGetMethod == null) {
                return soundEffectGetKey.get(soundEffectGetMethod.invoke(null, sound)).toString();
            }
            return soundGetMethod.invoke(null, sound);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class getNmsClass(Class cl) {
        if (VillagerData.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("VillagerData");
        }
        if (BlockPosition.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("BlockPosition");
        }
        if (WrappedBlockData.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("IBlockData");
        }
        if (ItemStack.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("ItemStack");
        }
        if (WrappedChatComponent.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("IChatBaseComponent");
        }
        if (Vector3F.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("Vector3f");
        }
        if (EulerAngle.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("Vector3f");
        }
        if (EnumWrappers.Direction.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("EnumDirection");
        }
        if (WrappedParticle.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("ParticleParam");
        }
        if (EntityPose.class.isAssignableFrom(cl)) {
            return entityPoseClass;
        }
        if (NbtWrapper.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("NBTTagCompound");
        }
        return cl;
    }

    public static Object convertInvalidMeta(Object value) {
        if (value instanceof Optional) {
            Optional opt = (Optional)value;
            if (!opt.isPresent()) {
                return NmsVersion.v1_13.isSupported() ? value : com.google.common.base.Optional.absent();
            }
            Object val = opt.get();
            if (val instanceof BlockPosition) {
                BlockPosition pos = (BlockPosition)val;
                try {
                    Object obj = blockPositionConstructor.newInstance(pos.getX(), pos.getY(), pos.getZ());
                    return NmsVersion.v1_13.isSupported() ? Optional.of(obj) : com.google.common.base.Optional.of(obj);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (val instanceof WrappedBlockData) {
                try {
                    Object obj = ((WrappedBlockData)val).getHandle();
                    return NmsVersion.v1_13.isSupported() ? Optional.of(obj) : com.google.common.base.Optional.of((Object)obj);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                if (val instanceof ItemStack) {
                    if ((val = ReflectionManager.getNmsItem((ItemStack)val)) == null) {
                        return NmsVersion.v1_13.isSupported() ? Optional.empty() : com.google.common.base.Optional.absent();
                    }
                    return Optional.of(val);
                }
                if (val instanceof WrappedChatComponent) {
                    Object obj = ((WrappedChatComponent)val).getHandle();
                    return NmsVersion.v1_13.isSupported() ? Optional.of(obj) : com.google.common.base.Optional.of((Object)obj);
                }
                if (!NmsVersion.v1_13.isSupported()) {
                    return com.google.common.base.Optional.of(val);
                }
            }
        } else if (value instanceof Vector3F) {
            Vector3F angle = (Vector3F)value;
            try {
                return vector3FConstructor.newInstance(Float.valueOf(angle.getX()), Float.valueOf(angle.getY()), Float.valueOf(angle.getZ()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (value instanceof EulerAngle) {
            EulerAngle angle = (EulerAngle)value;
            try {
                return vector3FConstructor.newInstance(Float.valueOf((float)angle.getX()), Float.valueOf((float)angle.getY()), Float.valueOf((float)angle.getZ()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (value instanceof EnumWrappers.Direction) {
            try {
                return enumDirectionFrom.invoke(null, ((EnumWrappers.Direction)value).ordinal());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (value instanceof BlockPosition) {
            BlockPosition pos = (BlockPosition)value;
            try {
                return blockPositionConstructor.newInstance(pos.getX(), pos.getY(), pos.getZ());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            if (value instanceof ItemStack) {
                return ReflectionManager.getNmsItem((ItemStack)value);
            }
            if (value instanceof Double) {
                return Float.valueOf(((Double)value).floatValue());
            }
            if (value instanceof NbtWrapper) {
                return ((NbtWrapper)value).getHandle();
            }
            if (value instanceof WrappedParticle) {
                return ((WrappedParticle)value).getHandle();
            }
            if (value instanceof EntityPose) {
                return ReflectionManager.getNmsEntityPose((EntityPose)((Object)value));
            }
            if (value instanceof VillagerData) {
                return ReflectionManager.getNmsVillagerData((VillagerData)value);
            }
            if (value instanceof WrappedChatComponent) {
                return ((WrappedChatComponent)value).getHandle();
            }
        }
        return value;
    }

    public static Material getMaterial(String name) {
        try {
            if (!NmsVersion.v1_13.isSupported()) {
                Method toMinecraft = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getMaterialFromInternalName", String.class);
                Object instance = toMinecraft.getDeclaringClass().getField("INSTANCE").get(null);
                return (Material)toMinecraft.invoke(instance, name);
            }
            Object mcKey = ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(name);
            Object registry = ReflectionManager.getNmsField("IRegistry", NmsVersion.v1_17.isSupported() ? "Z" : "ITEM").get(null);
            Method getMethod = ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass("RegistryMaterials"), "get", mcKey.getClass());
            Object item = getMethod.invoke(registry, mcKey);
            if (item == null) {
                return null;
            }
            Method getMaterial = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getMaterial", ReflectionManager.getNmsClass("Item"));
            return (Material)getMaterial.invoke(null, item);
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().severe("Error when trying to convert '" + name + "' into a Material");
            ex.printStackTrace();
            if (ex.getCause() != null) {
                ex.getCause().printStackTrace();
            }
            return null;
        }
    }

    public static String getItemName(Material material) {
        try {
            Object item = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getItem", Material.class).invoke(null, material);
            if (item == null) {
                return null;
            }
            Object registry = NmsVersion.v1_13.isSupported() ? ReflectionManager.getNmsField("IRegistry", NmsVersion.v1_17.isSupported() ? "Z" : "ITEM").get(null) : ReflectionManager.getNmsField("Item", "REGISTRY").get(null);
            Method getMethod = ReflectionManager.getNmsMethod(registry.getClass(), NmsVersion.v1_13.isSupported() ? "getKey" : "b", Object.class);
            Object mcKey = getMethod.invoke(registry, item);
            if (mcKey == null) {
                return null;
            }
            return (String)ReflectionManager.getNmsMethod("MinecraftKey", "getKey", new Class[0]).invoke(mcKey, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getNmsVillagerData(VillagerData data) {
        Object type = ReflectionManager.getVillagerType(data.getType());
        Object profession = ReflectionManager.getVillagerProfession(data.getProfession());
        try {
            return villagerDataConstructor.newInstance(type, profession, data.getLevel());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getVillagerType(Villager.Type type) {
        try {
            Object mcKey = bukkitKeyToNms.invoke(null, type.getKey());
            return registryBlocksGetMethod.invoke(villagerTypeRegistry, mcKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isAssignableFrom(Class toCheck, Class checkAgainst) {
        if (!NmsVersion.v1_14.isSupported() && toCheck != checkAgainst && toCheck == OcelotWatcher.class) {
            toCheck = TameableWatcher.class;
        }
        return checkAgainst.isAssignableFrom(toCheck);
    }

    public static Class getSuperClass(Class cl) {
        if (cl == FlagWatcher.class) {
            return null;
        }
        if (!NmsVersion.v1_14.isSupported() && cl == OcelotWatcher.class) {
            return TameableWatcher.class;
        }
        return cl.getSuperclass();
    }

    public static Object getVillagerProfession(Villager.Profession profession) {
        try {
            Object mcKey = bukkitKeyToNms.invoke(null, profession.getKey());
            return registryBlocksGetMethod.invoke(villagerProfessionRegistry, mcKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMinecraftVersion() {
        String version = Bukkit.getVersion();
        version = version.substring(version.lastIndexOf(" ") + 1, version.length() - 1);
        return version;
    }

    public static WrappedDataWatcher.WrappedDataWatcherObject createDataWatcherObject(MetaIndex index, Object value) {
        if (value == null) {
            return null;
        }
        return new WrappedDataWatcher.WrappedDataWatcherObject(index.getIndex(), index.getSerializer());
    }

    public static Object createDataWatcherItem(MetaIndex id, Object value) {
        WrappedDataWatcher.WrappedDataWatcherObject watcherObject = ReflectionManager.createDataWatcherObject(id, value);
        try {
            return dataWatcherItemConstructor.newInstance(watcherObject.getHandle(), ReflectionManager.convertInvalidMeta(value));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static Object createSoundEffect(String minecraftKey) {
        try {
            return ReflectionManager.getNmsConstructor("SoundEffect", ReflectionManager.getNmsClass("MinecraftKey")).newInstance(ReflectionManager.createMinecraftKey(minecraftKey));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object createMinecraftKey(String name) {
        try {
            return ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getVec3D(Vector vector) {
        try {
            return vec3DConstructor.newInstance(vector.getX(), vector.getY(), vector.getZ());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getEntityType(EntityType entityType) {
        try {
            Object val = entityTypesAMethod.invoke(null, entityType.getName() == null ? entityType.name().toLowerCase(Locale.ENGLISH) : entityType.getName());
            if (NmsVersion.v1_14.isSupported()) {
                return ((Optional)val).orElse(null);
            }
            return val;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object registerEntityType(NamespacedKey key) {
        try {
            Object mcKey = ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(key.toString());
            Class typesClass = ReflectionManager.getNmsClass("IRegistry");
            Object registry = typesClass.getField(NmsVersion.v1_17.isSupported() ? "Y" : "ENTITY_TYPE").get(null);
            Constructor<?> c = ReflectionManager.getNmsClass("EntityTypes").getConstructors()[0];
            Object entityType = NmsVersion.v1_16.isSupported() ? c.newInstance(null, null, false, false, false, false, null, null, 0, 0) : c.newInstance(null, null, false, false, false, false, null);
            for (Field f : entityType.getClass().getDeclaredFields()) {
                if (f.getType() != String.class) continue;
                f.setAccessible(true);
                f.set(entityType, key.toString());
                break;
            }
            typesClass.getMethod("a", typesClass, mcKey.getClass(), Object.class).invoke(null, registry, mcKey, entityType);
            return entityType;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to find EntityType id for " + key);
        }
    }

    public static int getEntityTypeId(Object entityTypes) {
        try {
            Class typesClass = ReflectionManager.getNmsClass("IRegistry");
            Object registry = typesClass.getField(NmsVersion.v1_17.isSupported() ? "Y" : "ENTITY_TYPE").get(null);
            return (Integer)registry.getClass().getMethod(NmsVersion.v1_17.isSupported() ? "getId" : "a", Object.class).invoke(registry, entityTypes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Failed to find EntityType id for " + entityTypes);
        }
    }

    public static int getEntityTypeId(EntityType entityType) {
        try {
            if (NmsVersion.v1_13.isSupported()) {
                Object entityTypes = ReflectionManager.getEntityType(entityType);
                Class typesClass = ReflectionManager.getNmsClass("IRegistry");
                Object registry = typesClass.getField(NmsVersion.v1_17.isSupported() ? "Y" : "ENTITY_TYPE").get(null);
                return (Integer)registry.getClass().getMethod(NmsVersion.v1_17.isSupported() ? "getId" : "a", Object.class).invoke(registry, entityTypes);
            }
            return entityType.getTypeId();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Failed to find EntityType id for " + entityType);
        }
    }

    public static Object getEntityType(NamespacedKey name) {
        try {
            Class typesClass = ReflectionManager.getNmsClass("IRegistry");
            Object registry = typesClass.getField(NmsVersion.v1_17.isSupported() ? "Y" : "ENTITY_TYPE").get(null);
            Object mcKey = ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(name.toString());
            return registry.getClass().getMethod(NmsVersion.v1_17.isSupported() ? "getId" : "a", mcKey.getClass()).invoke(registry, mcKey);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("The entity " + name + " is not registered!");
        }
    }

    public static Object getNmsEntityPose(EntityPose entityPose) {
        return Enum.valueOf(entityPoseClass, entityPose == EntityPose.SNEAKING && NmsVersion.v1_15.isSupported() ? "CROUCHING" : entityPose.name());
    }

    public static EntityPose getEntityPose(Object nmsEntityPose) {
        String name = ((Enum)nmsEntityPose).name();
        return EntityPose.valueOf(name.equals("CROUCHING") ? "SNEAKING" : name);
    }

    public static WrappedWatchableObject createWatchable(MetaIndex index, Object obj) {
        Object watcherItem = ReflectionManager.createDataWatcherItem(index, obj);
        if (watcherItem == null) {
            return null;
        }
        return new WrappedWatchableObject(watcherItem);
    }

    public static int getCombinedIdByBlockData(BlockData data) {
        try {
            Object iBlockData = craftBlockDataGetState.invoke((Object)data, new Object[0]);
            return (Integer)ReflectionManager.getNmsMethod("Block", "getCombinedId", ReflectionManager.getNmsClass("IBlockData")).invoke(null, iBlockData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static int getCombinedIdByItemStack(ItemStack itemStack) {
        try {
            if (!NmsVersion.v1_13.isSupported()) {
                return itemStack.getType().ordinal() + (itemStack.getDurability() << 12);
            }
            Object nmsBlock = magicGetBlock.invoke(null, itemStack.getType());
            Object iBlockData = getBlockData.invoke(nmsBlock, new Object[0]);
            return (Integer)getBlockDataAsId.invoke(null, iBlockData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static BlockData getBlockDataByCombinedId(int id) {
        try {
            Method idMethod = ReflectionManager.getNmsMethod("Block", "getByCombinedId", Integer.TYPE);
            Object iBlockData = idMethod.invoke(null, id);
            Class iBlockClass = ReflectionManager.getNmsClass("IBlockData");
            return (BlockData)ReflectionManager.getCraftMethod("CraftBlockData", "fromData", iBlockClass).invoke(null, iBlockData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ItemStack getItemStackByCombinedId(int id) {
        try {
            Method idMethod = ReflectionManager.getNmsMethod("Block", "getByCombinedId", Integer.TYPE);
            Object iBlockData = idMethod.invoke(null, id);
            Class iBlockClass = ReflectionManager.getNmsClass("IBlockData");
            Method getBlock = ReflectionManager.getNmsMethod(NmsVersion.v1_16.isSupported() ? iBlockClass.getSuperclass() : iBlockClass, "getBlock", new Class[0]);
            Object block = getBlock.invoke(iBlockData, new Object[0]);
            if (NmsVersion.v1_13.isSupported()) {
                return new ItemStack((Material)magicGetMaterial.invoke(null, block));
            }
            Method getItem = ReflectionManager.getNmsMethod("Block", "u", iBlockClass);
            return ReflectionManager.getBukkitItem(getItem.invoke(block, iBlockData));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getWorldServer(World w) {
        try {
            return getNmsWorld.invoke((Object)w, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ItemMeta getDeserializedItemMeta(Map<String, Object> meta) {
        try {
            return (ItemMeta)deserializedItemMeta.invoke(null, meta);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Class<? extends FlagWatcher> getFlagWatcher(DisguiseType disguiseType) {
        Class watcherClass;
        try {
            switch (disguiseType) {
                case MARKER: {
                    watcherClass = FlagWatcher.class;
                    break;
                }
                case GLOW_ITEM_FRAME: {
                    watcherClass = ItemFrameWatcher.class;
                    break;
                }
                case ARROW: {
                    watcherClass = TippedArrowWatcher.class;
                    break;
                }
                case MODDED_LIVING: 
                case MODDED_MISC: {
                    watcherClass = ModdedWatcher.class;
                    break;
                }
                case COD: 
                case SALMON: {
                    watcherClass = FishWatcher.class;
                    break;
                }
                case SPECTRAL_ARROW: {
                    watcherClass = ArrowWatcher.class;
                    break;
                }
                case PRIMED_TNT: {
                    watcherClass = TNTWatcher.class;
                    break;
                }
                case MINECART_CHEST: 
                case MINECART_HOPPER: 
                case MINECART_MOB_SPAWNER: 
                case MINECART_TNT: {
                    watcherClass = MinecartWatcher.class;
                    break;
                }
                case SPIDER: 
                case CAVE_SPIDER: {
                    watcherClass = SpiderWatcher.class;
                    break;
                }
                case PIG_ZOMBIE: 
                case HUSK: 
                case DROWNED: 
                case ZOMBIFIED_PIGLIN: {
                    watcherClass = ZombieWatcher.class;
                    break;
                }
                case MAGMA_CUBE: {
                    watcherClass = SlimeWatcher.class;
                    break;
                }
                case ELDER_GUARDIAN: {
                    watcherClass = GuardianWatcher.class;
                    break;
                }
                case ILLUSIONER: 
                case EVOKER: {
                    watcherClass = IllagerWizardWatcher.class;
                    break;
                }
                case PUFFERFISH: {
                    watcherClass = PufferFishWatcher.class;
                    break;
                }
                default: {
                    watcherClass = Class.forName("me.libraryaddict.disguise.disguisetypes.watchers." + ReflectionManager.toReadable(disguiseType.name()) + "Watcher");
                    break;
                }
            }
        }
        catch (ClassNotFoundException ex) {
            Class entityClass = disguiseType.getEntityType().getEntityClass();
            if (entityClass != null) {
                watcherClass = Tameable.class.isAssignableFrom(entityClass) ? TameableWatcher.class : (Ageable.class.isAssignableFrom(entityClass) ? AgeableWatcher.class : (Creature.class.isAssignableFrom(entityClass) ? InsentientWatcher.class : (LivingEntity.class.isAssignableFrom(entityClass) ? LivingWatcher.class : (Fish.class.isAssignableFrom(entityClass) ? FishWatcher.class : FlagWatcher.class))));
            }
            watcherClass = FlagWatcher.class;
        }
        return watcherClass;
    }

    public static void registerValues() {
        for (DisguiseType disguiseType : DisguiseType.values()) {
            if (disguiseType.getEntityType() == null) continue;
            Class<? extends FlagWatcher> watcherClass = ReflectionManager.getFlagWatcher(disguiseType);
            if (watcherClass == null) {
                DisguiseUtilities.getLogger().severe("Error loading " + disguiseType.name() + ", FlagWatcher not assigned");
                continue;
            }
            if (LibsPremium.isPremium().booleanValue() && (LibsPremium.getPaidInformation() != null && LibsPremium.getPaidInformation().isPremium() && !LibsPremium.getPaidInformation().isLegit() || LibsPremium.getPluginInformation() != null && LibsPremium.getPluginInformation().isPremium() && !LibsPremium.getPluginInformation().isLegit())) {
                throw new IllegalStateException("Error while checking pi rate on startup! Please re-download the jar from SpigotMC before reporting this error!");
            }
            disguiseType.setWatcherClass(watcherClass);
            if (LibsDisguises.getInstance() == null || DisguiseValues.getDisguiseValues(disguiseType) != null) continue;
            ReflectionManager.createNMSValues(disguiseType);
        }
    }

    public static byte[] readFuzzyFully(InputStream input) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
        byte[] array = output.toByteArray();
        for (int i = 0; i < array.length; ++i) {
            array[i] = (byte)(127 - array[i]);
        }
        return array;
    }

    private static void createNMSValues(DisguiseType disguiseType) {
        String nmsEntityName = ReflectionManager.toReadable(disguiseType.name());
        Class nmsClass = ReflectionManager.getNmsClassIgnoreErrors("Entity" + nmsEntityName);
        if (nmsClass == null || Modifier.isAbstract(nmsClass.getModifiers())) {
            Object[] split = ReflectionManager.splitReadable(disguiseType.name());
            ArrayUtils.reverse((Object[])split);
            nmsEntityName = StringUtils.join((Object[])split);
            nmsClass = ReflectionManager.getNmsClassIgnoreErrors("Entity" + nmsEntityName);
            if (nmsClass == null || Modifier.isAbstract(nmsClass.getModifiers())) {
                nmsEntityName = null;
            }
        }
        if (nmsEntityName == null) {
            switch (disguiseType) {
                case AXOLOTL: {
                    nmsEntityName = "Axolotl";
                    break;
                }
                case GOAT: {
                    nmsEntityName = "Goat";
                    break;
                }
                case GLOW_ITEM_FRAME: {
                    nmsEntityName = "GlowItemFrame";
                    break;
                }
                case GLOW_SQUID: {
                    nmsEntityName = "GlowSquid";
                    break;
                }
                case MARKER: {
                    nmsEntityName = "Marker";
                    break;
                }
                case DONKEY: {
                    nmsEntityName = "HorseDonkey";
                    break;
                }
                case ARROW: {
                    nmsEntityName = "TippedArrow";
                    break;
                }
                case DROPPED_ITEM: {
                    nmsEntityName = "Item";
                    break;
                }
                case FIREBALL: {
                    nmsEntityName = "LargeFireball";
                    break;
                }
                case FIREWORK: {
                    nmsEntityName = "Fireworks";
                    break;
                }
                case GIANT: {
                    nmsEntityName = "GiantZombie";
                    break;
                }
                case HUSK: {
                    nmsEntityName = "ZombieHusk";
                    break;
                }
                case ILLUSIONER: {
                    nmsEntityName = "IllagerIllusioner";
                    break;
                }
                case LEASH_HITCH: {
                    nmsEntityName = "Leash";
                    break;
                }
                case MINECART: {
                    nmsEntityName = "MinecartRideable";
                    break;
                }
                case MINECART_COMMAND: {
                    nmsEntityName = "MinecartCommandBlock";
                    break;
                }
                case MINECART_TNT: {
                    nmsEntityName = "MinecartTNT";
                    break;
                }
                case MULE: {
                    nmsEntityName = "HorseMule";
                    break;
                }
                case PRIMED_TNT: {
                    nmsEntityName = "TNTPrimed";
                    break;
                }
                case PUFFERFISH: {
                    nmsEntityName = "PufferFish";
                    break;
                }
                case SPLASH_POTION: {
                    nmsEntityName = "Potion";
                    break;
                }
                case STRAY: {
                    nmsEntityName = "SkeletonStray";
                    break;
                }
                case TRIDENT: {
                    nmsEntityName = "ThrownTrident";
                    break;
                }
                case WANDERING_TRADER: {
                    nmsEntityName = "VillagerTrader";
                    break;
                }
                case TRADER_LLAMA: {
                    nmsEntityName = "LLamaTrader";
                    break;
                }
                case ZOMBIFIED_PIGLIN: {
                    nmsEntityName = "PigZombie";
                    break;
                }
            }
        }
        try {
            Float soundStrength;
            if (disguiseType == DisguiseType.UNKNOWN || disguiseType.isCustom()) {
                DisguiseValues disguiseValues = new DisguiseValues(disguiseType, 0.0);
                disguiseValues.setAdultBox(new FakeBoundingBox(0.0, 0.0, 0.0));
                SoundGroup sound = SoundGroup.getGroup(disguiseType.name());
                if (sound != null) {
                    sound.setDamageAndIdleSoundVolume(1.0f);
                }
                return;
            }
            if (nmsEntityName == null) {
                DisguiseUtilities.getLogger().warning("Entity name not found! (" + disguiseType.name() + ")");
                return;
            }
            Object nmsEntity = ReflectionManager.createEntityInstance(disguiseType, nmsEntityName);
            if (nmsEntity == null) {
                DisguiseUtilities.getLogger().warning("Entity not found! (" + nmsEntityName + ")");
                return;
            }
            disguiseType.setTypeId(ReflectionManager.getEntityTypeId(disguiseType.getEntityType()));
            Entity bukkitEntity = ReflectionManager.getBukkitEntity(nmsEntity);
            DisguiseValues disguiseValues = new DisguiseValues(disguiseType, bukkitEntity instanceof Damageable ? ((Damageable)bukkitEntity).getMaxHealth() : 0.0);
            WrappedDataWatcher watcher = WrappedDataWatcher.getEntityWatcher((Entity)bukkitEntity);
            ArrayList<MetaIndex> indexes = MetaIndex.getMetaIndexes(disguiseType.getWatcherClass());
            boolean loggedName = false;
            for (WrappedWatchableObject watch : watcher.getWatchableObjects()) {
                MetaIndex flagType = MetaIndex.getMetaIndex(disguiseType.getWatcherClass(), watch.getIndex());
                if (flagType == null) {
                    DisguiseUtilities.getLogger().severe("MetaIndex not found for " + (Object)((Object)disguiseType) + "! Index: " + watch.getIndex());
                    DisguiseUtilities.getLogger().severe("Value: " + watch.getRawValue() + " (" + watch.getRawValue().getClass() + ") (" + nmsEntity.getClass() + ") & " + disguiseType.getWatcherClass().getSimpleName());
                    continue;
                }
                indexes.remove(flagType);
                Object ourValue = ReflectionManager.convertInvalidMeta(flagType.getDefault());
                Object nmsValue = ReflectionManager.convertInvalidMeta(watch.getRawValue());
                if (ourValue.getClass() == nmsValue.getClass()) continue;
                if (!loggedName) {
                    DisguiseUtilities.getLogger().severe(StringUtils.repeat((String)"=", (int)20));
                    DisguiseUtilities.getLogger().severe("MetaIndex mismatch! Disguise " + (Object)((Object)disguiseType) + ", Entity " + nmsEntityName);
                    loggedName = true;
                }
                DisguiseUtilities.getLogger().severe(StringUtils.repeat((String)"-", (int)20));
                DisguiseUtilities.getLogger().severe("Index: " + watch.getIndex() + " | " + flagType.getFlagWatcher().getSimpleName() + " | " + MetaIndex.getName(flagType));
                Object flagDefault = flagType.getDefault();
                DisguiseUtilities.getLogger().severe("LibsDisguises: " + flagDefault + " (" + flagDefault.getClass() + ")");
                DisguiseUtilities.getLogger().severe("LibsDisguises Converted: " + ourValue + " (" + ourValue.getClass() + ")");
                DisguiseUtilities.getLogger().severe("Minecraft: " + watch.getRawValue() + " (" + watch.getRawValue().getClass() + ")");
                DisguiseUtilities.getLogger().severe("Minecraft Converted: " + nmsValue + " (" + nmsValue.getClass() + ")");
                DisguiseUtilities.getLogger().severe(StringUtils.repeat((String)"-", (int)20));
            }
            for (MetaIndex index : indexes) {
                DisguiseUtilities.getLogger().severe((Object)((Object)disguiseType) + " has MetaIndex remaining! " + index.getFlagWatcher().getSimpleName() + " at index " + index.getIndex());
            }
            SoundGroup sound = SoundGroup.getGroup(disguiseType.name());
            if (sound != null && (soundStrength = ReflectionManager.getSoundModifier(nmsEntity)) != null) {
                sound.setDamageAndIdleSoundVolume(soundStrength.floatValue());
            }
            disguiseValues.setAdultBox(ReflectionManager.getBoundingBox(bukkitEntity));
            if (bukkitEntity instanceof Ageable) {
                ((Ageable)bukkitEntity).setBaby();
                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
            } else if (bukkitEntity instanceof Zombie) {
                ((Zombie)bukkitEntity).setBaby(true);
                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
            } else if (bukkitEntity instanceof ArmorStand) {
                ((ArmorStand)bukkitEntity).setSmall(true);
                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
            }
        }
        catch (FieldAccessException | IllegalArgumentException | SecurityException ex) {
            DisguiseUtilities.getLogger().severe("Uh oh! Trouble while making values for the disguise " + disguiseType.name() + "!");
            DisguiseUtilities.getLogger().severe("Before reporting this error, please make sure you are using the latest version of LibsDisguises and ProtocolLib.");
            DisguiseUtilities.getLogger().severe("Development builds are available at (ProtocolLib) http://ci.dmulloy2.net/job/ProtocolLib/ and (LibsDisguises) https://ci.md-5.net/job/LibsDisguises/");
            ex.printStackTrace();
        }
    }

    public static void setScore(final Scoreboard scoreboard, final Object criteria, final String name, final int score) {
        if (!Bukkit.isPrimaryThread()) {
            new BukkitRunnable(){

                public void run() {
                    ReflectionManager.setScore(scoreboard, criteria, name, score);
                }
            }.runTask((Plugin)LibsDisguises.getInstance());
            return;
        }
        try {
            Object board = boardField.get(scoreboard);
            if (!NmsVersion.v1_13.isSupported()) {
                Collection scores = (Collection)getObjectives.invoke(board, criteria);
                for (Object obj : scores) {
                    setScore.invoke(getPlayerScoreObjective.invoke(board, name, obj), score);
                }
                return;
            }
            Consumer<Object> con = o -> {
                try {
                    setScore.invoke(o, score);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            };
            getObjectives.invoke(board, criteria, name, con);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Map<String, Command> getCommands(CommandMap map) {
        try {
            Field field = SimpleCommandMap.class.getDeclaredField("knownCommands");
            field.setAccessible(true);
            return (Map)field.get(map);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static SimpleCommandMap getCommandMap() {
        try {
            Field commandMap = SimplePluginManager.class.getDeclaredField("commandMap");
            commandMap.setAccessible(true);
            return (SimpleCommandMap)commandMap.get(Bukkit.getPluginManager());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String[] splitReadable(String string) {
        String[] split = string.split("_");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].charAt(0) + split[i].substring(1).toLowerCase(Locale.ENGLISH);
        }
        return split;
    }

    public static String toReadable(String string) {
        return ReflectionManager.toReadable(string, "");
    }

    public static String toReadable(String string, String joiner) {
        return StringUtils.join((Object[])ReflectionManager.splitReadable(string), (String)joiner);
    }

    static {
        classLocations = new HashMap();
    }
}

