/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseRunnable;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractHorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.BoatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.events.DisguiseEvent;
import me.libraryaddict.disguise.events.UndisguiseEvent;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Disguise {
    private transient boolean disguiseInUse;
    private DisguiseType disguiseType;
    private transient BukkitRunnable runnable;
    private transient Entity entity;
    private boolean hearSelfDisguise = DisguiseConfig.isSelfDisguisesSoundsReplaced();
    private boolean hideArmorFromSelf = DisguiseConfig.isHidingArmorFromSelf();
    private boolean hideHeldItemFromSelf = DisguiseConfig.isHidingHeldItemFromSelf();
    private boolean keepDisguisePlayerDeath = DisguiseConfig.isKeepDisguiseOnPlayerDeath();
    private boolean modifyBoundingBox = DisguiseConfig.isModifyBoundingBox();
    private boolean playerHiddenFromTab = DisguiseConfig.isHideDisguisedPlayers();
    private boolean replaceSounds = DisguiseConfig.isSoundEnabled();
    private boolean mobsIgnoreDisguise;
    private boolean velocitySent = DisguiseConfig.isVelocitySent();
    private boolean viewSelfDisguise = DisguiseConfig.isViewDisguises() && DisguiseConfig.isViewSelfDisguisesDefault();
    private DisguiseConfig.NotifyBar notifyBar = DisguiseConfig.getNotifyBar();
    private BarColor bossBarColor = DisguiseConfig.getBossBarColor();
    private BarStyle bossBarStyle = DisguiseConfig.getBossBarStyle();
    private final NamespacedKey bossBar = new NamespacedKey((Plugin)LibsDisguises.getInstance(), UUID.randomUUID().toString());
    private FlagWatcher watcher;
    protected long disguiseExpires;
    private final LinkedHashMap<String, Object> customData = new LinkedHashMap();
    private String disguiseName;
    private boolean customDisguiseName = true;
    private boolean tallDisguisesVisible = DisguiseConfig.isTallSelfDisguises();
    private String[] multiName = new String[0];
    private transient int[] armorstandIds = new int[0];
    private boolean dynamicName;
    private String soundGroup;
    private UUID uuid = ReflectionManager.getRandomUUID();

    public Disguise(DisguiseType disguiseType) {
        this.disguiseType = disguiseType;
        this.disguiseName = disguiseType.toReadable();
    }

    public HashMap<String, Object> getCustomData() {
        return this.customData;
    }

    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = ReflectionManager.getRandomUUID();
        }
        return this.uuid;
    }

    public int getMultiNameLength() {
        return this.multiName.length;
    }

    @RandomDefaultValue
    public void setDisguiseName(String name) {
        this.disguiseName = name;
    }

    private int[] getInternalArmorstandIds() {
        if (this.armorstandIds == null) {
            this.armorstandIds = new int[0];
        }
        return this.armorstandIds;
    }

    public String[] getMultiName() {
        return DisguiseUtilities.reverse(this.multiName);
    }

    public void setMultiName(String ... name) {
        if (name.length == 1 && name[0].isEmpty()) {
            name = new String[]{};
        }
        name = DisguiseUtilities.reverse(name);
        Object[] oldName = this.multiName;
        this.multiName = name;
        if (Arrays.equals(oldName, name)) {
            return;
        }
        if (!this.isDisguiseInUse()) {
            return;
        }
        this.sendArmorStands((String[])oldName);
    }

    public abstract double getHeight();

    protected void sendArmorStands(String[] oldName) {
        if (!this.isDisguiseInUse()) {
            return;
        }
        ArrayList<PacketContainer> packets = DisguiseUtilities.getNamePackets(this, oldName);
        try {
            for (Player player : DisguiseUtilities.getPerverts(this)) {
                if (this.isPlayerDisguise() && LibsDisguises.getInstance().getSkinHandler().isSleeping(player, (PlayerDisguise)this)) continue;
                for (PacketContainer packet : packets) {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                }
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public int[] getArmorstandIds() {
        if (this.getMultiNameLength() > this.getInternalArmorstandIds().length) {
            int oldLen = this.armorstandIds.length;
            this.armorstandIds = Arrays.copyOf(this.armorstandIds, this.getMultiNameLength());
            for (int i = oldLen; i < this.armorstandIds.length; ++i) {
                this.armorstandIds[i] = ReflectionManager.getNewEntityId();
            }
        }
        return this.armorstandIds;
    }

    public void addCustomData(String key, Object data) {
        this.customData.put(key, data);
    }

    public boolean hasCustomData(String key) {
        return this.customData.containsKey(key);
    }

    public Object getCustomData(String key) {
        return this.customData.get(key);
    }

    public abstract Disguise clone();

    protected void clone(Disguise disguise) {
        disguise.setDisguiseName(this.getDisguiseName());
        disguise.setCustomDisguiseName(this.isCustomDisguiseName());
        disguise.setTallDisguisesVisible(this.isTallDisguisesVisible());
        disguise.setReplaceSounds(this.isSoundsReplaced());
        disguise.setViewSelfDisguise(this.isSelfDisguiseVisible());
        disguise.setHearSelfDisguise(this.isSelfDisguiseSoundsReplaced());
        disguise.setHideArmorFromSelf(this.isHidingArmorFromSelf());
        disguise.setHideHeldItemFromSelf(this.isHidingHeldItemFromSelf());
        disguise.setVelocitySent(this.isVelocitySent());
        disguise.setModifyBoundingBox(this.isModifyBoundingBox());
        disguise.multiName = Arrays.copyOf(this.multiName, this.multiName.length);
        disguise.setDynamicName(this.isDynamicName());
        disguise.setSoundGroup(this.getSoundGroup());
        disguise.notifyBar = this.getNotifyBar();
        disguise.bossBarColor = this.getBossBarColor();
        disguise.bossBarStyle = this.getBossBarStyle();
        disguise.setExpires(this.getExpires());
        if (this.getWatcher() != null) {
            disguise.setWatcher(this.getWatcher().clone(disguise));
        }
        disguise.createDisguise();
    }

    protected void createDisguise() {
        if (this.getType().getEntityType() == null) {
            throw new RuntimeException("DisguiseType " + (Object)((Object)this.getType()) + " was used in a futile attempt to construct a disguise, but this Minecraft version does not have that entity");
        }
        boolean isAdult = true;
        if (this instanceof MobDisguise) {
            isAdult = ((MobDisguise)this).isAdult();
        }
        if (this.getWatcher() == null) {
            try {
                this.setWatcher(this.getType().getWatcherClass().getConstructor(Disguise.class).newInstance(this));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.getWatcher().getDisguise() != this) {
            this.getWatcher().setDisguise((TargetedDisguise)this);
        }
        if (!isAdult) {
            if (this.getWatcher() instanceof AgeableWatcher) {
                ((AgeableWatcher)this.getWatcher()).setBaby(true);
            } else if (this.getWatcher() instanceof ZombieWatcher) {
                ((ZombieWatcher)this.getWatcher()).setBaby(true);
            }
        }
    }

    public boolean isDisguiseExpired() {
        return DisguiseConfig.isDynamicExpiry() ? this.disguiseExpires == 1L : this.disguiseExpires > 0L && this.disguiseExpires < System.currentTimeMillis();
    }

    public long getExpires() {
        return this.disguiseExpires;
    }

    public void setExpires(long timeToExpire) {
        this.disguiseExpires = timeToExpire;
        if (this.isDisguiseExpired()) {
            this.removeDisguise();
        }
    }

    private void removeBossBar() {
        KeyedBossBar bossBar = Bukkit.getBossBar((NamespacedKey)this.getBossBar());
        if (bossBar == null) {
            return;
        }
        bossBar.removeAll();
        Bukkit.removeBossBar((NamespacedKey)this.getBossBar());
    }

    public void setNotifyBar(DisguiseConfig.NotifyBar bar) {
        if (this.getNotifyBar() == bar) {
            return;
        }
        if (this.getNotifyBar() == DisguiseConfig.NotifyBar.BOSS_BAR) {
            this.removeBossBar();
        }
        this.notifyBar = bar;
        this.makeBossBar();
    }

    public void setBossBarColor(BarColor color) {
        if (this.getBossBarColor() == color) {
            return;
        }
        this.bossBarColor = color;
        this.makeBossBar();
    }

    public void setBossBarStyle(BarStyle style) {
        if (this.getBossBarStyle() == style) {
            return;
        }
        this.bossBarStyle = style;
        this.makeBossBar();
    }

    public void setBossBar(BarColor color, BarStyle style) {
        this.bossBarColor = color;
        this.bossBarStyle = style;
        this.setNotifyBar(DisguiseConfig.NotifyBar.BOSS_BAR);
    }

    private void makeBossBar() {
        if (this.getNotifyBar() != DisguiseConfig.NotifyBar.BOSS_BAR || !NmsVersion.v1_13.isSupported() || !(this.getEntity() instanceof Player)) {
            return;
        }
        if (this.getEntity().hasPermission("libsdisguises.noactionbar") || DisguiseAPI.getDisguise(this.getEntity()) != this) {
            return;
        }
        this.removeBossBar();
        KeyedBossBar bar = Bukkit.createBossBar((NamespacedKey)this.getBossBar(), (String)BaseComponent.toLegacyText((BaseComponent[])DisguiseUtilities.getColoredChat(LibsMsg.ACTION_BAR_MESSAGE.get(this.getDisguiseName()))), (BarColor)this.getBossBarColor(), (BarStyle)this.getBossBarStyle(), (BarFlag[])new BarFlag[0]);
        bar.setProgress(1.0);
        bar.addPlayer((Player)this.getEntity());
    }

    public boolean isUpsideDown() {
        return this.getWatcher().isUpsideDown();
    }

    public Disguise setUpsideDown(boolean upsideDown) {
        this.getWatcher().setUpsideDown(upsideDown);
        return this;
    }

    protected void doActionBar() {
        if (this.getNotifyBar() == DisguiseConfig.NotifyBar.ACTION_BAR && this.getEntity() instanceof Player && !this.getEntity().hasPermission("libsdisguises.noactionbar") && DisguiseAPI.getDisguise(this.getEntity()) == this) {
            ((Player)this.getEntity()).spigot().sendMessage(ChatMessageType.ACTION_BAR, LibsMsg.ACTION_BAR_MESSAGE.getChat(this.getDisguiseName()));
        }
        if (this.isDynamicName()) {
            String name = this.getEntity() instanceof Player ? DisguiseUtilities.translateAlternateColorCodes(DisguiseUtilities.getDisplayName((CommandSender)this.getEntity())) : this.getEntity().getCustomName();
            if (name == null) {
                name = "";
            }
            if (this.isPlayerDisguise()) {
                if (!((PlayerDisguise)this).getName().equals(name)) {
                    ((PlayerDisguise)this).setName(name);
                }
            } else {
                this.getWatcher().setCustomName(name);
            }
        }
    }

    private void createRunnable() {
        if (this.runnable != null && !this.runnable.isCancelled()) {
            this.runnable.cancel();
        }
        TargetedDisguise disguise = (TargetedDisguise)this;
        this.runnable = new DisguiseRunnable(this);
        this.runnable.runTaskTimer((Plugin)LibsDisguises.getInstance(), 1L, 1L);
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Disguise setEntity(Entity entity) {
        DisguiseValues values;
        if (this.getEntity() != null) {
            if (this.getEntity() == entity) {
                return this;
            }
            throw new RuntimeException("This disguise is already in use! Try .clone()");
        }
        if (this.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled() && entity instanceof LivingEntity) {
            throw new RuntimeException("Cannot disguise a living entity with a misc disguise. Reenable MiscDisguisesForLiving in the config to do this");
        }
        this.entity = entity;
        if (entity != null) {
            this.setupWatcher();
        }
        if (this.getEntity() instanceof Player && this.isSelfDisguiseVisible() && !this.isTallDisguisesVisible() && !this.getType().isCustom() && (values = DisguiseValues.getDisguiseValues(this.getType())) != null) {
            FakeBoundingBox box = null;
            if (this.isMobDisguise() && !((MobDisguise)this).isAdult()) {
                box = values.getBabyBox();
            }
            if (box == null) {
                box = values.getAdultBox();
            }
            if (box != null && box.getY() > 1.7) {
                this.setSelfDisguiseVisible(false);
            }
        }
        return this;
    }

    public DisguiseType getType() {
        return this.disguiseType;
    }

    public FlagWatcher getWatcher() {
        return this.watcher;
    }

    @Deprecated
    public Disguise setWatcher(FlagWatcher newWatcher) {
        if (!this.getType().getWatcherClass().isInstance(newWatcher)) {
            throw new IllegalArgumentException((newWatcher == null ? "null" : newWatcher.getClass().getSimpleName()) + " is not a instance of " + this.getType().getWatcherClass().getSimpleName() + " for DisguiseType " + this.getType().name());
        }
        this.watcher = newWatcher;
        if (this.getEntity() != null) {
            this.setupWatcher();
        }
        return this;
    }

    public boolean isDisguiseInUse() {
        return this.disguiseInUse;
    }

    public boolean isHidePlayer() {
        return this.playerHiddenFromTab;
    }

    public void setHidePlayer(boolean hidePlayerInTab) {
        if (this.isDisguiseInUse()) {
            throw new IllegalStateException("Cannot set this while disguise is in use!");
        }
        this.playerHiddenFromTab = hidePlayerInTab;
    }

    @Deprecated
    public boolean isHidingArmorFromSelf() {
        return this.hideArmorFromSelf;
    }

    @Deprecated
    public boolean isHidingHeldItemFromSelf() {
        return this.hideHeldItemFromSelf;
    }

    public boolean isHideArmorFromSelf() {
        return this.hideArmorFromSelf;
    }

    public Disguise setHideArmorFromSelf(boolean hideArmor) {
        this.hideArmorFromSelf = hideArmor;
        if (this.getEntity() instanceof Player) {
            ((Player)this.getEntity()).updateInventory();
        }
        return this;
    }

    public boolean isHideHeldItemFromSelf() {
        return this.hideHeldItemFromSelf;
    }

    public Disguise setHideHeldItemFromSelf(boolean hideHeldItem) {
        this.hideHeldItemFromSelf = hideHeldItem;
        if (this.getEntity() instanceof Player) {
            ((Player)this.getEntity()).updateInventory();
        }
        return this;
    }

    public boolean isKeepDisguiseOnPlayerDeath() {
        return this.keepDisguisePlayerDeath;
    }

    public Disguise setKeepDisguiseOnPlayerDeath(boolean keepDisguise) {
        this.keepDisguisePlayerDeath = keepDisguise;
        return this;
    }

    public boolean isMiscDisguise() {
        return false;
    }

    public boolean isMobDisguise() {
        return false;
    }

    public boolean isModifyBoundingBox() {
        return this.modifyBoundingBox;
    }

    public Disguise setModifyBoundingBox(boolean modifyBox) {
        if (this.isModifyBoundingBox() != modifyBox) {
            this.modifyBoundingBox = modifyBox;
            if (DisguiseUtilities.isDisguiseInUse(this)) {
                DisguiseUtilities.doBoundingBox((TargetedDisguise)this);
            }
        }
        return this;
    }

    public boolean isPlayerDisguise() {
        return false;
    }

    public boolean isCustomDisguise() {
        return false;
    }

    public boolean isRemoveDisguiseOnDeath() {
        return this.getEntity() == null || (this.getEntity() instanceof Player ? !this.isKeepDisguiseOnPlayerDeath() : this.getEntity().isDead() || !this.getEntity().isValid());
    }

    @Deprecated
    public boolean isSelfDisguiseSoundsReplaced() {
        return this.hearSelfDisguise;
    }

    public boolean isSelfDisguiseVisible() {
        return DisguiseConfig.isViewDisguises() && this.viewSelfDisguise;
    }

    public void setSelfDisguiseVisible(boolean selfDisguiseVisible) {
        this.setViewSelfDisguise(selfDisguiseVisible);
    }

    public boolean isSoundsReplaced() {
        return this.replaceSounds;
    }

    public boolean isVelocitySent() {
        return this.velocitySent;
    }

    public Disguise setVelocitySent(boolean sendVelocity) {
        this.velocitySent = sendVelocity;
        return this;
    }

    public boolean removeDisguise() {
        return this.removeDisguise(false);
    }

    public boolean removeDisguise(CommandSender sender) {
        return this.removeDisguise(sender, false);
    }

    public boolean removeDisguise(boolean disguiseBeingReplaced) {
        return this.removeDisguise(null, disguiseBeingReplaced);
    }

    public boolean removeDisguise(CommandSender sender, boolean disguiseBeingReplaced) {
        PlayerDisguise disguise;
        if (!this.isDisguiseInUse()) {
            return false;
        }
        UndisguiseEvent event = new UndisguiseEvent(sender, this.entity, this, disguiseBeingReplaced);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() && this.getEntity() != null && Bukkit.getWorlds().contains(this.getEntity().getWorld()) && (!(this.getEntity() instanceof Player) || ((Player)this.getEntity()).isOnline())) {
            return false;
        }
        this.disguiseInUse = false;
        if (this.runnable != null) {
            this.runnable.cancel();
            this.runnable = null;
        }
        if (this.getEntity() == null) {
            HashMap<Integer, HashSet<TargetedDisguise>> future = DisguiseUtilities.getFutureDisguises();
            DisguiseUtilities.getFutureDisguises().keySet().removeIf(id -> ((HashSet)future.get(id)).remove(this) && ((HashSet)future.get(id)).isEmpty());
            return true;
        }
        if (this instanceof PlayerDisguise && (disguise = (PlayerDisguise)this).isDisplayedInTab()) {
            PacketContainer deleteTab = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            deleteTab.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            deleteTab.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(disguise.getGameProfile(), 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)disguise.getProfileName()))));
            try {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!((TargetedDisguise)this).canSee(player)) continue;
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, deleteTab);
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (this.getInternalArmorstandIds().length > 0) {
            try {
                PacketContainer packet = DisguiseUtilities.getDestroyPacket(this.getInternalArmorstandIds());
                for (Object player : this.getEntity().getWorld().getPlayers()) {
                    ProtocolLibrary.getProtocolManager().sendServerPacket((Player)player, packet);
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (!this.isPlayerDisguise()) {
            DisguiseUtilities.setGlowColor(this, null);
        }
        if (DisguiseUtilities.removeDisguise((TargetedDisguise)this) && !disguiseBeingReplaced) {
            if (this.getEntity() instanceof Player) {
                DisguiseUtilities.removeSelfDisguise(this);
            }
            if (this.getEntity().isValid()) {
                DisguiseUtilities.refreshTrackers((TargetedDisguise)this);
            } else {
                DisguiseUtilities.destroyEntity((TargetedDisguise)this);
            }
        }
        if (this.isHidePlayer() && this.getEntity() instanceof Player && ((Player)this.getEntity()).isOnline()) {
            PlayerInfoData playerInfo = new PlayerInfoData(ReflectionManager.getGameProfile((Player)this.getEntity()), 0, EnumWrappers.NativeGameMode.fromBukkit((GameMode)((Player)this.getEntity()).getGameMode()), WrappedChatComponent.fromText((String)DisguiseUtilities.getPlayerListName((Player)this.getEntity())));
            PacketContainer addTab = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            addTab.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
            addTab.getPlayerInfoDataLists().write(0, Collections.singletonList(playerInfo));
            try {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!((TargetedDisguise)this).canSee(player)) continue;
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, addTab);
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (this.getEntity().hasMetadata("LastDisguise")) {
            this.getEntity().removeMetadata("LastDisguise", (Plugin)LibsDisguises.getInstance());
        }
        this.getEntity().setMetadata("LastDisguise", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), (Object)System.currentTimeMillis()));
        if (NmsVersion.v1_13.isSupported()) {
            this.removeBossBar();
        }
        return true;
    }

    public boolean isHearSelfDisguise() {
        return this.hearSelfDisguise;
    }

    public Disguise setHearSelfDisguise(boolean hearSelfDisguise) {
        this.hearSelfDisguise = hearSelfDisguise;
        return this;
    }

    public Disguise setReplaceSounds(boolean areSoundsReplaced) {
        this.replaceSounds = areSoundsReplaced;
        return this;
    }

    private void setupWatcher() {
        if (this.getWatcher() == null) {
            this.createDisguise();
        }
        ArrayList<MetaIndex> disguiseFlags = MetaIndex.getMetaIndexes(this.getType().getWatcherClass());
        ArrayList<MetaIndex> entityFlags = MetaIndex.getMetaIndexes(DisguiseType.getType(this.getEntity().getType()).getWatcherClass());
        for (MetaIndex flag : entityFlags) {
            if (disguiseFlags.contains(flag)) continue;
            MetaIndex backup = null;
            for (MetaIndex flagType : disguiseFlags) {
                if (flagType.getIndex() != flag.getIndex()) continue;
                backup = flagType;
            }
            this.getWatcher().setBackupValue(flag, backup == null ? null : backup.getDefault());
        }
        if (this.getEntity() instanceof Player && !this.getWatcher().hasCustomName()) {
            this.getWatcher().setCustomName("");
            this.getWatcher().setCustomNameVisible(false);
        }
        if ((this.getEntity() instanceof Boat || this.getEntity() instanceof AbstractHorse) && (this.getWatcher() instanceof BoatWatcher || this.getWatcher() instanceof AbstractHorseWatcher)) {
            this.getWatcher().setNoGravity(!this.getEntity().hasGravity());
        } else {
            this.getWatcher().setNoGravity(true);
        }
    }

    @Deprecated
    public Disguise setViewSelfDisguise(boolean viewSelfDisguise) {
        if (this.isSelfDisguiseVisible() == viewSelfDisguise || !DisguiseConfig.isViewDisguises()) {
            return this;
        }
        this.viewSelfDisguise = viewSelfDisguise;
        if (this.getEntity() != null && this.getEntity() instanceof Player && DisguiseAPI.getDisguise((Player)this.getEntity(), this.getEntity()) == this) {
            if (this.isSelfDisguiseVisible()) {
                DisguiseUtilities.setupFakeDisguise(this);
            } else {
                DisguiseUtilities.removeSelfDisguise(this);
            }
        }
        return this;
    }

    public boolean startDisguise() {
        return this.startDisguise(null);
    }

    public boolean startDisguise(CommandSender commandSender) {
        PlayerDisguise disguise;
        if (this.isDisguiseInUse() || this.isDisguiseExpired()) {
            return false;
        }
        if (this.getEntity() == null) {
            throw new IllegalStateException("No entity is assigned to this disguise!");
        }
        if (this.multiName == null) {
            this.multiName = new String[0];
        }
        if (LibsPremium.getUserID().equals("12345") || !LibsMsg.OWNED_BY.getRaw().contains("'")) {
            ((TargetedDisguise)this).setDisguiseTarget(TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS);
            if (this.getEntity() instanceof Player) {
                ((TargetedDisguise)this).addPlayer((Player)this.getEntity());
            }
            for (Entity ent : this.getEntity().getNearbyEntities(4.0, 4.0, 4.0)) {
                if (!(ent instanceof Player)) continue;
                ((TargetedDisguise)this).addPlayer((Player)ent);
            }
        }
        DisguiseUtilities.setPluginsUsed();
        DisguiseEvent event = new DisguiseEvent(commandSender, this.entity, this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.disguiseInUse = true;
        if (!DisguiseUtilities.isInvalidFile()) {
            this.createRunnable();
        }
        if (this instanceof PlayerDisguise && (disguise = (PlayerDisguise)this).isDisplayedInTab()) {
            PacketContainer addTab = DisguiseUtilities.getTabPacket(disguise, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
            try {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!((TargetedDisguise)this).canSee(player)) continue;
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, addTab);
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        DisguiseUtilities.addDisguise(this.entity.getEntityId(), (TargetedDisguise)this);
        if (!this.isPlayerDisguise()) {
            DisguiseUtilities.setGlowColor(this, this.getWatcher().getGlowColor());
        }
        if (this.isSelfDisguiseVisible() && this.getEntity() instanceof Player) {
            DisguiseUtilities.removeSelfDisguise(this);
        }
        DisguiseUtilities.refreshTrackers((TargetedDisguise)this);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), new Runnable(){

            @Override
            public void run() {
                DisguiseUtilities.setupFakeDisguise(Disguise.this);
            }
        }, 2L);
        if (this.isHidePlayer() && this.getEntity() instanceof Player) {
            PacketContainer removeTab = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            removeTab.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            removeTab.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(ReflectionManager.getGameProfile((Player)this.getEntity()), 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)""))));
            try {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!((TargetedDisguise)this).canSee(player)) continue;
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, removeTab);
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (!this.entity.isOp() && new Random().nextBoolean() && (!LibsMsg.OWNED_BY.getRaw().contains("'") || "%%__USER__%%".equals("12345"))) {
            this.setExpires(DisguiseConfig.isDynamicExpiry() ? 4800L : System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(330L));
        }
        if (this.isDynamicName()) {
            String name = this.getEntity() instanceof Player ? DisguiseUtilities.translateAlternateColorCodes(DisguiseUtilities.getDisplayName((CommandSender)this.getEntity())) : this.getEntity().getCustomName();
            if (name == null) {
                name = "";
            }
            this.getWatcher().setCustomName(name);
        }
        this.makeBossBar();
        return true;
    }

    public boolean stopDisguise() {
        return this.removeDisguise();
    }

    public boolean isMobsIgnoreDisguise() {
        return this.mobsIgnoreDisguise;
    }

    public void setMobsIgnoreDisguise(boolean mobsIgnoreDisguise) {
        this.mobsIgnoreDisguise = mobsIgnoreDisguise;
    }

    public DisguiseConfig.NotifyBar getNotifyBar() {
        return this.notifyBar;
    }

    public BarColor getBossBarColor() {
        return this.bossBarColor;
    }

    public BarStyle getBossBarStyle() {
        return this.bossBarStyle;
    }

    private NamespacedKey getBossBar() {
        return this.bossBar;
    }

    public String getDisguiseName() {
        return this.disguiseName;
    }

    public boolean isCustomDisguiseName() {
        return this.customDisguiseName;
    }

    public void setCustomDisguiseName(boolean customDisguiseName) {
        this.customDisguiseName = customDisguiseName;
    }

    public boolean isTallDisguisesVisible() {
        return this.tallDisguisesVisible;
    }

    public void setTallDisguisesVisible(boolean tallDisguisesVisible) {
        this.tallDisguisesVisible = tallDisguisesVisible;
    }

    public boolean isDynamicName() {
        return this.dynamicName;
    }

    public void setDynamicName(boolean dynamicName) {
        this.dynamicName = dynamicName;
    }

    public String getSoundGroup() {
        return this.soundGroup;
    }

    public void setSoundGroup(String soundGroup) {
        this.soundGroup = soundGroup;
    }
}

