/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.interactions;

import java.util.ArrayList;
import java.util.Arrays;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsEntityInteract;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseModifyInteraction
implements LibsEntityInteract {
    private String[] options;

    @Override
    public void onInteract(Player p, Entity entity) {
        DisguisePerm disguisePerm;
        String entityName = entity instanceof Player ? entity.getName() : DisguiseType.getType(entity).toReadable();
        Disguise disguise = DisguiseAPI.getDisguise(p, entity);
        if (disguise == null) {
            LibsMsg.UNDISG_PLAYER_FAIL.send((CommandSender)p, entityName);
            return;
        }
        this.options = DisguiseParser.parsePlaceholders(this.options, (CommandSender)p, (CommandSender)entity);
        DisguisePermissions perms = DisguiseParser.getPermissions((CommandSender)p, "disguiseentitymodify");
        if (!perms.isAllowedDisguise(disguisePerm = new DisguisePerm(disguise.getType()), Arrays.asList(this.options))) {
            LibsMsg.DMODPLAYER_NOPERM.send((CommandSender)p, new Object[0]);
            return;
        }
        try {
            DisguiseParser.callMethods((CommandSender)p, disguise, perms, disguisePerm, new ArrayList<String>(Arrays.asList(this.options)), this.options, "DisguiseModifyEntity");
            LibsMsg.LISTENER_MODIFIED_DISG.send((CommandSender)p, new Object[0]);
        }
        catch (DisguiseParseException ex) {
            if (ex.getMessage() != null) {
                DisguiseUtilities.sendMessage((CommandSender)p, ex.getMessage());
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public DisguiseModifyInteraction(String[] options) {
        this.options = options;
    }
}

