/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.serializer;

import ld-shaded.net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.jetbrains.annotations.Contract;

public interface ComponentSerializer<I extends Component, O extends Component, R> {
    public @NonNull O deserialize(@NonNull R var1);

    @Contract(value="!null -> !null; null -> null", pure=true)
    default public @PolyNull O deseializeOrNull(@PolyNull R input) {
        return this.deserializeOr(input, null);
    }

    @Contract(value="!null, _ -> !null; null, _ -> param2", pure=true)
    default public @PolyNull O deserializeOr(@Nullable R input, @PolyNull O fallback) {
        if (input == null) {
            return fallback;
        }
        return this.deserialize(input);
    }

    public @NonNull R serialize(@NonNull I var1);

    @Contract(value="!null -> !null; null -> null", pure=true)
    default public @PolyNull R serializeOrNull(@PolyNull I component) {
        return this.serializeOr(component, null);
    }

    @Contract(value="!null, _ -> !null; null, _ -> param2", pure=true)
    default public @PolyNull R serializeOr(@Nullable I component, @PolyNull R fallback) {
        if (component == null) {
            return fallback;
        }
        return this.serialize(component);
    }
}

