/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.ComponentLike;
import ld-shaded.net.kyori.adventure.text.TextComponent;
import ld-shaded.net.kyori.adventure.text.minimessage.Context;
import ld-shaded.net.kyori.adventure.text.minimessage.MiniMessageImpl;
import ld-shaded.net.kyori.adventure.text.minimessage.ParseException;
import ld-shaded.net.kyori.adventure.text.minimessage.Template;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.MiniMessageLexer;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.Token;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.TokenType;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Inserting;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.InstantApplyTransformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.OneTimeTransformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.TransformationRegistry;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.PreTransformation;
import org.checkerframework.checker.nullness.qual.NonNull;

class MiniMessageParser {
    private static final String START = "start";
    private static final String TOKEN = "token";
    private static final String INNER = "inner";
    private static final String END = "end";
    private static final Pattern pattern = Pattern.compile("((?<start><)(?<token>[^<>]+(:(?<inner>['\"]?([^'\"](\\\\['\"])?)+['\"]?))*)(?<end>>))+?");
    private final TransformationRegistry registry;
    private final Function<String, ComponentLike> placeholderResolver;

    MiniMessageParser() {
        this.registry = new TransformationRegistry();
        this.placeholderResolver = MiniMessageImpl.DEFAULT_PLACEHOLDER_RESOLVER;
    }

    MiniMessageParser(TransformationRegistry registry, Function<String, ComponentLike> placeholderResolver) {
        this.registry = registry;
        this.placeholderResolver = placeholderResolver;
    }

    @NonNull String escapeTokens(@NonNull String richMessage) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = pattern.matcher(richMessage);
        int lastEnd = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex > lastEnd) {
                sb.append(richMessage, lastEnd, startIndex);
            }
            lastEnd = endIndex;
            String start = matcher.group(START);
            String token = matcher.group(TOKEN);
            String inner = matcher.group(INNER);
            String end = matcher.group(END);
            if (inner != null) {
                token = token.replace(inner, this.escapeTokens(inner));
            }
            sb.append("\\").append(start).append(token).append(end);
        }
        if (richMessage.length() > lastEnd) {
            sb.append(richMessage.substring(lastEnd));
        }
        return sb.toString();
    }

    @NonNull String stripTokens(@NonNull String richMessage) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = pattern.matcher(richMessage);
        int lastEnd = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex > lastEnd) {
                sb.append(richMessage, lastEnd, startIndex);
            }
            lastEnd = endIndex;
        }
        if (richMessage.length() > lastEnd) {
            sb.append(richMessage.substring(lastEnd));
        }
        return sb.toString();
    }

    @NonNull String sanitizePlaceholder(String input) {
        return input.replace("</pre>", "\\</pre>");
    }

    @NonNull String handlePlaceholders(@NonNull String richMessage, @NonNull Context context, String ... placeholders) {
        if (placeholders.length % 2 != 0) {
            throw new ParseException("Invalid number placeholders defined, usage: parseFormat(format, key, value, key, value...)");
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            richMessage = richMessage.replace("<" + placeholders[i] + ">", this.sanitizePlaceholder(placeholders[i + 1]));
        }
        context.replacedMessage(richMessage);
        return richMessage;
    }

    @NonNull String handlePlaceholders(@NonNull String richMessage, @NonNull Context context, @NonNull Map<String, String> placeholders) {
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            richMessage = richMessage.replace("<" + entry.getKey() + ">", entry.getValue());
        }
        context.replacedMessage(richMessage);
        return richMessage;
    }

    @NonNull Component parseFormat(@NonNull String richMessage, @NonNull Context context, String ... placeholders) {
        return this.parseFormat(this.handlePlaceholders(richMessage, context, placeholders), context);
    }

    @NonNull Component parseFormat(@NonNull String richMessage, @NonNull Map<String, String> placeholders, Context context) {
        return this.parseFormat(this.handlePlaceholders(richMessage, context, placeholders), context);
    }

    @NonNull Component parseFormat(@NonNull String input, Context context, Template ... placeholders) {
        HashMap<String, Template.ComponentTemplate> map = new HashMap<String, Template.ComponentTemplate>();
        for (Template placeholder : placeholders) {
            if (placeholder instanceof Template.StringTemplate) {
                Template.StringTemplate stringTemplate = (Template.StringTemplate)placeholder;
                input = input.replace("<" + stringTemplate.key() + ">", this.sanitizePlaceholder(stringTemplate.value()));
                continue;
            }
            if (!(placeholder instanceof Template.ComponentTemplate)) continue;
            Template.ComponentTemplate componentTemplate = (Template.ComponentTemplate)placeholder;
            map.put(componentTemplate.key(), componentTemplate);
        }
        return this.parseFormat0(input, map, context);
    }

    @NonNull Component parseFormat(@NonNull String input, @NonNull List<Template> placeholders, @NonNull Context context) {
        HashMap<String, Template.ComponentTemplate> map = new HashMap<String, Template.ComponentTemplate>();
        for (Template placeholder : placeholders) {
            if (placeholder instanceof Template.StringTemplate) {
                Template.StringTemplate stringTemplate = (Template.StringTemplate)placeholder;
                input = input.replace("<" + stringTemplate.key() + ">", stringTemplate.value());
                continue;
            }
            if (!(placeholder instanceof Template.ComponentTemplate)) continue;
            Template.ComponentTemplate componentTemplate = (Template.ComponentTemplate)placeholder;
            map.put(componentTemplate.key(), componentTemplate);
        }
        return this.parseFormat0(input, map, context);
    }

    @NonNull Component parseFormat(@NonNull String richMessage, @NonNull Context context) {
        return this.parseFormat0(richMessage, Collections.emptyMap(), context);
    }

    @NonNull Component parseFormat0(@NonNull String richMessage, @NonNull Map<String, Template.ComponentTemplate> templates, @NonNull Context context) {
        return this.parseFormat0(richMessage, templates, this.registry, this.placeholderResolver, context);
    }

    @NonNull Component parseFormat0(@NonNull String richMessage, @NonNull Map<String, Template.ComponentTemplate> templates, @NonNull TransformationRegistry registry, @NonNull Function<String, ComponentLike> placeholderResolver, Context context) {
        MiniMessageLexer lexer = new MiniMessageLexer(richMessage, context);
        try {
            lexer.scan();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        lexer.clean();
        List<Token> tokens = lexer.getTokens();
        context.tokens(tokens);
        return this.parse(tokens, registry, templates, placeholderResolver, context);
    }

    @NonNull Component parse(@NonNull List<Token> tokens, @NonNull TransformationRegistry registry, @NonNull Map<String, Template.ComponentTemplate> templates, @NonNull Function<String, ComponentLike> placeholderResolver, @NonNull Context context) {
        TextComponent parentBuild;
        TextComponent.Builder parent = Component.text();
        ArrayDeque<Transformation> transformations = new ArrayDeque<Transformation>();
        ArrayDeque<OneTimeTransformation> oneTimeTransformations = new ArrayDeque<OneTimeTransformation>();
        boolean preActive = false;
        int i = 0;
        block4: while (i < tokens.size()) {
            Token token = tokens.get(i);
            switch (token.type()) {
                case ESCAPED_OPEN_TAG_START: 
                case OPEN_TAG_START: {
                    String string;
                    Transformation transformation;
                    Object next;
                    ArrayList<Token> inners;
                    Object paramOrEnd;
                    Token name;
                    if (tokens.size() - 1 == i) {
                        if (context.isStrict()) {
                            throw new ParsingException("Expected name after open tag, but got nothing", -1);
                        }
                        tokens.set(i, new Token(TokenType.STRING, token.value()));
                        continue block4;
                    }
                    if ((name = tokens.get(++i)).type() == TokenType.OPEN_TAG_START && token.type() == TokenType.ESCAPED_OPEN_TAG_START) {
                        tokens.set(--i, new Token(TokenType.STRING, name.value()));
                        continue block4;
                    }
                    if (name.type() != TokenType.NAME && token.type() != TokenType.ESCAPED_OPEN_TAG_START) {
                        if (context.isStrict()) {
                            throw new ParsingException("Expected name after open tag, but got " + name, -1);
                        }
                        context.miniMessage().parsingErrorMessageConsumer().accept(Collections.singletonList("Expected name after open tag, but got " + name));
                        continue block4;
                    }
                    if (tokens.size() - 1 == i) {
                        if (context.isStrict()) {
                            throw new ParsingException("Expected param or end after open tag + name, but got nothing", -1);
                        }
                        context.miniMessage().parsingErrorMessageConsumer().accept(Collections.singletonList("Expected param or end after open tag + name, but got nothing"));
                        continue block4;
                    }
                    if (((Token)(paramOrEnd = tokens.get(++i))).type() == TokenType.PARAM_SEPARATOR) {
                        inners = new ArrayList<Token>();
                        next = null;
                        while (i < tokens.size() - 1 && ((Token)(next = tokens.get(++i))).type() != TokenType.TAG_END) {
                            inners.add((Token)next);
                        }
                        if (next == null) {
                            if (context.isStrict()) {
                                throw new ParsingException("Expected end sometimes after open tag + name, but got name = " + name + " and inners = " + inners, -1);
                            }
                            context.miniMessage().parsingErrorMessageConsumer().accept(Collections.singletonList("Expected end sometimes after open tag + name, but got name = " + name + " and inners = " + inners));
                            continue block4;
                        }
                        transformation = registry.get(name.value(), inners, templates, placeholderResolver, context);
                        if (transformation == null || preActive && !transformation.allowedInPre() || token.type() == TokenType.ESCAPED_OPEN_TAG_START) {
                            StringBuilder string2 = new StringBuilder(tokens.get(i -= 3 + inners.size()).value()).append(name.value()).append(((Token)paramOrEnd).value());
                            inners.forEach(t -> string2.append(t.value()));
                            string2.append(((Token)next).value());
                            tokens.set(i, new Token(TokenType.STRING, string2.toString()));
                            for (int c = 0; c < inners.size() + 3; ++c) {
                                tokens.remove(i + 1);
                            }
                            continue block4;
                        }
                        if (transformation instanceof InstantApplyTransformation) {
                            ((InstantApplyTransformation)transformation).applyInstant(parent, transformations);
                            break;
                        }
                        if (transformation instanceof OneTimeTransformation) {
                            oneTimeTransformations.addLast((OneTimeTransformation)transformation);
                            break;
                        }
                        if (transformation instanceof PreTransformation) {
                            preActive = true;
                        }
                        transformations.addLast(transformation);
                        break;
                    }
                    if (((Token)paramOrEnd).type() == TokenType.TAG_END || ((Token)paramOrEnd).type() == TokenType.ESCAPED_CLOSE_TAG_START) {
                        Transformation transformation2 = registry.get(name.value(), Collections.emptyList(), templates, placeholderResolver, context);
                        if (transformation2 == null || preActive && !transformation2.allowedInPre() || token.type() == TokenType.ESCAPED_OPEN_TAG_START) {
                            string = tokens.get(i -= 2).value() + name.value() + ((Token)paramOrEnd).value();
                            tokens.set(i, new Token(TokenType.STRING, string));
                            tokens.remove(i + 1);
                            tokens.remove(i + 1);
                            continue block4;
                        }
                        if (transformation2 instanceof InstantApplyTransformation) {
                            ((InstantApplyTransformation)transformation2).applyInstant(parent, transformations);
                            break;
                        }
                        if (transformation2 instanceof OneTimeTransformation) {
                            oneTimeTransformations.addLast((OneTimeTransformation)transformation2);
                            break;
                        }
                        if (transformation2 instanceof PreTransformation) {
                            preActive = true;
                        }
                        transformations.addLast(transformation2);
                        break;
                    }
                    if (context.isStrict()) {
                        throw new ParsingException("Expected tag end or param separator after tag name, but got " + paramOrEnd, -1);
                    }
                    context.miniMessage().parsingErrorMessageConsumer().accept(Collections.singletonList("Expected tag end or param separator after tag name, but got " + paramOrEnd));
                    continue block4;
                }
                case ESCAPED_CLOSE_TAG_START: 
                case CLOSE_TAG_START: {
                    String string;
                    Transformation transformation;
                    Object next;
                    ArrayList<Token> inners;
                    Object paramOrEnd;
                    Token name;
                    if (tokens.size() - 1 == i) {
                        if (context.isStrict()) {
                            throw new ParsingException("Expected name after open tag, but got nothing", -1);
                        }
                        tokens.set(i, new Token(TokenType.STRING, token.value()));
                        continue block4;
                    }
                    if ((name = tokens.get(++i)).type() != TokenType.NAME && token.type() != TokenType.ESCAPED_CLOSE_TAG_START) {
                        if (context.isStrict()) {
                            throw new ParsingException("Expected name after close tag start, but got " + name, -1);
                        }
                        context.miniMessage().parsingErrorMessageConsumer().accept(Collections.singletonList("Expected name after close tag start, but got " + name));
                        continue block4;
                    }
                    if (tokens.size() - 1 == i) {
                        if (context.isStrict()) {
                            throw new ParsingException("Expected param or end after open tag + name, but got nothing", -1);
                        }
                        context.miniMessage().parsingErrorMessageConsumer().accept(Collections.singletonList("Expected param or end after open tag + name, but got nothing"));
                        continue block4;
                    }
                    if (((Token)(paramOrEnd = tokens.get(++i))).type() == TokenType.TAG_END) {
                        if (!registry.exists(name.value()) || preActive && !name.value().equalsIgnoreCase("pre") || token.type() == TokenType.ESCAPED_CLOSE_TAG_START) {
                            String string3 = tokens.get(i -= 2).value() + name.value() + ((Token)paramOrEnd).value();
                            tokens.set(i, new Token(TokenType.STRING, string3));
                            tokens.remove(i + 1);
                            tokens.remove(i + 1);
                            continue block4;
                        }
                        Transformation removed = this.removeFirst(transformations, t -> t.name().equals(name.value()));
                        if (removed instanceof PreTransformation) {
                            preActive = false;
                            break;
                        }
                        if (removed != null || registry.couldBeOnetimeTransformation(name.value())) break;
                        string = tokens.get(i -= 2).value() + name.value() + ((Token)paramOrEnd).value();
                        tokens.set(i, new Token(TokenType.STRING, string));
                        tokens.remove(i + 1);
                        tokens.remove(i + 1);
                        --i;
                        break;
                    }
                    if (((Token)paramOrEnd).type() == TokenType.PARAM_SEPARATOR) {
                        inners = new ArrayList();
                        while (((Token)(next = tokens.get(++i))).type() != TokenType.TAG_END) {
                            inners.add((Token)next);
                        }
                        transformation = registry.get(name.value(), inners, templates, placeholderResolver, context);
                        transformations.removeFirstOccurrence(transformation);
                        break;
                    }
                    if (context.isStrict()) {
                        throw new ParsingException("Expected tag end or param separator after tag name, but got " + paramOrEnd, -1);
                    }
                    context.miniMessage().parsingErrorMessageConsumer().accept(Collections.singletonList("Expected tag end or param separator after tag name, but got " + paramOrEnd));
                    continue block4;
                }
                default: {
                    Transformation transformation;
                    Component current = Component.text(token.value());
                    Object next = transformations.iterator();
                    while (next.hasNext()) {
                        transformation = (Transformation)next.next();
                        current = transformation.apply(current, parent);
                    }
                    while (!oneTimeTransformations.isEmpty()) {
                        current = ((OneTimeTransformation)oneTimeTransformations.removeLast()).applyOneTime(current, parent, transformations);
                    }
                    if (current == null) break;
                    parent.append(current);
                }
            }
            ++i;
        }
        List<Component> children = parent.asComponent().children();
        TextComponent last = children.isEmpty() ? Component.empty() : children.get(children.size() - 1);
        for (Transformation transformation2 : transformations) {
            if (!(transformation2 instanceof Inserting)) continue;
            transformation2.apply(last, parent);
        }
        boolean didApplyOneTime = false;
        while (!oneTimeTransformations.isEmpty()) {
            didApplyOneTime = true;
            ((OneTimeTransformation)oneTimeTransformations.removeFirst()).applyOneTime(last, parent, transformations);
        }
        if (didApplyOneTime && !transformations.isEmpty()) {
            List<Component> newChildren = parent.asComponent().children();
            Component newLast = newChildren.isEmpty() ? Component.empty() : newChildren.get(newChildren.size() - 1);
            for (Transformation transformation : transformations) {
                newLast = transformation.apply(newLast, parent);
            }
            parentBuild = (TextComponent)parent.build();
            newChildren = new ArrayList<Component>(newChildren);
            newChildren.set(newChildren.size() - 1, newLast);
            parentBuild = (TextComponent)parentBuild.children(newChildren);
        } else {
            parentBuild = (TextComponent)parent.build();
        }
        if (parentBuild.content().equals("") && parentBuild.children().size() == 1) {
            return parentBuild.children().get(0);
        }
        return parentBuild;
    }

    private Transformation removeFirst(Deque<Transformation> transformations, Predicate<Transformation> filter) {
        Iterator<Transformation> each = transformations.descendingIterator();
        while (each.hasNext()) {
            Transformation next = each.next();
            if (!filter.test(next)) continue;
            each.remove();
            return next;
        }
        return null;
    }
}

