/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListenerEntityDestroy
extends PacketAdapter {
    public PacketListenerEntityDestroy(Plugin plugin) {
        super(plugin, new PacketType[]{PacketType.Play.Server.ENTITY_DESTROY});
    }

    public void onPacketSending(PacketEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!NmsVersion.v1_17.isSupported()) {
            this.onPre17Packet(event);
            return;
        }
        int[] toAdd = this.getToRemove(event.getPlayer(), (Integer)event.getPacket().getIntegers().read(0));
        if (toAdd == null) {
            return;
        }
        try {
            for (PacketContainer container : DisguiseUtilities.getDestroyPackets(toAdd)) {
                ProtocolLibrary.getProtocolManager().sendServerPacket(event.getPlayer(), container);
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private int[] getToRemove(Player player, int entityId) {
        if (entityId == DisguiseAPI.getSelfDisguiseId()) {
            return null;
        }
        Disguise disguise = DisguiseUtilities.getDisguise(player, entityId);
        if (disguise == null) {
            return null;
        }
        int len = disguise.getMultiNameLength();
        if (len == 0) {
            return null;
        }
        return disguise.getArmorstandIds();
    }

    public void onPre17Packet(PacketEvent event) {
        int[] entityIds;
        int[] newEntityIds = entityIds = (int[])event.getPacket().getIntegerArrays().read(0);
        for (int entityId : entityIds) {
            int[] toAdd = this.getToRemove(event.getPlayer(), entityId);
            if (toAdd == null) continue;
            newEntityIds = Arrays.copyOf(entityIds, entityIds.length + toAdd.length);
            for (int a = 0; a < toAdd.length; ++a) {
                newEntityIds[newEntityIds.length - (a + 1)] = toAdd[a];
            }
        }
        if (entityIds.length == newEntityIds.length) {
            return;
        }
        event.getPacket().getIntegerArrays().write(0, (Object)newEntityIds);
    }
}

