/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.modify;

import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseModifyCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Entity)) {
            LibsMsg.NO_CONSOLE.send(sender, new Object[0]);
            return true;
        }
        DisguisePermissions permissions = this.getPermissions(sender);
        if (!permissions.hasPermissions()) {
            LibsMsg.NO_PERM.send(sender, new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, permissions);
            return true;
        }
        Disguise disguise = DisguiseAPI.getDisguise((Player)sender, (Entity)sender);
        if (disguise == null) {
            LibsMsg.NOT_DISGUISED.send(sender, new Object[0]);
            return true;
        }
        DisguisePerm disguisePerm = new DisguisePerm(disguise.getType());
        if (!permissions.isAllowedDisguise(disguisePerm)) {
            LibsMsg.DMODIFY_NO_PERM.send(sender, new Object[0]);
            return true;
        }
        String[] options = DisguiseUtilities.split(StringUtils.join((Object[])args, (String)" "));
        options = DisguiseParser.parsePlaceholders(options, sender, sender);
        try {
            DisguiseParser.callMethods(sender, disguise, permissions, disguisePerm, new ArrayList<String>(), options, "DisguiseModify");
        }
        catch (DisguiseParseException ex) {
            if (ex.getMessage() != null) {
                DisguiseUtilities.sendMessage(sender, ex.getMessage());
            }
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return true;
        }
        LibsMsg.DMODIFY_MODIFIED.send(sender, new Object[0]);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Disguise disguise = DisguiseAPI.getDisguise((Player)sender, (Entity)sender);
        if (disguise == null) {
            return new ArrayList<String>();
        }
        String[] args = this.getPreviousArgs(origArgs);
        DisguisePermissions perms = this.getPermissions(sender);
        DisguisePerm disguiseType = new DisguisePerm(disguise.getType());
        List<String> tabs = this.getTabDisguiseOptions(sender, perms, disguiseType, args, 0, this.getCurrentArg(origArgs));
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, DisguisePermissions permissions) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(permissions);
        LibsMsg.DMODIFY_HELP3.send(sender, new Object[0]);
        LibsMsg.DMODIFY_HELP3.send(sender, new Object[0]);
        LibsMsg.DMODIFY_HELP3.send(sender, StringUtils.join(allowedDisguises, (String)LibsMsg.CAN_USE_DISGS_SEPERATOR.get(new Object[0])));
    }
}

