/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class LDJson
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Arrays.asList("json", "gson", "tostring", "item", "parse");
    }

    @Override
    public String getPermission() {
        return "libsdisguises.json";
    }

    @Override
    public void onCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            LibsMsg.NO_CONSOLE.send(sender, new Object[0]);
            return;
        }
        ItemStack item = ((Player)sender).getInventory().getItemInMainHand();
        String gson = DisguiseUtilities.getGson().toJson((Object)item);
        String simple = ParamInfoManager.toString(item);
        String itemName = ReflectionManager.getItemName(item.getType());
        ArrayList<String> mcArray = new ArrayList<String>();
        if (NmsVersion.v1_13.isSupported() && item.hasItemMeta()) {
            mcArray.add(itemName + DisguiseUtilities.serialize((NbtBase)NbtFactory.fromItemTag((ItemStack)item)));
        } else {
            mcArray.add(itemName);
        }
        if (item.getAmount() != 1) {
            mcArray.add(String.valueOf(item.getAmount()));
        }
        if (!NmsVersion.v1_13.isSupported()) {
            if (item.getDurability() != 0) {
                mcArray.add(String.valueOf(item.getDurability()));
            }
            if (item.hasItemMeta()) {
                mcArray.add(DisguiseUtilities.serialize((NbtBase)NbtFactory.fromItemTag((ItemStack)item)));
            }
        }
        String ldItem = StringUtils.join(mcArray, (String)"-");
        String mcItem = StringUtils.join(mcArray, (String)" ");
        this.sendMessage(sender, LibsMsg.ITEM_SERIALIZED, LibsMsg.ITEM_SERIALIZED_NO_COPY, gson);
        if (!(gson.equals(simple) || ldItem.equals(simple) || mcItem.equals(simple))) {
            this.sendMessage(sender, LibsMsg.ITEM_SIMPLE_STRING, LibsMsg.ITEM_SIMPLE_STRING_NO_COPY, simple);
        }
        this.sendMessage(sender, LibsMsg.ITEM_SERIALIZED_MC, LibsMsg.ITEM_SERIALIZED_MC_NO_COPY, mcItem);
        if (mcArray.size() > 1) {
            this.sendMessage(sender, LibsMsg.ITEM_SERIALIZED_MC, LibsMsg.ITEM_SERIALIZED_MC_NO_COPY, ldItem);
        }
    }

    private void sendMessage(CommandSender sender, LibsMsg prefix, LibsMsg oldVer, String string) {
        int start = 0;
        int msg = 1;
        ComponentBuilder builder = new ComponentBuilder("").append(TextComponent.fromLegacyText((String)prefix.get(new Object[0])));
        while (start < string.length()) {
            int end = Math.min(256, string.length() - start);
            String sub = string.substring(start, start + end);
            builder.append(" ");
            if (string.length() <= 256) {
                builder.append(TextComponent.fromLegacyText((String)LibsMsg.CLICK_TO_COPY_DATA.get(new Object[0])));
            } else {
                builder.reset();
                builder.append(TextComponent.fromLegacyText((String)LibsMsg.CLICK_COPY.get(msg)));
            }
            start += end;
            builder.event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, sub));
            builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(LibsMsg.CLICK_TO_COPY_HOVER.get(new Object[0]) + (string.length() <= 256 ? "" : " " + msg)).create()));
            ++msg;
        }
        sender.spigot().sendMessage(builder.create());
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission(this.getPermission());
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_JSON;
    }
}

