/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.ComponentLike;
import ld-shaded.net.kyori.adventure.text.minimessage.Context;
import ld-shaded.net.kyori.adventure.text.minimessage.MiniMessage;
import ld-shaded.net.kyori.adventure.text.minimessage.MiniMessageParser;
import ld-shaded.net.kyori.adventure.text.minimessage.MiniMessageSerializer;
import ld-shaded.net.kyori.adventure.text.minimessage.Template;
import ld-shaded.net.kyori.adventure.text.minimessage.markdown.MarkdownFlavor;
import ld-shaded.net.kyori.adventure.text.minimessage.markdown.MiniMarkdownParser;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.TransformationRegistry;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.TransformationType;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MiniMessageImpl
implements MiniMessage {
    static final Function<String, ComponentLike> DEFAULT_PLACEHOLDER_RESOLVER = s -> null;
    static final Consumer<List<String>> DEFAULT_ERROR_CONSUMER = message -> message.forEach(System.out::println);
    static final MiniMessage INSTANCE = new MiniMessageImpl(false, MarkdownFlavor.defaultFlavor(), new TransformationRegistry(), DEFAULT_PLACEHOLDER_RESOLVER, false, DEFAULT_ERROR_CONSUMER);
    static final MiniMessage MARKDOWN = new MiniMessageImpl(true, MarkdownFlavor.defaultFlavor(), new TransformationRegistry(), DEFAULT_PLACEHOLDER_RESOLVER, false, DEFAULT_ERROR_CONSUMER);
    private final boolean markdown;
    private final MarkdownFlavor markdownFlavor;
    private final MiniMessageParser parser;
    private final boolean strict;
    private final Consumer<List<String>> parsingErrorMessageConsumer;

    MiniMessageImpl(boolean markdown, @NonNull MarkdownFlavor markdownFlavor, @NonNull TransformationRegistry registry, @NonNull Function<String, ComponentLike> placeholderResolver, boolean strict, @NonNull Consumer<List<String>> parsingErrorMessageConsumer) {
        this.markdown = markdown;
        this.markdownFlavor = markdownFlavor;
        this.parser = new MiniMessageParser(registry, placeholderResolver);
        this.strict = strict;
        this.parsingErrorMessageConsumer = parsingErrorMessageConsumer;
    }

    @Override
    public @NonNull Component deserialize(@NonNull String input) {
        if (this.markdown) {
            input = MiniMarkdownParser.parse(input, this.markdownFlavor);
        }
        return this.parser.parseFormat(input, Context.of(this.strict, input, this));
    }

    @Override
    public @NonNull String serialize(@NonNull Component component) {
        return MiniMessageSerializer.serialize(component);
    }

    @Override
    public @NonNull Component parse(@NonNull String input, String ... placeholders) {
        if (this.markdown) {
            input = MiniMarkdownParser.parse(input, this.markdownFlavor);
        }
        return this.parser.parseFormat(input, Context.of(this.strict, input, this), placeholders);
    }

    @Override
    public @NonNull Component parse(@NonNull String input, @NonNull Map<String, String> placeholders) {
        if (this.markdown) {
            input = MiniMarkdownParser.parse(input, this.markdownFlavor);
        }
        return this.parser.parseFormat(input, placeholders, Context.of(this.strict, input, this));
    }

    @Override
    public @NonNull Component parse(@NonNull String input, Object ... placeholders) {
        ArrayList<Template> templates = new ArrayList<Template>();
        String key = null;
        for (int i = 0; i < placeholders.length; ++i) {
            Object object = placeholders[i];
            if (object instanceof Template) {
                templates.add((Template)object);
                continue;
            }
            if (key == null) {
                if (object instanceof String) {
                    key = (String)object;
                    continue;
                }
                throw new IllegalArgumentException("Argument " + i + " in placeholders is key, must be String, was " + object.getClass().getName());
            }
            if (object instanceof ComponentLike) {
                templates.add(Template.of(key, ((ComponentLike)object).asComponent()));
                key = null;
                continue;
            }
            if (object instanceof String) {
                templates.add(Template.of(key, (String)object));
                key = null;
                continue;
            }
            throw new IllegalArgumentException("Argument " + i + " in placeholders is a value, must be Component or String, was " + object.getClass().getName());
        }
        if (key != null) {
            throw new IllegalArgumentException("Found a key in placeholders that wasn't followed by a value: " + key);
        }
        return this.parse(input, templates);
    }

    @Override
    public @NonNull Component parse(@NonNull String input, Template ... placeholders) {
        if (this.markdown) {
            input = MiniMarkdownParser.parse(input, this.markdownFlavor);
        }
        return this.parser.parseFormat(input, Context.of(this.strict, input, this, placeholders), placeholders);
    }

    @Override
    public @NonNull Component parse(@NonNull String input, @NonNull List<Template> placeholders) {
        if (this.markdown) {
            input = MiniMarkdownParser.parse(input, this.markdownFlavor);
        }
        return this.parser.parseFormat(input, placeholders, Context.of(this.strict, input, this));
    }

    @Override
    public @NonNull String escapeTokens(@NonNull String input) {
        return this.parser.escapeTokens(input);
    }

    @Override
    public @NonNull String stripTokens(@NonNull String input) {
        if (this.markdown) {
            input = MiniMarkdownParser.stripMarkdown(input, this.markdownFlavor);
        }
        return this.parser.stripTokens(input);
    }

    public @NonNull Consumer<List<String>> parsingErrorMessageConsumer() {
        return this.parsingErrorMessageConsumer;
    }

    @Override
    public @NonNull MiniMessage.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    implements MiniMessage.Builder {
        private boolean markdown = false;
        private MarkdownFlavor markdownFlavor = MarkdownFlavor.defaultFlavor();
        private final TransformationRegistry registry = new TransformationRegistry();
        private Function<String, ComponentLike> placeholderResolver = DEFAULT_PLACEHOLDER_RESOLVER;
        private boolean strict = false;
        private Consumer<List<String>> parsingErrorMessageConsumer = DEFAULT_ERROR_CONSUMER;

        BuilderImpl() {
        }

        BuilderImpl(MiniMessageImpl serializer) {
            this.markdown = serializer.markdown;
        }

        @Override
        public @NonNull MiniMessage.Builder markdown() {
            this.markdown = true;
            return this;
        }

        @Override
        public @NonNull MiniMessage.Builder removeDefaultTransformations() {
            this.registry.clear();
            return this;
        }

        @Override
        public @NonNull MiniMessage.Builder transformation(TransformationType<? extends Transformation> type) {
            this.registry.register(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final @NonNull MiniMessage.Builder transformations(TransformationType<? extends Transformation> ... types) {
            for (TransformationType<? extends Transformation> type : types) {
                this.registry.register(type);
            }
            return this;
        }

        @Override
        public @NonNull MiniMessage.Builder markdownFlavor(MarkdownFlavor markdownFlavor) {
            this.markdownFlavor = markdownFlavor;
            return this;
        }

        @Override
        public @NonNull MiniMessage.Builder placeholderResolver(Function<String, ComponentLike> placeholderResolver) {
            this.placeholderResolver = placeholderResolver;
            return this;
        }

        @Override
        public @NonNull MiniMessage.Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        @Override
        public @NonNull MiniMessage.Builder parsingErrorMessageConsumer(Consumer<List<String>> consumer) {
            this.parsingErrorMessageConsumer = consumer;
            return this;
        }

        @Override
        public @NonNull MiniMessage build() {
            if (this.markdown) {
                return new MiniMessageImpl(true, this.markdownFlavor, this.registry, this.placeholderResolver, this.strict, this.parsingErrorMessageConsumer);
            }
            return new MiniMessageImpl(false, MarkdownFlavor.defaultFlavor(), this.registry, this.placeholderResolver, this.strict, this.parsingErrorMessageConsumer);
        }
    }
}

