/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.translations;

import java.util.ArrayList;
import java.util.Locale;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.parser.WatcherMethod;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class TranslateFiller {
    /*
     * WARNING - void declaration
     */
    public static void fillConfigs() {
        void var2_6;
        for (ParamInfo info : ParamInfoManager.getParamInfos()) {
            TranslateType.DISGUISE_OPTIONS_PARAMETERS.save(info.getRawName(), "A disguise option name, has description " + info.getDescription());
            if (!info.getRawName().equals(info.getRawDescriptiveName())) {
                TranslateType.DISGUISE_OPTIONS_PARAMETERS.save(info.getRawDescriptiveName(), "A disguise option descriptive name");
            }
            TranslateType.DISGUISE_OPTIONS_PARAMETERS.save(info.getRawDescription(), "Description for the disguise option " + info.getRawName());
            if (!info.canTranslateValues()) continue;
            for (String e : info.getValues().keySet()) {
                TranslateType.DISGUISE_OPTIONS_PARAMETERS.save(e, "Used for the disguise option " + info.getRawName());
            }
        }
        DisguiseType[] disguiseTypeArray = DisguiseType.values();
        int n = disguiseTypeArray.length;
        boolean bl = false;
        while (var2_6 < n) {
            DisguiseType type = disguiseTypeArray[var2_6];
            Object[] objectArray = type.name().split("_");
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = ((String)objectArray[i]).charAt(0) + ((String)objectArray[i]).substring(1).toLowerCase(Locale.ENGLISH);
            }
            TranslateType.DISGUISES.save(StringUtils.join((Object[])objectArray, (String)" "), "Name for the " + type.name() + " disguise");
            if (type.getEntityType() != null) {
                for (WatcherMethod method : ParamInfoManager.getDisguiseWatcherMethods(type.getWatcherClass())) {
                    Class para = method.getParam();
                    String className = method.getWatcherClass().getSimpleName().replace("Watcher", "");
                    if (className.equals("Flag") || className.equals("Disguise")) {
                        className = "Entity";
                    } else if (className.equals("Living")) {
                        className = "Living Entity";
                    } else if (className.equals("AbstractHorse")) {
                        className = "Horse";
                    } else if (className.equals("DroppedItem")) {
                        className = "Item";
                    } else if (className.equals("IllagerWizard")) {
                        className = "Illager";
                    }
                    TranslateType.DISGUISE_OPTIONS.save(method.getName(), "Found in the disguise options for " + className + " and uses " + (para.isArray() ? "multiple " : "a ") + para.getSimpleName().replace("[]", "s"));
                }
            }
            ++var2_6;
        }
        TranslateType.DISGUISE_OPTIONS.save("baby", "Used as a shortcut for setBaby when disguising an entity");
        TranslateType.DISGUISE_OPTIONS.save("adult", "Used as a shortcut for setBaby(false) when disguising an entity");
        ArrayList validClasses = new ArrayList();
        for (EntityType entityType : EntityType.values()) {
            for (Class c = entityType.getEntityClass(); c != null && Entity.class.isAssignableFrom(c) && !validClasses.contains(c); c = c.getSuperclass()) {
                validClasses.add(c);
            }
        }
        for (Class clazz : validClasses) {
            if (clazz == Entity.class || !Entity.class.isAssignableFrom(clazz) || clazz.getAnnotation(Deprecated.class) != null) continue;
            TranslateType.DISGUISES.save(clazz.getSimpleName(), "Name for the " + clazz.getSimpleName() + " EntityType, this is used in radius commands");
        }
        TranslateType.DISGUISES.save("EntityType", "Used for the disgiuse radius command to list all entitytypes");
        TranslateType.DISGUISES.save("DisgiseType", "Used for the disgiuse modify radius command to list all disguisetypes");
        for (LibsMsg libsMsg : LibsMsg.values()) {
            TranslateType.MESSAGES.save(libsMsg.getRaw(), "Reference: " + libsMsg.name());
        }
        for (TranslateType translateType : TranslateType.values()) {
            translateType.saveTranslations();
        }
    }
}

