/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;

public class LDMetaInfo
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Arrays.asList("metainfo", "metadata", "metadatainfo", "metaindex");
    }

    @Override
    public String getPermission() {
        return "libsdisguises.metainfo";
    }

    @Override
    public void onCommand(CommandSender sender, String[] args) {
        if (args.length > 1) {
            MetaIndex index = MetaIndex.getMetaIndexByName(args[1]);
            if (index == null) {
                LibsMsg.META_NOT_FOUND.send(sender, new Object[0]);
                return;
            }
            sender.sendMessage(index.toString());
        } else {
            ArrayList<String> names = new ArrayList<String>();
            for (MetaIndex index : MetaIndex.values()) {
                names.add(MetaIndex.getName(index));
            }
            names.sort(String::compareToIgnoreCase);
            ComponentBuilder builder = new ComponentBuilder("").append(TextComponent.fromLegacyText((String)LibsMsg.META_VALUES.get(new Object[0])));
            Iterator itel = names.iterator();
            while (itel.hasNext()) {
                String name = (String)itel.next();
                builder.append(TextComponent.fromLegacyText((String)name));
                builder.event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/libsdisguises metainfo " + name));
                builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)LibsMsg.META_CLICK_SHOW.get(name))));
                if (!itel.hasNext()) continue;
                builder.append(TextComponent.fromLegacyText((String)LibsMsg.META_VALUE_SEPERATOR.get(new Object[0])));
            }
            sender.spigot().sendMessage(builder.create());
        }
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission(this.getPermission());
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_METAINFO;
    }
}

