/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection.asm;

import com.google.gson.Gson;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.asm.Asm13;
import me.libraryaddict.disguise.utilities.reflection.asm.AsmDownloader;
import me.libraryaddict.disguise.utilities.reflection.asm.WatcherInfo;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPluginLoader;

public class WatcherSanitizer {
    public static void checkPreLoaded() throws NoSuchFieldException, IllegalAccessException {
        JavaPluginLoader javaLoader = (JavaPluginLoader)LibsDisguises.getInstance().getPluginLoader();
        Field lM = JavaPluginLoader.class.getDeclaredField("loaders");
        lM.setAccessible(true);
        List loaders = (List)lM.get(javaLoader);
        Field lF = WatcherSanitizer.class.getClassLoader().getClass().getDeclaredField("classes");
        lF.setAccessible(true);
        Field dF = WatcherSanitizer.class.getClassLoader().getClass().getDeclaredField("description");
        dF.setAccessible(true);
        for (Object loader : loaders) {
            Map lClasses = (Map)lF.get(loader);
            PluginDescriptionFile desc = (PluginDescriptionFile)dF.get(loader);
            if (!WatcherSanitizer.hasWatcher(lClasses)) continue;
            LibsDisguises.getInstance().getLogger().severe(desc.getFullName() + " has been a naughty plugin, they're declaring access to the disguise watchers before Lib's Disguises can properly load them! They should add 'LibsDisguises' to the 'depend' section of their plugin.yml!");
            break;
        }
        Field cM = JavaPluginLoader.class.getDeclaredField("classes");
        cM.setAccessible(true);
        Map classes = (Map)cM.get(javaLoader);
        if (WatcherSanitizer.hasWatcher(classes)) {
            LibsDisguises.getInstance().getLogger().severe("Somehow the main server has a Watcher instance! Hopefully there was a plugin mentioned above! This is a bug!");
        }
    }

    private static boolean hasWatcher(Map<String, Class<?>> classes) {
        for (Class<?> c : classes.values()) {
            if (!c.getName().startsWith("me.libraryaddict.disguise.disguisetypes.watchers.") && !c.getName().equals("me.libraryaddict.disguise.disguisetypes.FlagWatcher")) continue;
            return true;
        }
        return false;
    }

    public static void init() {
        try {
            WatcherSanitizer.checkPreLoaded();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        ArrayList mapped = new ArrayList();
        try (InputStream stream = LibsDisguises.getInstance().getResource("ANTI_PIRACY_ENCRYPTION");){
            new AsmDownloader();
            Asm13 asm = new Asm13();
            String[] lines = new String(ReflectionManager.readFully(stream), StandardCharsets.UTF_8).split("\n");
            LinkedHashMap toRemove = new LinkedHashMap();
            for (String s : lines) {
                WatcherInfo info = new WatcherInfo(s);
                if (info.isSupported()) continue;
                String path = "me.libraryaddict.disguise.disguisetypes." + (info.getWatcher().equals("FlagWatcher") ? "" : "watchers.") + info.getWatcher();
                toRemove.putIfAbsent(path, new ArrayList());
                ArrayList list = (ArrayList)toRemove.get(path);
                list.add(new AbstractMap.SimpleEntry<String, String>(info.getMethod(), info.getDescriptor()));
            }
            for (Map.Entry entry : toRemove.entrySet()) {
                asm.createClassWithoutMethods((String)entry.getKey(), (ArrayList)entry.getValue());
                mapped.add(entry.getKey());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            LibsDisguises.getInstance().getLogger().severe("Registered: " + new Gson().toJson(mapped));
        }
    }
}

