/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.modify;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseModifyRadiusCommand
extends DisguiseBaseCommand
implements TabCompleter {
    private Collection<Entity> getNearbyEntities(CommandSender sender, int radius) {
        Location center = sender instanceof Player ? ((Player)sender).getLocation() : ((BlockCommandSender)sender).getBlock().getLocation().add(0.5, 0.0, 0.5);
        return center.getWorld().getNearbyEntities(center, (double)radius, (double)radius, (double)radius);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender.getName().equals("CONSOLE")) {
            LibsMsg.NO_CONSOLE.send(sender, new Object[0]);
            return true;
        }
        DisguisePermissions permissions = this.getPermissions(sender);
        if (!permissions.hasPermissions()) {
            LibsMsg.NO_PERM.send(sender, new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, permissions);
            return true;
        }
        if (args[0].equalsIgnoreCase(TranslateType.DISGUISES.get("DisguiseType")) || args[0].equalsIgnoreCase(TranslateType.DISGUISES.get("DisguiseType") + "s")) {
            ArrayList<String> classes = new ArrayList<String>();
            for (DisguiseType type : DisguiseType.values()) {
                if (type.getEntityType() == null) continue;
                classes.add(type.toReadable());
            }
            Collections.sort(classes);
            LibsMsg.DMODRADIUS_USABLE.send(sender, ChatColor.GREEN + StringUtils.join(classes, (String)(ChatColor.DARK_GREEN + ", " + ChatColor.GREEN)));
            return true;
        }
        DisguiseType baseType = null;
        int starting = 0;
        if (!this.isInteger(args[0])) {
            for (DisguiseType t : DisguiseType.values()) {
                if (t.getEntityType() == null || !t.toReadable().replaceAll(" ", "").equalsIgnoreCase(args[0].replaceAll("_", ""))) continue;
                baseType = t;
                starting = 1;
                break;
            }
            if (baseType == null) {
                LibsMsg.DMODRADIUS_UNRECOGNIZED.send(sender, args[0]);
                return true;
            }
        }
        if (args.length == starting + 1) {
            if (starting == 0) {
                LibsMsg.DMODRADIUS_NEEDOPTIONS.send(sender, new Object[0]);
            } else {
                LibsMsg.DMODRADIUS_NEEDOPTIONS_ENTITY.send(sender, new Object[0]);
            }
            return true;
        }
        if (args.length < 2) {
            LibsMsg.DMODRADIUS_NEEDOPTIONS.send(sender, new Object[0]);
            return true;
        }
        if (!this.isInteger(args[starting])) {
            LibsMsg.NOT_NUMBER.send(sender, args[starting]);
            return true;
        }
        int radius = Integer.parseInt(args[starting]);
        if (radius > DisguiseConfig.getDisguiseRadiusMax()) {
            LibsMsg.LIMITED_RADIUS.send(sender, DisguiseConfig.getDisguiseRadiusMax());
            radius = DisguiseConfig.getDisguiseRadiusMax();
        }
        Object[] newArgs = new String[args.length - (starting + 1)];
        System.arraycopy(args, starting + 1, newArgs, 0, newArgs.length);
        if (newArgs.length == 0) {
            this.sendCommandUsage(sender, permissions);
            return true;
        }
        int modifiedDisguises = 0;
        int noPermission = 0;
        String[] disguiseArgs = DisguiseUtilities.split(StringUtils.join((Object[])newArgs, (String)" "));
        for (Entity entity : this.getNearbyEntities(sender, radius)) {
            Disguise disguise;
            if (entity == sender || baseType != null && !baseType.name().equalsIgnoreCase(entity.getType().name()) || (disguise = sender instanceof Player ? DisguiseAPI.getDisguise((Player)sender, entity) : DisguiseAPI.getDisguise(entity)) == null) continue;
            DisguisePerm disguisePerm = new DisguisePerm(disguise.getType());
            if (!permissions.isAllowedDisguise(disguisePerm)) {
                ++noPermission;
                continue;
            }
            String[] tempArgs = Arrays.copyOf(disguiseArgs, disguiseArgs.length);
            tempArgs = DisguiseParser.parsePlaceholders(tempArgs, sender, (CommandSender)entity);
            try {
                DisguiseParser.callMethods(sender, disguise, permissions, disguisePerm, new ArrayList<String>(), tempArgs, "DisguiseModifyRadius");
                ++modifiedDisguises;
            }
            catch (DisguiseParseException ex) {
                if (ex.getMessage() != null) {
                    DisguiseUtilities.sendMessage(sender, ex.getMessage());
                }
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return true;
            }
        }
        if (noPermission > 0) {
            LibsMsg.DMODRADIUS_NOPERM.send(sender, noPermission);
        }
        if (modifiedDisguises > 0) {
            LibsMsg.DMODRADIUS.send(sender, modifiedDisguises);
        } else {
            LibsMsg.DMODRADIUS_NOENTS.send(sender, new Object[0]);
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs = new ArrayList<String>();
        String[] args = this.getPreviousArgs(origArgs);
        DisguisePermissions perms = this.getPermissions(sender);
        if (args.length == 0) {
            for (DisguiseType type : DisguiseType.values()) {
                if (type.getEntityType() == null) continue;
                tabs.add(type.toReadable().replaceAll(" ", "_"));
            }
            return this.filterTabs(tabs, origArgs);
        }
        int starting = 0;
        if (!this.isInteger(args[0])) {
            for (DisguiseType t : DisguiseType.values()) {
                if (t.getEntityType() == null || !t.toReadable().replaceAll(" ", "").equalsIgnoreCase(args[0].replaceAll("_", ""))) continue;
                starting = 2;
                break;
            }
            if (starting == 1 || args.length == 1 || !this.isInteger(args[1])) {
                return this.filterTabs(tabs, origArgs);
            }
        }
        if (args.length <= starting || !this.isInteger(args[starting])) {
            return this.filterTabs(tabs, origArgs);
        }
        int radius = Integer.parseInt(args[starting]);
        if (radius > DisguiseConfig.getDisguiseRadiusMax()) {
            LibsMsg.LIMITED_RADIUS.send(sender, DisguiseConfig.getDisguiseRadiusMax());
            radius = DisguiseConfig.getDisguiseRadiusMax();
        }
        ++starting;
        ArrayList<String> usedOptions = new ArrayList<String>();
        for (Entity entity : this.getNearbyEntities(sender, radius)) {
            Disguise disguise = DisguiseAPI.getDisguise(entity);
            if (disguise == null) continue;
            DisguiseType disguiseType = disguise.getType();
            for (Method method : ParamInfoManager.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                for (String arg : args) {
                    if (!method.getName().equalsIgnoreCase(arg) || usedOptions.contains(arg)) continue;
                    usedOptions.add(arg);
                }
            }
            DisguisePerm perm = new DisguisePerm(disguiseType);
            if (!perms.isAllowedDisguise(perm, usedOptions)) continue;
            tabs.addAll(this.getTabDisguiseSubOptions(sender, perms, perm, args, starting, this.getCurrentArg(args)));
        }
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, DisguisePermissions permissions) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(permissions);
        LibsMsg.DMODRADIUS_HELP1.send(sender, DisguiseConfig.getDisguiseRadiusMax());
        LibsMsg.DMODIFY_HELP3.send(sender, StringUtils.join(allowedDisguises, (String)LibsMsg.CAN_USE_DISGS_SEPERATOR.get(new Object[0])));
        LibsMsg.DMODRADIUS_HELP2.send(sender, new Object[0]);
        LibsMsg.DMODRADIUS_HELP3.send(sender, new Object[0]);
    }
}

