/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params.types.custom;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;

public class ParamInfoBlockData
extends ParamInfo {
    private Material[] materials;

    public ParamInfoBlockData(Class paramClass, String name, String description, Material[] possibleValues) {
        super(paramClass, name, "BlockData[State=Something]", description);
        this.materials = (Material[])Arrays.stream(possibleValues).filter(m -> {
            switch (m) {
                case CHEST: 
                case TRAPPED_CHEST: {
                    return false;
                }
            }
            if (!m.isBlock()) {
                return false;
            }
            if (NmsVersion.v1_13.isSupported()) {
                return true;
            }
            switch (m) {
                case CAKE: 
                case FLOWER_POT: 
                case CAULDRON: 
                case BREWING_STAND: {
                    return false;
                }
            }
            return true;
        }).toArray(Material[]::new);
    }

    @Override
    protected Object fromString(String string) throws DisguiseParseException {
        if (string == null || string.equals("null")) {
            return null;
        }
        return Bukkit.createBlockData((String)string.toLowerCase());
    }

    @Override
    public String toString(Object object) {
        if (object == null) {
            return "null";
        }
        return ((BlockData)object).getAsString();
    }

    @Override
    public boolean isParam(Class paramClass) {
        return this.getParamClass().isAssignableFrom(paramClass);
    }

    @Override
    public Set<String> getEnums(String tabComplete) {
        String s = tabComplete.toLowerCase(Locale.ENGLISH);
        HashSet<String> returns = new HashSet<String>();
        if (s.matches("[a-z_:]+\\[.*")) {
            s = s.substring(0, s.indexOf("["));
        } else if (tabComplete.matches("[a-z:_]+")) {
            for (Material m : this.materials) {
                if (m.isLegacy() || !m.isBlock() || !m.name().toLowerCase(Locale.ENGLISH).startsWith(s) && !m.getKey().toString().startsWith(s)) continue;
                if (m.name().toLowerCase(Locale.ENGLISH).startsWith(s)) {
                    returns.add(m.name());
                    continue;
                }
                returns.add(m.getKey().toString());
            }
        } else {
            return returns;
        }
        return returns;
    }
}

