/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookup;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerDisguise
extends TargetedDisguise {
    private transient LibsProfileLookup currentLookup;
    private WrappedGameProfile gameProfile;
    private String playerName = "Herobrine";
    private String skinToUse;
    private boolean nameVisible = true;
    private boolean explicitNameVisible = false;
    private final UUID uuid = ReflectionManager.getRandomUUID();
    private transient DisguiseUtilities.DScoreTeam scoreboardName;
    private boolean deadmau5Ears;

    private PlayerDisguise() {
        super(DisguiseType.PLAYER);
    }

    public PlayerDisguise(Player player) {
        this(ReflectionManager.getGameProfile(player));
    }

    public PlayerDisguise(Player player, Player skinToUse) {
        this(ReflectionManager.getGameProfile(player), ReflectionManager.getGameProfile(skinToUse));
    }

    public PlayerDisguise(String name) {
        this(name, name);
    }

    public PlayerDisguise(String name, String skinToUse) {
        this();
        WrappedGameProfile profile;
        if (name.equals(skinToUse) && (profile = this.getProfile(skinToUse)) != null) {
            this.setName(profile.getName());
            this.setSkin(profile);
            this.createDisguise();
            return;
        }
        this.setName(name);
        this.setSkin(skinToUse);
        this.createDisguise();
    }

    public PlayerDisguise(WrappedGameProfile gameProfile) {
        this();
        this.setName(gameProfile.getName());
        this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.uuid, gameProfile.getName(), gameProfile);
        this.createDisguise();
    }

    public PlayerDisguise(WrappedGameProfile gameProfile, WrappedGameProfile skinToUse) {
        this();
        this.setName(gameProfile.getName());
        this.gameProfile = ReflectionManager.getGameProfile(this.uuid, gameProfile.getName());
        this.setSkin(skinToUse);
        this.createDisguise();
    }

    @Override
    public double getHeight() {
        if (this.getWatcher() == null) {
            return 1.8;
        }
        if (this.getEntity() == null || this.getWatcher().getModifiedEntityAnimations()[1]) {
            return this.getWatcher().isSneaking() ? 1.5 : 1.8;
        }
        return this.getEntity() instanceof Player && ((Player)this.getEntity()).isSneaking() ? 1.5 : 1.8;
    }

    @Deprecated
    public DisguiseUtilities.DScoreTeam getScoreboardName() {
        if (!DisguiseConfig.isScoreboardNames()) {
            throw new IllegalStateException("Cannot use this method when it's been disabled in config!");
        }
        if (this.scoreboardName == null) {
            this.scoreboardName = this.isUpsideDown() || this.isDeadmau5Ears() ? new DisguiseUtilities.DScoreTeam(this, new String[]{"", this.getProfileName(), ""}) : DisguiseUtilities.createExtendedName(this);
        }
        return this.scoreboardName;
    }

    private void setScoreboardName(String[] split) {
        if (this.isUpsideDown() || this.isDeadmau5Ears()) {
            return;
        }
        this.getScoreboardName().setSplit(split);
    }

    private boolean isStaticName(String name) {
        return name != null && (name.equalsIgnoreCase("Dinnerbone") || name.equalsIgnoreCase("Grumm"));
    }

    public boolean hasScoreboardName() {
        if (!DisguiseConfig.isArmorstandsName() && this.isStaticName(this.getName())) {
            return false;
        }
        return DisguiseConfig.isScoreboardNames();
    }

    public String getProfileName() {
        return this.isUpsideDown() ? "Dinnerbone" : (this.isDeadmau5Ears() ? "deadmau5" : (this.hasScoreboardName() ? this.getScoreboardName().getPlayer() : (this.getName().isEmpty() ? "\u00a7r" : this.getName())));
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isNameVisible() {
        return this.nameVisible;
    }

    public PlayerDisguise setNameVisible(boolean nameVisible) {
        return this.setNameVisible(nameVisible, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PlayerDisguise setNameVisible(boolean nameVisible, boolean setInternally) {
        if (this.isNameVisible() == nameVisible || setInternally && this.explicitNameVisible) {
            return this;
        }
        if (!setInternally) {
            this.explicitNameVisible = true;
        }
        if (this.isDisguiseInUse()) {
            if (DisguiseConfig.isArmorstandsName()) {
                this.nameVisible = nameVisible;
                this.sendArmorStands(this.isNameVisible() ? DisguiseUtilities.reverse(this.getMultiName()) : new String[]{});
                return this;
            } else {
                if (!DisguiseConfig.isScoreboardNames()) {
                    if (!this.stopDisguise()) throw new IllegalStateException("Unable to restart disguise");
                    this.nameVisible = nameVisible;
                    if (this.startDisguise()) return this;
                    throw new IllegalStateException("Unable to restart disguise");
                }
                this.nameVisible = nameVisible;
                DisguiseUtilities.updateExtendedName(this);
            }
            return this;
        } else {
            this.nameVisible = nameVisible;
        }
        return this;
    }

    @Override
    public PlayerDisguise addPlayer(Player player) {
        return (PlayerDisguise)super.addPlayer(player);
    }

    @Override
    public PlayerDisguise addPlayer(String playername) {
        return (PlayerDisguise)super.addPlayer(playername);
    }

    @Override
    public PlayerDisguise setUpsideDown(boolean upsideDown) {
        if (this.isUpsideDown() == upsideDown) {
            return this;
        }
        this.getWatcher().setInternalUpsideDown(upsideDown);
        if (this.isDisguiseInUse()) {
            this.resendDisguise(DisguiseConfig.isArmorstandsName() ? this.getName() : "Dinnerbone", true);
        } else {
            this.scoreboardName = null;
        }
        return this;
    }

    public PlayerDisguise setDeadmau5Ears(boolean deadmau5Ears) {
        if (deadmau5Ears == this.isDeadmau5Ears()) {
            return this;
        }
        this.deadmau5Ears = deadmau5Ears;
        if (this.isDisguiseInUse()) {
            this.resendDisguise(DisguiseConfig.isArmorstandsName() ? this.getName() : "deadmau5", true);
        } else {
            this.scoreboardName = null;
        }
        return this;
    }

    @Override
    public PlayerDisguise clone() {
        PlayerDisguise disguise = new PlayerDisguise();
        if (this.getWatcher() != null) {
            disguise.setWatcher(this.getWatcher().clone(disguise));
        }
        if (this.currentLookup == null && this.gameProfile != null) {
            disguise.skinToUse = this.getSkin();
            disguise.gameProfile = ReflectionManager.getGameProfileWithThisSkin(disguise.uuid, this.getGameProfile().getName(), this.getGameProfile());
        } else {
            disguise.setSkin(this.getSkin());
        }
        disguise.setName(this.getName());
        disguise.nameVisible = this.isNameVisible();
        disguise.explicitNameVisible = this.explicitNameVisible;
        disguise.setUpsideDown(this.isUpsideDown());
        disguise.setDeadmau5Ears(this.isDeadmau5Ears());
        this.clone(disguise);
        return disguise;
    }

    public WrappedGameProfile getGameProfile() {
        if (this.gameProfile == null) {
            this.gameProfile = this.getSkin() != null ? ReflectionManager.getGameProfile(this.uuid, this.getProfileName()) : ReflectionManager.getGameProfileWithThisSkin(this.uuid, this.getProfileName(), DisguiseUtilities.getProfileFromMojang(this));
        }
        return this.gameProfile;
    }

    public void setGameProfile(WrappedGameProfile gameProfile) {
        this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.uuid, gameProfile.getName(), gameProfile);
    }

    public String getName() {
        return this.playerName;
    }

    public void setName(String name) {
        int cLimit;
        if (this.getName().equals("<Inherit>") && this.getEntity() != null && ((name = this.getEntity().getCustomName()) == null || name.isEmpty())) {
            name = this.getEntity().getType().name();
        }
        if (DisguiseConfig.isCopyPlayerTeamInfo() && (DisguiseConfig.getPlayerNameType() == DisguiseConfig.PlayerNameType.TEAMS || DisguiseConfig.getPlayerNameType() == DisguiseConfig.PlayerNameType.ARMORSTANDS)) {
            name = DisguiseUtilities.getDisplayName(name);
        }
        if (name.equals(this.playerName)) {
            return;
        }
        switch (DisguiseConfig.getPlayerNameType()) {
            case TEAMS: {
                cLimit = (NmsVersion.v1_13.isSupported() ? 64 : 16) * 2;
                break;
            }
            case EXTENDED: {
                cLimit = (NmsVersion.v1_13.isSupported() ? 64 : 16) * 2 + 16;
                break;
            }
            case ARMORSTANDS: {
                cLimit = 256;
                break;
            }
            default: {
                cLimit = 16;
            }
        }
        if (name.length() > cLimit) {
            name = name.substring(0, cLimit);
        }
        if (this.isDisguiseInUse()) {
            if (DisguiseConfig.isArmorstandsName()) {
                this.playerName = name;
                this.setNameVisible(!name.isEmpty(), true);
                this.setMultiName(DisguiseUtilities.splitNewLine(name));
            } else {
                boolean resendDisguise = false;
                if (DisguiseConfig.isScoreboardNames() && !this.isStaticName(name)) {
                    DisguiseUtilities.DScoreTeam team = this.getScoreboardName();
                    String[] split = DisguiseUtilities.getExtendedNameSplit(team.getPlayer(), name);
                    resendDisguise = !split[1].equals(team.getPlayer());
                    this.setScoreboardName(split);
                }
                boolean bl = resendDisguise = !DisguiseConfig.isScoreboardNames() || this.isStaticName(name) || this.isStaticName(this.getName()) || resendDisguise;
                if (resendDisguise) {
                    this.resendDisguise(name, false);
                } else {
                    if (this.getName().isEmpty() && !name.isEmpty() && !this.isNameVisible()) {
                        this.setNameVisible(true, true);
                    } else if (!this.getName().isEmpty() && name.isEmpty() && this.isNameVisible()) {
                        this.setNameVisible(false, true);
                    } else {
                        DisguiseUtilities.updateExtendedName(this);
                    }
                    this.playerName = name;
                }
            }
            if (this.isDisplayedInTab()) {
                PacketContainer addTab = DisguiseUtilities.getTabPacket(this, EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME);
                try {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!this.canSee(player)) continue;
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, addTab);
                    }
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        } else {
            if (this.scoreboardName != null) {
                DisguiseUtilities.DScoreTeam team = this.getScoreboardName();
                String[] split = DisguiseUtilities.getExtendedNameSplit(team.getPlayer(), name);
                this.setScoreboardName(split);
            }
            if (DisguiseConfig.isArmorstandsName()) {
                this.setMultiName(DisguiseUtilities.splitNewLine(name));
            }
            this.setNameVisible(!name.isEmpty(), true);
            this.playerName = name;
            if (this.gameProfile != null) {
                this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.uuid, this.getProfileName(), this.getGameProfile());
            }
        }
    }

    private void resendDisguise(String name, boolean updateTeams) {
        if (this.stopDisguise()) {
            if (this.getName().isEmpty() && !name.isEmpty()) {
                this.setNameVisible(true, true);
            } else if (!this.getName().isEmpty() && name.isEmpty()) {
                this.setNameVisible(false, true);
            }
            this.playerName = name;
            if (updateTeams) {
                this.scoreboardName = null;
            }
            if (this.gameProfile != null) {
                this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.uuid, this.getProfileName(), this.getGameProfile());
            }
            if (!this.startDisguise()) {
                throw new IllegalStateException("Unable to restart disguise");
            }
        } else {
            throw new IllegalStateException("Unable to restart disguise");
        }
    }

    public String getSkin() {
        return this.skinToUse;
    }

    public PlayerDisguise setSkin(String newSkin) {
        String[] split;
        WrappedGameProfile profile = this.getProfile(newSkin);
        if (profile != null) {
            return this.setSkin(profile);
        }
        if (newSkin != null && (split = DisguiseUtilities.splitNewLine(newSkin)).length > 0) {
            newSkin = split[0];
        }
        if (newSkin != null && newSkin.length() > 16) {
            newSkin = null;
        }
        String oldSkin = this.skinToUse;
        this.skinToUse = newSkin;
        if (newSkin == null) {
            this.currentLookup = null;
            this.gameProfile = null;
        } else {
            if (newSkin.length() > 16) {
                this.skinToUse = newSkin.substring(0, 16);
            }
            if (newSkin.equals(oldSkin)) {
                return this;
            }
            if (this.isDisguiseInUse()) {
                this.currentLookup = new LibsProfileLookup(){

                    @Override
                    public void onLookup(WrappedGameProfile gameProfile) {
                        if (PlayerDisguise.this.currentLookup != this || gameProfile == null || gameProfile.getProperties().isEmpty()) {
                            return;
                        }
                        PlayerDisguise.this.setSkin(gameProfile);
                        PlayerDisguise.this.currentLookup = null;
                    }
                };
                WrappedGameProfile gameProfile = DisguiseUtilities.getProfileFromMojang(this.skinToUse, this.currentLookup, DisguiseConfig.isContactMojangServers());
                if (gameProfile != null) {
                    this.setSkin(gameProfile);
                }
            }
        }
        return this;
    }

    public PlayerDisguise setSkin(WrappedGameProfile gameProfile) {
        if (gameProfile == null) {
            this.gameProfile = null;
            this.skinToUse = null;
            return this;
        }
        this.currentLookup = null;
        this.skinToUse = gameProfile.getName();
        this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.uuid, this.getProfileName(), gameProfile);
        this.refreshDisguise();
        return this;
    }

    private WrappedGameProfile getProfile(String string) {
        if (string != null && string.length() > 70 && string.startsWith("{\"id\":") && string.endsWith("}") && string.contains(",\"name\":")) {
            try {
                return (WrappedGameProfile)DisguiseUtilities.getGson().fromJson(string, WrappedGameProfile.class);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Tried to parse " + string + " to a GameProfile, but it has been formatted incorrectly!");
            }
        }
        return null;
    }

    private void refreshDisguise() {
        if (!DisguiseUtilities.isDisguiseInUse(this)) {
            return;
        }
        if (this.isDisplayedInTab()) {
            PacketContainer addTab = DisguiseUtilities.getTabPacket(this, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
            PacketContainer deleteTab = addTab.shallowClone();
            deleteTab.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            try {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!this.canSee(player)) continue;
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, deleteTab);
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, addTab);
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        DisguiseUtilities.refreshTrackers(this);
    }

    @Override
    public PlayerWatcher getWatcher() {
        return (PlayerWatcher)super.getWatcher();
    }

    @Override
    public PlayerDisguise setWatcher(FlagWatcher newWatcher) {
        return (PlayerDisguise)super.setWatcher(newWatcher);
    }

    public boolean isDisplayedInTab() {
        return this.getWatcher().isDisplayedInTab();
    }

    public void setDisplayedInTab(boolean showPlayerInTab) {
        this.getWatcher().setDisplayedInTab(showPlayerInTab);
    }

    @Override
    public boolean isPlayerDisguise() {
        return true;
    }

    @Override
    public PlayerDisguise removePlayer(Player player) {
        return (PlayerDisguise)super.removePlayer(player);
    }

    @Override
    public PlayerDisguise removePlayer(String playername) {
        return (PlayerDisguise)super.removePlayer(playername);
    }

    @Override
    public PlayerDisguise setDisguiseTarget(TargetedDisguise.TargetType newTargetType) {
        return (PlayerDisguise)super.setDisguiseTarget(newTargetType);
    }

    @Override
    public PlayerDisguise setEntity(Entity entity) {
        return (PlayerDisguise)super.setEntity(entity);
    }

    @Override
    public PlayerDisguise setHearSelfDisguise(boolean hearSelfDisguise) {
        return (PlayerDisguise)super.setHearSelfDisguise(hearSelfDisguise);
    }

    @Override
    public PlayerDisguise setHideArmorFromSelf(boolean hideArmor) {
        return (PlayerDisguise)super.setHideArmorFromSelf(hideArmor);
    }

    @Override
    public PlayerDisguise setHideHeldItemFromSelf(boolean hideHeldItem) {
        return (PlayerDisguise)super.setHideHeldItemFromSelf(hideHeldItem);
    }

    @Override
    public PlayerDisguise setKeepDisguiseOnPlayerDeath(boolean keepDisguise) {
        return (PlayerDisguise)super.setKeepDisguiseOnPlayerDeath(keepDisguise);
    }

    @Override
    public PlayerDisguise setModifyBoundingBox(boolean modifyBox) {
        return (PlayerDisguise)super.setModifyBoundingBox(modifyBox);
    }

    @Override
    public PlayerDisguise setReplaceSounds(boolean areSoundsReplaced) {
        return (PlayerDisguise)super.setReplaceSounds(areSoundsReplaced);
    }

    @Override
    public boolean startDisguise() {
        String name;
        if (this.isDisguiseInUse()) {
            return false;
        }
        if (this.skinToUse != null && this.gameProfile == null) {
            this.currentLookup = new LibsProfileLookup(){

                @Override
                public void onLookup(WrappedGameProfile gameProfile) {
                    if (PlayerDisguise.this.currentLookup != this || gameProfile == null || gameProfile.getProperties().isEmpty()) {
                        return;
                    }
                    PlayerDisguise.this.setSkin(gameProfile);
                    PlayerDisguise.this.currentLookup = null;
                }
            };
            WrappedGameProfile gameProfile = DisguiseUtilities.getProfileFromMojang(this.skinToUse, this.currentLookup, DisguiseConfig.isContactMojangServers());
            if (gameProfile != null) {
                this.setSkin(gameProfile);
            }
        }
        if (this.isDynamicName()) {
            name = this.getEntity().getCustomName();
            if (name == null) {
                name = "";
            }
            if (!this.getName().equals(name)) {
                this.setName(name);
            }
        } else if (this.getName().equals("<Inherit>") && this.getEntity() != null) {
            name = this.getEntity().getCustomName();
            if (name == null || name.isEmpty()) {
                name = this.getEntity().getType().name();
            }
            this.setName(name);
        }
        boolean result = super.startDisguise();
        if (result && this.hasScoreboardName()) {
            DisguiseUtilities.registerExtendedName(this);
        }
        return result;
    }

    @Override
    public PlayerDisguise setVelocitySent(boolean sendVelocity) {
        return (PlayerDisguise)super.setVelocitySent(sendVelocity);
    }

    @Override
    public PlayerDisguise setViewSelfDisguise(boolean viewSelfDisguise) {
        return (PlayerDisguise)super.setViewSelfDisguise(viewSelfDisguise);
    }

    @Override
    public PlayerDisguise silentlyAddPlayer(String playername) {
        return (PlayerDisguise)super.silentlyAddPlayer(playername);
    }

    @Override
    public PlayerDisguise silentlyRemovePlayer(String playername) {
        return (PlayerDisguise)super.silentlyRemovePlayer(playername);
    }

    @Override
    public boolean removeDisguise(boolean disguiseBeingReplaced) {
        boolean result = super.removeDisguise(disguiseBeingReplaced);
        if (!result) {
            return result;
        }
        if (this.hasScoreboardName()) {
            if (disguiseBeingReplaced) {
                new BukkitRunnable(){

                    public void run() {
                        DisguiseUtilities.unregisterExtendedName(PlayerDisguise.this);
                    }
                }.runTaskLater((Plugin)LibsDisguises.getInstance(), 5L);
            } else {
                DisguiseUtilities.unregisterExtendedName(this);
            }
        }
        return result;
    }

    public boolean isDeadmau5Ears() {
        return this.deadmau5Ears;
    }
}

