/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.updates;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.updates.DisguiseUpdate;
import me.libraryaddict.disguise.utilities.updates.UpdateChecker;
import org.bukkit.ChatColor;

public class LDJenkins {
    private UpdateChecker updateChecker;

    private String[] getBadUsers() {
        try {
            HashMap map;
            URL url = new URL("https://api.github.com/repos/libraryaddict/libsdisguises/issues/469");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("User-Agent", "libraryaddict/LibsDisguises");
            con.setRequestProperty("Accept", "application/vnd.github.v3+json");
            try (InputStream input = con.getInputStream();){
                String json = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                map = (HashMap)new Gson().fromJson(json, HashMap.class);
            }
            if (!map.containsKey("body")) {
                return new String[0];
            }
            return ((String)map.get("body")).split("(\\r|\\n)+");
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    private Map<String, Object> fetchLastSnapshotBuild() {
        try {
            Map jsonObject;
            String[] users;
            for (String s : users = this.getBadUsers()) {
                if (LibsPremium.getPaidInformation() == null || !s.equals(LibsPremium.getPaidInformation().getDownloadID()) && !s.equals(LibsPremium.getPaidInformation().getUserID())) continue;
                LibsDisguises.getInstance().unregisterCommands(true);
            }
            DisguiseUtilities.getLogger().info("Now looking for update on Jenkins..");
            URL url = new URL("https://ci.md-5.net/job/LibsDisguises/api/json?tree=builds[changeSet[items[msg]],id,result]");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDefaultUseCaches(false);
            try (InputStream input = con.getInputStream();){
                String json = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                jsonObject = (Map)new Gson().fromJson(json, Map.class);
            }
            return jsonObject;
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Failed to check for a snapshot update on jenkins.");
            ex.printStackTrace();
            return null;
        }
    }

    public DisguiseUpdate getLatestSnapshot() {
        Map<String, Object> lastBuild = this.fetchLastSnapshotBuild();
        if (lastBuild == null || !lastBuild.containsKey("builds")) {
            return null;
        }
        ArrayList<String> changelog = new ArrayList<String>();
        String version = null;
        for (Map map : (List)lastBuild.get("builds")) {
            String result = (String)map.get("result");
            if ((result == null || result.equalsIgnoreCase("null")) && version == null) {
                DisguiseUtilities.getLogger().info("Jenkins build is pending.. Sleeping and checking again in 10 seconds");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return this.getLatestSnapshot();
            }
            Object items = ((Map)map.get("changeSet")).get("items");
            boolean release = false;
            if (items instanceof List) {
                for (Map item : (List)items) {
                    String msg = (String)item.get("msg");
                    if (msg == null) continue;
                    changelog.add("#" + map.get("id") + ": " + ChatColor.YELLOW + msg);
                    release = release || msg.toLowerCase(Locale.ENGLISH).matches("(re)?.?release.? .*");
                }
            }
            if (!"SUCCESS".equalsIgnoreCase(result)) continue;
            if (version == null) {
                version = (String)map.get("id");
            }
            if (!release) continue;
            break;
        }
        if (changelog.isEmpty()) {
            return null;
        }
        return new JenkinsUpdate(version, changelog.toArray(new String[0]));
    }

    private class JenkinsUpdate
    implements DisguiseUpdate {
        private final Date fetched = new Date();
        private final String version;
        private final String[] changelog;

        @Override
        public String getDownload() {
            return "https://ci.md-5.net/job/LibsDisguises/" + this.getVersion() + "/artifact/target/LibsDisguises.jar";
        }

        @Override
        public boolean isReleaseBuild() {
            return false;
        }

        public JenkinsUpdate(String version, String[] changelog) {
            this.version = version;
            this.changelog = changelog;
        }

        @Override
        public Date getFetched() {
            return this.fetched;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String[] getChangelog() {
            return this.changelog;
        }
    }
}

