/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.sounds;

import java.util.Arrays;
import java.util.LinkedHashMap;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.apache.commons.lang.math.RandomUtils;
import org.bukkit.Sound;

public class SoundGroup {
    private static final LinkedHashMap<String, SoundGroup> groups = new LinkedHashMap();
    private float damageSoundVolume = 1.0f;
    private final LinkedHashMap<Object, SoundType> disguiseSoundTypes = new LinkedHashMap();
    private final LinkedHashMap<SoundType, Object[]> disguiseSounds = new LinkedHashMap();
    private boolean customSounds;

    public SoundGroup(String name) {
        groups.put(name, this);
        try {
            DisguiseType.valueOf(name);
        }
        catch (Exception ex) {
            this.customSounds = true;
        }
    }

    public void addSound(Object sound, SoundType type) {
        Object origSound = sound;
        if (sound instanceof Sound) {
            sound = ReflectionManager.getCraftSound((Sound)sound);
        } else if (sound instanceof String) {
            sound = ReflectionManager.createMinecraftKey((String)sound);
        } else if (!sound.getClass().getSimpleName().equals("SoundEffect")) {
            throw new IllegalArgumentException("Unexpected " + sound.getClass());
        }
        if (sound == null) {
            return;
        }
        this.disguiseSoundTypes.putIfAbsent(sound, type);
        if (this.disguiseSounds.containsKey((Object)type)) {
            Object[] array = this.disguiseSounds.get((Object)type);
            array = Arrays.copyOf(array, array.length + 1);
            array[array.length - 1] = sound;
            this.disguiseSounds.put(type, array);
        } else {
            this.disguiseSounds.put(type, new Object[]{sound});
        }
    }

    public float getDamageAndIdleSoundVolume() {
        return this.damageSoundVolume;
    }

    public void setDamageAndIdleSoundVolume(float strength) {
        this.damageSoundVolume = strength;
    }

    public Object getSound(SoundType type) {
        if (type == null) {
            return null;
        }
        if (this.customSounds) {
            return this.getRandomSound(type);
        }
        Object[] sounds = this.disguiseSounds.get((Object)type);
        if (sounds == null) {
            return null;
        }
        return sounds[0];
    }

    private Object getRandomSound(SoundType type) {
        if (type == null) {
            return null;
        }
        Object[] sounds = this.disguiseSounds.get((Object)type);
        if (sounds == null) {
            return null;
        }
        return sounds[RandomUtils.nextInt((int)sounds.length)];
    }

    public SoundType getSound(Object sound) {
        if (sound == null) {
            return null;
        }
        return this.disguiseSoundTypes.get(sound);
    }

    public SoundType getType(Object sound, boolean ignoreDamage) {
        if (sound == null) {
            return SoundType.CANCEL;
        }
        SoundType soundType = this.getSound(sound);
        if (soundType == SoundType.DEATH || ignoreDamage && soundType == SoundType.HURT) {
            return null;
        }
        return soundType;
    }

    public boolean isCancelSound(String sound) {
        return this.getSound(sound) == SoundType.CANCEL;
    }

    public static SoundGroup getGroup(Disguise disguise) {
        SoundGroup dSoundGroup;
        if (disguise.getSoundGroup() != null && (dSoundGroup = SoundGroup.getGroup(disguise.getSoundGroup())) != null) {
            return dSoundGroup;
        }
        return SoundGroup.getGroup(disguise.getType().name());
    }

    public static SoundGroup getGroup(String name) {
        return groups.get(name);
    }

    public static LinkedHashMap<String, SoundGroup> getGroups() {
        return groups;
    }

    public LinkedHashMap<Object, SoundType> getDisguiseSoundTypes() {
        return this.disguiseSoundTypes;
    }

    public LinkedHashMap<SoundType, Object[]> getDisguiseSounds() {
        return this.disguiseSounds;
    }

    public static enum SoundType {
        CANCEL,
        DEATH,
        HURT,
        IDLE,
        STEP;

    }
}

