/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.parser;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.ModdedDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.modded.ModdedEntity;
import me.libraryaddict.disguise.utilities.modded.ModdedManager;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemBlock;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.potion.PotionEffectType;

public class DisguiseParser {
    private static HashMap<Method, Map.Entry<Method, Object>> defaultWatcherValues = new HashMap();

    public static void createDefaultMethods() {
        try {
            for (DisguiseType type : DisguiseType.values()) {
                Method[] methods;
                TargetedDisguise disguise;
                if (type.getEntityType() == null) continue;
                if (type.isMisc()) {
                    disguise = new MiscDisguise(type);
                } else if (type.isMob()) {
                    disguise = new MobDisguise(type);
                } else {
                    if (!type.isPlayer()) continue;
                    disguise = new PlayerDisguise("Foobar");
                }
                FlagWatcher watcher = type.getWatcherClass().getConstructor(Disguise.class).newInstance(disguise);
                for (Method setMethod : methods = ParamInfoManager.getDisguiseWatcherMethods(watcher.getClass())) {
                    if (setMethod.getName().equals("addPotionEffect") || setMethod.getName().equals("setSkin") && setMethod.getParameterTypes()[0] == String.class || setMethod.getName().equals("setTarget") && setMethod.getParameterTypes()[0] != Integer.TYPE || setMethod.getName().equals("setItemInMainHand") && setMethod.getParameterTypes()[0] == Material.class || setMethod.getName().matches("setArmor") && setMethod.getParameterTypes()[0] == ItemStack[].class) continue;
                    String getName = setMethod.getName().substring(3);
                    getName = getName.equals("HasNectar") ? "hasNectar" : (getName.equals("HasStung") ? "hasStung" : (setMethod.getParameterTypes()[0].isAssignableFrom(Boolean.TYPE) ? "is" + getName : "get" + getName));
                    Method getMethod = setMethod.getDeclaringClass().getMethod(getName, new Class[0]);
                    if (getMethod == null) {
                        DisguiseUtilities.getLogger().severe(String.format("No such method '%s' when looking for the companion of '%s' in '%s'", getName, setMethod.getName(), setMethod.getDeclaringClass().getSimpleName()));
                        continue;
                    }
                    if (getMethod.getReturnType() != setMethod.getParameterTypes()[0]) {
                        DisguiseUtilities.getLogger().severe(String.format("Invalid return type of '%s' when looking for the companion of '%s' in '%s'", getName, setMethod.getName(), setMethod.getDeclaringClass().getSimpleName()));
                        continue;
                    }
                    Object defaultValue = null;
                    if (!setMethod.isAnnotationPresent(RandomDefaultValue.class)) {
                        Object invokeWith = watcher;
                        if (!FlagWatcher.class.isAssignableFrom(getMethod.getDeclaringClass())) {
                            invokeWith = disguise;
                        }
                        defaultValue = getMethod.invoke(invokeWith, new Object[0]);
                    }
                    DisguiseParser.addWatcherDefault(setMethod, getMethod, defaultValue);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static HashMap<Method, Map.Entry<Method, Object>> getMethodDefaults() {
        return defaultWatcherValues;
    }

    public static String parseToString(Disguise disguise) {
        return DisguiseParser.parseToString(disguise, true);
    }

    public static String parseToString(Disguise disguise, boolean outputSkinData) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(disguise.getType().name());
            if (disguise.isPlayerDisguise()) {
                stringBuilder.append(" ").append(DisguiseUtilities.quote(((PlayerDisguise)disguise).getName()));
            }
            Method[] methods = ParamInfoManager.getDisguiseWatcherMethods(disguise.getType().getWatcherClass());
            for (int i = methods.length - 1; i >= 0; --i) {
                String valueString;
                Map.Entry<Method, Object> entry;
                Method m = methods[i];
                if (m.getName().equals("addPotionEffect")) {
                    PotionEffectType[] types;
                    for (PotionEffectType type : types = (PotionEffectType[])m.getDeclaringClass().getMethod("getPotionEffects", new Class[0]).invoke((Object)disguise.getWatcher(), new Object[0])) {
                        if (type == null) continue;
                        stringBuilder.append(" ").append(m.getName()).append(" ").append(type.getName());
                    }
                    continue;
                }
                if (m.getName().equals("setNoGravity") || (entry = defaultWatcherValues.get(m)) == null) continue;
                Object invokeWith = m.getDeclaringClass().isInstance(disguise) ? disguise : disguise.getWatcher();
                Object ourValue = entry.getKey().invoke(invokeWith, new Object[0]);
                if ("".equals(ourValue) && m.getName().equals("setCustomName")) {
                    ourValue = null;
                }
                if (m.getName().equals("setSkin") && !outputSkinData) {
                    PlayerDisguise pDisg = (PlayerDisguise)disguise;
                    ourValue = pDisg.getName();
                    if (pDisg.getSkin() != null) {
                        ourValue = pDisg.getSkin();
                    } else if (pDisg.getGameProfile() != null && pDisg.getGameProfile().getName() != null) {
                        ourValue = pDisg.getGameProfile().getName();
                    }
                    if (ourValue.equals(pDisg.getName())) {
                        continue;
                    }
                } else if (!m.isAnnotationPresent(RandomDefaultValue.class) && Objects.deepEquals(entry.getValue(), ourValue)) continue;
                stringBuilder.append(" ").append(m.getName());
                if (ourValue instanceof Boolean && ((Boolean)ourValue).booleanValue()) continue;
                if (ourValue != null) {
                    valueString = ParamInfoManager.getParamInfo(ourValue.getClass()).toString(ourValue);
                    valueString = DisguiseUtilities.quote(valueString);
                } else {
                    valueString = "null";
                }
                stringBuilder.append(" ").append(valueString);
            }
            return stringBuilder.toString();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void addWatcherDefault(Method setMethod, Method getMethod, Object object) {
        if (defaultWatcherValues.containsKey(setMethod)) {
            Object dObj = defaultWatcherValues.get(setMethod).getValue();
            if (!Objects.deepEquals(dObj, object)) {
                throw new IllegalStateException(String.format("%s has conflicting values in class %s! This means it expected the same value again but received a different value on a different disguise! %s is not the same as %s!", setMethod.getName(), setMethod.getDeclaringClass().getName(), object, dObj));
            }
            return;
        }
        AbstractMap.SimpleEntry<Method, Object> entry = new AbstractMap.SimpleEntry<Method, Object>(getMethod, object);
        defaultWatcherValues.put(setMethod, entry);
    }

    private static void doCheck(CommandSender sender, DisguisePermissions permissions, DisguisePerm disguisePerm, Collection<String> usedOptions) throws DisguiseParseException {
        if (!permissions.isAllowedDisguise(disguisePerm, usedOptions)) {
            throw new DisguiseParseException(LibsMsg.D_PARSE_NOPERM, usedOptions.stream().reduce((first, second) -> second).orElse(null));
        }
    }

    private static HashMap<String, HashMap<String, Boolean>> getDisguiseOptions(CommandSender sender, String permNode, DisguisePerm type) {
        HashMap<String, HashMap<String, Boolean>> returns = new HashMap<String, HashMap<String, Boolean>>();
        for (PermissionAttachmentInfo permission : sender.getEffectivePermissions()) {
            String[] split;
            String lowerPerm = permission.getPermission().toLowerCase(Locale.ENGLISH);
            if (!lowerPerm.startsWith("libsdisguises.options.") || (split = lowerPerm.split("\\.")).length < 4 || !split[2].equalsIgnoreCase(permNode) && !split[2].equalsIgnoreCase("*")) continue;
            boolean applicable = false;
            for (String s : split[3].split("/")) {
                if (!s.equals("*") && !s.replace("_", "").equalsIgnoreCase(type.toReadable().replace(" ", ""))) continue;
                applicable = true;
                break;
            }
            if (!applicable) continue;
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            for (int i = 5; i < split.length; ++i) {
                options.put(split[i], permission.getValue());
            }
            for (String s : split[4].split("/")) {
                if (returns.containsKey(s)) {
                    returns.get(s).putAll(options);
                    continue;
                }
                returns.put(s, options);
            }
        }
        return returns;
    }

    public static DisguisePerm getDisguisePerm(String name) {
        for (DisguisePerm perm : DisguiseParser.getDisguisePerms()) {
            if (!perm.toReadable().replaceAll("[ |_]", "").equalsIgnoreCase(name.replaceAll("[ |_]", ""))) continue;
            return perm;
        }
        if (name.equalsIgnoreCase("p")) {
            return DisguiseParser.getDisguisePerm(DisguiseType.PLAYER.toReadable());
        }
        return null;
    }

    public static DisguisePerm[] getDisguisePerms() {
        ArrayList<DisguisePerm> perms = new ArrayList<DisguisePerm>();
        for (DisguiseType disguiseType : DisguiseType.values()) {
            if (disguiseType.getEntityType() == null || disguiseType.isCustom()) continue;
            perms.add(new DisguisePerm(disguiseType));
        }
        for (Map.Entry entry : DisguiseConfig.getCustomDisguises().entrySet()) {
            perms.add((DisguisePerm)entry.getKey());
        }
        perms.addAll(ModdedManager.getDisguiseTypes());
        return perms.toArray(new DisguisePerm[0]);
    }

    public static DisguisePermissions getPermissions(CommandSender sender, String commandName) {
        return new DisguisePermissions((Permissible)sender, commandName);
    }

    private static boolean isDouble(String string) {
        try {
            Float.parseFloat(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean hasPermissionOption(HashMap<String, HashMap<String, Boolean>> disguiseOptions, String method, String value) {
        if (!disguiseOptions.containsKey(method = method.toLowerCase(Locale.ENGLISH))) {
            return true;
        }
        HashMap<String, Boolean> map = disguiseOptions.get(method);
        if (map.containsKey(value = value.toLowerCase(Locale.ENGLISH))) {
            return map.get(value);
        }
        return !map.containsValue(true);
    }

    public static String getName(CommandSender entity) {
        if (entity == null) {
            return "??";
        }
        if (entity instanceof Player) {
            return entity.getName();
        }
        if (entity instanceof Entity && ((Entity)entity).getCustomName() != null && ((Entity)entity).getCustomName().length() > 0) {
            return ((Entity)entity).getCustomName();
        }
        return entity.getName();
    }

    private static String getSkin(CommandSender entity) {
        WrappedGameProfile gameProfile;
        if (entity == null) {
            return "??";
        }
        if (entity instanceof Player && (gameProfile = ReflectionManager.getGameProfile((Player)entity)) != null) {
            return DisguiseUtilities.getGson().toJson((Object)gameProfile);
        }
        return "{}";
    }

    public static String[] parsePlaceholders(String[] args, CommandSender user, CommandSender target) {
        return DisguiseParser.parsePlaceholders(args, DisguiseParser.getName(user), DisguiseUtilities.getDisplayName(user), DisguiseParser.getSkin(user), DisguiseParser.getName(target), DisguiseUtilities.getDisplayName(target), DisguiseParser.getSkin(target), DisguiseParser.getEntityEquipment(user), DisguiseParser.getEntityEquipment(target));
    }

    private static EntityEquipment getEntityEquipment(CommandSender entity) {
        return entity instanceof LivingEntity ? ((LivingEntity)entity).getEquipment() : null;
    }

    public static String[] parsePlaceholders(String[] args, String userName, String userSkin, String targetName, String targetSkin, EntityEquipment equip, EntityEquipment targetEquip) {
        return DisguiseParser.parsePlaceholders(args, userName, userName, userSkin, targetName, targetName, targetSkin, equip, targetEquip);
    }

    public static String[] parsePlaceholders(String[] args, String userName, String userDisplayname, String userSkin, String targetName, String targetDisplayname, String targetSkin, EntityEquipment equip, EntityEquipment targetEquip) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            arg = DisguiseParser.replace(arg, "%name%", userName);
            arg = DisguiseParser.replace(arg, "%displayname%", userDisplayname);
            arg = DisguiseParser.replace(arg, "%skin%", userSkin);
            arg = DisguiseParser.replace(arg, "%user-name%", userName);
            arg = DisguiseParser.replace(arg, "%user-displayname%", userDisplayname);
            arg = DisguiseParser.replace(arg, "%user-skin%", userSkin);
            arg = DisguiseParser.replace(arg, "%held-item%", equip == null ? null : equip.getItemInMainHand());
            arg = DisguiseParser.replace(arg, "%offhand-item%", equip == null ? null : equip.getItemInOffHand());
            arg = DisguiseParser.replace(arg, "%armor%", equip == null ? null : equip.getArmorContents());
            arg = DisguiseParser.replace(arg, "%helmet%", equip == null ? null : equip.getHelmet());
            arg = DisguiseParser.replace(arg, "%chestplate%", equip == null ? null : equip.getChestplate());
            arg = DisguiseParser.replace(arg, "%leggings%", equip == null ? null : equip.getLeggings());
            arg = DisguiseParser.replace(arg, "%boots%", equip == null ? null : equip.getBoots());
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!arg.contains("%" + p.getName() + "-")) continue;
                String name = p.getName();
                arg = DisguiseParser.replace(arg, "%" + name + "-name%", name);
                arg = DisguiseParser.replace(arg, "%" + name + "-displayname%", DisguiseUtilities.getDisplayName((CommandSender)p));
                arg = DisguiseParser.replace(arg, "%" + name + "-skin%", DisguiseParser.getSkin((CommandSender)p));
                EntityEquipment pEquip = p.getEquipment();
                arg = DisguiseParser.replace(arg, "%" + name + "-held-item%", pEquip == null ? null : pEquip.getItemInMainHand());
                arg = DisguiseParser.replace(arg, "%" + name + "-offhand-item%", pEquip == null ? null : pEquip.getItemInOffHand());
                arg = DisguiseParser.replace(arg, "%" + name + "-armor%", pEquip == null ? null : pEquip.getArmorContents());
                arg = DisguiseParser.replace(arg, "%" + name + "-helmet%", pEquip == null ? null : pEquip.getHelmet());
                arg = DisguiseParser.replace(arg, "%" + name + "-chestplate%", pEquip == null ? null : pEquip.getChestplate());
                arg = DisguiseParser.replace(arg, "%" + name + "-leggings%", pEquip == null ? null : pEquip.getLeggings());
                arg = DisguiseParser.replace(arg, "%" + name + "-boots%", pEquip == null ? null : pEquip.getBoots());
            }
            arg = DisguiseParser.replace(arg, "%target-name%", targetName);
            arg = DisguiseParser.replace(arg, "%target-displayname%", targetDisplayname);
            arg = DisguiseParser.replace(arg, "%target-skin%", targetSkin);
            arg = DisguiseParser.replace(arg, "%target-held-item%", targetEquip == null ? null : targetEquip.getItemInMainHand());
            arg = DisguiseParser.replace(arg, "%target-offhand-item%", targetEquip == null ? null : targetEquip.getItemInOffHand());
            arg = DisguiseParser.replace(arg, "%target-armor%", targetEquip == null ? null : targetEquip.getArmorContents());
            arg = DisguiseParser.replace(arg, "%target-helmet%", targetEquip == null ? null : targetEquip.getHelmet());
            arg = DisguiseParser.replace(arg, "%target-chestplate%", targetEquip == null ? null : targetEquip.getChestplate());
            arg = DisguiseParser.replace(arg, "%target-leggings%", targetEquip == null ? null : targetEquip.getLeggings());
            args[i] = arg = DisguiseParser.replace(arg, "%target-boots%", targetEquip == null ? null : targetEquip.getBoots());
        }
        return args;
    }

    private static String replace(String string, String value, Object toReplace) {
        if (!string.contains(value)) {
            return string;
        }
        String oValue = toReplace != null ? ParamInfoManager.toString(toReplace) : "null";
        return string.replace(value, oValue);
    }

    public static long parseStringToTime(String string) throws DisguiseParseException {
        if (!(string = string.toLowerCase(Locale.ENGLISH)).matches("([0-9]+[a-z]+)+")) {
            throw new DisguiseParseException(LibsMsg.PARSE_INVALID_TIME_SEQUENCE, string);
        }
        String[] split = string.split("((?<=[a-zA-Z])(?=[0-9]))|((?<=[0-9])(?=[a-zA-Z]))");
        long time = 0L;
        for (int i = 0; i < split.length; i += 2) {
            String t = split[i + 1];
            long v = Long.parseLong(split[i]);
            if (t.equals("s") || t.equals("sec") || t.equals("secs") || t.equals("seconds")) {
                time += v;
                continue;
            }
            if (t.equals("m") || t.equals("min") || t.equals("minute") || t.equals("minutes")) {
                time += TimeUnit.MINUTES.toSeconds(v);
                continue;
            }
            if (t.equals("h") || t.equals("hour") || t.equals("hours")) {
                time += TimeUnit.HOURS.toSeconds(v);
                continue;
            }
            if (t.equals("d") || t.equals("day") || t.equals("days")) {
                time += TimeUnit.DAYS.toSeconds(v);
                continue;
            }
            if (t.equals("w") || t.equals("week") || t.equals("weeks")) {
                time += TimeUnit.DAYS.toSeconds(v) * 7L;
                continue;
            }
            if (t.equals("mon") || t.equals("month") || t.equals("months")) {
                time += TimeUnit.DAYS.toSeconds(v) * 31L;
                continue;
            }
            if (t.equals("y") || t.equals("year") || t.equals("years")) {
                time += TimeUnit.DAYS.toSeconds(v) * 365L;
                continue;
            }
            throw new DisguiseParseException(LibsMsg.PARSE_INVALID_TIME, t);
        }
        return time;
    }

    public static Disguise parseTestDisguise(CommandSender sender, String permNode, String[] args, DisguisePermissions permissions) throws DisguiseParseException, IllegalAccessException, InvocationTargetException {
        args = Arrays.copyOf(args, args.length);
        String skin = "{\"id\":\"a149f81bf7844f8987c554afdd4db533\",\"name\":\"libraryaddict\",\"properties\":[]}";
        args = DisguiseParser.parsePlaceholders(args, "libraryaddict", skin, "libraryaddict", skin, null, null);
        return DisguiseParser.parseDisguise(sender, null, permNode, args, permissions);
    }

    public static void modifyDisguise(Disguise disguise, Entity target, String[] params) throws IllegalAccessException, DisguiseParseException, InvocationTargetException {
        if (target != null) {
            params = DisguiseParser.parsePlaceholders(params, (CommandSender)target, (CommandSender)target);
        }
        DisguiseParser.callMethods((CommandSender)Bukkit.getConsoleSender(), disguise, new DisguisePermissions((Permissible)Bukkit.getConsoleSender(), "disguise"), new DisguisePerm(disguise.getType()), new ArrayList<String>(), params, "Disguise");
    }

    public static void modifyDisguise(Disguise disguise, String[] params) throws IllegalAccessException, InvocationTargetException, DisguiseParseException {
        DisguiseParser.modifyDisguise(disguise, null, params);
    }

    public static void modifyDisguise(Disguise disguise, String params) throws IllegalAccessException, DisguiseParseException, InvocationTargetException {
        DisguiseParser.modifyDisguise(disguise, DisguiseUtilities.split(params));
    }

    public static void modifyDisguise(Disguise disguise, Entity target, String params) throws IllegalAccessException, InvocationTargetException, DisguiseParseException {
        DisguiseParser.modifyDisguise(disguise, target, DisguiseUtilities.split(params));
    }

    public static Disguise parseDisguise(String disguise) throws IllegalAccessException, InvocationTargetException, DisguiseParseException {
        return DisguiseParser.parseDisguise((CommandSender)Bukkit.getConsoleSender(), null, disguise);
    }

    public static Disguise parseDisguise(CommandSender sender, Entity target, String disguise) throws IllegalAccessException, InvocationTargetException, DisguiseParseException {
        return DisguiseParser.parseDisguise(sender, target, "disguise", DisguiseUtilities.split(disguise), new DisguisePermissions((Permissible)Bukkit.getConsoleSender(), "disguise"));
    }

    public static Disguise parseDisguise(CommandSender sender, Entity target, String permNode, String[] args, DisguisePermissions permissions) throws DisguiseParseException, IllegalAccessException, InvocationTargetException {
        String name;
        DisguisePerm disguisePerm;
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("DisguiseParser should not be called async!");
        }
        if (sender instanceof Player) {
            DisguiseUtilities.setCommandsUsed();
        }
        if (!permissions.hasPermissions()) {
            throw new DisguiseParseException(LibsMsg.NO_PERM, new String[0]);
        }
        if (args.length == 0) {
            throw new DisguiseParseException(LibsMsg.PARSE_NO_ARGS, new String[0]);
        }
        int toSkip = 1;
        ArrayList<String> usedOptions = new ArrayList<String>();
        Disguise disguise = null;
        boolean customName = false;
        if (args[0].startsWith("@")) {
            if (sender.hasPermission("libsdisguises.disguise.disguiseclone")) {
                disguise = DisguiseUtilities.getClonedDisguise(args[0].toLowerCase(Locale.ENGLISH));
                if (disguise == null) {
                    throw new DisguiseParseException(LibsMsg.PARSE_NO_REF, args[0]);
                }
            } else {
                throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_REF, new String[0]);
            }
            disguisePerm = new DisguisePerm(disguise.getType());
            name = disguise.getDisguiseName();
            customName = disguise.isCustomDisguiseName();
            if (disguisePerm.isUnknown()) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_DISG_UNKNOWN, new String[0]);
            }
            if (disguisePerm.getEntityType() == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_LOAD, new String[0]);
            }
            if (!permissions.isAllowedDisguise(disguisePerm)) {
                throw new DisguiseParseException(LibsMsg.NO_PERM_DISGUISE, new String[0]);
            }
        } else {
            Map.Entry<DisguisePerm, String> customDisguise;
            disguisePerm = DisguiseParser.getDisguisePerm(args[0]);
            if (disguisePerm == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_DISG_NO_EXIST, args[0]);
            }
            name = disguisePerm.toReadable();
            if (disguisePerm.getType().isCustom()) {
                ModdedEntity ent = ModdedManager.getModdedEntity(disguisePerm.toReadable());
                if (ent == null) {
                    throw new DisguiseParseException(LibsMsg.PARSE_CANT_DISG_UNKNOWN, new String[0]);
                }
                disguise = new ModdedDisguise(ent);
                customName = true;
            }
            if ((customDisguise = DisguiseConfig.getRawCustomDisguise(args[0])) != null) {
                args = DisguiseUtilities.split(customDisguise.getValue());
                name = customDisguise.getKey().toReadable();
                customName = true;
            }
            args = DisguiseParser.parsePlaceholders(args, sender, (CommandSender)target);
            if (disguisePerm.isUnknown()) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_DISG_UNKNOWN, new String[0]);
            }
            if (disguisePerm.getEntityType() == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_LOAD, new String[0]);
            }
            if (!permissions.isAllowedDisguise(disguisePerm)) {
                throw new DisguiseParseException(LibsMsg.NO_PERM_DISGUISE, new String[0]);
            }
            HashMap<String, HashMap<String, Boolean>> disguiseOptions = DisguiseParser.getDisguiseOptions(sender, permNode, disguisePerm);
            if (disguise == null) {
                if (disguisePerm.isPlayer()) {
                    if (args.length == 1) {
                        throw new DisguiseParseException(LibsMsg.PARSE_SUPPLY_PLAYER, new String[0]);
                    }
                    if (!(DisguiseParser.hasPermissionOption(disguiseOptions, "setname", args[1].toLowerCase(Locale.ENGLISH)) || args[1].equalsIgnoreCase(sender.getName()) && DisguiseParser.hasPermissionOption(disguiseOptions, "setname", "themselves"))) {
                        throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_NAME, new String[0]);
                    }
                    args[1] = args[1].replace("\\_", " ");
                    if (DisguiseConfig.isArmorstandsName() && !sender.hasPermission("libsdisguises.multiname")) {
                        args[1] = DisguiseUtilities.quoteNewLine(args[1]);
                    }
                    disguise = new PlayerDisguise(ChatColor.translateAlternateColorCodes((char)'&', (String)args[1]));
                    if (!customName) {
                        name = ((PlayerDisguise)disguise).getName();
                    }
                    ++toSkip;
                } else if (disguisePerm.isMob()) {
                    if (args.length > 1) {
                        boolean adult = true;
                        if (args[1].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS.get("baby")) || args[1].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS.get("adult"))) {
                            usedOptions.add("setbaby");
                            DisguiseParser.doCheck(sender, permissions, disguisePerm, usedOptions);
                            adult = args[1].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS.get("adult"));
                            ++toSkip;
                            disguise = new MobDisguise(disguisePerm.getType(), adult);
                        } else {
                            disguise = new MobDisguise(disguisePerm.getType());
                        }
                    } else {
                        disguise = new MobDisguise(disguisePerm.getType());
                    }
                } else if (disguisePerm.isMisc()) {
                    ItemStack itemStack = new ItemStack(Material.STONE);
                    Object blockData = null;
                    int miscId = -1;
                    if (args.length > 1) {
                        switch (disguisePerm.getType()) {
                            case FALLING_BLOCK: 
                            case DROPPED_ITEM: {
                                String itemName;
                                try {
                                    if (disguisePerm.getType() == DisguiseType.FALLING_BLOCK) {
                                        if (NmsVersion.v1_13.isSupported() && args[1].contains("[")) {
                                            ParamInfo info = ParamInfoManager.getParamInfo(BlockData.class);
                                            blockData = info.fromString(new ArrayList<String>(Collections.singletonList(args[1])));
                                        } else {
                                            ParamInfoItemBlock info = ParamInfoManager.getParamInfoItemBlock();
                                            itemStack = (ItemStack)info.fromString(new ArrayList<String>(Collections.singletonList(args[1])));
                                        }
                                    } else {
                                        ParamInfo info = ParamInfoManager.getParamInfo(ItemStack.class);
                                        itemStack = (ItemStack)info.fromString(new ArrayList<String>(Collections.singletonList(args[1])));
                                    }
                                }
                                catch (Exception ex) {
                                    break;
                                }
                                String optionName = disguisePerm.getType() == DisguiseType.FALLING_BLOCK ? "setblock" : "setitemstack";
                                usedOptions.add(optionName);
                                DisguiseParser.doCheck(sender, permissions, disguisePerm, usedOptions);
                                String string = itemName = itemStack == null ? "null" : itemStack.getType().name().toLowerCase(Locale.ENGLISH);
                                if (!DisguiseParser.hasPermissionOption(disguiseOptions, optionName, itemName)) {
                                    throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_PARAM, itemName, disguisePerm.toReadable());
                                }
                                ++toSkip;
                                break;
                            }
                            case PAINTING: 
                            case SPLASH_POTION: {
                                if (!DisguiseParser.isInteger(args[1])) break;
                                miscId = Integer.parseInt(args[1]);
                                ++toSkip;
                                String optionName = disguisePerm.getType() == DisguiseType.PAINTING ? "setpainting" : "setpotionid";
                                usedOptions.add(optionName);
                                DisguiseParser.doCheck(sender, permissions, disguisePerm, usedOptions);
                                if (DisguiseParser.hasPermissionOption(disguiseOptions, optionName, miscId + "")) break;
                                throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_PARAM, miscId + "", disguisePerm.toReadable());
                            }
                        }
                    }
                    if (disguisePerm.getType() == DisguiseType.DROPPED_ITEM || disguisePerm.getType() == DisguiseType.FALLING_BLOCK) {
                        disguise = new MiscDisguise(disguisePerm.getType(), itemStack);
                        if (blockData != null && disguisePerm.getType() == DisguiseType.FALLING_BLOCK) {
                            ((FallingBlockWatcher)disguise.getWatcher()).setBlockData((BlockData)blockData);
                        }
                        if (!customName) {
                            name = disguise.getDisguiseName();
                        }
                    } else {
                        disguise = new MiscDisguise(disguisePerm.getType(), miscId);
                    }
                }
            }
        }
        disguise.setDisguiseName(name);
        disguise.setCustomDisguiseName(customName);
        String[] newArgs = new String[args.length - toSkip];
        System.arraycopy(args, toSkip, newArgs, 0, args.length - toSkip);
        DisguiseParser.callMethods(sender, disguise, permissions, disguisePerm, usedOptions, newArgs, permNode);
        if (sender instanceof Player && target instanceof Player && "%%__USER__%%".equals("1592") && ThreadLocalRandom.current().nextBoolean()) {
            ((TargetedDisguise)disguise).setDisguiseTarget(TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS);
            ((TargetedDisguise)disguise).addPlayer((Player)sender);
        }
        return disguise;
    }

    public static void callMethods(CommandSender sender, Disguise disguise, DisguisePermissions disguisePermission, DisguisePerm disguisePerm, Collection<String> usedOptions, String[] args, String permNode) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, DisguiseParseException {
        Method[] methods = ParamInfoManager.getDisguiseWatcherMethods(disguise.getWatcher().getClass());
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(args));
        HashMap<String, HashMap<String, Boolean>> disguiseOptions = DisguiseParser.getDisguiseOptions(sender, permNode, disguisePerm);
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            String methodNameProvided = (String)list.remove(0);
            String methodNameJava = TranslateType.DISGUISE_OPTIONS.reverseGet(methodNameProvided);
            Method methodToUse = null;
            Object valueToSet = null;
            DisguiseParseException parseException = null;
            for (Method method : methods) {
                if (!method.getName().equalsIgnoreCase(methodNameJava)) continue;
                ParamInfo paramInfo = ParamInfoManager.getParamInfo(method);
                try {
                    int argCount = list.size();
                    if (argCount < paramInfo.getMinArguments()) {
                        throw new DisguiseParseException(LibsMsg.PARSE_NO_OPTION_VALUE, TranslateType.DISGUISE_OPTIONS.reverseGet(method.getName()));
                    }
                    valueToSet = paramInfo.fromString(list);
                    if (valueToSet == null && !paramInfo.canReturnNull()) {
                        throw new IllegalStateException();
                    }
                    argIndex += argCount - list.size();
                    methodToUse = method;
                    break;
                }
                catch (DisguiseParseException ex) {
                    parseException = ex;
                }
                catch (Exception ignored) {
                    parseException = new DisguiseParseException(LibsMsg.PARSE_EXPECTED_RECEIVED, paramInfo.getDescriptiveName(), list.isEmpty() ? null : (String)list.get(0), TranslateType.DISGUISE_OPTIONS.reverseGet(method.getName()));
                }
            }
            if (methodToUse == null) {
                if (parseException != null) {
                    throw parseException;
                }
                throw new DisguiseParseException(LibsMsg.PARSE_OPTION_NA, methodNameProvided);
            }
            if (!usedOptions.contains(methodToUse.getName().toLowerCase(Locale.ENGLISH))) {
                usedOptions.add(methodToUse.getName().toLowerCase(Locale.ENGLISH));
            }
            DisguiseParser.doCheck(sender, disguisePermission, disguisePerm, usedOptions);
            if (!disguiseOptions.isEmpty()) {
                String stringValue = ParamInfoManager.toString(valueToSet);
                if (!DisguiseParser.hasPermissionOption(disguiseOptions, methodToUse.getName(), stringValue)) {
                    throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_PARAM, stringValue, disguisePerm.toReadable());
                }
            }
            if (DisguiseConfig.isArmorstandsName() && (methodToUse.getName().equals("setName") && disguise.isPlayerDisguise() || DisguiseConfig.isOverrideCustomNames() && methodToUse.getName().equals("setCustomName")) && !sender.hasPermission("libsdisguises.multiname")) {
                valueToSet = DisguiseUtilities.quoteNewLine((String)valueToSet);
            }
            if (FlagWatcher.class.isAssignableFrom(methodToUse.getDeclaringClass())) {
                methodToUse.invoke((Object)disguise.getWatcher(), valueToSet);
                continue;
            }
            methodToUse.invoke((Object)disguise, valueToSet);
        }
    }
}

