/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection.asm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;

public class AsmDownloader {
    private String urlToGrab = "https://search.maven.org/remotecontent?filepath=org/ow2/asm/asm/7.3.1/asm-7.3.1.jar";
    private File filePath = new File(LibsDisguises.getInstance().getDataFolder(), "libs/org-ow2-asm-7.3.1.jar");

    public AsmDownloader() {
        if (NmsVersion.v1_13.isSupported()) {
            throw new IllegalStateException("Sorry, this shouldn't have been started!");
        }
        try {
            Class.forName("org.objectweb.asm.ClassReader");
            return;
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            if (!this.hasASM()) {
                LibsDisguises.getInstance().getLogger().info("Downloading required library for 1.12 support!");
                this.downloadASM();
                LibsDisguises.getInstance().getLogger().info("Downloaded!");
            }
            try {
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)this.getClass().getClassLoader(), this.filePath.toURI().toURL());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return;
        }
    }

    private boolean hasASM() {
        return this.filePath.exists();
    }

    private void downloadASM() {
        this.filePath.getParentFile().mkdirs();
        try (BufferedInputStream in = new BufferedInputStream(new URL(this.getUrlToGrab()).openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(this.getFilePath());){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getUrlToGrab() {
        return this.urlToGrab;
    }

    private File getFilePath() {
        return this.filePath;
    }
}

