/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.mineskin;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.SkinUtils;
import me.libraryaddict.disguise.utilities.mineskin.MineSkinResponse;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;

public class MineSkinAPI {
    private long nextRequest;
    private final ReentrantLock lock = new ReentrantLock();

    public boolean isInUse() {
        return this.lock.isLocked();
    }

    public int nextRequestIn() {
        long timeTillNext = this.nextRequest - System.currentTimeMillis();
        if (timeTillNext < 0L) {
            return 0;
        }
        return (int)Math.ceil((double)timeTillNext / 1000.0);
    }

    public MineSkinResponse generateFromUrl(SkinUtils.SkinCallback callback, String url, SkinUtils.ModelType modelType) {
        return this.doPost(callback, "/generate/url", url, null, modelType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MineSkinResponse doPost(SkinUtils.SkinCallback callback, String path, String skinUrl, File file, SkinUtils.ModelType modelType) {
        MineSkinResponse mineSkinResponse;
        InputStream input;
        Throwable throwable;
        long nextRequestIn;
        HttpURLConnection connection;
        block67: {
            block68: {
                block66: {
                    APIError error;
                    block64: {
                        block65: {
                            block60: {
                                block63: {
                                    block62: {
                                        block61: {
                                            this.lock.lock();
                                            long sleep = this.nextRequest - System.currentTimeMillis();
                                            if (sleep > 0L) {
                                                try {
                                                    Thread.sleep(sleep);
                                                }
                                                catch (InterruptedException e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                            connection = null;
                                            nextRequestIn = TimeUnit.SECONDS.toMillis(10L);
                                            URL url = new URL("https://api.mineskin.org" + path);
                                            connection = (HttpURLConnection)url.openConnection();
                                            connection.setRequestProperty("User-Agent", "LibsDisguises");
                                            connection.setConnectTimeout(19000);
                                            connection.setReadTimeout(19000);
                                            String boundary = Long.toHexString(System.currentTimeMillis());
                                            connection.setDoOutput(true);
                                            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                                            String charset = "UTF-8";
                                            String CRLF = "\r\n";
                                            throwable = null;
                                            try (OutputStream output = connection.getOutputStream();
                                                 PrintWriter writer2 = new PrintWriter((Writer)new OutputStreamWriter(output, charset), true);){
                                                writer2.append("--").append(boundary).append(CRLF);
                                                writer2.append("Content-Disposition: form-data; name=\"visibility\"").append(CRLF);
                                                writer2.append("Content-Type: text/plain; charset=").append(charset).append(CRLF);
                                                writer2.append(CRLF).append("1").append(CRLF).flush();
                                                if (file != null) {
                                                    writer2.append("--").append(boundary).append(CRLF);
                                                    writer2.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(file.getName()).append("\"").append(CRLF);
                                                    writer2.append("Content-Type: image/png").append(CRLF);
                                                    writer2.append("Content-Transfer-Encoding: binary").append(CRLF);
                                                    writer2.append(CRLF).flush();
                                                    Files.copy(file.toPath(), output);
                                                    output.flush();
                                                    writer2.append(CRLF).flush();
                                                } else if (skinUrl != null) {
                                                    writer2.append("--").append(boundary).append(CRLF);
                                                    writer2.append("Content-Disposition: form-data; name=\"url\"").append(CRLF);
                                                    writer2.append(CRLF).append(skinUrl).append(CRLF).flush();
                                                }
                                                if (modelType == SkinUtils.ModelType.SLIM) {
                                                    writer2.append("--").append(boundary).append(CRLF);
                                                    writer2.append("Content-Disposition: form-data; name=\"model\"").append(CRLF);
                                                    writer2.append(CRLF).append("slim").append(CRLF).flush();
                                                }
                                                writer2.append("--").append(boundary).append("--").append(CRLF).flush();
                                            }
                                            catch (Throwable writer2) {
                                                throwable = writer2;
                                                throw writer2;
                                            }
                                            if (connection.getResponseCode() != 500) break block60;
                                            error = (APIError)new Gson().fromJson(new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")), APIError.class);
                                            if (error.code != 403) break block61;
                                            callback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + error.code, LibsMsg.SKIN_API_403.get(new Object[0]));
                                            throwable = null;
                                            this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                                            this.lock.unlock();
                                            return throwable;
                                        }
                                        if (error.code != 404) break block62;
                                        callback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + error.code, LibsMsg.SKIN_API_404.get(new Object[0]));
                                        throwable = null;
                                        this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                                        this.lock.unlock();
                                        return throwable;
                                    }
                                    if (error.code != 408 && error.code != 504 && error.code != 599) break block63;
                                    callback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + error.code, LibsMsg.SKIN_API_TIMEOUT.get(new Object[0]));
                                    throwable = null;
                                    this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                                    this.lock.unlock();
                                    return throwable;
                                }
                                callback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + error.code, LibsMsg.SKIN_API_IMAGE_HAS_ERROR.get(error.error));
                                throwable = null;
                                this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                                this.lock.unlock();
                                return throwable;
                            }
                            if (connection.getResponseCode() != 400) break block64;
                            if (skinUrl == null) break block65;
                            callback.onError(LibsMsg.SKIN_API_BAD_URL, new Object[0]);
                            error = null;
                            this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                            this.lock.unlock();
                            return error;
                        }
                        if (file == null) break block66;
                        callback.onError(LibsMsg.SKIN_API_BAD_FILE, new Object[0]);
                        error = null;
                        this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                        this.lock.unlock();
                        return error;
                    }
                    if (connection.getResponseCode() != 429) break block66;
                    callback.onError(LibsMsg.SKIN_API_FAIL_TOO_FAST, new Object[0]);
                    error = null;
                    this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                    this.lock.unlock();
                    return error;
                }
                input = connection.getInputStream();
                throwable = null;
                String response = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                MineSkinResponse skinResponse = (MineSkinResponse)new Gson().fromJson(response, MineSkinResponse.class);
                nextRequestIn = (long)(skinResponse.getNextRequest() * 1000.0);
                mineSkinResponse = skinResponse;
                if (input == null) break block67;
                if (throwable == null) break block68;
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block67;
            }
            input.close();
        }
        this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
        this.lock.unlock();
        return mineSkinResponse;
        {
            catch (Throwable throwable3) {
                MineSkinResponse mineSkinResponse2;
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (input == null) throw throwable4;
                        if (throwable != null) {
                            try {
                                input.close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            throw throwable4;
                        } else {
                            input.close();
                        }
                        throw throwable4;
                    }
                }
                catch (SocketTimeoutException ex) {
                    callback.onError(skinUrl == null ? LibsMsg.SKIN_API_TIMEOUT_ERROR : LibsMsg.SKIN_API_IMAGE_TIMEOUT, new Object[0]);
                    mineSkinResponse2 = null;
                    this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                    this.lock.unlock();
                    return mineSkinResponse2;
                }
                catch (Exception ex) {
                    block69: {
                        if (connection == null || connection.getResponseCode() != 524 && connection.getResponseCode() != 408 && connection.getResponseCode() != 504 && connection.getResponseCode() != 599) break block69;
                        callback.onError(LibsMsg.SKIN_API_TIMEOUT_ERROR, new Object[0]);
                        mineSkinResponse2 = null;
                        this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                        this.lock.unlock();
                        return mineSkinResponse2;
                    }
                    try {
                        block70: {
                            break block70;
                            {
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        DisguiseUtilities.getLogger().warning("Failed to access MineSkin.org");
                        ex.printStackTrace();
                        callback.onError(LibsMsg.SKIN_API_FAIL, new Object[0]);
                        return null;
                    }
                    catch (Throwable throwable6) {
                        throw throwable6;
                    }
                    finally {
                        this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                        this.lock.unlock();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public MineSkinResponse generateFromUUID(UUID uuid, SkinUtils.ModelType modelType) throws IllegalArgumentException {
        this.lock.lock();
        long sleep = this.nextRequest - System.currentTimeMillis();
        if (sleep > 0L) {
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        long nextRequestIn = TimeUnit.SECONDS.toMillis(10L);
        try {
            MineSkinResponse mineSkinResponse;
            Throwable throwable;
            InputStream input;
            block22: {
                block23: {
                    String siteUrl = "https://api.mineskin.org/generate/user/:" + uuid.toString();
                    if (modelType == SkinUtils.ModelType.SLIM) {
                        siteUrl = siteUrl + "?model=slim";
                    }
                    URL url = new URL(siteUrl);
                    HttpURLConnection con = (HttpURLConnection)url.openConnection();
                    con.setRequestProperty("User-Agent", "LibsDisguises");
                    con.setDoOutput(true);
                    input = con.getInputStream();
                    throwable = null;
                    String response = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    MineSkinResponse skinResponse = (MineSkinResponse)new Gson().fromJson(response, MineSkinResponse.class);
                    nextRequestIn = (long)(skinResponse.getNextRequest() * 1000.0);
                    mineSkinResponse = skinResponse;
                    if (input == null) break block22;
                    if (throwable == null) break block23;
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block22;
                }
                input.close();
            }
            return mineSkinResponse;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (input != null) {
                            if (throwable != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                input.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception ex) {
                    if (ex.getMessage() != null && ex.getMessage().contains("Server returned HTTP response code: 400 for URL")) {
                        throw new IllegalArgumentException();
                    }
                    DisguiseUtilities.getLogger().warning("Failed to access MineSkin.org");
                    ex.printStackTrace();
                }
            }
        }
        finally {
            this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
            this.lock.unlock();
        }
        return null;
    }

    public MineSkinResponse generateFromFile(SkinUtils.SkinCallback callback, File file, SkinUtils.ModelType modelType) {
        return this.doPost(callback, "/generate/upload", null, file, modelType);
    }

    private class APIError {
        int code;
        String error;

        private APIError() {
        }
    }
}

