/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractHorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DisguiseAPI {
    private static int selfDisguiseId = ReflectionManager.getNewEntityId(true);
    private static int entityAttachmentId = ReflectionManager.getNewEntityId(true);

    public static void addCustomDisguise(String disguiseName, String disguiseInfo) throws DisguiseParseException {
        disguiseName = disguiseName.replace(".", "");
        try {
            YamlConfiguration configuration;
            DisguiseConfig.removeCustomDisguise(disguiseName);
            DisguiseConfig.addCustomDisguise(disguiseName, disguiseInfo);
            File disguisesFile = new File(LibsDisguises.getInstance().getDataFolder(), "configs/disguises.yml");
            if (!disguisesFile.exists()) {
                disguisesFile.getParentFile().mkdirs();
                disguisesFile.createNewFile();
            }
            if (!(configuration = YamlConfiguration.loadConfiguration((File)disguisesFile)).isConfigurationSection("Disguises")) {
                configuration.createSection("Disguises");
            }
            ConfigurationSection section = configuration.getConfigurationSection("Disguises");
            section.set(disguiseName, (Object)disguiseInfo.replace("\n", "\\n").replace("\r", "\\r"));
            configuration.save(disguisesFile);
            DisguiseUtilities.getLogger().info("Added new Custom Disguise " + disguiseName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addGameProfile(String profileName, WrappedGameProfile gameProfile) {
        DisguiseUtilities.addGameProfile(profileName, gameProfile);
    }

    public static String getRawCustomDisguise(String disguiseName) {
        Map.Entry<DisguisePerm, String> entry = DisguiseConfig.getRawCustomDisguise(disguiseName);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public static Disguise getCustomDisguise(String disguiseName) {
        Map.Entry<DisguisePerm, Disguise> disguise = DisguiseConfig.getCustomDisguise(disguiseName);
        if (disguise == null) {
            return null;
        }
        return disguise.getValue();
    }

    @Deprecated
    public static Disguise constructDisguise(Entity entity) {
        return DisguiseAPI.constructDisguise(entity, true, true, true);
    }

    @Deprecated
    public static Disguise constructDisguise(Entity entity, boolean doEquipment, boolean doSneak, boolean doSprint) {
        DisguiseType disguiseType = DisguiseType.getType(entity);
        TargetedDisguise disguise = disguiseType.isMisc() ? new MiscDisguise(disguiseType) : (disguiseType.isMob() ? new MobDisguise(disguiseType) : new PlayerDisguise(entity.getName()));
        FlagWatcher watcher = disguise.getWatcher();
        if (entity instanceof LivingEntity) {
            for (PotionEffect effect : ((LivingEntity)entity).getActivePotionEffects()) {
                ((LivingWatcher)watcher).addPotionEffect(effect.getType());
                if (effect.getType() == PotionEffectType.INVISIBILITY) {
                    watcher.setInvisible(true);
                    continue;
                }
                if (effect.getType() != PotionEffectType.GLOWING) continue;
                watcher.setGlowing(true);
            }
        }
        if (entity.getFireTicks() > 0) {
            watcher.setBurning(true);
        }
        if (doEquipment && entity instanceof LivingEntity) {
            Horse horse;
            HorseInventory horseInventory;
            ItemStack saddle;
            EntityEquipment equip = ((LivingEntity)entity).getEquipment();
            watcher.setArmor(equip.getArmorContents());
            watcher.setItemInMainHand(equip.getItemInMainHand());
            if (disguiseType.getEntityType() == EntityType.HORSE && (saddle = (horseInventory = (horse = (Horse)entity).getInventory()).getSaddle()) != null && saddle.getType() == Material.SADDLE) {
                ((AbstractHorseWatcher)watcher).setSaddled(true);
            }
        }
        for (Method method : entity.getClass().getMethods()) {
            int firstCapitalMethod;
            if (!doSneak && method.getName().equals("setSneaking") || !doSprint && method.getName().equals("setSprinting") || method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) continue;
            Class<Object> methodReturn = method.getReturnType();
            if (methodReturn == Float.TYPE || methodReturn == Float.class || methodReturn == Double.class) {
                methodReturn = Double.TYPE;
            }
            if ((firstCapitalMethod = DisguiseAPI.firstCapital(method.getName())) <= 0) continue;
            for (Method watcherMethod : watcher.getClass().getMethods()) {
                int firstCapitalWatcher;
                if (watcherMethod.getName().startsWith("get") || watcherMethod.getReturnType() != Void.TYPE || watcherMethod.getParameterTypes().length != 1 || (firstCapitalWatcher = DisguiseAPI.firstCapital(watcherMethod.getName())) <= 0 || !method.getName().substring(firstCapitalMethod).equalsIgnoreCase(watcherMethod.getName().substring(firstCapitalWatcher))) continue;
                Class<Object> methodParam = watcherMethod.getParameterTypes()[0];
                if (methodParam == Float.TYPE || methodParam == Float.class || methodParam == Double.class) {
                    methodParam = Double.TYPE;
                } else if (methodParam == AnimalColor.class) {
                    methodParam = DyeColor.class;
                }
                if (methodReturn != methodParam) continue;
                try {
                    Object value = method.invoke((Object)entity, new Object[0]);
                    if (value != null) {
                        Class<?> toCast = watcherMethod.getParameterTypes()[0];
                        if (!toCast.isInstance(value)) {
                            if (toCast == Float.TYPE) {
                                if (!(value instanceof Float)) {
                                    double d = (Double)value;
                                    value = Float.valueOf((float)d);
                                }
                            } else if (toCast == Double.TYPE) {
                                if (!(value instanceof Double)) {
                                    float d = ((Float)value).floatValue();
                                    value = (double)d;
                                }
                            } else if (toCast == AnimalColor.class) {
                                value = AnimalColor.valueOf(((DyeColor)value).name());
                            }
                        }
                        if (value instanceof Boolean && !((Boolean)value).booleanValue() && watcherMethod.getDeclaringClass() == FlagWatcher.class) continue;
                    }
                    watcherMethod.invoke((Object)watcher, value);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return disguise;
    }

    public static void disguiseEntity(Entity entity, Disguise disguise) {
        if (entity == null || disguise == null) {
            return;
        }
        if (disguise.getEntity() != entity) {
            if (disguise.getEntity() != null) {
                disguise = disguise.clone();
            }
            disguise.setEntity(entity);
        }
        if (DisguiseAPI.hasSelfDisguisePreference(entity) && disguise.isSelfDisguiseVisible() == DisguiseConfig.isViewDisguises()) {
            disguise.setViewSelfDisguise(!disguise.isSelfDisguiseVisible());
        }
        if (DisguiseAPI.hasActionBarPreference(entity) && !DisguiseAPI.isActionBarShown(entity)) {
            disguise.setNotifyBar(DisguiseConfig.NotifyBar.NONE);
        }
        disguise.startDisguise();
    }

    public static void disguiseIgnorePlayers(Entity entity, Disguise disguise, Collection playersToNotSeeDisguise) {
        if (disguise.getEntity() != null) {
            disguise = disguise.clone();
        }
        ((TargetedDisguise)disguise).setDisguiseTarget(TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS);
        for (Object obj : playersToNotSeeDisguise) {
            if (obj instanceof String) {
                ((TargetedDisguise)disguise).addPlayer((String)obj);
                continue;
            }
            if (!(obj instanceof Player)) continue;
            ((TargetedDisguise)disguise).addPlayer(((Player)obj).getName());
        }
        DisguiseAPI.disguiseEntity(entity, disguise);
    }

    @Deprecated
    public static void disguiseIgnorePlayers(Entity entity, Disguise disguise, List<String> playersToNotSeeDisguise) {
        DisguiseAPI.disguiseIgnorePlayers(entity, disguise, playersToNotSeeDisguise);
    }

    public static void disguiseIgnorePlayers(Entity entity, Disguise disguise, Player ... playersToNotSeeDisguise) {
        DisguiseAPI.disguiseIgnorePlayers(entity, disguise, Arrays.asList(playersToNotSeeDisguise));
    }

    public static void disguiseIgnorePlayers(Entity entity, Disguise disguise, String ... playersToNotSeeDisguise) {
        DisguiseAPI.disguiseIgnorePlayers(entity, disguise, Arrays.asList(playersToNotSeeDisguise));
    }

    public static int disguiseNextEntity(Disguise disguise) {
        if (disguise == null) {
            return -1;
        }
        if (disguise.getEntity() != null || DisguiseUtilities.getDisguises().containsValue(disguise)) {
            disguise = disguise.clone();
        }
        int id = ReflectionManager.getNewEntityId(false);
        DisguiseUtilities.addFutureDisguise(id, (TargetedDisguise)disguise);
        return id;
    }

    public static void disguiseToAll(Entity entity, Disguise disguise) {
        if (disguise.getEntity() != null) {
            disguise = disguise.clone();
        }
        ((TargetedDisguise)disguise).setDisguiseTarget(TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS);
        for (String observer : ((TargetedDisguise)disguise).getObservers()) {
            ((TargetedDisguise)disguise).removePlayer(observer);
        }
        DisguiseAPI.disguiseEntity(entity, disguise);
    }

    public static void disguiseToPlayers(Entity entity, Disguise disguise, Collection playersToViewDisguise) {
        if (disguise.getEntity() != null) {
            disguise = disguise.clone();
        }
        ((TargetedDisguise)disguise).setDisguiseTarget(TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS);
        for (Object obj : playersToViewDisguise) {
            if (obj instanceof String) {
                ((TargetedDisguise)disguise).addPlayer((String)obj);
                continue;
            }
            if (!(obj instanceof Player)) continue;
            ((TargetedDisguise)disguise).addPlayer(((Player)obj).getName());
        }
        DisguiseAPI.disguiseEntity(entity, disguise);
    }

    @Deprecated
    public static void disguiseToPlayers(Entity entity, Disguise disguise, List<String> playersToViewDisguise) {
        DisguiseAPI.disguiseToPlayers(entity, disguise, playersToViewDisguise);
    }

    public static void disguiseToPlayers(Entity entity, Disguise disguise, Player ... playersToViewDisguise) {
        DisguiseAPI.disguiseToPlayers(entity, disguise, Arrays.asList(playersToViewDisguise));
    }

    public static void disguiseToPlayers(Entity entity, Disguise disguise, String ... playersToViewDisguise) {
        DisguiseAPI.disguiseToPlayers(entity, disguise, Arrays.asList(playersToViewDisguise));
    }

    private static int firstCapital(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static Disguise getDisguise(Entity disguised) {
        if (disguised == null) {
            return null;
        }
        return DisguiseUtilities.getMainDisguise(disguised.getEntityId());
    }

    public static String parseToString(Disguise disguise, boolean outputSkin) {
        return DisguiseParser.parseToString(disguise, outputSkin);
    }

    public static String parseToString(Disguise disguise) {
        return DisguiseAPI.parseToString(disguise, true);
    }

    public static Disguise getDisguise(Player observer, Entity disguised) {
        if (disguised == null || observer == null) {
            return null;
        }
        return DisguiseUtilities.getDisguise(observer, disguised);
    }

    public static Disguise[] getDisguises(Entity disguised) {
        if (disguised == null) {
            return null;
        }
        return DisguiseUtilities.getDisguises(disguised.getEntityId());
    }

    public static int getSelfDisguiseId() {
        return selfDisguiseId;
    }

    public static boolean isDisguised(Entity disguised) {
        return DisguiseAPI.getDisguise(disguised) != null;
    }

    public static boolean isDisguised(Player observer, Entity disguised) {
        return DisguiseAPI.getDisguise(observer, disguised) != null;
    }

    public static boolean isDisguiseInUse(Disguise disguise) {
        return disguise.isDisguiseInUse();
    }

    public static boolean isSelfDisguised(Player player) {
        return DisguiseUtilities.getSelfDisguised().contains(player.getUniqueId());
    }

    public static boolean isViewSelfToggled(Entity entity) {
        return DisguiseAPI.hasSelfDisguisePreference(entity) != DisguiseConfig.isViewDisguises();
    }

    public static boolean isActionBarShown(Entity entity) {
        return !DisguiseAPI.hasActionBarPreference(entity);
    }

    public static boolean hasSelfDisguisePreference(Entity entity) {
        return DisguiseUtilities.getViewSelf().contains(entity.getUniqueId());
    }

    public static boolean hasActionBarPreference(Entity entity) {
        return DisguiseUtilities.getViewBar().contains(entity.getUniqueId());
    }

    public static void undisguiseToAll(Entity entity) {
        Disguise[] disguises;
        for (Disguise disguise : disguises = DisguiseAPI.getDisguises(entity)) {
            disguise.removeDisguise();
        }
    }

    public static void setViewDisguiseToggled(Entity entity, boolean canSeeSelfDisguises) {
        if (DisguiseAPI.isDisguised(entity)) {
            Disguise[] disguises;
            for (Disguise disguise : disguises = DisguiseAPI.getDisguises(entity)) {
                disguise.setViewSelfDisguise(canSeeSelfDisguises);
            }
        }
        if (!canSeeSelfDisguises == DisguiseConfig.isViewDisguises()) {
            if (!DisguiseAPI.hasSelfDisguisePreference(entity)) {
                DisguiseUtilities.getViewSelf().add(entity.getUniqueId());
                DisguiseUtilities.addSaveAttempt();
            }
        } else {
            DisguiseUtilities.getViewSelf().remove(entity.getUniqueId());
            DisguiseUtilities.addSaveAttempt();
        }
    }

    public static void setActionBarShown(Player player, boolean isShown) {
        if (DisguiseAPI.isDisguised((Entity)player)) {
            Disguise[] disguises;
            for (Disguise disguise : disguises = DisguiseAPI.getDisguises((Entity)player)) {
                disguise.setNotifyBar(isShown ? DisguiseConfig.getNotifyBar() : DisguiseConfig.NotifyBar.NONE);
            }
        }
        if (!isShown) {
            if (!DisguiseAPI.hasActionBarPreference((Entity)player)) {
                DisguiseUtilities.getViewBar().add(player.getUniqueId());
                DisguiseUtilities.addSaveAttempt();
            }
        } else {
            DisguiseUtilities.getViewBar().remove(player.getUniqueId());
            DisguiseUtilities.addSaveAttempt();
        }
    }

    private DisguiseAPI() {
    }

    public static int getEntityAttachmentId() {
        return entityAttachmentId;
    }
}

