/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.updates;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.updates.DisguiseUpdate;
import me.libraryaddict.disguise.utilities.updates.UpdateChecker;

public class LDGithub {
    private UpdateChecker checker;

    private String[] getBadUsers() {
        try {
            HashMap map;
            URL url = new URL("https://api.github.com/repos/libraryaddict/libsdisguises/issues/469");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("User-Agent", "libraryaddict/LibsDisguises");
            con.setRequestProperty("Accept", "application/vnd.github.v3+json");
            try (InputStream input = con.getInputStream();){
                String json = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                map = (HashMap)new Gson().fromJson(json, HashMap.class);
            }
            if (!map.containsKey("body")) {
                return new String[0];
            }
            return ((String)map.get("body")).split("(\\r|\\n)+");
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public DisguiseUpdate getLatestRelease() {
        try {
            GithubData gitData;
            String[] users;
            for (String s : users = this.getBadUsers()) {
                if (LibsPremium.getPaidInformation() != null && (s.equals(LibsPremium.getPaidInformation().getDownloadID()) || s.equals(LibsPremium.getPaidInformation().getUserID()))) {
                    LibsDisguises.getInstance().unregisterCommands(true);
                    continue;
                }
                if (LibsPremium.getUserID() == null || !s.equals(LibsPremium.getUserID()) && !s.equals(LibsPremium.getDownloadID())) continue;
                this.getChecker().setGoSilent(true);
            }
            if (!this.getChecker().isGoSilent()) {
                DisguiseUtilities.getLogger().info("Now looking for update on Github..");
            }
            URL url = new URL("https://api.github.com/repos/libraryaddict/LibsDisguises/releases/latest");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("User-Agent", "libraryaddict/LibsDisguises");
            con.setRequestProperty("Accept", "application/vnd.github.v3+json");
            try {
                GithubData.Asset[] assetArray = null;
                try (InputStream input = con.getInputStream();){
                    String json = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    gitData = (GithubData)new Gson().fromJson(json, GithubData.class);
                }
                catch (Throwable object) {
                    assetArray = object;
                    throw object;
                }
            }
            catch (IOException ex) {
                try (InputStream error = con.getErrorStream();){
                    String line = new BufferedReader(new InputStreamReader(error, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    DisguiseUtilities.getLogger().severe("Error with Github! " + line);
                    if (line.contains("rate limit") && !DisguiseConfig.isHittingRateLimit()) {
                        DisguiseConfig.setHittingRateLimit(true);
                        DisguiseUtilities.getLogger().severe("Changed update checker to be every 36 hours due to rate limiting from this IP");
                    }
                }
                catch (Exception ex1) {
                    DisguiseUtilities.getLogger().severe("Error when trying to read error stream! Inception!");
                    ex1.printStackTrace();
                }
                throw ex;
            }
            String download = null;
            for (GithubData.Asset asset : gitData.getAssets()) {
                if (!asset.getName().endsWith(".jar")) continue;
                download = asset.getBrowser_download_url();
                break;
            }
            if (download == null) {
                throw new IllegalStateException("Download url is missing");
            }
            return new GithubUpdate(gitData.getTag_name().replace("v", ""), gitData.getBody().split("(\\r|\\n)+"), download);
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Failed to check for a release on Github");
            ex.printStackTrace();
            return null;
        }
    }

    public LDGithub(UpdateChecker checker) {
        this.checker = checker;
    }

    public UpdateChecker getChecker() {
        return this.checker;
    }

    private class GithubData {
        String name;
        String tag_name;
        String body;
        Date published_at;
        Asset[] assets;

        private GithubData() {
        }

        public String getName() {
            return this.name;
        }

        public String getTag_name() {
            return this.tag_name;
        }

        public String getBody() {
            return this.body;
        }

        public Date getPublished_at() {
            return this.published_at;
        }

        public Asset[] getAssets() {
            return this.assets;
        }

        class Asset {
            String browser_download_url;
            String name;
            String content_type;

            Asset() {
            }

            public String getBrowser_download_url() {
                return this.browser_download_url;
            }

            public String getName() {
                return this.name;
            }

            public String getContent_type() {
                return this.content_type;
            }
        }
    }

    private class GithubUpdate
    implements DisguiseUpdate {
        private String version;
        private String[] changelog;
        private String download;
        private final Date fetched = new Date();

        @Override
        public boolean isReleaseBuild() {
            return true;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String[] getChangelog() {
            return this.changelog;
        }

        @Override
        public String getDownload() {
            return this.download;
        }

        @Override
        public Date getFetched() {
            return this.fetched;
        }

        public GithubUpdate(String version, String[] changelog, String download) {
            this.version = version;
            this.changelog = changelog;
            this.download = download;
        }
    }
}

