/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.modify;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseModifyPlayerCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        DisguisePermissions permissions = this.getPermissions(sender);
        if (!permissions.hasPermissions()) {
            sender.sendMessage(LibsMsg.NO_PERM.get(new Object[0]));
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, permissions);
            return true;
        }
        Player entityTarget = Bukkit.getPlayer((String)args[0]);
        if (entityTarget == null && args[0].contains("-")) {
            try {
                entityTarget = Bukkit.getEntity((UUID)UUID.fromString(args[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (entityTarget == null) {
            sender.sendMessage(LibsMsg.CANNOT_FIND_PLAYER.get(args[0]));
            return true;
        }
        Object[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        if (newArgs.length == 0) {
            this.sendCommandUsage(sender, permissions);
            return true;
        }
        Disguise disguise = null;
        if (sender instanceof Player) {
            disguise = DisguiseAPI.getDisguise((Player)sender, (Entity)entityTarget);
        }
        if (disguise == null) {
            disguise = DisguiseAPI.getDisguise((Entity)entityTarget);
        }
        if (disguise == null) {
            sender.sendMessage(LibsMsg.DMODPLAYER_NODISGUISE.get(entityTarget.getName()));
            return true;
        }
        DisguisePerm disguisePerm = new DisguisePerm(disguise.getType());
        if (!permissions.isAllowedDisguise(disguisePerm)) {
            sender.sendMessage(LibsMsg.DMODPLAYER_NOPERM.get(new Object[0]));
            return true;
        }
        String[] options = DisguiseUtilities.split(StringUtils.join((Object[])newArgs, (String)" "));
        options = DisguiseParser.parsePlaceholders(options, sender, (CommandSender)entityTarget);
        try {
            DisguiseParser.callMethods(sender, disguise, permissions, disguisePerm, new ArrayList<String>(), options, "DisguiseModifyPlayer");
        }
        catch (DisguiseParseException ex) {
            if (ex.getMessage() != null) {
                sender.sendMessage(ex.getMessage());
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
        sender.sendMessage(LibsMsg.DMODPLAYER_MODIFIED.get(entityTarget.getName()));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs = new ArrayList<String>();
        String[] args = this.getPreviousArgs(origArgs);
        DisguisePermissions perms = this.getPermissions(sender);
        if (!perms.hasPermissions()) {
            return tabs;
        }
        if (args.length == 0) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (sender instanceof Player && !((Player)sender).canSee(player)) continue;
                tabs.add(player.getName());
            }
        } else {
            Player player = Bukkit.getPlayer((String)args[0]);
            if (player == null) {
                return tabs;
            }
            Disguise disguise = null;
            if (sender instanceof Player) {
                disguise = DisguiseAPI.getDisguise((Player)sender, (Entity)player);
            }
            if (disguise == null) {
                disguise = DisguiseAPI.getDisguise((Entity)player);
            }
            if (disguise == null) {
                return tabs;
            }
            DisguisePerm disguiseType = new DisguisePerm(disguise.getType());
            tabs.addAll(this.getTabDisguiseOptions(sender, perms, disguiseType, args, 1, this.getCurrentArg(args)));
        }
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, DisguisePermissions permissions) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(permissions);
        sender.sendMessage(LibsMsg.DMODPLAYER_HELP1.get(new Object[0]));
        sender.sendMessage(LibsMsg.DMODIFY_HELP3.get(ChatColor.GREEN + StringUtils.join(allowedDisguises, (String)(ChatColor.RED + ", " + ChatColor.GREEN))));
    }
}

