/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.bukkit.Location;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.plugin.Plugin;

public class PacketListenerSounds
extends PacketAdapter {
    private static boolean cancelSound;

    public PacketListenerSounds(LibsDisguises plugin) {
        super((Plugin)plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.NAMED_SOUND_EFFECT, PacketType.Play.Server.ENTITY_STATUS});
    }

    public void onPacketSending(PacketEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.isAsync()) {
            return;
        }
        if (event.getPlayer().getName().contains("UNKNOWN[")) {
            return;
        }
        event.setPacket(event.getPacket().deepClone());
        StructureModifier mods = event.getPacket().getModifier();
        Player observer = event.getPlayer();
        if (event.getPacketType() == PacketType.Play.Server.NAMED_SOUND_EFFECT) {
            SoundGroup.SoundType soundType = null;
            Entity disguisedEntity = null;
            SoundGroup entitySound = null;
            Object soundEffectObj = mods.read(0);
            Disguise disguise = null;
            int[] soundCords = new int[]{(Integer)mods.read(2), (Integer)mods.read(3), (Integer)mods.read(4)};
            block2: for (Set<TargetedDisguise> disguises : DisguiseUtilities.getDisguises().values()) {
                for (TargetedDisguise entityDisguise : disguises) {
                    boolean hasInvun;
                    Location loc;
                    int[] entCords;
                    Entity entity = entityDisguise.getEntity();
                    if (entity == null || entity.getWorld() != observer.getWorld() || !entityDisguise.canSee(observer) || soundCords[0] != (entCords = new int[]{(int)((loc = entity.getLocation()).getX() * 8.0), (int)(loc.getY() * 8.0), (int)(loc.getZ() * 8.0)})[0] || soundCords[1] != entCords[1] || soundCords[2] != entCords[2] || (entitySound = SoundGroup.getGroup(entity.getType().name())) == null || (soundType = !(entity instanceof LivingEntity) || ((LivingEntity)entity).getHealth() > 0.0 ? entitySound.getType(soundEffectObj, !(hasInvun = ReflectionManager.hasInvul(entity))) : SoundGroup.SoundType.DEATH) == null) continue;
                    disguise = entityDisguise;
                    disguisedEntity = entity;
                    break block2;
                }
            }
            if (disguise != null && disguise.isSoundsReplaced() && (disguise.isSelfDisguiseSoundsReplaced() || disguisedEntity != observer)) {
                Object sound = null;
                SoundGroup disguiseSound = SoundGroup.getGroup(disguise);
                if (disguiseSound != null) {
                    sound = disguiseSound.getSound(soundType);
                }
                if (sound == null) {
                    event.setCancelled(true);
                } else {
                    mods.write(0, sound);
                    mods.write(1, (Object)ReflectionManager.getSoundCategory(disguise.getType()));
                    if (soundType == SoundGroup.SoundType.HURT || soundType == SoundGroup.SoundType.DEATH || soundType == SoundGroup.SoundType.IDLE) {
                        if (mods.read(5).equals(Float.valueOf(entitySound.getDamageAndIdleSoundVolume()))) {
                            mods.write(5, (Object)Float.valueOf(disguiseSound.getDamageAndIdleSoundVolume()));
                        }
                        if (disguise instanceof MobDisguise && disguisedEntity instanceof LivingEntity && ((MobDisguise)disguise).doesDisguiseAge()) {
                            boolean baby = false;
                            if (disguisedEntity instanceof Zombie) {
                                baby = ((Zombie)disguisedEntity).isBaby();
                            } else if (disguisedEntity instanceof Ageable) {
                                boolean bl = baby = !((Ageable)disguisedEntity).isAdult();
                            }
                            if (((MobDisguise)disguise).isAdult() == baby) {
                                float pitch = ((Float)mods.read(6)).floatValue();
                                if (baby) {
                                    if ((double)pitch < 1.5 || (double)pitch > 1.7) {
                                        return;
                                    }
                                    pitch = (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.5f;
                                } else {
                                    if (pitch < 1.0f || (double)pitch > 1.2) {
                                        return;
                                    }
                                    pitch = (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.0f;
                                }
                                mods.write(6, (Object)Float.valueOf(pitch));
                            }
                        }
                    }
                }
            }
        } else if (event.getPacketType() == PacketType.Play.Server.ENTITY_STATUS) {
            if ((Byte)mods.read(1) != 2) {
                return;
            }
            Disguise disguise = DisguiseUtilities.getDisguise(observer, (Integer)event.getPacket().getIntegers().read(0));
            if (disguise == null) {
                return;
            }
            Entity entity = disguise.getEntity();
            if (!disguise.getType().isPlayer() && (disguise.isSelfDisguiseSoundsReplaced() || entity != event.getPlayer())) {
                SoundGroup disSound = SoundGroup.getGroup(entity.getType().name());
                if (disSound == null) {
                    return;
                }
                SoundGroup.SoundType soundType = SoundGroup.SoundType.HURT;
                Object obj = null;
                if (entity instanceof LivingEntity && ((LivingEntity)entity).getHealth() == 0.0) {
                    soundType = SoundGroup.SoundType.DEATH;
                }
                if (disSound.getSound(soundType) == null || disguise.isSelfDisguiseSoundsReplaced() && entity == event.getPlayer()) {
                    Object sound;
                    if (disguise.isSelfDisguiseSoundsReplaced() && entity == event.getPlayer()) {
                        boolean bl = cancelSound = !cancelSound;
                        if (cancelSound) {
                            return;
                        }
                    }
                    if ((disSound = SoundGroup.getGroup(disguise)) != null && (sound = disSound.getSound(soundType)) != null) {
                        Location loc = entity.getLocation();
                        PacketContainer packet = new PacketContainer(PacketType.Play.Server.NAMED_SOUND_EFFECT);
                        mods = packet.getModifier();
                        mods.write(0, sound);
                        mods.write(1, (Object)ReflectionManager.getSoundCategory(disguise.getType()));
                        mods.write(2, (Object)((int)(loc.getX() * 8.0)));
                        mods.write(3, (Object)((int)(loc.getY() * 8.0)));
                        mods.write(4, (Object)((int)(loc.getZ() * 8.0)));
                        mods.write(5, (Object)Float.valueOf(disSound.getDamageAndIdleSoundVolume()));
                        float pitch = disguise instanceof MobDisguise && !((MobDisguise)disguise).isAdult() ? (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.5f : (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.0f;
                        if (disguise.getType() == DisguiseType.BAT) {
                            pitch *= 0.95f;
                        }
                        mods.write(6, (Object)Float.valueOf(pitch));
                        try {
                            ProtocolLibrary.getProtocolManager().sendServerPacket(observer, packet, false);
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

