/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LDUploadLogs
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Arrays.asList("uploadlog", "uploadlogs", "uploadconfig", "uploadconfigs", "logs");
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.isOp();
    }

    @Override
    public String getPermission() {
        return null;
    }

    @Override
    public void onCommand(final CommandSender sender, String[] args) {
        File latest = new File("logs/latest.log");
        final File disguises = new File(LibsDisguises.getInstance().getDataFolder(), "disguises.yml");
        final File config = new File(LibsDisguises.getInstance().getDataFolder(), "config.yml");
        if (this.isTooBig(latest)) {
            sender.sendMessage(ChatColor.RED + "Your latest.log file is too big! It should be less than 512kb! Please restart and run this command again!");
            return;
        }
        if (this.isTooBig(disguises)) {
            sender.sendMessage(ChatColor.RED + "Your disguises.yml is too big! You'll need to trim that file down before using this command! It should be less than 512kb!");
            return;
        }
        if (this.isTooBig(config)) {
            sender.sendMessage(ChatColor.RED + "Your config.yml is too big! It should be less than 512kb!");
            return;
        }
        try {
            int nextLine;
            final String latestText = new String(Files.readAllBytes(latest.toPath()));
            boolean valid = false;
            int lastFind = 0;
            for (int i = 0; i < 15 && (nextLine = latestText.indexOf("\n", lastFind)) != -1; ++i) {
                String str = latestText.substring(lastFind, nextLine);
                lastFind = nextLine + 2;
                if (!str.contains("Starting minecraft server version") && !str.contains("Loading properties") && !str.contains("This server is running")) continue;
                valid = true;
                break;
            }
            if (!valid) {
                sender.sendMessage(ChatColor.RED + "Your latest.log is too old! Please restart the server and try again!");
                return;
            }
            sender.sendMessage(ChatColor.GOLD + "Now creating pastebin links...");
            new BukkitRunnable(){

                public void run() {
                    try {
                        String disguiseText = new String(Files.readAllBytes(disguises.toPath()));
                        StringBuilder configText = new StringBuilder(new String(Files.readAllBytes(config.toPath())));
                        configText.append("\n================\n");
                        ArrayList<String> modified = DisguiseConfig.doOutput((ConfigurationSection)LibsDisguises.getInstance().getConfig(), true, true);
                        for (String s : modified) {
                            configText.append("\n").append(s);
                        }
                        if (modified.isEmpty()) {
                            configText.append("\nUsing default config!");
                        }
                        final URL latestPaste = new GuestPaste("latest.log", latestText).paste();
                        final URL configPaste = new GuestPaste("LibsDisguises config.yml", configText.toString()).paste();
                        final URL disguisesPaste = new GuestPaste("LibsDisguises disguises.yml", disguiseText).paste();
                        new BukkitRunnable(){

                            public void run() {
                                sender.sendMessage(ChatColor.GOLD + "Upload successful!");
                                if (sender instanceof Player) {
                                    sender.sendMessage(ChatColor.GOLD + "Click on the below message to have it appear in your chat input");
                                }
                                String text = "My log file: " + latestPaste + ", my config file: " + configPaste + " and my disguises file: " + disguisesPaste;
                                ComponentBuilder builder = new ComponentBuilder("");
                                builder.append(text);
                                builder.color(net.md_5.bungee.api.ChatColor.AQUA);
                                builder.event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, text));
                                sender.spigot().sendMessage(builder.create());
                            }
                        }.runTask((Plugin)LibsDisguises.getInstance());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        sender.sendMessage(ChatColor.RED + "Unexpected error! Upload failed! " + e.getMessage());
                    }
                }
            }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isTooBig(File file) {
        return file.exists() && file.length() >= 524288L;
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_UPLOAD_LOGS;
    }

    public class GuestPaste {
        private String name = null;
        private final String text;

        public GuestPaste(String name, String text) {
            this.name = name;
            this.text = text;
        }

        public URL paste() throws Exception {
            URL url = new URL("https://pastebin.com/api/api_post.php");
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "Mozilla/5.0");
            LinkedList<AbstractMap.SimpleEntry<String, String>> params = new LinkedList<AbstractMap.SimpleEntry<String, String>>();
            if (this.getClass().getName().contains("me.libraryaddict")) {
                params.add(new AbstractMap.SimpleEntry<String, String>("api_dev_key", "62067f9dcc1979a475105b529eb453a5"));
            }
            params.add(new AbstractMap.SimpleEntry<String, String>("api_option", "paste"));
            params.add(new AbstractMap.SimpleEntry<String, String>("api_paste_name", this.name));
            params.add(new AbstractMap.SimpleEntry<String, String>("api_paste_code", this.text));
            params.add(new AbstractMap.SimpleEntry<String, String>("api_paste_format", "text"));
            params.add(new AbstractMap.SimpleEntry<String, String>("api_paste_expire_date", "1M"));
            params.add(new AbstractMap.SimpleEntry<String, String>("api_paste_private", "1"));
            StringBuilder output = new StringBuilder();
            for (AbstractMap.SimpleEntry simpleEntry : params) {
                if (output.length() > 0) {
                    output.append('&');
                }
                output.append(URLEncoder.encode((String)simpleEntry.getKey(), "UTF-8"));
                output.append('=');
                output.append(URLEncoder.encode((String)simpleEntry.getValue(), "UTF-8"));
            }
            con.setDoOutput(true);
            Throwable throwable = null;
            try (DataOutputStream dos = new DataOutputStream(con.getOutputStream());){
                dos.writeBytes(output.toString());
                dos.flush();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            int status = con.getResponseCode();
            if (status >= 200 && status < 300) {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                    String inputLine;
                    StringBuilder response = new StringBuilder();
                    while ((inputLine = bufferedReader.readLine()) != null) {
                        response.append(inputLine);
                    }
                    URL uRL = new URL(response.toString());
                    return uRL;
                }
            }
            throw new IllegalStateException("Unexpected response code " + status);
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return this.text;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GuestPaste)) {
                return false;
            }
            GuestPaste other = (GuestPaste)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GuestPaste;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        public String toString() {
            return "LDUploadLogs.GuestPaste(name=" + this.getName() + ", text=" + this.getText() + ")";
        }
    }
}

