/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packethandlers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.PacketsHandler;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class PacketHandlerEquipment
implements IPacketHandler {
    private PacketsHandler packetsHandler;

    public PacketHandlerEquipment(PacketsHandler packetsHandler) {
        this.packetsHandler = packetsHandler;
    }

    @Override
    public PacketType[] getHandledPackets() {
        return new PacketType[]{PacketType.Play.Server.ENTITY_EQUIPMENT};
    }

    @Override
    public void handle(Disguise disguise, PacketContainer sentPacket, LibsPackets packets, Player observer, Entity entity) {
        if (NmsVersion.v1_16.isSupported()) {
            this.handleNew(disguise, sentPacket, packets, observer, entity);
        } else {
            this.handleOld(disguise, sentPacket, packets, observer, entity);
        }
    }

    public void handleNew(Disguise disguise, PacketContainer sentPacket, LibsPackets packets, Player observer, Entity entity) {
        List slots = (List)packets.getPackets().get(0).getModifier().read(1);
        ArrayList<Pair> newSlots = new ArrayList<Pair>();
        boolean constructed = false;
        for (Pair pair : slots) {
            EquipmentSlot slot = ReflectionManager.createEquipmentSlot(pair.getFirst());
            ItemStack itemStack = disguise.getWatcher().getItemStack(slot);
            if (itemStack != null) {
                if (!constructed) {
                    constructed = true;
                    if (packets.getPackets().size() > 1) {
                        packets.getPackets().remove(1);
                    } else {
                        packets.clear();
                    }
                    PacketContainer equipPacket = sentPacket.shallowClone();
                    packets.getPackets().add(packets.getPackets().size(), equipPacket);
                    equipPacket.getModifier().write(1, newSlots);
                }
                newSlots.add(Pair.of((Object)pair.getFirst(), (Object)ReflectionManager.getNmsItem(itemStack.getType() == Material.AIR ? null : itemStack)));
            } else {
                newSlots.add(pair);
            }
            if (!disguise.getWatcher().isRightClicking() || slot != EquipmentSlot.HAND && slot != EquipmentSlot.OFF_HAND || (itemStack = ReflectionManager.getBukkitItem(pair.getSecond())) == null || itemStack.getType() == Material.AIR) continue;
            List<WrappedWatchableObject> list = new ArrayList<WrappedWatchableObject>();
            if (DisguiseConfig.isMetaPacketsEnabled()) {
                WrappedWatchableObject watch = ReflectionManager.createWatchable(MetaIndex.LIVING_HAND, WrappedDataWatcher.getEntityWatcher((Entity)entity).getByte(MetaIndex.LIVING_HAND.getIndex()));
                if (watch != null) {
                    list.add(watch);
                }
                list = disguise.getWatcher().convert(list);
            } else {
                for (WrappedWatchableObject obj : disguise.getWatcher().getWatchableObjects()) {
                    if (obj.getIndex() != MetaIndex.LIVING_HAND.getIndex()) continue;
                    list.add(obj);
                    break;
                }
            }
            PacketContainer packetBlock = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
            packetBlock.getModifier().write(0, (Object)entity.getEntityId());
            packetBlock.getWatchableCollectionModifier().write(0, list);
            PacketContainer packetUnblock = packetBlock.deepClone();
            for (WrappedWatchableObject watcher : (List)packetUnblock.getWatchableCollectionModifier().read(0)) {
                watcher.setValue((Object)0);
            }
            PacketContainer packet1 = packets.getPackets().get(0);
            packets.clear();
            packets.addPacket(packetUnblock);
            packets.addPacket(packet1);
            packets.addPacket(packetBlock);
        }
    }

    public void handleOld(Disguise disguise, PacketContainer sentPacket, LibsPackets packets, Player observer, Entity entity) {
        ItemStack heldItem;
        EquipmentSlot slot = ReflectionManager.createEquipmentSlot(packets.getPackets().get(0).getModifier().read(1));
        ItemStack itemStack = disguise.getWatcher().getItemStack(slot);
        if (itemStack != null) {
            packets.clear();
            PacketContainer equipPacket = sentPacket.shallowClone();
            packets.addPacket(equipPacket);
            equipPacket.getModifier().write(2, ReflectionManager.getNmsItem(itemStack.getType() == Material.AIR ? null : itemStack));
        }
        if (disguise.getWatcher().isRightClicking() && (slot == EquipmentSlot.HAND || slot == EquipmentSlot.OFF_HAND) && (heldItem = (ItemStack)packets.getPackets().get(0).getItemModifier().read(0)) != null && heldItem.getType() != Material.AIR) {
            MetaIndex<Byte> toUse;
            List<WrappedWatchableObject> list = new ArrayList<WrappedWatchableObject>();
            MetaIndex<Byte> metaIndex = toUse = NmsVersion.v1_13.isSupported() ? MetaIndex.LIVING_HAND : MetaIndex.ENTITY_META;
            if (DisguiseConfig.isMetaPacketsEnabled()) {
                WrappedWatchableObject watch = ReflectionManager.createWatchable(toUse, WrappedDataWatcher.getEntityWatcher((Entity)entity).getByte(toUse.getIndex()));
                if (watch != null) {
                    list.add(watch);
                }
                list = disguise.getWatcher().convert(list);
            } else {
                for (WrappedWatchableObject obj : disguise.getWatcher().getWatchableObjects()) {
                    if (obj.getIndex() != toUse.getIndex()) continue;
                    list.add(obj);
                    break;
                }
            }
            PacketContainer packetBlock = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
            packetBlock.getModifier().write(0, (Object)entity.getEntityId());
            packetBlock.getWatchableCollectionModifier().write(0, list);
            PacketContainer packetUnblock = packetBlock.deepClone();
            for (WrappedWatchableObject watcher : (List)packetUnblock.getWatchableCollectionModifier().read(0)) {
                if (NmsVersion.v1_13.isSupported()) {
                    watcher.setValue((Object)0);
                    continue;
                }
                watcher.setValue((Object)((byte)((Byte)watcher.getValue() & 0xFFFFFFEF)));
            }
            PacketContainer packet1 = packets.getPackets().get(0);
            packets.clear();
            packets.addPacket(packetUnblock);
            packets.addPacket(packet1);
            packets.addPacket(packetBlock);
        }
    }
}

