/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.listeners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.events.UndisguiseEvent;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerSkinHandler
implements Listener {
    private final Cache<Player, List<PlayerSkin>> cache = CacheBuilder.newBuilder().weakKeys().expireAfterWrite(30L, TimeUnit.SECONDS).removalListener(event -> {
        if (event.getCause() != RemovalCause.EXPIRED) {
            return;
        }
        List skins = (List)event.getValue();
        for (PlayerSkin skin : skins) {
            this.doPacketRemoval((Player)event.getKey(), skin);
        }
        skins.clear();
    }).build();

    public PlayerSkinHandler() {
        new BukkitRunnable(){

            public void run() {
                PlayerSkinHandler.this.getCache().asMap().forEach((key, value) -> PlayerSkinHandler.this.doTeleport(key, value));
            }
        }.runTaskTimer((Plugin)LibsDisguises.getInstance(), 1L, 1L);
    }

    public PlayerSkin addPlayerSkin(Player player, PlayerDisguise disguise) {
        this.tryProcess(player, false);
        ArrayList<PlayerSkin> skins = (ArrayList<PlayerSkin>)this.getCache().getIfPresent((Object)player);
        if (skins == null) {
            skins = new ArrayList<PlayerSkin>();
        }
        PlayerSkin toReturn = new PlayerSkin(new WeakReference<PlayerDisguise>(disguise));
        skins.add(toReturn);
        this.getCache().put((Object)player, skins);
        return toReturn;
    }

    private void doTeleport(Player player, List<PlayerSkin> value) {
        if (player == null || !player.isOnline()) {
            return;
        }
        Location loc = player.getLocation();
        loc.add(loc.getDirection().normalize().multiply(10));
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        packet.getModifier().write(1, (Object)loc.getX());
        packet.getModifier().write(2, (Object)loc.getY());
        packet.getModifier().write(3, (Object)loc.getZ());
        for (PlayerSkin skin : value) {
            PlayerDisguise disguise;
            if (!skin.isSleepPackets() || (disguise = (PlayerDisguise)skin.getDisguise().get()) == null || !disguise.isDisguiseInUse()) continue;
            packet = packet.shallowClone();
            int id = disguise.getEntity().getEntityId();
            if (id == player.getEntityId()) {
                id = DisguiseAPI.getSelfDisguiseId();
            }
            packet.getModifier().write(0, (Object)id);
            try {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet, false);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void handlePackets(Player player, PlayerDisguise disguise, LibsPackets packets) {
        if (packets.getPackets().stream().anyMatch(p -> p.getType() == PacketType.Play.Server.NAMED_ENTITY_SPAWN)) {
            return;
        }
        List skins = (List)this.getCache().getIfPresent((Object)player);
        if (skins == null) {
            return;
        }
        PlayerSkin skin = skins.stream().filter(s -> s.getDisguise().get() == disguise).findAny().orElse(null);
        if (skin == null || !skin.isSleepPackets()) {
            return;
        }
        packets.getPackets().removeIf(packet -> this.isRemove(skin, (PacketContainer)packet));
        packets.getDelayedPacketsMap().entrySet().removeIf(entry -> {
            ((ArrayList)entry.getValue()).removeIf(packet -> this.isRemove(skin, (PacketContainer)packet));
            return ((ArrayList)entry.getValue()).isEmpty();
        });
    }

    private boolean isRemove(PlayerSkin skin, PacketContainer packetContainer) {
        PacketType type = packetContainer.getType();
        if (type != PacketType.Play.Server.ENTITY_EQUIPMENT && type != PacketType.Play.Server.ENTITY_METADATA) {
            return false;
        }
        if (type == PacketType.Play.Server.ENTITY_EQUIPMENT) {
            skin.getSleptPackets().computeIfAbsent(3, a -> new ArrayList()).add(packetContainer);
        }
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onUndisguise(UndisguiseEvent event) {
        if (!event.getDisguise().isPlayerDisguise()) {
            return;
        }
        PlayerDisguise disguise = (PlayerDisguise)event.getDisguise();
        for (Player player : DisguiseUtilities.getPerverts(disguise)) {
            PlayerSkin skin;
            List skins = (List)this.getCache().getIfPresent((Object)player);
            if (skins == null || (skin = (PlayerSkin)skins.stream().filter(s -> s.getDisguise().get() == disguise).findAny().orElse(null)) == null) continue;
            this.doPacketRemoval(player, skin);
            if (skins.size() == 1) {
                this.getCache().invalidate((Object)player);
                continue;
            }
            skins.remove(skin);
        }
    }

    private void addTeleport(Player player, PlayerSkin skin) {
        int id;
        PlayerDisguise disguise = (PlayerDisguise)skin.getDisguise().get();
        PacketContainer teleport = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        StructureModifier mods = teleport.getModifier();
        Location loc = disguise.getEntity().getLocation();
        Float pitchLock = DisguiseConfig.isMovementPacketsEnabled() ? disguise.getWatcher().getPitchLock() : null;
        Float yawLock = DisguiseConfig.isMovementPacketsEnabled() ? disguise.getWatcher().getYawLock() : null;
        byte yaw = (byte)((yawLock == null ? loc.getYaw() : yawLock.floatValue()) * 256.0f / 360.0f);
        byte pitch = (byte)((pitchLock == null ? loc.getPitch() : pitchLock.floatValue()) * 256.0f / 360.0f);
        if (DisguiseConfig.isMovementPacketsEnabled()) {
            if (yawLock == null) {
                yaw = DisguiseUtilities.getYaw(DisguiseType.getType(disguise.getEntity().getType()), yaw);
            }
            if (pitchLock == null) {
                pitch = DisguiseUtilities.getPitch(DisguiseType.getType(disguise.getEntity().getType()), pitch);
            }
            yaw = DisguiseUtilities.getYaw(disguise.getType(), yaw);
            pitch = DisguiseUtilities.getPitch(disguise.getType(), pitch);
        }
        if ((id = disguise.getEntity().getEntityId()) == player.getEntityId()) {
            id = DisguiseAPI.getSelfDisguiseId();
        }
        mods.write(0, (Object)id);
        mods.write(1, (Object)loc.getX());
        mods.write(2, (Object)(loc.getY() + DisguiseUtilities.getYModifier(disguise)));
        mods.write(3, (Object)loc.getZ());
        mods.write(4, (Object)yaw);
        mods.write(5, (Object)pitch);
        skin.getSleptPackets().computeIfAbsent(0, a -> new ArrayList()).add(teleport);
    }

    private void doPacketRemoval(final Player player, PlayerSkin skin) {
        final PlayerDisguise disguise = (PlayerDisguise)skin.getDisguise().get();
        if (disguise == null) {
            return;
        }
        if (skin.isSleepPackets()) {
            this.addTeleport(player, skin);
        }
        try {
            for (final Map.Entry<Integer, ArrayList<PacketContainer>> entry : skin.getSleptPackets().entrySet()) {
                if (entry.getKey() == 0) {
                    for (PacketContainer packet : entry.getValue()) {
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet, false);
                    }
                    continue;
                }
                new BukkitRunnable(){

                    public void run() {
                        try {
                            if (!disguise.isDisguiseInUse()) {
                                return;
                            }
                            for (PacketContainer packet : (ArrayList)entry.getValue()) {
                                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet, false);
                            }
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                }.runTaskLater((Plugin)LibsDisguises.getInstance(), (long)entry.getKey().intValue());
            }
            if (skin.isDoTabList()) {
                PacketContainer packetContainer = DisguiseUtilities.getTabPacket(disguise, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void tryProcess(Player player, boolean onMove) {
        List skins = (List)this.getCache().getIfPresent((Object)player);
        if (skins == null) {
            return;
        }
        ArrayList<PlayerSkin> removed = new ArrayList<PlayerSkin>();
        skins.removeIf(skin -> {
            if (!skin.canRemove(onMove)) {
                return false;
            }
            removed.add((PlayerSkin)skin);
            return true;
        });
        removed.forEach(skin -> this.doPacketRemoval(player, (PlayerSkin)skin));
        if (!skins.isEmpty()) {
            return;
        }
        this.getCache().invalidate((Object)player);
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        this.tryProcess(event.getPlayer(), true);
    }

    public Cache<Player, List<PlayerSkin>> getCache() {
        return this.cache;
    }

    public static class PlayerSkin {
        private final long firstPacketSent = System.currentTimeMillis();
        private final WeakReference<PlayerDisguise> disguise;
        private final HashMap<Integer, ArrayList<PacketContainer>> sleptPackets = new HashMap();
        private boolean doTabList = true;
        private boolean sleepPackets;

        public boolean canRemove(boolean onMoved) {
            return this.firstPacketSent + (long)(DisguiseConfig.getTablistRemoveDelay() * 50) + (onMoved ? 0L : TimeUnit.SECONDS.toMillis(5L)) < System.currentTimeMillis();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlayerSkin that = (PlayerSkin)o;
            return this.getDisguise().get() == that.getDisguise().get();
        }

        public PlayerSkin(WeakReference<PlayerDisguise> disguise) {
            this.disguise = disguise;
        }

        public WeakReference<PlayerDisguise> getDisguise() {
            return this.disguise;
        }

        public HashMap<Integer, ArrayList<PacketContainer>> getSleptPackets() {
            return this.sleptPackets;
        }

        public boolean isDoTabList() {
            return this.doTabList;
        }

        public void setDoTabList(boolean doTabList) {
            this.doTabList = doTabList;
        }

        public boolean isSleepPackets() {
            return this.sleepPackets;
        }

        public void setSleepPackets(boolean sleepPackets) {
            this.sleepPackets = sleepPackets;
        }
    }
}

