/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.listeners;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.events.UndisguiseEvent;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerSkinHandler
implements Listener {
    private final Cache<Player, List<PlayerSkin>> cache = CacheBuilder.newBuilder().weakKeys().expireAfterWrite(30L, TimeUnit.SECONDS).removalListener(event -> {
        if (event.getCause() != RemovalCause.EXPIRED) {
            return;
        }
        List skins = (List)event.getValue();
        for (PlayerSkin skin : skins) {
            PlayerDisguise disguise = (PlayerDisguise)skin.disguise.get();
            if (disguise == null) {
                return;
            }
            this.doPacketRemoval((Player)event.getKey(), disguise);
        }
        skins.clear();
    }).build();

    public void addPlayerSkin(Player player, PlayerDisguise disguise) {
        this.tryProcess(player);
        ArrayList<PlayerSkin> skins = (ArrayList<PlayerSkin>)this.getCache().getIfPresent((Object)player);
        if (skins == null) {
            skins = new ArrayList<PlayerSkin>();
        }
        skins.add(new PlayerSkin(new WeakReference<PlayerDisguise>(disguise)));
        this.getCache().put((Object)player, skins);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onUndisguise(UndisguiseEvent event) {
        if (!event.getDisguise().isPlayerDisguise()) {
            return;
        }
        PlayerDisguise disguise = (PlayerDisguise)event.getDisguise();
        for (Player player : DisguiseUtilities.getPerverts(disguise)) {
            PlayerSkin skin;
            List skins = (List)this.getCache().getIfPresent((Object)player);
            if (skins == null || (skin = (PlayerSkin)skins.stream().filter(s -> s.getDisguise().get() == disguise).findAny().orElse(null)) == null) continue;
            this.doPacketRemoval(player, disguise);
            if (skins.size() == 1) {
                this.getCache().invalidate((Object)player);
                continue;
            }
            skins.remove(skin);
        }
    }

    private void doPacketRemoval(Player player, PlayerDisguise disguise) {
        if (disguise == null) {
            return;
        }
        PacketContainer packetContainer = DisguiseUtilities.getTabPacket(disguise, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void tryProcess(Player player) {
        List skins = (List)this.getCache().getIfPresent((Object)player);
        if (skins == null) {
            return;
        }
        ArrayList<PlayerDisguise> removed = new ArrayList<PlayerDisguise>();
        skins.removeIf(skin -> {
            if (!skin.canRemove()) {
                return false;
            }
            removed.add((PlayerDisguise)skin.getDisguise().get());
            return true;
        });
        removed.forEach(disguise -> this.doPacketRemoval(player, (PlayerDisguise)disguise));
        if (!skins.isEmpty()) {
            return;
        }
        this.getCache().invalidate((Object)player);
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        this.tryProcess(event.getPlayer());
    }

    public Cache<Player, List<PlayerSkin>> getCache() {
        return this.cache;
    }

    private static class PlayerSkin {
        private final long firstPacketSent = System.currentTimeMillis();
        private final WeakReference<PlayerDisguise> disguise;

        public boolean canRemove() {
            return this.firstPacketSent + (long)(DisguiseConfig.getTablistRemoveDelay() * 50) < System.currentTimeMillis();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlayerSkin that = (PlayerSkin)o;
            return this.getDisguise().get() == that.getDisguise().get();
        }

        public PlayerSkin(WeakReference<PlayerDisguise> disguise) {
            this.disguise = disguise;
        }

        public WeakReference<PlayerDisguise> getDisguise() {
            return this.disguise;
        }
    }
}

