/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.listeners;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsEntityInteract;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.modded.ModdedEntity;
import me.libraryaddict.disguise.utilities.modded.ModdedManager;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.math.RandomUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DisguiseListener
implements Listener {
    private HashMap<String, LibsEntityInteract> interactions = new HashMap();
    private HashMap<String, BukkitRunnable> disguiseRunnable = new HashMap();
    private LibsDisguises plugin;

    public DisguiseListener(LibsDisguises libsDisguises) {
        this.plugin = libsDisguises;
        this.runUpdateScheduler();
        if (!LibsPremium.getPluginInformation().isPremium() || LibsPremium.getPluginInformation().getUserID().matches("[0-9]+")) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                Disguise[] disguises = DisguiseUtilities.getSavedDisguises(entity.getUniqueId(), true);
                if (disguises.length <= 0) continue;
                DisguiseUtilities.resetPluginTimer();
                for (Disguise disguise : disguises) {
                    disguise.setEntity(entity);
                    disguise.startDisguise();
                }
            }
        }
    }

    private boolean isCheckReleases() {
        if (DisguiseConfig.getUpdatesBranch() == DisguiseConfig.UpdatesBranch.RELEASES) {
            return true;
        }
        if (DisguiseConfig.getUpdatesBranch() == DisguiseConfig.UpdatesBranch.SAME_BUILDS && this.plugin.isReleaseBuild()) {
            return true;
        }
        return !this.plugin.isNumberedBuild();
    }

    private void runUpdateScheduler() {
        boolean autoUpdate = this.plugin.getConfig().getBoolean("AutoUpdateDev");
        if (!this.plugin.getConfig().getBoolean("NotifyUpdate")) {
            return;
        }
        if (autoUpdate && !this.isCheckReleases()) {
            DisguiseUtilities.getLogger().info("Plugin will attempt to auto update when new builds are ready! Check config to disable.");
        }
    }

    public void cleanup() {
        for (BukkitRunnable r : this.disguiseRunnable.values()) {
            r.cancel();
        }
        this.interactions.clear();
    }

    private void checkPlayerCanBlowDisguise(Player player) {
        Disguise[] disguises = DisguiseAPI.getDisguises((Entity)player);
        if (disguises.length > 0) {
            DisguiseAPI.undisguiseToAll((Entity)player);
            LibsMsg.BLOWN_DISGUISE.send((CommandSender)player, new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVelocity(PlayerVelocityEvent event) {
        DisguiseUtilities.setPlayerVelocity(event.getPlayer());
        if (LibsPremium.getUserID().equals("12345")) {
            event.setVelocity(event.getVelocity().multiply(5));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onAttack(EntityDamageByEntityEvent event) {
        Entity attacker = event.getDamager();
        if (attacker instanceof Projectile && ((Projectile)attacker).getShooter() instanceof Player) {
            attacker = (Entity)((Projectile)attacker).getShooter();
        }
        if ("%%__USER__%%".equals("12345")) {
            event.setDamage(0.5);
            event.setCancelled(false);
        }
        if (event.getEntityType() != EntityType.PLAYER && !(attacker instanceof Player)) {
            return;
        }
        if (event.getEntity() instanceof Player && DisguiseConfig.isDisguiseBlownWhenAttacked()) {
            this.checkPlayerCanBlowDisguise((Player)event.getEntity());
        }
        this.checkPlayerCanFight(event, attacker);
        if (attacker instanceof Player && DisguiseConfig.isDisguiseBlownWhenAttacking()) {
            this.checkPlayerCanBlowDisguise((Player)attacker);
        }
    }

    private boolean canRetaliate(Entity entity) {
        return entity.hasMetadata("LD-LastAttacked") && (double)((MetadataValue)entity.getMetadata("LD-LastAttacked").get(0)).asLong() + DisguiseConfig.getPvPTimer() * 1000.0 > (double)System.currentTimeMillis();
    }

    private void setRetaliation(Entity entity) {
        entity.removeMetadata("LD-LastAttacked", (Plugin)LibsDisguises.getInstance());
        entity.setMetadata("LD-LastAttacked", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), (Object)System.currentTimeMillis()));
    }

    private void checkPlayerCanFight(EntityDamageByEntityEvent event, Entity attacker) {
        boolean pvp;
        boolean bl = pvp = attacker instanceof Player && event.getEntity() instanceof Player;
        if (pvp ? !DisguiseConfig.isDisablePvP() : !DisguiseConfig.isDisablePvE()) {
            return;
        }
        if (!(attacker.hasPermission("libsdisguises." + (pvp ? "pvp" : "pve")) || attacker.hasPermission("libsdisguises." + (pvp ? "pvp" : "pve")) || DisguiseConfig.isRetaliationCombat() && this.canRetaliate(attacker))) {
            long lastDisguised;
            Disguise[] disguises = DisguiseAPI.getDisguises(attacker);
            if (disguises.length > 0) {
                event.setCancelled(true);
                LibsMsg.CANT_ATTACK_DISGUISED.send((CommandSender)attacker, new Object[0]);
            } else if (DisguiseConfig.getPvPTimer() > 0.0 && attacker.hasMetadata("LastDisguise") && (double)(lastDisguised = ((MetadataValue)attacker.getMetadata("LastDisguise").get(0)).asLong()) + DisguiseConfig.getPvPTimer() * 1000.0 > (double)System.currentTimeMillis()) {
                event.setCancelled(true);
                LibsMsg.CANT_ATTACK_DISGUISED_RECENTLY.send((CommandSender)attacker, new Object[0]);
            }
        }
        if (!event.isCancelled() && DisguiseConfig.isRetaliationCombat()) {
            this.setRetaliation(event.getEntity());
            this.setRetaliation(attacker);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (!"%%__USER__%%".equals("12345")) {
            return;
        }
        event.setCancelled(false);
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            event.setDamage(event.getDamage() * 3.0);
        } else {
            event.setDamage(new Random().nextDouble() * 8.0);
        }
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (Entity entity : event.getChunk().getEntities()) {
            Disguise[] disguises = DisguiseAPI.getDisguises(entity);
            if (disguises.length <= 0) continue;
            DisguiseUtilities.saveDisguises(entity.getUniqueId(), disguises);
        }
    }

    @EventHandler
    public void onChunkUnload(WorldUnloadEvent event) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (Entity entity : event.getWorld().getEntities()) {
            Disguise[] disguises;
            if (entity instanceof Player || (disguises = DisguiseAPI.getDisguises(entity)).length <= 0) continue;
            DisguiseUtilities.saveDisguises(entity.getUniqueId(), disguises);
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (Entity entity : event.getChunk().getEntities()) {
            Disguise[] disguises = DisguiseUtilities.getSavedDisguises(entity.getUniqueId(), true);
            if (disguises.length <= 0) continue;
            DisguiseUtilities.resetPluginTimer();
            for (Disguise disguise : disguises) {
                disguise.setEntity(entity);
                disguise.startDisguise();
            }
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (Entity entity : event.getWorld().getEntities()) {
            Disguise[] disguises = DisguiseUtilities.getSavedDisguises(entity.getUniqueId(), true);
            if (disguises.length <= 0) continue;
            DisguiseUtilities.resetPluginTimer();
            for (Disguise disguise : disguises) {
                disguise.setEntity(entity);
                disguise.startDisguise();
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Disguise[] version;
        String requiredProtocolLib;
        final Player p = event.getPlayer();
        p.removeMetadata("ld_loggedin", (Plugin)LibsDisguises.getInstance());
        this.plugin.getUpdateChecker().notifyUpdate((CommandSender)p);
        if ((p.isOp() || p.hasPermission("minecraft.command.op") || new DisguisePermissions((Permissible)p, "disguiseradius").hasPermissions()) && DisguiseUtilities.isOlderThan(requiredProtocolLib = DisguiseUtilities.getProtocolLibRequiredVersion(), (String)(version = ProtocolLibrary.getPlugin().getDescription().getVersion()))) {
            new BukkitRunnable((String)version, requiredProtocolLib){
                final /* synthetic */ String val$version;
                final /* synthetic */ String val$requiredProtocolLib;
                {
                    this.val$version = string;
                    this.val$requiredProtocolLib = string2;
                }

                public void run() {
                    if (!p.isOnline()) {
                        this.cancel();
                        return;
                    }
                    p.sendMessage(ChatColor.RED + "Update your ProtocolLib! You are running " + this.val$version + " but the minimum version you should be on is " + this.val$requiredProtocolLib + "!");
                    p.sendMessage(ChatColor.RED + "https://ci.dmulloy2.net/job/ProtocolLib/lastSuccessfulBuild/artifact/target/ProtocolLib.jar");
                    p.sendMessage(ChatColor.RED + "Or! Use /ld updateprotocollib - To update to the latest development build");
                    p.sendMessage(ChatColor.DARK_GREEN + "This message is `kindly` provided by Lib's Disguises on repeat due to the sheer number of people who don't see it");
                }
            }.runTaskTimer((Plugin)LibsDisguises.getInstance(), 10L, 12000L);
        }
        if (DisguiseConfig.isSavePlayerDisguises()) {
            Disguise[] disguises = DisguiseUtilities.getSavedDisguises(p.getUniqueId(), true);
            if (disguises.length > 0) {
                DisguiseUtilities.resetPluginTimer();
            }
            for (Disguise disguise : disguises) {
                disguise.setEntity((Entity)p);
                disguise.startDisguise();
            }
        }
        for (Set<TargetedDisguise> disguiseList : DisguiseUtilities.getDisguises().values()) {
            for (TargetedDisguise targetedDisguise : disguiseList) {
                Disguise disguise;
                if (targetedDisguise.getEntity() == null || !targetedDisguise.canSee(p) || !(targetedDisguise instanceof PlayerDisguise) || !((PlayerDisguise)(disguise = (PlayerDisguise)targetedDisguise)).isDisplayedInTab()) continue;
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(p, DisguiseUtilities.getTabPacket((PlayerDisguise)disguise, EnumWrappers.PlayerInfoAction.ADD_PLAYER));
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        new BukkitRunnable(){

            public void run() {
                WrappedGameProfile profile;
                if (!p.isOnline()) {
                    return;
                }
                DisguiseUtilities.registerNoName(p.getScoreboard());
                if (p.getScoreboard() != Bukkit.getScoreboardManager().getMainScoreboard()) {
                    DisguiseUtilities.registerAllExtendedNames(p.getScoreboard());
                }
                if (!p.hasMetadata("forge_mods")) {
                    Optional<ModdedEntity> required = ModdedManager.getEntities().values().stream().filter(c -> c.getMod() != null && c.getRequired() != null).findAny();
                    required.ifPresent(customEntity -> p.kickPlayer(customEntity.getRequired()));
                }
                if (DisguiseConfig.isSaveGameProfiles() && DisguiseConfig.isUpdateGameProfiles() && DisguiseUtilities.hasGameProfile(p.getName()) && !(profile = WrappedGameProfile.fromPlayer((Player)p)).getProperties().isEmpty()) {
                    DisguiseUtilities.addGameProfile(p.getName(), profile);
                }
            }
        }.runTaskLater((Plugin)LibsDisguises.getInstance(), 20L);
        new BukkitRunnable(){

            public void run() {
                if (!p.isOnline()) {
                    return;
                }
                if (!p.hasMetadata("forge_mods")) {
                    Optional<ModdedEntity> required = ModdedManager.getEntities().values().stream().filter(c -> c.getMod() != null && c.getRequired() != null).findAny();
                    required.ifPresent(customEntity -> p.kickPlayer(customEntity.getRequired()));
                }
            }
        }.runTaskLater((Plugin)LibsDisguises.getInstance(), 60L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent event) {
        Disguise disguise;
        if (("%%__USER__%%".isEmpty() || DisguiseUtilities.isInvalidFile()) && !event.getPlayer().isOp() && RandomUtils.nextDouble() < 0.01) {
            event.setCancelled(true);
        }
        if (DisguiseConfig.isModifyBoundingBox() && event.getFrom().distanceSquared(event.getTo()) > 0.2) {
            disguise = DisguiseAPI.getDisguise((Entity)event.getPlayer());
            if (disguise == null || !disguise.isModifyBoundingBox()) {
                return;
            }
            DisguiseUtilities.doBoundingBox((TargetedDisguise)disguise);
        }
        if (DisguiseConfig.isStopShulkerDisguisesFromMoving() && (disguise = DisguiseAPI.getDisguise((Entity)event.getPlayer())) != null && disguise.getType() == DisguiseType.SHULKER) {
            Location from = event.getFrom();
            Location to = event.getTo();
            to.setX(from.getX());
            to.setZ(from.getZ());
            event.setTo(to);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        DisguiseUtilities.removeSelfDisguiseScoreboard(player);
        if (!DisguiseConfig.isSavePlayerDisguises()) {
            return;
        }
        Disguise[] disguises = DisguiseAPI.getDisguises((Entity)player);
        if (disguises.length <= 0) {
            return;
        }
        DisguiseUtilities.saveDisguises(player.getUniqueId(), disguises);
    }

    @EventHandler
    public void onRightClick(PlayerInteractEntityEvent event) {
        Player p = event.getPlayer();
        if (!this.interactions.containsKey(p.getName())) {
            return;
        }
        event.setCancelled(true);
        this.disguiseRunnable.remove(p.getName()).cancel();
        Entity entity = event.getRightClicked();
        this.interactions.remove(p.getName()).onInteract(p, entity);
    }

    @EventHandler
    public void onRightClick(PlayerInteractAtEntityEvent event) {
        Player p = event.getPlayer();
        if (!this.interactions.containsKey(p.getName())) {
            return;
        }
        event.setCancelled(true);
        this.disguiseRunnable.remove(p.getName()).cancel();
        Entity entity = event.getRightClicked();
        this.interactions.remove(p.getName()).onInteract(p, entity);
    }

    @EventHandler
    public void onTarget(EntityTargetEvent event) {
        if (event.getTarget() == null) {
            return;
        }
        switch (event.getReason()) {
            case TARGET_ATTACKED_ENTITY: 
            case TARGET_ATTACKED_OWNER: 
            case OWNER_ATTACKED_TARGET: 
            case CUSTOM: {
                return;
            }
        }
        Disguise disguise = DisguiseAPI.getDisguise(event.getTarget());
        if (disguise == null) {
            return;
        }
        if (disguise.isMobsIgnoreDisguise()) {
            event.setCancelled(true);
        } else if (DisguiseConfig.isMonstersIgnoreDisguises() && event.getTarget() instanceof Player) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTeleport(final PlayerTeleportEvent event) {
        Disguise disguise;
        boolean viewSelfToggled;
        Disguise[] disguises;
        final Player player = event.getPlayer();
        Location to = event.getTo();
        Location from = event.getFrom();
        if (!DisguiseAPI.isDisguised((Entity)player)) {
            return;
        }
        if (DisguiseConfig.isUndisguiseOnWorldChange() && to.getWorld() != null && from.getWorld() != null && to.getWorld() != from.getWorld() && (disguises = DisguiseAPI.getDisguises((Entity)event.getPlayer())).length > 0) {
            for (Disguise disguise2 : disguises) {
                disguise2.removeDisguise();
            }
            LibsMsg.SWITCH_WORLD_DISGUISE_REMOVED.send((CommandSender)event.getPlayer(), new Object[0]);
        }
        if (DisguiseAPI.isSelfDisguised(player) && to.getWorld() == from.getWorld()) {
            final Disguise disguise3 = DisguiseAPI.getDisguise(player, (Entity)player);
            if (disguise3 != null && disguise3.isSelfDisguiseVisible() && from.distanceSquared(to) > 4096.0) {
                PacketContainer packet = DisguiseUtilities.getDestroyPacket(DisguiseAPI.getSelfDisguiseId());
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                new BukkitRunnable(){

                    public void run() {
                        if (event.isCancelled() || !disguise3.isDisguiseInUse()) {
                            return;
                        }
                        DisguiseUtilities.sendSelfDisguise(player, (TargetedDisguise)disguise3);
                    }
                }.runTaskLater((Plugin)LibsDisguises.getInstance(), 4L);
            }
        } else if (from.getWorld() != to.getWorld() && (viewSelfToggled = DisguiseAPI.isViewSelfToggled((Entity)event.getPlayer())) && (disguise = DisguiseAPI.getDisguise((Entity)event.getPlayer())) != null && disguise.isSelfDisguiseVisible()) {
            disguise.setViewSelfDisguise(false);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> disguise.setViewSelfDisguise(true), 20L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleEnter(VehicleEnterEvent event) {
        if (!(event.getEntered() instanceof Player)) {
            return;
        }
        Disguise disguise = DisguiseAPI.getDisguise((Player)event.getEntered(), event.getEntered());
        if (disguise == null) {
            return;
        }
        DisguiseUtilities.removeSelfDisguise(disguise);
        ((Player)event.getEntered()).updateInventory();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleLeave(VehicleExitEvent event) {
        Disguise disguise;
        if (event.getExited() instanceof Player && (disguise = DisguiseAPI.getDisguise((Player)event.getExited(), (Entity)event.getExited())) != null) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    DisguiseUtilities.setupFakeDisguise(disguise);
                    ((Player)disguise.getEntity()).updateInventory();
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldSwitch(PlayerChangedWorldEvent event) {
        if (!DisguiseAPI.isDisguised((Entity)event.getPlayer())) {
            return;
        }
        if (DisguiseConfig.isUndisguiseOnWorldChange()) {
            Disguise[] disguises = DisguiseAPI.getDisguises((Entity)event.getPlayer());
            if (disguises.length > 0) {
                for (Disguise disguise : disguises) {
                    disguise.removeDisguise();
                }
                LibsMsg.SWITCH_WORLD_DISGUISE_REMOVED.send((CommandSender)event.getPlayer(), new Object[0]);
            }
        } else {
            Disguise disguise;
            boolean viewSelfToggled = DisguiseAPI.isViewSelfToggled((Entity)event.getPlayer());
            if (viewSelfToggled && (disguise = DisguiseAPI.getDisguise((Entity)event.getPlayer())) != null && disguise.isSelfDisguiseVisible()) {
                disguise.setViewSelfDisguise(false);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> disguise.setViewSelfDisguise(true), 20L);
            }
        }
    }

    public void addInteraction(final String playerName, LibsEntityInteract interaction, int secondsExpire) {
        if (this.disguiseRunnable.containsKey(playerName)) {
            this.disguiseRunnable.get(playerName).cancel();
        }
        this.interactions.put(playerName, interaction);
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                DisguiseListener.this.interactions.remove(playerName);
                DisguiseListener.this.disguiseRunnable.remove(playerName);
            }
        };
        runnable.runTaskLater((Plugin)LibsDisguises.getInstance(), (long)(secondsExpire * 20));
        this.disguiseRunnable.put(playerName, runnable);
    }
}

