/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params.types.custom;

import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.params.types.ParamInfoEnum;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemBlock;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class ParamInfoItemStack
extends ParamInfoEnum {
    public ParamInfoItemStack(Class paramClass, String name, String valueType, String description, Enum[] possibleValues) {
        super(paramClass, name, valueType, description, possibleValues);
        if (this instanceof ParamInfoItemBlock) {
            return;
        }
        this.setOtherValues("null", "%held-item%", "%offhand-item%", "%helmet%", "%chestplate%", "%leggings%", "%boots%");
    }

    @Override
    public boolean canTranslateValues() {
        return false;
    }

    @Override
    public boolean canReturnNull() {
        return true;
    }

    @Override
    public Object fromString(String string) {
        return ParamInfoItemStack.parseToItemstack(string);
    }

    @Override
    public String toString(Object object) {
        ItemStack item = (ItemStack)object;
        ItemStack temp = new ItemStack(item.getType(), item.getAmount());
        if (item.containsEnchantment(Enchantment.DURABILITY)) {
            temp.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        }
        if (temp.isSimilar(item)) {
            String name = item.getType().name();
            if (item.getAmount() != 1) {
                name = name + ":" + item.getAmount();
            }
            if (item.containsEnchantment(Enchantment.DURABILITY)) {
                name = name + ":" + TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("glow");
            }
            return name;
        }
        if (!MinecraftReflection.isCraftItemStack((Object)item) && item.hasItemMeta()) {
            item = ReflectionManager.getCraftItem(item);
        }
        String itemName = ReflectionManager.getItemName(item.getType());
        ArrayList<String> mcArray = new ArrayList<String>();
        if (NmsVersion.v1_13.isSupported() && item.hasItemMeta()) {
            mcArray.add(itemName + DisguiseUtilities.serialize((NbtBase)NbtFactory.fromItemTag((ItemStack)item)));
        } else {
            mcArray.add(itemName);
        }
        if (item.getAmount() != 1) {
            mcArray.add(String.valueOf(item.getAmount()));
        }
        if (!NmsVersion.v1_13.isSupported()) {
            if (item.getDurability() != 0) {
                mcArray.add(String.valueOf(item.getDurability()));
            }
            if (item.hasItemMeta()) {
                mcArray.add(DisguiseUtilities.serialize((NbtBase)NbtFactory.fromItemTag((ItemStack)item)));
            }
        }
        return StringUtils.join(mcArray, (String)"-");
    }

    protected static ItemStack parseToItemstack(String string) {
        if (string.isEmpty()) {
            return null;
        }
        if (string.startsWith("{") && string.endsWith("}")) {
            try {
                return (ItemStack)DisguiseUtilities.getGson().fromJson(string, ItemStack.class);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException();
            }
        }
        if (!string.matches("[a-zA-Z0-9_:,]+")) {
            String[] split;
            if (string.matches("[^{]+?[ -]\\{.+?}")) {
                split = string.substring(0, string.indexOf("{") - 1).split("[ -]");
                split = Arrays.copyOf(split, split.length + 1);
                split[split.length - 1] = string.substring(string.indexOf("{"));
            } else if (string.matches("[^{ ]+?\\{.+?}( [0-9]+)?")) {
                split = new String[string.endsWith("}") ? 2 : 3];
                split[0] = string.substring(0, string.indexOf("{"));
                split[string.endsWith((String)"}") ? 1 : 2] = string.substring(string.indexOf("{"), string.lastIndexOf("}") + 1);
                if (!string.endsWith("}")) {
                    split[1] = string.substring(string.lastIndexOf(" ") + 1);
                }
            } else {
                split = string.split("[ -]");
            }
            Material material = ReflectionManager.getMaterial(split[0].toLowerCase(Locale.ENGLISH));
            if (material == null) {
                material = Material.getMaterial((String)split[0].toUpperCase(Locale.ENGLISH));
            }
            if (material == null || material == Material.AIR && !split[0].equalsIgnoreCase("air")) {
                throw new IllegalArgumentException();
            }
            int amount = split.length > 1 && split[1].matches("[0-9]+") ? Integer.parseInt(split[1]) : 1;
            ItemStack itemStack = !NmsVersion.v1_13.isSupported() && split.length > 2 && split[2].matches("[0-9]+") ? new ItemStack(material, amount, Short.parseShort(split[2])) : new ItemStack(material, amount);
            if (split[split.length - 1].contains("{")) {
                Bukkit.getUnsafe().modifyItemStack(itemStack, split[split.length - 1]);
            }
            return itemStack;
        }
        return ParamInfoItemStack.parseToItemstack(string.split("[:,]"));
    }

    protected static ItemStack parseToItemstack(String[] split) {
        if (split[0].isEmpty() || split[0].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("null"))) {
            return null;
        }
        Material material = Material.getMaterial((String)split[0].toUpperCase(Locale.ENGLISH));
        if (material == null || material == Material.AIR && !split[0].equalsIgnoreCase("air")) {
            throw new IllegalArgumentException();
        }
        Integer amount = null;
        boolean enchanted = false;
        for (int i = 1; i < split.length; ++i) {
            String s = split[i];
            if (!enchanted && s.equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("glow"))) {
                enchanted = true;
                continue;
            }
            if (s.matches("\\d+") && amount == null) {
                amount = Integer.parseInt(s);
                continue;
            }
            throw new IllegalArgumentException();
        }
        ItemStack itemStack = new ItemStack(material, amount == null ? 1 : amount);
        if (enchanted) {
            itemStack.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        }
        return itemStack;
    }

    @Override
    public boolean isParam(Class paramClass) {
        return this.getParamClass().isAssignableFrom(paramClass);
    }

    @Override
    public boolean isCustomValues() {
        return true;
    }
}

