/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.json;

import com.google.gson.Gson;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.internal.LinkedTreeMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.VillagerData;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;

public class SerializerFlagWatcher
implements JsonDeserializer<FlagWatcher>,
JsonSerializer<FlagWatcher>,
InstanceCreator<FlagWatcher> {
    private Gson gson;

    public SerializerFlagWatcher(Gson gson) {
        this.gson = gson;
    }

    public FlagWatcher deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            FlagWatcher watcher = (FlagWatcher)this.gson.fromJson(json, Class.forName(((JsonObject)json).get("flagType").getAsString()));
            DisguiseType entity = DisguiseType.valueOf(((JsonObject)json).get("entityType").getAsString());
            this.correct(watcher, watcher.getClass(), "entityValues");
            this.correct(watcher, entity.getWatcherClass(), "backupEntityValues");
            return watcher;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void correct(FlagWatcher watcher, Class<? extends FlagWatcher> flagWatcher, String name) throws NoSuchFieldException, IllegalAccessException {
        Field field = FlagWatcher.class.getDeclaredField(name);
        field.setAccessible(true);
        HashMap map = (HashMap)field.get(watcher);
        int count = 0;
        for (Map.Entry entry : map.entrySet()) {
            MetaIndex index;
            block12: {
                block10: {
                    Object def;
                    block15: {
                        block14: {
                            block13: {
                                block11: {
                                    index = MetaIndex.getMetaIndex(flagWatcher, (int)((Integer)entry.getKey()));
                                    if (!(entry.getValue() instanceof Double)) break block10;
                                    def = index.getDefault();
                                    if (!(def instanceof Long)) break block11;
                                    entry.setValue(((Double)entry.getValue()).longValue());
                                    break block12;
                                }
                                if (!(def instanceof Float)) break block13;
                                entry.setValue(Float.valueOf(((Double)entry.getValue()).floatValue()));
                                break block12;
                            }
                            if (!(def instanceof Integer)) break block14;
                            entry.setValue(((Double)entry.getValue()).intValue());
                            break block12;
                        }
                        if (!(def instanceof Short)) break block15;
                        entry.setValue(((Double)entry.getValue()).shortValue());
                        break block12;
                    }
                    if (!(def instanceof Byte)) break block12;
                    entry.setValue(((Double)entry.getValue()).byteValue());
                    break block12;
                }
                if (entry.getValue() instanceof LinkedTreeMap) {
                    if (index.getDefault() instanceof VillagerData) {
                        entry.setValue(new Gson().fromJson(new Gson().toJson(entry.getValue()), VillagerData.class));
                    } else if (index.getDefault() instanceof Optional) {
                        for (Field f : MetaIndex.class.getFields()) {
                            try {
                                if (f.get(null) != index) {
                                    continue;
                                }
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            Type type = f.getGenericType();
                            Type opt = ((ParameterizedType)type).getActualTypeArguments()[0];
                            if (!(opt instanceof ParameterizedType)) continue;
                            Type val = ((ParameterizedType)opt).getActualTypeArguments()[0];
                            Optional<Object> value = ((LinkedTreeMap)entry.getValue()).isEmpty() ? Optional.empty() : Optional.of(this.gson.fromJson(this.gson.toJson(((LinkedTreeMap)entry.getValue()).get((Object)"value")), val));
                            entry.setValue(value);
                        }
                    }
                }
            }
            if (index.getDefault().getClass().isInstance(entry.getValue())) continue;
            entry.setValue(index.getDefault());
            ++count;
        }
        if (count > 0) {
            DisguiseUtilities.getLogger().info("Fixed " + count + " incorrect disguise flags on saved disguise");
        }
    }

    public FlagWatcher createInstance(Type type) {
        try {
            return (FlagWatcher)type.getClass().getConstructor(Disguise.class).newInstance(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JsonElement serialize(FlagWatcher src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = (JsonObject)this.gson.toJsonTree((Object)src);
        obj.addProperty("flagType", src.getClass().getName());
        try {
            Method method = FlagWatcher.class.getDeclaredMethod("getDisguise", new Class[0]);
            method.setAccessible(true);
            Disguise disguise = (Disguise)method.invoke((Object)src, new Object[0]);
            obj.addProperty("entityType", disguise.getType().name());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return obj;
    }
}

