/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.interactions;

import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsEntityInteract;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;

public class DisguiseEntityInteraction
implements LibsEntityInteract {
    private String[] disguiseArgs;

    @Override
    public void onInteract(Player p, Entity entity) {
        Disguise disguise;
        String entityName = entity instanceof Player ? entity.getName() : DisguiseType.getType(entity).toReadable();
        try {
            disguise = DisguiseParser.parseDisguise((CommandSender)p, entity, "disguiseentity", this.disguiseArgs, DisguiseParser.getPermissions((CommandSender)p, "disguiseentity"));
        }
        catch (DisguiseParseException e) {
            if (e.getMessage() != null) {
                DisguiseUtilities.sendMessage((CommandSender)p, e.getMessage());
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (disguise.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled() && entity instanceof LivingEntity) {
            LibsMsg.DISABLED_LIVING_TO_MISC.send((CommandSender)p, new Object[0]);
        } else {
            if (entity instanceof Player && DisguiseConfig.isNameOfPlayerShownAboveDisguise() && !entity.hasPermission("libsdisguises.hidename") && disguise.getWatcher() instanceof LivingWatcher) {
                Team team = ((Player)entity).getScoreboard().getEntryTeam(entity.getName());
                disguise.getWatcher().setCustomName((team == null ? "" : team.getPrefix()) + entity.getName() + (team == null ? "" : team.getSuffix()));
                if (DisguiseConfig.isNameAboveHeadAlwaysVisible()) {
                    disguise.getWatcher().setCustomNameVisible(true);
                }
            }
            DisguiseAPI.disguiseEntity(entity, disguise);
            String disguiseName = disguise.getDisguiseName();
            if (disguise.isDisguiseInUse()) {
                if (disguise.isPlayerDisguise()) {
                    if (entity instanceof Player) {
                        LibsMsg.LISTEN_ENTITY_PLAYER_DISG_PLAYER.send((CommandSender)p, entityName, disguiseName);
                    } else {
                        LibsMsg.LISTEN_ENTITY_ENTITY_DISG_PLAYER.send((CommandSender)p, entityName, disguiseName);
                    }
                } else if (entity instanceof Player) {
                    LibsMsg.LISTEN_ENTITY_PLAYER_DISG_ENTITY.send((CommandSender)p, entityName, disguiseName);
                } else {
                    LibsMsg.LISTEN_ENTITY_ENTITY_DISG_ENTITY.send((CommandSender)p, entityName, disguiseName);
                }
            } else if (disguise.isPlayerDisguise()) {
                if (entity instanceof Player) {
                    LibsMsg.LISTEN_ENTITY_PLAYER_DISG_PLAYER_FAIL.send((CommandSender)p, entityName, disguiseName);
                } else {
                    LibsMsg.LISTEN_ENTITY_ENTITY_DISG_PLAYER_FAIL.send((CommandSender)p, entityName, disguiseName);
                }
            } else if (entity instanceof Player) {
                LibsMsg.LISTEN_ENTITY_PLAYER_DISG_ENTITY_FAIL.send((CommandSender)p, entityName, disguiseName);
            } else {
                LibsMsg.LISTEN_ENTITY_ENTITY_DISG_ENTITY_FAIL.send((CommandSender)p, entityName, disguiseName);
            }
        }
    }

    public DisguiseEntityInteraction(String[] disguiseArgs) {
        this.disguiseArgs = disguiseArgs;
    }
}

