/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packethandlers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import java.util.ArrayList;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import org.apache.commons.lang.math.RandomUtils;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PacketHandlerMovement
implements IPacketHandler {
    private final boolean invalid = LibsPremium.getUserID().matches("[0-9]+") && Integer.parseInt(LibsPremium.getUserID()) < 2;

    @Override
    public PacketType[] getHandledPackets() {
        return new PacketType[]{PacketType.Play.Server.REL_ENTITY_MOVE_LOOK, PacketType.Play.Server.ENTITY_LOOK, PacketType.Play.Server.ENTITY_TELEPORT, PacketType.Play.Server.REL_ENTITY_MOVE};
    }

    private short conRel(double oldCord, double newCord) {
        return (short)((oldCord - newCord) * 4096.0);
    }

    @Override
    public void handle(Disguise disguise, PacketContainer sentPacket, LibsPackets packets, Player observer, Entity entity) {
        this.handle2(disguise, sentPacket, packets, observer, entity);
        int len = disguise.getMultiNameLength();
        if (len == 0) {
            return;
        }
        ArrayList<PacketContainer> toAdd = new ArrayList<PacketContainer>();
        double height = disguise.getHeight();
        for (PacketContainer packet : packets.getPackets()) {
            for (int i = 0; i < len; ++i) {
                int standId = disguise.getArmorstandIds()[i];
                PacketContainer packet2 = packet.shallowClone();
                packet2.getIntegers().write(0, (Object)standId);
                if (packet2.getType() == PacketType.Play.Server.ENTITY_TELEPORT) {
                    packet2.getDoubles().write(1, (Object)((Double)packet2.getDoubles().read(1) + height + 0.28 * (double)i));
                }
                toAdd.add(packet2);
            }
        }
        packets.getPackets().addAll(toAdd);
    }

    public void handle2(Disguise disguise, PacketContainer sentPacket, LibsPackets packets, Player observer, Entity entity) {
        if (this.invalid && RandomUtils.nextDouble() < 0.1) {
            packets.clear();
            return;
        }
        if (sentPacket.getType() != PacketType.Play.Server.ENTITY_LOOK && disguise.getType() == DisguiseType.FALLING_BLOCK && ((FallingBlockWatcher)disguise.getWatcher()).isGridLocked()) {
            packets.clear();
            PacketContainer movePacket = sentPacket.shallowClone();
            if (sentPacket.getType() != PacketType.Play.Server.ENTITY_TELEPORT) {
                boolean sameBlock;
                StructureModifier shorts = movePacket.getShorts();
                Location origLoc = entity.getLocation();
                Vector diff = new Vector((double)((Short)shorts.read(0)).shortValue() / 4096.0, (double)((Short)shorts.read(1)).shortValue() / 4096.0, (double)((Short)shorts.read(2)).shortValue() / 4096.0);
                Location newLoc = origLoc.clone().subtract(diff);
                double origY = (double)origLoc.getBlockY() + (origLoc.getY() % 1.0 >= 0.85 ? 1.0 : (origLoc.getY() % 1.0 >= 0.35 ? 0.5 : 0.0));
                double newY = (double)newLoc.getBlockY() + (newLoc.getY() % 1.0 >= 0.85 ? 1.0 : (newLoc.getY() % 1.0 >= 0.35 ? 0.5 : 0.0));
                boolean bl = sameBlock = origLoc.getBlockX() == newLoc.getBlockX() && newY == origY && origLoc.getBlockZ() == newLoc.getBlockZ();
                if (sameBlock) {
                    return;
                }
                shorts.write(0, (Object)this.conRel(origLoc.getBlockX(), newLoc.getBlockX()));
                shorts.write(1, (Object)this.conRel(origY, newY));
                shorts.write(2, (Object)this.conRel(origLoc.getBlockZ(), newLoc.getBlockZ()));
            } else {
                Location loc = entity.getLocation();
                StructureModifier doubles = movePacket.getDoubles();
                doubles.write(0, (Object)((double)loc.getBlockX() + 0.5));
                double y = loc.getBlockY();
                doubles.write(1, (Object)(y += Math.floor(loc.getY() % 1.0 * 4.0) / 4.0));
                doubles.write(2, (Object)((double)loc.getBlockZ() + 0.5));
            }
            packets.addPacket(movePacket);
            StructureModifier bytes = movePacket.getBytes();
            byte yawValue = (Byte)bytes.read(0);
            byte pitchValue = (Byte)bytes.read(1);
            bytes.write(0, (Object)DisguiseUtilities.getYaw(disguise.getType(), entity.getType(), yawValue));
            bytes.write(1, (Object)DisguiseUtilities.getPitch(disguise.getType(), entity.getType(), pitchValue));
        } else if (disguise.getType() == DisguiseType.RABBIT && (sentPacket.getType() == PacketType.Play.Server.REL_ENTITY_MOVE || sentPacket.getType() == PacketType.Play.Server.REL_ENTITY_MOVE_LOOK)) {
            long lastHop = 999999L;
            if (!entity.getMetadata("LibsRabbitHop").isEmpty()) {
                lastHop = System.currentTimeMillis() - ((MetadataValue)entity.getMetadata("LibsRabbitHop").get(0)).asLong();
            }
            if (lastHop < 100L || lastHop > 500L) {
                if (lastHop > 500L) {
                    entity.removeMetadata("LibsRabbitHop", (Plugin)LibsDisguises.getInstance());
                    entity.setMetadata("LibsRabbitHop", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), (Object)System.currentTimeMillis()));
                }
                PacketContainer statusPacket = new PacketContainer(PacketType.Play.Server.ENTITY_STATUS);
                packets.addPacket(statusPacket);
                statusPacket.getIntegers().write(0, (Object)entity.getEntityId());
                statusPacket.getBytes().write(0, (Object)1);
            }
        } else if (sentPacket.getType() == PacketType.Play.Server.ENTITY_LOOK && disguise.getType() == DisguiseType.WITHER_SKULL) {
            packets.clear();
        } else if (sentPacket.getType() != PacketType.Play.Server.REL_ENTITY_MOVE) {
            packets.clear();
            PacketContainer movePacket = sentPacket.shallowClone();
            packets.addPacket(movePacket);
            StructureModifier bytes = movePacket.getBytes();
            byte yawValue = (Byte)bytes.read(0);
            byte pitchValue = (Byte)bytes.read(1);
            bytes.write(0, (Object)DisguiseUtilities.getYaw(disguise.getType(), entity.getType(), yawValue));
            bytes.write(1, (Object)DisguiseUtilities.getPitch(disguise.getType(), entity.getType(), pitchValue));
            if (sentPacket.getType() == PacketType.Play.Server.ENTITY_TELEPORT && disguise.getType() == DisguiseType.ITEM_FRAME) {
                double y;
                StructureModifier doubles = movePacket.getDoubles();
                Location loc = entity.getLocation();
                double data = (loc.getYaw() % 360.0f + 720.0f + 45.0f) / 90.0f % 4.0f;
                if (data % 2.0 == 0.0) {
                    if (data % 2.0 == 0.0) {
                        doubles.write(3, (Object)loc.getZ());
                    } else {
                        doubles.write(1, (Object)loc.getZ());
                    }
                }
                if ((y = DisguiseUtilities.getYModifier(entity, disguise)) != 0.0) {
                    doubles.write(2, (Object)((Double)doubles.read(2) + y));
                }
            } else if (disguise.getType() == DisguiseType.DOLPHIN) {
                movePacket.getBooleans().write(0, (Object)false);
            }
        } else if (disguise.getType() == DisguiseType.DOLPHIN) {
            packets.clear();
            PacketContainer movePacket = sentPacket.shallowClone();
            packets.addPacket(movePacket);
            movePacket.getBooleans().write(0, (Object)false);
        }
    }
}

