/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.sounds;

import java.util.LinkedHashMap;
import java.util.Map;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.apache.commons.lang.math.RandomUtils;
import org.bukkit.Sound;

public class SoundGroup {
    private static final LinkedHashMap<String, SoundGroup> groups = new LinkedHashMap();
    private float damageSoundVolume = 1.0f;
    private final LinkedHashMap<Object, SoundType> disguiseSounds = new LinkedHashMap();
    private boolean customSounds;

    public SoundGroup(String name) {
        groups.put(name, this);
        try {
            DisguiseType.valueOf(name);
        }
        catch (Exception ex) {
            this.customSounds = true;
        }
    }

    public void addSound(Object sound, SoundType type) {
        if (sound instanceof Sound) {
            sound = ReflectionManager.getCraftSound((Sound)sound);
        } else if (sound instanceof String) {
            sound = ReflectionManager.createSoundEffect((String)sound);
        } else if (!sound.getClass().getName().equals("SoundEffect")) {
            throw new IllegalArgumentException();
        }
        if (sound == null) {
            return;
        }
        this.disguiseSounds.put(sound, type);
    }

    public float getDamageAndIdleSoundVolume() {
        return this.damageSoundVolume;
    }

    public void setDamageAndIdleSoundVolume(float strength) {
        this.damageSoundVolume = strength;
    }

    public Object getSound(SoundType type) {
        if (type == null) {
            return null;
        }
        if (this.customSounds) {
            return this.getRandomSound(type);
        }
        for (Map.Entry<Object, SoundType> entry : this.disguiseSounds.entrySet()) {
            if (entry.getValue() != type) continue;
            return entry.getKey();
        }
        return null;
    }

    private Object getRandomSound(SoundType type) {
        if (type == null) {
            return null;
        }
        Object[] sounds = new Object[this.disguiseSounds.size()];
        int i = 0;
        for (Map.Entry<Object, SoundType> entry : this.disguiseSounds.entrySet()) {
            if (entry.getValue() != type) continue;
            sounds[i++] = entry.getKey();
        }
        if (i == 0) {
            return null;
        }
        return sounds[RandomUtils.nextInt((int)i)];
    }

    public SoundType getSound(Object sound) {
        if (sound == null) {
            return null;
        }
        return this.disguiseSounds.get(sound);
    }

    public SoundType getType(Object sound, boolean ignoreDamage) {
        if (sound == null) {
            return SoundType.CANCEL;
        }
        SoundType soundType = this.getSound(sound);
        if (soundType == SoundType.DEATH || ignoreDamage && soundType == SoundType.HURT) {
            return null;
        }
        return soundType;
    }

    public boolean isCancelSound(String sound) {
        return this.getSound(sound) == SoundType.CANCEL;
    }

    public static SoundGroup getGroup(Disguise disguise) {
        SoundGroup dSoundGroup;
        if (disguise.getSoundGroup() != null && (dSoundGroup = SoundGroup.getGroup(disguise.getSoundGroup())) != null) {
            return dSoundGroup;
        }
        return SoundGroup.getGroup(disguise.getType().name());
    }

    public static SoundGroup getGroup(String name) {
        return groups.get(name);
    }

    public static LinkedHashMap<String, SoundGroup> getGroups() {
        return groups;
    }

    public LinkedHashMap<Object, SoundType> getDisguiseSounds() {
        return this.disguiseSounds;
    }

    public static enum SoundType {
        CANCEL,
        DEATH,
        HURT,
        IDLE,
        STEP;

    }
}

