/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.utils;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.util.Arrays;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.SkinUtils;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class SaveDisguiseCommand
implements CommandExecutor {
    public boolean onCommand(final CommandSender sender, Command command, String s, String[] strings) {
        if (!(!(sender instanceof Player) || sender.isOp() || LibsPremium.isPremium().booleanValue() && LibsPremium.getPaidInformation() != LibsPremium.getPluginInformation())) {
            sender.sendMessage(ChatColor.RED + "Please purchase Lib's Disguises to enable player commands");
            return true;
        }
        if (!sender.hasPermission("libsdisguises.savedisguise")) {
            DisguiseUtilities.sendMessage(sender, LibsMsg.NO_PERM, new Object[0]);
            return true;
        }
        if (strings.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        strings = DisguiseUtilities.split(StringUtils.join((Object[])strings, (String)" "));
        final String name = strings[0];
        String[] args = Arrays.copyOfRange(strings, 1, strings.length);
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                DisguiseUtilities.sendMessage(sender, LibsMsg.NO_CONSOLE, new Object[0]);
                return true;
            }
            Disguise disguise = DisguiseAPI.getDisguise((Entity)sender);
            if (disguise == null) {
                DisguiseUtilities.sendMessage(sender, LibsMsg.NOT_DISGUISED, new Object[0]);
                return true;
            }
            String disguiseString = DisguiseAPI.parseToString(disguise);
            try {
                DisguiseAPI.addCustomDisguise(name, disguiseString);
                DisguiseUtilities.sendMessage(sender, LibsMsg.CUSTOM_DISGUISE_SAVED, name);
            }
            catch (DisguiseParseException e) {
                if (e.getMessage() != null) {
                    sender.sendMessage(e.getMessage());
                }
                DisguiseUtilities.sendMessage(sender, LibsMsg.PARSE_CANT_LOAD, new Object[0]);
            }
            return true;
        }
        if (args.length >= 2 && args[0].equalsIgnoreCase("player")) {
            int skinId;
            int i;
            for (i = 2; i < args.length && !args[i].equalsIgnoreCase("setskin"); ++i) {
            }
            if (args.length < i + 1) {
                args = Arrays.copyOf(args, Math.max(args.length, i + 2));
                i = args.length - 2;
                args[i] = "setSkin";
                args[i + 1] = args[1];
            }
            if (!args[skinId = i + 1].startsWith("{")) {
                String usable = SkinUtils.getUsableStatus();
                if (usable != null) {
                    sender.sendMessage(usable);
                    return true;
                }
                final String[] finalArgs = args;
                SkinUtils.grabSkin(args[skinId], new SkinUtils.SkinCallback(){
                    private BukkitTask runnable = new BukkitRunnable(){

                        public void run() {
                            DisguiseUtilities.sendMessage(sender, LibsMsg.PLEASE_WAIT, new Object[0]);
                        }
                    }.runTaskTimer((Plugin)LibsDisguises.getInstance(), 100L, 100L);

                    @Override
                    public void onError(LibsMsg msg, Object ... args) {
                        this.runnable.cancel();
                        sender.sendMessage(msg.get(args));
                    }

                    @Override
                    public void onInfo(LibsMsg msg, Object ... args) {
                        sender.sendMessage(msg.get(args));
                    }

                    @Override
                    public void onSuccess(WrappedGameProfile profile) {
                        this.runnable.cancel();
                        finalArgs[skinId] = DisguiseUtilities.getGson().toJson((Object)profile);
                        SaveDisguiseCommand.this.saveDisguise(sender, name, finalArgs);
                    }
                });
            } else {
                this.saveDisguise(sender, name, args);
            }
        } else {
            this.saveDisguise(sender, name, args);
        }
        return true;
    }

    private void saveDisguise(CommandSender sender, String name, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = DisguiseUtilities.quote(args[i]);
        }
        String disguiseString = StringUtils.join((Object[])args, (String)" ");
        try {
            DisguiseAPI.addCustomDisguise(name, disguiseString);
            DisguiseUtilities.sendMessage(sender, LibsMsg.CUSTOM_DISGUISE_SAVED, name);
            DisguiseUtilities.setSaveDisguiseCommandUsed();
        }
        catch (DisguiseParseException e) {
            if (e.getMessage() != null) {
                sender.sendMessage(e.getMessage());
            }
            DisguiseUtilities.sendMessage(sender, LibsMsg.PARSE_CANT_LOAD, new Object[0]);
        }
    }

    private void sendHelp(CommandSender sender) {
        DisguiseUtilities.sendMessage(sender, LibsMsg.SAVE_DISG_HELP_1, new Object[0]);
        DisguiseUtilities.sendMessage(sender, LibsMsg.SAVE_DISG_HELP_2, new Object[0]);
        DisguiseUtilities.sendMessage(sender, LibsMsg.SAVE_DISG_HELP_3, new Object[0]);
        DisguiseUtilities.sendMessage(sender, LibsMsg.SAVE_DISG_HELP_4, new Object[0]);
        DisguiseUtilities.sendMessage(sender, LibsMsg.SAVE_DISG_HELP_5, new Object[0]);
        DisguiseUtilities.sendMessage(sender, LibsMsg.SAVE_DISG_HELP_6, new Object[0]);
    }
}

