/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.modify;

import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.commands.interactions.DisguiseModifyInteraction;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class DisguiseModifyEntityCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            DisguiseUtilities.sendMessage(sender, LibsMsg.NO_CONSOLE, new Object[0]);
            return true;
        }
        DisguisePermissions permissions = this.getPermissions(sender);
        if (!permissions.hasPermissions()) {
            DisguiseUtilities.sendMessage(sender, LibsMsg.NO_PERM, new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, permissions);
            return true;
        }
        LibsDisguises.getInstance().getListener().addInteraction(sender.getName(), new DisguiseModifyInteraction(DisguiseUtilities.split(StringUtils.join((Object[])args, (String)" "))), DisguiseConfig.getDisguiseEntityExpire());
        DisguiseUtilities.sendMessage(sender, LibsMsg.DMODIFYENT_CLICK, DisguiseConfig.getDisguiseEntityExpire());
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        String[] args = this.getPreviousArgs(origArgs);
        DisguisePermissions perms = this.getPermissions(sender);
        if (!perms.hasPermissions()) {
            return new ArrayList<String>();
        }
        ArrayList<String> tabs = new ArrayList<String>();
        for (DisguisePerm perm : perms.getAllowed()) {
            tabs.addAll(this.getTabDisguiseOptions(sender, perms, perm, args, 0, this.getCurrentArg(origArgs)));
        }
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, DisguisePermissions permissions) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(permissions);
        DisguiseUtilities.sendMessage(sender, LibsMsg.DMODENT_HELP1, new Object[0]);
        DisguiseUtilities.sendMessage(sender, LibsMsg.DMODIFY_HELP3, StringUtils.join(allowedDisguises, (String)LibsMsg.CAN_USE_DISGS_SEPERATOR.get(new Object[0])));
    }
}

